/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ObjectCache<E> {
    protected static final Logger logger = Logger.getLogger(ObjectCache.class.getName());
    private final Map<Key, E> map;
    private final ConcurrentMap<Key, Boolean> triedFindOnServerBeforeFail;
    private GlobalInstancesAdapter globalInstancesListener;
    private Integer idSession;
    private String name;

    public ObjectCache(String name) {
        this.name = name;
        this.map = new ConcurrentHashMap<Key, E>();
        this.triedFindOnServerBeforeFail = new ConcurrentHashMap<Key, Boolean>();
        this.globalInstancesListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                Integer newIdSession = ObjectCache.this.getNewIdSession();
                if (!MiscUtil.areObjectsEquals((Object)ObjectCache.this.idSession, (Object)newIdSession)) {
                    ObjectCache.this.idSession = newIdSession;
                    ObjectCache.this.reload(false);
                }
            }

            public void logout() {
                ObjectCache.this.idSession = null;
                ObjectCache.this.clear();
                super.logout();
            }
        };
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
    }

    private Integer getNewIdSession() {
        try {
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null) {
                return session.getId();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get codeClient from xsession bug", e);
        }
        return null;
    }

    public void reload(boolean sync) {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session == null) {
            this.fill(new ArrayList());
        } else {
            Callback callback = new Callback(){

                @Override
                public void responseReceived(ReturnObject response) {
                    List list = (List)response.getObj();
                    ObjectCache.this.fill(list);
                }

                @Override
                public void exception(Exception e) {
                    logger.log(Level.WARNING, "Failed to load " + ObjectCache.this.name + " list", e);
                    ObjectCache.this.fill(null);
                }
            };
            try {
                if (sync) {
                    this.loadSync(this.hashCode(), session, callback);
                } else {
                    this.load(this.hashCode(), session, callback);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load " + this.name + " list", e);
                callback.kill();
            }
        }
    }

    protected void fill(List<E> list) {
        this.triedFindOnServerBeforeFail.clear();
        this.map.clear();
        int c = 0;
        if (list != null) {
            for (E e : list) {
                ++c;
                this.add(this.map, e);
            }
        }
        System.out.println("MapSize: " + c + "/" + this.map.size() + " : " + (list != null && list.size() > 0 ? list.get(0).getClass().getName() : "empty"));
    }

    public void clear() {
        this.triedFindOnServerBeforeFail.clear();
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected E get(Key key, boolean logIfNotFound, boolean mustTryToFindServer) {
        XSession session;
        if (key == null) {
            return null;
        }
        E e = this.map.get(key);
        if (e == null && mustTryToFindServer && (session = Application.get().getGlobalInstances().getSession()) != null) {
            ConcurrentMap<Key, Boolean> concurrentMap = this.triedFindOnServerBeforeFail;
            synchronized (concurrentMap) {
                if (!Boolean.TRUE.equals(this.triedFindOnServerBeforeFail.get(key))) {
                    this.triedFindOnServerBeforeFail.put(key, true);
                    try {
                        e = this.loadSync(Application.get().getGlobalInstances().getSession(), key);
                        if (e != null) {
                            this.add(this.map, e);
                        }
                    }
                    catch (Exception a) {
                        logger.log(Level.SEVERE, "Failed to get " + this.name + " with id " + key + " , param: logIfNotFound:" + logIfNotFound + ", mustTryToFindServer:" + mustTryToFindServer, a);
                    }
                }
                if ((e = this.map.get(key)) == null && logIfNotFound) {
                    Exception ex = new Exception();
                    ex.fillInStackTrace();
                    logger.log(Level.SEVERE, "Failed to get " + this.name + " with id " + key + " , param: logIfNotFound:" + logIfNotFound + ", mustTryToFindServer:" + mustTryToFindServer, ex);
                }
            }
        }
        return e;
    }

    protected void remove(Key k) {
        this.map.remove(k);
    }

    public void dispose() {
        this.clear();
        Application.get().getGlobalInstances().removeGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
    }

    protected abstract void load(int var1, XSession var2, ICallback var3) throws Exception;

    protected abstract void loadSync(int var1, XSession var2, ICallback var3) throws Exception;

    protected abstract void add(Map<Key, E> var1, E var2);

    protected abstract E loadSync(XSession var1, Key var2) throws Exception;

    protected Map<Key, E> getMap() {
        return this.map;
    }

    public static class Key {
        public final String type;
        public final Integer id;

        public Key(String type, Integer id) {
            if (id == null) {
                throw new NullPointerException("id");
            }
            if (type == null) {
                throw new NullPointerException("type");
            }
            this.type = type;
            this.id = id;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }

        public String toString() {
            return "Key [type=" + this.type + ", id=" + this.id + "]";
        }
    }
}

