/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.callback;

import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.status.IStatus;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JustLogStatusHandler
implements IStatusHandler {
    public static final Logger logger = Logger.getLogger(JustLogStatusHandler.class.getName());
    private static JustLogStatusHandler instance = new JustLogStatusHandler();

    public static JustLogStatusHandler getInstance() {
        return instance;
    }

    @Override
    public IStatusHandler.State handle(IStatus status) {
        if (status == null) {
            return IStatusHandler.State.NOT_HANDLED;
        }
        switch (status.getSeverity()) {
            case OK: 
            case INFO: {
                if (status.getMessage() == null || status.getMessage().isEmpty()) break;
                logger.log(Level.INFO, status.getMessage());
                break;
            }
            case NEED_MORE_INFO: {
                logger.log(Level.INFO, "Question = " + status.getMessage());
            }
            case WARNING: 
            case ERROR: {
                logger.log(Level.INFO, status.getMessage());
                break;
            }
            case BUG: {
                logger.log(Level.SEVERE, status.getMessage(), status.getException());
            }
        }
        return IStatusHandler.State.HANDLED;
    }
}

