/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IRessourceAccessor;
import ca.infodata.ofys.data.dataaccess.ISearchTextAccessor;
import ca.infodata.ofys.data.dataaccess.util.notification.DataObjectNotificationHandler;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillCriteria;
import ca.infodata.ofys.data.middle.dataobjects.service.XBillingRessource;
import ca.infodata.ofys.data.middle.dataobjects.service.XRessourceCriteria;
import ca.infodata.ofys.data.middle.dataobjects.service.XTaxeCriteria;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;

public class RessourceAccessorClient
extends BaseAccessorClient
implements ISearchTextAccessor {
    private static RessourceAccessorClient instance;
    private final IRessourceAccessor accessor;
    private final DataObjectNotificationHandler handler;

    public static RessourceAccessorClient getInstance() throws CannotConnectToServerException {
        return RessourceAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static RessourceAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new RessourceAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", (Throwable)e2);
            throw e2;
        }
        return instance;
    }

    private RessourceAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getRessourceAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", (Throwable)e2);
            throw e2;
        }
        this.handler = new DataObjectNotificationHandler(){

            public void handle(DataObjectUpdatedNotification notification) {
                IDataObject object = notification.getObject();
                if (object instanceof XBillingRessource) {
                    XBillingRessource item = (XBillingRessource)object;
                    System.out.println("RessourceAccessorClient DataObjectNotificationHandler.handle:" + item);
                }
            }
        };
        Application.get().getGlobalInstances().getNotificationSystem().addDataObjectNotificationHandler(this.handler);
    }

    protected IRessourceAccessor getAccessor() {
        return this.accessor;
    }

    public void getAllSecteur(final XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("RessourceAccessorClient.getAllSecteur", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getAllSecteurs());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", "RessourceAccessorClient.getAllSecteur", session, callback), e);
                            RessourceAccessorClient.this.functionCallEnded("RessourceAccessorClient.getAllSecteur", callback);
                        }
                    }
                    finally {
                        RessourceAccessorClient.this.functionCallEnded("RessourceAccessorClient.getAllSecteur", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getActiveTaxeByDate(final Integer date, final XSession session, final ICallback callback) {
        final String function = "RessourceAccessorClient.getActiveTaxeByDate: " + date;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getActiveTaxeByDate(date));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, date), e);
                            RessourceAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        RessourceAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getAllTaxes(XSession session, ICallback callback) {
        XTaxeCriteria c = new XTaxeCriteria();
        this.getTaxeByCriteria(c, session, callback);
    }

    public void getTaxeByCriteria(final XTaxeCriteria c, final XSession session, final ICallback callback) {
        final String function = "RessourceAccessorClient.getTaxeByCriteria: " + c;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getTaxeByCriteria(c));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, c), e);
                            RessourceAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        RessourceAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getRessourceDefDataByCriteria(final XRessourceCriteria c, final XSession session, final ICallback callback) {
        final String function = "RessourceAccessorClient.getRessourceDefDataByCriteria: " + c;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getRessourceDefDataByCriteria(c));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, c), e);
                            RessourceAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        RessourceAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getRessourceByCriteria(final XRessourceCriteria c, final XSession session, final ICallback callback) {
        final String function = "RessourceAccessorClient.getRessourceByCriteria: " + c;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getRessourceByCriteria(c));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, c), e);
                            RessourceAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        RessourceAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getBillingRessourceByCriteria(final XBillCriteria c, final XSession session, final ICallback callback) {
        final String function = "RessourceAccessorClient.getBillingRessourceByCriteria: " + c;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getBillingRessourceByCriteria(c));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, c), e);
                            RessourceAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        RessourceAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getBilledRessourceByCriteria(final XBillCriteria c, final XSession session, final ICallback callback) {
        final String function = "RessourceAccessorClient.getBilledRessourceByCriteria: " + c;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getBilledRessourceByCriteria(c));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, callback, c), e);
                            RessourceAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        RessourceAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    @Override
    public void findFromSearchText(int uniqueKey, XSession session, ICallback callback, int specialCase, String name) {
        XRessourceCriteria container = new XRessourceCriteria();
        container.name = StringUtils.removeMultiSpace((String)name);
        container.date = LocalDate.today().dayFrom1970;
        container.activeDefData = Boolean.TRUE;
        this.getRessourceDefDataByCriteria(container, Application.get().getGlobalInstances().getSession(), callback);
    }

    @Override
    public void findFromId(int uniqueKey, XSession session, final ICallback callback, int idPatient) {
        if (this.isOkToCallFunction("PatientAccessorClient.getBasePatient", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    RessourceAccessorClient.this.functionCallEnded("PatientAccessorClient.findPatient", callback);
                    return callback;
                }
            };
        }
    }
}

