/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IProfessionnalRequestAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.request.XSearchProfessionnalRequestCriteria;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfessionnalRequestAccessorClient
extends BaseAccessorClient {
    private static final Logger logger = Logger.getLogger(ProfessionnalRequestAccessorClient.class.getName());
    private static ProfessionnalRequestAccessorClient instance;
    private final IProfessionnalRequestAccessor accessor;

    public static ProfessionnalRequestAccessorClient getInstance() throws CannotConnectToServerException {
        return ProfessionnalRequestAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static ProfessionnalRequestAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new ProfessionnalRequestAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private ProfessionnalRequestAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getProfessionnalRequestAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    protected IProfessionnalRequestAccessor getAccessor() {
        return this.accessor;
    }

    public void findProfessionnalRequest(XSession session, final ICallback callback, final XSearchProfessionnalRequestCriteria criteria) {
        if (this.isOkToCallFunction("ProfessionnalRequestAccessorClient.findProfessionnalRequest", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.findProfessionnalRequest(criteria);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            ProfessionnalRequestAccessorClient.this.functionCallEnded("ProfessionnalRequestAccessorClient.findProfessionnalRequest", callback);
                        }
                    }
                    finally {
                        ProfessionnalRequestAccessorClient.this.functionCallEnded("ProfessionnalRequestAccessorClient.findProfessionnalRequest", callback);
                    }
                    return callback;
                }
            };
        }
    }
}

