/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IPreferencesAccessor;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.library.log.Log;
import java.io.Serializable;
import java.util.logging.Level;

public class PreferencesAccessorClient
extends BaseAccessorClient {
    private static PreferencesAccessorClient instance;
    private final IPreferencesAccessor accessor;

    public static PreferencesAccessorClient getInstance() throws CannotConnectToServerException {
        return PreferencesAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static PreferencesAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new PreferencesAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private PreferencesAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getPreferencesAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    protected IPreferencesAccessor getAccessor() {
        return this.accessor;
    }

    public void getPreferencesContainer(final int uniqueKey, XSession session, final Callback callback) {
        if (this.isOkToCallFunction("PreferencesAccessorClient.getPreferencesContainer" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getPreferencesContainer());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.getPreferencesContainer" + uniqueKey, callback);
                        }
                    }
                    finally {
                        PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.getPreferencesContainer" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getWebLinks(XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("PreferencesAccessorClient.getWebLinks", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getWebLinks());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.getWebLinks", callback);
                        }
                    }
                    finally {
                        PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.getWebLinks", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPersonGroups(XSession session, final ICallback callback, boolean async) {
        if (this.isOkToCallFunction("PreferencesAccessorClient.findPersonGroups", callback)) {
            if (async) {
                new BaseAccessorClient.DoThread(this){

                    @Override
                    public ICallback run() {
                        try {
                            try {
                                callback.response(instance.accessor.findPersonGroups());
                            }
                            catch (Exception e) {
                                callback.exception(e);
                                Log.severe((String)"Erreur", (Exception)e);
                                PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.findPersonGroups", callback);
                            }
                        }
                        finally {
                            PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.findPersonGroups", callback);
                        }
                        return callback;
                    }
                };
            } else {
                try {
                    try {
                        callback.response(PreferencesAccessorClient.instance.accessor.findPersonGroups());
                    }
                    catch (Exception e) {
                        callback.exception(e);
                        Log.severe((String)"Erreur", (Exception)e);
                        this.functionCallEnded("PreferencesAccessorClient.findPersonGroups", callback);
                    }
                }
                finally {
                    this.functionCallEnded("PreferencesAccessorClient.findPersonGroups", callback);
                }
            }
        }
    }

    public void reactivateStations(final int uniqueKey, XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("PreferencesAccessorClient.reactivateStations" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.reactivateStations());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.reactivateStations" + uniqueKey, callback);
                        }
                    }
                    finally {
                        PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.reactivateStations" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void exportPatients(final char delimiter, XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("PreferencesAccessorClient.exportPatient", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.exportPatients(delimiter));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.exportPatient", callback);
                        }
                    }
                    finally {
                        PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.exportPatient", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void exportPatientsClinicDatas(final char delimiter, XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("PreferencesAccessorClient.exportPatientsClinicDatas", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.exportPatientsClinicDatas(delimiter));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.exportPatientsClinicDatas", callback);
                        }
                    }
                    finally {
                        PreferencesAccessorClient.this.functionCallEnded("PreferencesAccessorClient.exportPatientsClinicDatas", callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void executeTask(String taskName, Serializable taskParameter, XSession session, ICallback callback) {
        String function = "PreferencesAccessorClient.executeTask" + taskName.hashCode();
        try {
            try {
                callback.response(PreferencesAccessorClient.instance.accessor.executeTask(taskName, taskParameter));
            }
            catch (Exception e) {
                callback.exception(e);
                Log.severe((String)"Erreur", (Exception)e);
                this.functionCallEnded(function, callback);
            }
        }
        finally {
            this.functionCallEnded(function, callback);
        }
    }

    public Object setCourrielDossier(Integer userAnchorid, int courrielDossierId, String newName, Integer toFolder, XSession session, Callback callback) {
        String function = "PreferencesAccessorClient.setCourrielDossier," + userAnchorid + ":" + courrielDossierId;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                ReturnObject returnObject = PreferencesAccessorClient.instance.accessor.setCourrielDossier(userAnchorid, courrielDossierId, newName, toFolder);
                Object object = returnObject == null ? null : returnObject.getObj();
                return object;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to setCourrielDossier " + userAnchorid + ":" + courrielDossierId, e);
                throw e;
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    @Override
    public final void save(int uniqueKey, XSession session, SaveCallback callback, Serializable dataObject, boolean askQuestion) {
        super.save(uniqueKey, session, callback, dataObject, askQuestion);
    }
}

