/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.client.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.client.dataaccess.LastShowMessageLogList;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstances;
import ca.infodata.ofys.data.dataaccess.util.IGlobalInstances;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.library.log.LogContextProvider;
import ca.infodata.util1.IPair;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.TimeZoneProvider;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ClientDataaccessPlugin
extends AbstractUIPlugin {
    private static ClientDataaccessPlugin plugin;
    private LogContextProvider jmsLogContextProvider;
    private LastShowMessageLogList lastShowMessageLogList;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        final Application application = Application.get();
        application.setGlobalInstances((IGlobalInstances)new GlobalInstances());
        this.lastShowMessageLogList = new LastShowMessageLogList();
        this.jmsLogContextProvider = new LogContextProvider(){

            public String getContextElement() {
                String time;
                FastDateFormat sdf = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss", (TimeZone)TimeZoneProvider.getTimeZone());
                StringBuilder b = new StringBuilder(2000);
                b.append("\n\n");
                b.append("LastJMSNotifications");
                List lastNotifications = application.getGlobalInstances().getNotificationSystem().getLastNotifications();
                for (IPair iPair : lastNotifications) {
                    b.append("\n");
                    time = sdf.format(new Date((Long)iPair.getFirst()));
                    b.append(time).append(" : ").append(iPair.getSecond());
                    b.append("\n");
                }
                b.append("\n\n");
                b.append("BaseAccessorClient LastCalls");
                for (Pair pair : BaseAccessorClient.getLastCalls()) {
                    b.append("\n");
                    time = sdf.format(new Date((Long)pair.first));
                    b.append(time).append(" : ").append((String)pair.second);
                }
                b.append("\n\n");
                b.append("BaseAccessorClient Session");
                b.append("\n").append(application.getGlobalInstances().getSession());
                b.append("\n\n");
                b.append("BaseAccessorClient Session Person Name");
                if (application.getGlobalInstances().getSession() != null) {
                    b.append("\n").append(application.getGlobalInstances().getSession().getUser().getPersonNameOrTextOrEmpty());
                }
                b.append("\n\n");
                return b.toString();
            }
        };
        Log.registerLogContextProvider((LogContextProvider)this.jmsLogContextProvider);
        Log.registerLogContextProvider((LogContextProvider)this.lastShowMessageLogList);
    }

    public void stop(BundleContext context) throws Exception {
        Log.unregisterLogContextProvider((LogContextProvider)this.jmsLogContextProvider);
        Log.unregisterLogContextProvider((LogContextProvider)this.lastShowMessageLogList);
        super.stop(context);
        plugin = null;
    }

    public ClientDataaccessPlugin() {
        plugin = this;
    }

    public static ClientDataaccessPlugin getDefault() {
        return plugin;
    }

    public LastShowMessageLogList getLastShowMessageLogList() {
        return this.lastShowMessageLogList;
    }
}

