/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signature;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class XmlSignatureCore {
    private String alias;
    private String password;
    private PrivateKey privateKey;
    private KeyInfo keyInfo;
    private XMLSignatureFactory factory;
    private DigestMethod sha1;
    private CanonicalizationMethod inclusive;
    private SignatureMethod rsasha1;
    private List<Transform> transforms;

    public void initOnChange(String alias, String password) throws Exception {
        if (alias == null) {
            throw new NullPointerException("alias");
        }
        if (!alias.equals(this.alias) || password != this.password && !password.equals(this.password)) {
            this.init(alias, password);
        }
    }

    public XmlSignatureCore init(String alias, String password) throws Exception {
        if (alias == null) {
            throw new NullPointerException("alias");
        }
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        KeyStore keyStore = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
        keyStore.load(null, null);
        KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(password == null ? "nopassword".toCharArray() : password.toCharArray()));
        if (entry == null) {
            throw new KeyStoreException("alias " + alias + " cannot be found in keyStore Windows-MY");
        }
        this.privateKey = entry.getPrivateKey();
        Certificate[] chain = keyStore.getCertificateChain(alias);
        X509Certificate cert = (X509Certificate)chain[0];
        ArrayList<Object> certs = new ArrayList<Object>();
        certs.add(cert.getSubjectDN().getName());
        certs.add(cert);
        this.factory = XMLSignatureFactory.getInstance("DOM");
        this.transforms = new ArrayList<Transform>();
        Transform enveloped = this.factory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        this.transforms.add(enveloped);
        this.sha1 = this.factory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        this.inclusive = this.factory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        this.rsasha1 = this.factory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        KeyInfoFactory keyFactory = this.factory.getKeyInfoFactory();
        X509Data data = keyFactory.newX509Data(certs);
        List<X509Data> dataList = Collections.singletonList(data);
        this.keyInfo = keyFactory.newKeyInfo(dataList);
        this.alias = alias;
        this.password = password;
        return this;
    }

    PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    SignedInfo newSignedInfo() {
        Reference ref = this.factory.newReference("#Signature_I", this.sha1, this.transforms, null, null);
        List<Reference> references = Collections.singletonList(ref);
        return this.factory.newSignedInfo(this.inclusive, this.rsasha1, references);
    }

    KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    XMLSignatureFactory getFactory() {
        return this.factory;
    }
}

