/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signature;

import ca.infodata.dsq.service.DSQTimeSourceProvider;
import ca.infodata.dsq.signature.Pkcs7SignatureFactory;
import java.util.Calendar;
import java.util.TimeZone;

public class TimestampSignatureIFactory {
    private Pkcs7SignatureFactory signatureI = new Pkcs7SignatureFactory();

    public static String computeNowTimestamp() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTimeInMillis(DSQTimeSourceProvider.currentTimeMillis());
        StringBuilder b = new StringBuilder(24);
        TimestampSignatureIFactory.appendPadded(c.get(1), 4, b);
        b.append('-');
        TimestampSignatureIFactory.appendPadded(c.get(2) + 1, 2, b);
        b.append('-');
        TimestampSignatureIFactory.appendPadded(c.get(5), 2, b);
        b.append('T');
        TimestampSignatureIFactory.appendPadded(c.get(11), 2, b);
        b.append(':');
        TimestampSignatureIFactory.appendPadded(c.get(12), 2, b);
        b.append(':');
        TimestampSignatureIFactory.appendPadded(c.get(13), 2, b);
        b.append('.');
        TimestampSignatureIFactory.appendPadded(c.get(14), 3, b);
        b.append('Z');
        return b.toString();
    }

    public static String computeTimestamp(long timestamp) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTimeInMillis(timestamp);
        StringBuilder b = new StringBuilder(24);
        TimestampSignatureIFactory.appendPadded(c.get(1), 4, b);
        b.append('-');
        TimestampSignatureIFactory.appendPadded(c.get(2) + 1, 2, b);
        b.append('-');
        TimestampSignatureIFactory.appendPadded(c.get(5), 2, b);
        b.append('T');
        TimestampSignatureIFactory.appendPadded(c.get(11), 2, b);
        b.append(':');
        TimestampSignatureIFactory.appendPadded(c.get(12), 2, b);
        b.append(':');
        TimestampSignatureIFactory.appendPadded(c.get(13), 2, b);
        b.append('.');
        TimestampSignatureIFactory.appendPadded(c.get(14), 3, b);
        b.append('Z');
        return b.toString();
    }

    private static void appendPadded(int number, int length, StringBuilder b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        if (number < 0) {
            throw new IllegalArgumentException("negative number are not supported");
        }
        int pad = TimestampSignatureIFactory.computePadding(number, length);
        for (int i = 0; i < pad; ++i) {
            b.append('0');
        }
        b.append(String.valueOf(number));
    }

    private static int computePadding(int number, int length) {
        int d = number >= 0 && number < 10 ? 1 : (number > 0 ? TimestampSignatureIFactory.fastLog10(number) + 1 : TimestampSignatureIFactory.fastLog10(-number) + 1 + 1);
        return length - d;
    }

    private static int fastLog10(int n) {
        int i = 10;
        int j = 0;
        while (n / i != 0) {
            i *= 10;
            ++j;
        }
        return j;
    }

    public String sign(String alias, String password, boolean forceResetCache) throws Exception {
        return this.signatureI.sign(alias, password, TimestampSignatureIFactory.computeNowTimestamp().getBytes(), forceResetCache);
    }

    public String sign(String alias, String password, long timestamp, boolean forceResetCache) throws Exception {
        return this.signatureI.sign(alias, password, TimestampSignatureIFactory.computeTimestamp(timestamp).getBytes(), forceResetCache);
    }

    public static void main(String[] args) {
        System.out.println(TimestampSignatureIFactory.computeNowTimestamp());
    }
}

