/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.ri;

import ca.infodata.dsq.domain.Gender;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_COLLEGE;
import ca.infodata.dsq.domain.NIU_I;
import ca.infodata.dsq.domain.NIU_LDS;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;

public final class FindProviderCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private NIU_I niu;
    private NIU_LDS lds;
    private NIU_COLLEGE niuCollege;
    private final String juridiction;
    private String firstName;
    private String lastName;
    private Long birthdateUTC;
    private Gender gender;
    private String role;
    private String specialityCode;
    private String typeIntervenant;
    private String cityEstablissement;
    private String postalCode;
    private String statusRights;

    public FindProviderCriteria(String juridiction) {
        if (juridiction == null) {
            throw new NullPointerException("juridiction");
        }
        this.juridiction = juridiction.toUpperCase();
    }

    public boolean hasDeliveryAddress() {
        boolean value = false;
        value = this.postalCode != null && this.cityEstablissement != null;
        return value;
    }

    public void setDeliveryAddress(String city, String postalCode, NIU_LDS lds) {
        this.cityEstablissement = city;
        this.postalCode = postalCode;
        this.lds = lds;
    }

    public NIU_I getNiu() {
        return this.niu;
    }

    public String getJuridiction() {
        return this.juridiction;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Long getBirthdateUTC() {
        return this.birthdateUTC;
    }

    public void setBirthdateUTC(Long birthdateUTC) {
        this.birthdateUTC = birthdateUTC;
    }

    public String getCityEstablissement() {
        return this.cityEstablissement;
    }

    public void setCityEstablissement(String cityEstablissement) {
        this.cityEstablissement = cityEstablissement;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public NIU getLds() {
        return this.lds;
    }

    public void setLds(NIU_LDS lds) {
        this.lds = lds;
    }

    public NIU_COLLEGE getNiuCollege() {
        return this.niuCollege;
    }

    public void setNiuCollege(NIU_COLLEGE niuCollege) {
        this.niuCollege = niuCollege;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getSpecialityCode() {
        return this.specialityCode;
    }

    public void setSpecialityCode(String specialityCode) {
        this.specialityCode = specialityCode;
    }

    public String getTypeIntervenant() {
        return this.typeIntervenant;
    }

    public void setTypeIntervenant(String typeIntervenant) {
        this.typeIntervenant = typeIntervenant;
    }

    public void setStatusRights(String statusRights) {
        this.statusRights = statusRights;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getStatusRights() {
        return this.statusRights;
    }

    public void setNiu(NIU_I niu) {
        this.niu = niu;
    }

    public String toString() {
        return String.format("ProviderCriteria [birthdateUTC=%s(%s), cityEstablissement=%s, firstName=%s, gender=%s, juridiction=%s, lastName=%s, lds=%s, niu=%s, niuCollege=%s, postalCode=%s, role=%s, specialityCode=%s, statusRights=%s, typeIntervenant=%s]", new Object[]{Helper.formatFULLDATE(this.birthdateUTC), this.birthdateUTC, this.cityEstablissement, this.firstName, this.gender, this.juridiction, this.lastName, this.lds, this.niu, this.niuCollege, this.postalCode, this.role, this.specialityCode, this.statusRights, this.typeIntervenant});
    }
}

