/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.dm.DMC0103Svc;

import ca.infodata.dsq.domain.ICandidate;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.fco.CandidateConsentDirective;
import java.io.Serializable;

public final class GetDrugDispenseDetailCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String dispenseNumber;
    private ICandidate candidate;
    private IProvider provider;
    private CandidateConsentDirective consentDirective;

    public GetDrugDispenseDetailCriteria(String dispenseNumber, ICandidate candidate, IProvider provider, CandidateConsentDirective consentDirective) {
        if (dispenseNumber == null) {
            throw new NullPointerException("dispenseNumber");
        }
        if (candidate == null) {
            throw new NullPointerException("candidate");
        }
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        if (consentDirective == null) {
            throw new NullPointerException("consentDirective");
        }
        if (!consentDirective.hasAccepted()) {
            throw new IllegalArgumentException("candidate has refused consent to his data");
        }
        this.dispenseNumber = dispenseNumber;
        this.candidate = candidate;
        this.provider = provider;
        this.consentDirective = consentDirective;
    }

    public String getDispenseNumber() {
        return this.dispenseNumber;
    }

    public ICandidate getCandidate() {
        return this.candidate;
    }

    public IProvider getProvider() {
        return this.provider;
    }

    public CandidateConsentDirective getConsentDirective() {
        return this.consentDirective;
    }

    public String toString() {
        return String.format("CandidateSingleDrugDispenseCriteria [candidate=%s, consentDirective=%s, dispenseNumber=%s, provider=%s]", this.candidate, this.consentDirective, this.dispenseNumber, this.provider);
    }
}

