/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.dm.DMC0102Svc;

import ca.infodata.dsq.domain.ICandidate;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.fco.CandidateConsentDirective;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;

public final class GetDrugDispensesSummaryCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ICandidate usager;
    private IProvider intervenant;
    private CandidateConsentDirective consentDirective;
    private long startdate;
    private long enddate;
    private boolean mostRecentDispenseForEachRxIndicator = true;
    private Integer limit;

    public GetDrugDispensesSummaryCriteria(long startdate, long enddate, ICandidate candidate, IProvider provider, CandidateConsentDirective consentDirective) {
        if (candidate == null) {
            throw new NullPointerException("candidate");
        }
        if (provider == null) {
            throw new NullPointerException("provider");
        }
        if (consentDirective == null) {
            throw new NullPointerException("consentDirective");
        }
        if (!consentDirective.hasAccepted()) {
            throw new IllegalArgumentException("candidate has refused consent to his data");
        }
        if (startdate > enddate) {
            throw new IllegalArgumentException("startdate muste be < enddate");
        }
        this.startdate = startdate;
        this.enddate = enddate;
        this.usager = candidate;
        this.intervenant = provider;
        this.consentDirective = consentDirective;
    }

    public ICandidate getCandidate() {
        return this.usager;
    }

    public IProvider getProvider() {
        return this.intervenant;
    }

    public CandidateConsentDirective getConsentDirective() {
        return this.consentDirective;
    }

    public long getStartdate() {
        return this.startdate;
    }

    public long getEnddate() {
        return this.enddate;
    }

    public boolean getMostRecentDispenseForEachRxIndicator() {
        return this.mostRecentDispenseForEachRxIndicator;
    }

    public void setMostRecentDispenseForEachRxIndicator(boolean mostRecentDispenseForEachRxIndicator) {
        this.mostRecentDispenseForEachRxIndicator = mostRecentDispenseForEachRxIndicator;
    }

    public String toString() {
        return String.format("CandidateDrugDispensesCriteria [startdate=%s, enddate=%s, usager=%s, mostRecentDispenseForEachRxIndicator=%s, intervenant=%s, consentDirective=%s, limit=%s]", Helper.formatFULLDATE(this.startdate), this.startdate, Helper.formatFULLDATE(this.enddate), this.enddate, this.usager, this.mostRecentDispenseForEachRxIndicator, this.intervenant, this.consentDirective, this.limit);
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

