/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.Gender;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_COLLEGE;
import ca.infodata.dsq.domain.NIU_I;
import ca.infodata.dsq.domain.NIU_IPC;
import ca.infodata.dsq.domain.NIU_RAMQ;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Provider
implements IProvider {
    private static final long serialVersionUID = 1L;
    public final String firstName;
    public final String lastName;
    public final Gender gender;
    public final Long birthdate;
    public final List<NIU> nius;
    public final Code code;
    public final String status;
    public final List<String> specialities;
    public final List<Long> specialitiesStartdate;
    public final List<Long> specialitiesEnddate;
    public final List<ILocation> locations;
    public final List<Long> locationsStartdate;
    public final List<Long> locationsEnddate;

    public Provider(String firstName, String lastName, NIU ... nius) {
        this(firstName, lastName, null, null, Provider.toList(nius), null, null, null, null, null, null, null, null);
    }

    private static List<NIU> toList(NIU[] nius2) {
        if (nius2 != null) {
            ArrayList<NIU> list = new ArrayList<NIU>(nius2.length);
            for (NIU niu : nius2) {
                list.add(niu);
            }
            return list;
        }
        return null;
    }

    public Provider(String firstName, String lastName, List<NIU> nius) {
        this(firstName, lastName, null, null, nius, null, null, null, null, null, null, null, null);
    }

    public Provider(String firstName, String lastName, Gender gender, Long birthdate, List<NIU> nius, Code code, String status, List<String> specialities, List<Long> specialitiesStartdate, List<Long> specialitiesEnddate, List<ILocation> locations, List<Long> locationsStartdate, List<Long> locationsEnddate) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.gender = gender;
        this.birthdate = birthdate;
        this.nius = Collections.unmodifiableList(nius);
        this.code = code;
        this.status = status;
        this.specialities = specialities == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(specialities);
        this.specialitiesStartdate = specialitiesStartdate == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(specialitiesStartdate);
        this.specialitiesEnddate = specialitiesEnddate == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(specialitiesEnddate);
        this.locations = locations == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(locations);
        this.locationsStartdate = locationsStartdate == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(locationsStartdate);
        this.locationsEnddate = locationsEnddate == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(locationsEnddate);
    }

    @Override
    public NIU_I getNIU_I() {
        return (NIU_I)Provider.getNIU(this.nius, NIU_I.class);
    }

    @Override
    public NIU_COLLEGE getNIU_COLLEGE() {
        return (NIU_COLLEGE)Provider.getNIU(this.nius, NIU_COLLEGE.class);
    }

    public NIU_RAMQ getNIU_RAMQ() {
        return (NIU_RAMQ)Provider.getNIU(this.nius, NIU_RAMQ.class);
    }

    public NIU_IPC getNIU_IPC() {
        return (NIU_IPC)Provider.getNIU(this.nius, NIU_IPC.class);
    }

    private static NIU getNIU(List<NIU> nius, Class c) {
        for (NIU niu : nius) {
            if (!niu.getClass().equals(c)) continue;
            return niu;
        }
        return null;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public Code getCode() {
        return this.code;
    }

    public String toString() {
        return String.format("Provider [gender=%s, firstName=%s, lastName=%s, code=%s, nius=%s, status=%s, specialities=%s, specialitiesStartdate=%s, specialitiesEnddate=%s, locations=%s, locationsStartdate=%s, locationsEnddate=%s]", new Object[]{this.gender, this.firstName, this.lastName, this.code, this.nius, this.status, this.specialities, this.specialitiesStartdate, this.specialitiesEnddate, this.locations, this.locationsStartdate, this.locationsEnddate});
    }

    private Object writeReplace() {
        return new ProviderProxy(this);
    }

    @Override
    public ILocation getRepresentedOrganization() {
        return null;
    }

    private static class ProviderProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String firstName;
        private String lastName;
        private Gender gender;
        private Long birthdate;
        private List<NIU> nius;
        private Code code;
        private String status;
        private List<String> specialities;
        private List<Long> specialitiesStartdate;
        private List<Long> specialitiesEnddate;
        private List<ILocation> locations;
        private List<Long> locationsStartdate;
        private List<Long> locationsEnddate;

        public ProviderProxy(Provider provider) {
            this.firstName = provider.firstName;
            this.lastName = provider.lastName;
            this.gender = provider.gender;
            this.birthdate = provider.birthdate;
            this.nius = new ArrayList<NIU>(provider.nius);
            this.firstName = provider.firstName;
            this.code = provider.code;
            this.status = provider.status;
            this.specialities = new ArrayList<String>(provider.specialities);
            this.specialitiesStartdate = new ArrayList<Long>(provider.specialitiesStartdate);
            this.specialitiesEnddate = new ArrayList<Long>(provider.specialitiesEnddate);
            this.locations = new ArrayList<ILocation>(provider.locations);
            this.locationsStartdate = new ArrayList<Long>(provider.locationsStartdate);
            this.locationsEnddate = new ArrayList<Long>(provider.locationsEnddate);
        }

        private Object readResolve() {
            return new Provider(this.firstName, this.lastName, this.gender, this.birthdate, this.nius, this.code, this.status, this.specialities, this.specialitiesStartdate, this.specialitiesEnddate, this.locations, this.locationsStartdate, this.locationsEnddate);
        }
    }
}

