/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.Device;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IPrescriptionDetails;
import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.Refusal;
import ca.infodata.dsq.domain.TherapeuticIntent;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;

public final class PrescriptionDeviceSummary
implements Serializable,
IPrescriptionSummary {
    private static final long serialVersionUID = 1L;
    public int sequence;
    public String id;
    public String version;
    public Code status;
    public Long datetime;
    public IProvider prescriber;
    public Device device;
    public ArrayList<TherapeuticIntent> reasons;
    public Boolean electronicVersionHasAuthority;
    public String usageInstructions;
    public ILocation supplyRequestLocation;
    public Long supplyRequestLocationPickupDate;
    public BigInteger supplyRequestTotalQuantity;
    public ArrayList<Refusal> refusalsToFill;
    public Boolean hasIssues;
    public Boolean hasAnnotations;
    public IPrescriptionDetails detail;

    @Override
    public IPrescriptionDetails getDetail() {
        return this.detail;
    }

    @Override
    public void setDetail(IPrescriptionDetails detail) {
        this.detail = detail;
    }

    public PrescriptionDeviceSummary() {
    }

    public PrescriptionDeviceSummary(String id, String version, Code status, Long datetime, IProvider prescriber, ArrayList<TherapeuticIntent> reasons, Boolean electronicVersionHasAuthority, String usageInstructions, Device device, BigInteger supplyRequestTotalQuantity, ILocation supplyRequestLocation, Long supplyRequestLocationPickupDate, ArrayList<Refusal> refusalsToFill, Boolean hasIssues, Boolean hasAnnotations) {
        this.id = id;
        this.version = version;
        this.status = status;
        this.datetime = datetime;
        this.prescriber = prescriber;
        this.reasons = reasons;
        this.usageInstructions = usageInstructions;
        this.device = device;
        this.electronicVersionHasAuthority = electronicVersionHasAuthority;
        this.supplyRequestLocationPickupDate = supplyRequestLocationPickupDate;
        this.supplyRequestLocation = supplyRequestLocation;
        this.supplyRequestTotalQuantity = supplyRequestTotalQuantity;
        this.refusalsToFill = refusalsToFill;
        this.hasIssues = hasIssues;
        this.hasAnnotations = hasAnnotations;
    }

    public String toString() {
        return String.format("PrescriptionDeviceSummary [id=%s, version=%s, status=%s, date=%s, \nPrescriber %s\nReasons %s\nElectronic Version Has Authority %s,\nDevice %s\nSupplyRequest totalQuantity=%s, location=%s, pickupDate=%s(%s)\nRefusalToFill %s\nhasIssues=%s, hasAnnotations=%s]", this.id, this.version, this.status, this.datetime, this.prescriber, this.reasons, this.electronicVersionHasAuthority, this.device, this.supplyRequestTotalQuantity, this.supplyRequestLocation, this.supplyRequestLocationPickupDate, Helper.formatFULLDATETIME(this.supplyRequestLocationPickupDate), this.refusalsToFill, this.hasIssues, this.hasAnnotations);
    }

    @Override
    public Long getDatetime() {
        return this.datetime;
    }

    @Override
    public Boolean getElectronicVersionHasAuthority() {
        return this.electronicVersionHasAuthority;
    }

    @Override
    public Boolean getHasAnnotations() {
        return this.hasAnnotations;
    }

    @Override
    public Boolean getHasIssues() {
        return this.hasIssues;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IProvider getPrescriber() {
        return this.prescriber;
    }

    @Override
    public ArrayList<TherapeuticIntent> getReasons() {
        return this.reasons;
    }

    @Override
    public ArrayList<Refusal> getRefusalsToFill() {
        return this.refusalsToFill;
    }

    @Override
    public Code getStatus() {
        return this.status;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ILocation getSupplyRequestLocation() {
        return this.supplyRequestLocation;
    }
}

