/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.ILocation;
import ca.infodata.dsq.domain.IProvider;
import ca.infodata.dsq.domain.NIU;
import ca.infodata.dsq.domain.NIU_I;

public final class BasicProvider
implements IProvider {
    private static final long serialVersionUID = 1L;
    private final NIU_I niuI;
    private final NIU niuCollege;
    private final String firstName;
    private final String lastName;
    private final ILocation representedOrganization;
    private final Code code;

    public BasicProvider(NIU_I niuI, NIU niuCollege, String firstName, String lastName) {
        if (firstName == null) {
            throw new NullPointerException("firstName");
        }
        if (lastName == null) {
            throw new NullPointerException("lastName");
        }
        this.niuI = niuI;
        this.niuCollege = niuCollege;
        this.firstName = firstName;
        this.lastName = lastName;
        this.representedOrganization = null;
        this.code = null;
    }

    public BasicProvider(NIU_I niuI, NIU niuCollege, String firstName, String lastName, ILocation representedOrganization, Code code) {
        if (firstName == null) {
            throw new NullPointerException("firstName");
        }
        if (lastName == null) {
            throw new NullPointerException("lastName");
        }
        this.niuI = niuI;
        this.niuCollege = niuCollege;
        this.firstName = firstName;
        this.lastName = lastName;
        this.representedOrganization = representedOrganization;
        this.code = code;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public NIU getNIU_COLLEGE() {
        return this.niuCollege;
    }

    @Override
    public NIU_I getNIU_I() {
        return this.niuI;
    }

    public String toString() {
        return String.format("BasicProvider [%s %s, niuI=%s, niuCollege=%s, representedOrganization=%s]", this.firstName, this.lastName, this.niuI, this.niuCollege, this.representedOrganization);
    }

    @Override
    public Code getCode() {
        return this.code;
    }

    @Override
    public ILocation getRepresentedOrganization() {
        return this.representedOrganization;
    }
}

