/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;
import org.ddogleg.struct.GrowQueue;

public class GrowQueue_I8
implements GrowQueue<GrowQueue_I8> {
    public byte[] data;
    public int size;

    public GrowQueue_I8(int maxSize) {
        this.data = new byte[maxSize];
        this.size = 0;
    }

    public GrowQueue_I8() {
        this(10);
    }

    public static GrowQueue_I8 zeros(int length) {
        GrowQueue_I8 out = new GrowQueue_I8(length);
        out.size = length;
        return out;
    }

    public static GrowQueue_I8 array(int ... values) {
        GrowQueue_I8 out = GrowQueue_I8.zeros(values.length);
        for (int i = 0; i < values.length; ++i) {
            out.data[i] = (byte)values[i];
        }
        return out;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    public void addAll(GrowQueue_I8 queue) {
        if (this.size + queue.size > this.data.length) {
            byte[] temp = new byte[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void addAll(byte[] array, int startIndex, int endIndex) {
        if (endIndex > array.length) {
            throw new IllegalAccessError("endIndex is larger than input array");
        }
        int arraySize = endIndex - startIndex;
        if (this.size + arraySize > this.data.length) {
            byte[] temp = new byte[(this.size + arraySize) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(array, startIndex, this.data, this.size, arraySize);
        this.size += arraySize;
    }

    public void add(int value) {
        this.push(value);
    }

    public void push(int val) {
        if (this.size == this.data.length) {
            byte[] temp = new byte[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = (byte)val;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("index = " + index + "  size = " + this.size);
        }
        return this.data[index];
    }

    public int getFraction(double fraction) {
        return this.get((int)((double)(this.size - 1) * fraction));
    }

    public int unsafe_get(int index) {
        return this.data[index];
    }

    public void set(int index, int value) {
        this.data[index] = (byte)value;
    }

    @Override
    public void setTo(GrowQueue_I8 original) {
        this.resize(original.size);
        System.arraycopy(original.data, 0, this.data, 0, this.size());
    }

    public void insert(int index, int value) {
        if (this.size == this.data.length) {
            byte[] temp = new byte[this.size * 2 + 5];
            System.arraycopy(this.data, 0, temp, 0, index);
            temp[index] = (byte)value;
            System.arraycopy(this.data, index, temp, index + 1, this.size - index);
            this.data = temp;
            ++this.size;
        } else {
            ++this.size;
            for (int i = this.size - 1; i > index; --i) {
                this.data[i] = this.data[i - 1];
            }
            this.data[index] = (byte)value;
        }
    }

    public byte removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new RuntimeException("Size zero, no tail");
    }

    public void setTo(byte[] array, int offset, int length) {
        this.resize(length);
        System.arraycopy(array, offset, this.data, 0, length);
    }

    public void remove(int first, int last) {
        if (last < first) {
            throw new IllegalArgumentException("first <= last");
        }
        if (last >= this.size) {
            throw new IllegalArgumentException("last must be less than the max size");
        }
        int delta = last - first + 1;
        for (int i = last + 1; i < this.size; ++i) {
            this.data[i - delta] = this.data[i];
        }
        this.size -= delta;
    }

    public void fill(byte value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public boolean contains(byte value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new byte[size];
        }
        this.size = size;
    }

    @Override
    public void extend(int size) {
        if (this.data.length < size) {
            byte[] tmp = new byte[size];
            System.arraycopy(this.data, 0, tmp, 0, this.size);
            this.data = tmp;
        }
        this.size = size;
    }

    @Override
    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new byte[size];
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public int pop() {
        return this.data[--this.size];
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.size, (byte)0);
    }

    @Override
    public GrowQueue_I8 copy() {
        GrowQueue_I8 ret = new GrowQueue_I8(this.size);
        ret.setTo(this);
        return ret;
    }

    @Override
    public void flip() {
        if (this.size <= 1) {
            return;
        }
        int D2 = this.size / 2;
        int i = 0;
        int j = this.size - 1;
        while (i < D2) {
            byte tmp = this.data[i];
            this.data[i] = this.data[j];
            this.data[j] = tmp;
            ++i;
            --j;
        }
    }

    public void printHex() {
        System.out.print("[ ");
        for (int i = 0; i < this.size; ++i) {
            System.out.printf("0x%02X ", this.data[i]);
        }
        System.out.print("]");
    }

    public static GrowQueue_I8 parseHex(String message) {
        message = message.replaceAll("\\[", "");
        message = message.replaceAll("\\]", "");
        message = message.replaceAll(" ", "");
        String[] words = message.split(",");
        GrowQueue_I8 out = new GrowQueue_I8(words.length);
        out.size = words.length;
        for (int i = 0; i < words.length; ++i) {
            out.data[i] = Integer.decode(words[i]).byteValue();
        }
        return out;
    }

    public int indexOf(byte value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void sort() {
        Arrays.sort(this.data, 0, this.size);
    }
}

