/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.alg.AxisSplitRuleMax;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.AxisSplitterMedian;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.ddogleg.struct.GrowQueue_I32;

public class KdTreeConstructor<P> {
    AxisSplitter<P> splitter;
    KdTreeMemory<P> memory;

    public KdTreeConstructor(KdTreeMemory<P> memory, AxisSplitter<P> splitter) {
        this.memory = memory;
        this.splitter = splitter;
    }

    public KdTreeConstructor(KdTreeDistance<P> distance) {
        this(new KdTreeMemory(), new AxisSplitterMedian<P>(distance, new AxisSplitRuleMax()));
    }

    public KdTree construct(List<P> points, boolean trackIndexes) {
        GrowQueue_I32 indexes = null;
        if (trackIndexes) {
            indexes = new GrowQueue_I32();
            indexes.resize(points.size());
            for (int i = 0; i < indexes.size; ++i) {
                indexes.data[i] = i;
            }
        }
        KdTree tree = this.memory.requestTree(this.splitter.getPointLength());
        if (points.size() == 1) {
            tree.root = this.createLeaf(points, indexes);
        } else if (points.size() > 1) {
            tree.root = this.computeBranch(points, indexes);
        }
        return tree;
    }

    protected KdTree.Node computeBranch(List<P> points, GrowQueue_I32 indexes) {
        GrowQueue_I32 rightIndexes;
        GrowQueue_I32 leftIndexes;
        ArrayList left = new ArrayList(points.size() / 2);
        ArrayList right = new ArrayList(points.size() / 2);
        if (indexes == null) {
            leftIndexes = null;
            rightIndexes = null;
        } else {
            leftIndexes = new GrowQueue_I32(points.size() / 2);
            rightIndexes = new GrowQueue_I32(points.size() / 2);
        }
        this.splitter.splitData(points, indexes, left, leftIndexes, right, rightIndexes);
        KdTree.Node node = this.memory.requestNode();
        node.split = this.splitter.getSplitAxis();
        node.point = this.splitter.getSplitPoint();
        node.index = this.splitter.getSplitIndex();
        node.left = this.computeChild(left, leftIndexes);
        left = null;
        leftIndexes = null;
        node.right = this.computeChild(right, rightIndexes);
        return node;
    }

    protected KdTree.Node computeChild(List<P> points, GrowQueue_I32 indexes) {
        if (points.size() == 0) {
            return null;
        }
        if (points.size() == 1) {
            return this.createLeaf(points, indexes);
        }
        return this.computeBranch(points, indexes);
    }

    private KdTree.Node createLeaf(List<P> points, GrowQueue_I32 indexes) {
        int index = indexes == null ? -1 : indexes.get(0);
        return this.memory.requestNode(points.get(0), index);
    }
}

