/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.background;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.background.moving.BackgroundMovingBasic_IL;
import boofcv.alg.background.moving.BackgroundMovingBasic_PL;
import boofcv.alg.background.moving.BackgroundMovingBasic_SB;
import boofcv.alg.background.moving.BackgroundMovingGaussian;
import boofcv.alg.background.moving.BackgroundMovingGaussian_IL;
import boofcv.alg.background.moving.BackgroundMovingGaussian_PL;
import boofcv.alg.background.moving.BackgroundMovingGaussian_SB;
import boofcv.alg.background.moving.BackgroundMovingGmm;
import boofcv.alg.background.moving.BackgroundMovingGmm_MB;
import boofcv.alg.background.moving.BackgroundMovingGmm_SB;
import boofcv.alg.background.stationary.BackgroundStationaryBasic;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_IL;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_PL;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_SB;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_IL;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_PL;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_SB;
import boofcv.alg.background.stationary.BackgroundStationaryGmm;
import boofcv.alg.background.stationary.BackgroundStationaryGmm_MB;
import boofcv.alg.background.stationary.BackgroundStationaryGmm_SB;
import boofcv.factory.background.ConfigBackgroundBasic;
import boofcv.factory.background.ConfigBackgroundGaussian;
import boofcv.factory.background.ConfigBackgroundGmm;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FactoryBackgroundModel {
    public static <T extends ImageBase<T>> BackgroundStationaryBasic<T> stationaryBasic(@Nonnull ConfigBackgroundBasic config, ImageType<T> imageType) {
        config.checkValidity();
        switch (imageType.getFamily()) {
            case GRAY: {
                return new BackgroundStationaryBasic_SB(config.learnRate, config.threshold, imageType.getImageClass());
            }
            case PLANAR: {
                return new BackgroundStationaryBasic_PL(config.learnRate, config.threshold, imageType);
            }
            case INTERLEAVED: {
                return new BackgroundStationaryBasic_IL(config.learnRate, config.threshold, imageType);
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageBase<T>, Motion extends InvertibleTransform<Motion>> BackgroundMovingBasic<T, Motion> movingBasic(@Nonnull ConfigBackgroundBasic config, Point2Transform2Model_F32<Motion> transform, ImageType<T> imageType) {
        BackgroundMovingBasic ret;
        config.checkValidity();
        switch (imageType.getFamily()) {
            case GRAY: {
                ret = new BackgroundMovingBasic_SB(config.learnRate, config.threshold, transform, config.interpolation, imageType.getImageClass());
                break;
            }
            case PLANAR: {
                ret = new BackgroundMovingBasic_PL(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                break;
            }
            case INTERLEAVED: {
                ret = new BackgroundMovingBasic_IL(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type");
            }
        }
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }

    public static <T extends ImageBase<T>> BackgroundStationaryGaussian<T> stationaryGaussian(@Nonnull ConfigBackgroundGaussian config, ImageType<T> imageType) {
        BackgroundStationaryGaussian ret;
        config.checkValidity();
        switch (imageType.getFamily()) {
            case GRAY: {
                ret = new BackgroundStationaryGaussian_SB(config.learnRate, config.threshold, imageType.getImageClass());
                break;
            }
            case PLANAR: {
                ret = new BackgroundStationaryGaussian_PL(config.learnRate, config.threshold, imageType);
                break;
            }
            case INTERLEAVED: {
                ret = new BackgroundStationaryGaussian_IL(config.learnRate, config.threshold, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type");
            }
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMinimumDifference(config.minimumDifference);
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }

    public static <T extends ImageBase<T>, Motion extends InvertibleTransform<Motion>> BackgroundMovingGaussian<T, Motion> movingGaussian(@Nonnull ConfigBackgroundGaussian config, Point2Transform2Model_F32<Motion> transform, ImageType<T> imageType) {
        BackgroundMovingGaussian ret;
        config.checkValidity();
        switch (imageType.getFamily()) {
            case GRAY: {
                ret = new BackgroundMovingGaussian_SB(config.learnRate, config.threshold, transform, config.interpolation, imageType.getImageClass());
                break;
            }
            case PLANAR: {
                ret = new BackgroundMovingGaussian_PL(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                break;
            }
            case INTERLEAVED: {
                ret = new BackgroundMovingGaussian_IL(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type");
            }
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMinimumDifference(config.minimumDifference);
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }

    public static <T extends ImageBase<T>> BackgroundStationaryGmm<T> stationaryGmm(@Nullable ConfigBackgroundGmm config, ImageType<T> imageType) {
        BackgroundStationaryGmm ret;
        if (config == null) {
            config = new ConfigBackgroundGmm();
        } else {
            config.checkValidity();
        }
        switch (imageType.getFamily()) {
            case GRAY: {
                ret = new BackgroundStationaryGmm_SB<T>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, imageType);
                break;
            }
            case PLANAR: 
            case INTERLEAVED: {
                ret = new BackgroundStationaryGmm_MB<T>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type");
            }
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMaxDistance(config.maxDistance);
        ret.setSignificantWeight(config.significantWeight);
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }

    public static <T extends ImageBase<T>, Motion extends InvertibleTransform<Motion>> BackgroundMovingGmm<T, Motion> movingGmm(@Nullable ConfigBackgroundGmm config, Point2Transform2Model_F32<Motion> transform, ImageType<T> imageType) {
        BackgroundMovingGmm ret;
        if (config == null) {
            config = new ConfigBackgroundGmm();
        } else {
            config.checkValidity();
        }
        switch (imageType.getFamily()) {
            case GRAY: {
                ret = new BackgroundMovingGmm_SB<T, Motion>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, transform, imageType);
                break;
            }
            case PLANAR: 
            case INTERLEAVED: {
                ret = new BackgroundMovingGmm_MB<T, Motion>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, transform, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type");
            }
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMaxDistance(config.maxDistance);
        ret.setSignificantWeight(config.significantWeight);
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }
}

