/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrixRMaj;

public class PairwiseImageGraph {
    public List<View> nodes = new ArrayList<View>();
    public List<Motion> edges = new ArrayList<Motion>();
    public Map<String, Camera> cameras = new HashMap<String, Camera>();

    public void addCamera(Camera camera) {
        this.cameras.put(camera.camera, camera);
    }

    public List<Motion> findCameraMotions(Camera target, @Nullable List<Motion> storage) {
        if (storage == null) {
            storage = new ArrayList<Motion>();
        }
        for (int i = 0; i < this.edges.size(); ++i) {
            Motion m = this.edges.get(i);
            if (m.viewSrc.camera != target || m.viewDst.camera != target) continue;
            storage.add(m);
        }
        return storage;
    }

    static class Motion {
        public DMatrixRMaj F = new DMatrixRMaj(3, 3);
        public boolean metric;
        public List<AssociatedIndex> associated = new ArrayList<AssociatedIndex>();
        public View viewSrc;
        public View viewDst;
        public int index;

        Motion() {
        }

        public View destination(View src) {
            if (src == this.viewSrc) {
                return this.viewDst;
            }
            if (src == this.viewDst) {
                return this.viewSrc;
            }
            throw new RuntimeException("BUG!");
        }
    }

    static class View {
        Camera camera;
        public int index;
        public List<Motion> connections = new ArrayList<Motion>();
        public FastQueue<TupleDesc> descriptions;
        public FastQueue<Point2D_F64> observationPixels = new FastQueue<Point2D_F64>(Point2D_F64.class, true);
        public FastQueue<Point2D_F64> observationNorm = new FastQueue<Point2D_F64>(Point2D_F64.class, true);

        public View(int index, FastQueue<TupleDesc> descriptions) {
            this.index = index;
            this.descriptions = descriptions;
        }
    }

    static class Camera {
        public String camera;
        public Point2Transform2_F64 pixelToNorm;
        public CameraPinhole pinhole;

        public Camera(String camera, Point2Transform2_F64 pixelToNorm, CameraPinhole pinhole) {
            this.camera = camera;
            this.pixelToNorm = pixelToNorm;
            this.pinhole = pinhole;
        }
    }
}

