/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;

public class Zhang99CalibrationMatrixFromHomographies {
    private DMatrixRMaj A = new DMatrixRMaj(1, 1);
    private SolveNullSpaceSvd_DDRM solverNull = new SolveNullSpaceSvd_DDRM();
    private DMatrixRMaj b;
    private DMatrixRMaj K = new DMatrixRMaj(3, 3);
    private boolean assumeZeroSkew;

    public Zhang99CalibrationMatrixFromHomographies(boolean assumeZeroSkew) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.b = assumeZeroSkew ? new DMatrixRMaj(5, 1) : new DMatrixRMaj(6, 1);
    }

    public void process(List<DMatrixRMaj> homographies) {
        if (this.assumeZeroSkew) {
            if (homographies.size() < 2) {
                throw new IllegalArgumentException("At least two homographies are required. Found " + homographies.size());
            }
        } else if (homographies.size() < 3) {
            throw new IllegalArgumentException("At least three homographies are required. Found " + homographies.size());
        }
        if (this.assumeZeroSkew) {
            this.setupA_NoSkew(homographies);
            if (!this.solverNull.process(this.A, 1, this.b)) {
                throw new RuntimeException("SVD failed");
            }
            this.computeParam_ZeroSkew();
        } else {
            this.setupA(homographies);
            if (!this.solverNull.process(this.A, 1, this.b)) {
                throw new RuntimeException("SVD failed");
            }
            this.computeParam();
        }
        if (MatrixFeatures_DDRM.hasUncountable(this.K)) {
            throw new RuntimeException("Failed!");
        }
    }

    private void setupA(List<DMatrixRMaj> homographies) {
        this.A.reshape(2 * homographies.size(), 6, false);
        DMatrixRMaj h1 = new DMatrixRMaj(3, 1);
        DMatrixRMaj h2 = new DMatrixRMaj(3, 1);
        DMatrixRMaj v12 = new DMatrixRMaj(1, 6);
        DMatrixRMaj v11 = new DMatrixRMaj(1, 6);
        DMatrixRMaj v22 = new DMatrixRMaj(1, 6);
        DMatrixRMaj v11m22 = new DMatrixRMaj(1, 6);
        for (int i = 0; i < homographies.size(); ++i) {
            DMatrixRMaj H = homographies.get(i);
            CommonOps_DDRM.extract(H, 0, 3, 0, 1, h1, 0, 0);
            CommonOps_DDRM.extract(H, 0, 3, 1, 2, h2, 0, 0);
            double max1 = CommonOps_DDRM.elementMaxAbs(h1);
            double max2 = CommonOps_DDRM.elementMaxAbs(h2);
            double max = Math.max(max1, max2);
            CommonOps_DDRM.divide(h1, max);
            CommonOps_DDRM.divide(h2, max);
            this.computeV(h1, h2, v12);
            this.computeV(h1, h1, v11);
            this.computeV(h2, h2, v22);
            CommonOps_DDRM.subtract((DMatrixD1)v11, (DMatrixD1)v22, (DMatrixD1)v11m22);
            CommonOps_DDRM.insert(v12, this.A, i * 2, 0);
            CommonOps_DDRM.insert(v11m22, this.A, i * 2 + 1, 0);
        }
    }

    private void setupA_NoSkew(List<DMatrixRMaj> homographies) {
        this.A.reshape(2 * homographies.size(), 5, false);
        DMatrixRMaj h1 = new DMatrixRMaj(3, 1);
        DMatrixRMaj h2 = new DMatrixRMaj(3, 1);
        DMatrixRMaj v12 = new DMatrixRMaj(1, 5);
        DMatrixRMaj v11 = new DMatrixRMaj(1, 5);
        DMatrixRMaj v22 = new DMatrixRMaj(1, 5);
        DMatrixRMaj v11m22 = new DMatrixRMaj(1, 5);
        for (int i = 0; i < homographies.size(); ++i) {
            DMatrixRMaj H = homographies.get(i);
            CommonOps_DDRM.extract(H, 0, 3, 0, 1, h1, 0, 0);
            CommonOps_DDRM.extract(H, 0, 3, 1, 2, h2, 0, 0);
            double max1 = CommonOps_DDRM.elementMaxAbs(h1);
            double max2 = CommonOps_DDRM.elementMaxAbs(h2);
            double max = Math.max(max1, max2);
            CommonOps_DDRM.divide(h1, max);
            CommonOps_DDRM.divide(h2, max);
            this.computeV_NoSkew(h1, h2, v12);
            this.computeV_NoSkew(h1, h1, v11);
            this.computeV_NoSkew(h2, h2, v22);
            CommonOps_DDRM.subtract((DMatrixD1)v11, (DMatrixD1)v22, (DMatrixD1)v11m22);
            CommonOps_DDRM.insert(v12, this.A, i * 2, 0);
            CommonOps_DDRM.insert(v11m22, this.A, i * 2 + 1, 0);
        }
    }

    private void computeV(DMatrixRMaj h1, DMatrixRMaj h2, DMatrixRMaj v) {
        double h1x = h1.get(0, 0);
        double h1y = h1.get(1, 0);
        double h1z = h1.get(2, 0);
        double h2x = h2.get(0, 0);
        double h2y = h2.get(1, 0);
        double h2z = h2.get(2, 0);
        v.set(0, 0, h1x * h2x);
        v.set(0, 1, h1x * h2y + h1y * h2x);
        v.set(0, 2, h1y * h2y);
        v.set(0, 3, h1z * h2x + h1x * h2z);
        v.set(0, 4, h1z * h2y + h1y * h2z);
        v.set(0, 5, h1z * h2z);
    }

    private void computeV_NoSkew(DMatrixRMaj h1, DMatrixRMaj h2, DMatrixRMaj v) {
        double h1x = h1.get(0, 0);
        double h1y = h1.get(1, 0);
        double h1z = h1.get(2, 0);
        double h2x = h2.get(0, 0);
        double h2y = h2.get(1, 0);
        double h2z = h2.get(2, 0);
        v.set(0, 0, h1x * h2x);
        v.set(0, 1, h1y * h2y);
        v.set(0, 2, h1z * h2x + h1x * h2z);
        v.set(0, 3, h1z * h2y + h1y * h2z);
        v.set(0, 4, h1z * h2z);
    }

    private void computeParam() {
        CommonOps_DDRM.divide(this.b, CommonOps_DDRM.elementMaxAbs(this.b));
        double B11 = this.b.get(0, 0);
        double B12 = this.b.get(1, 0);
        double B22 = this.b.get(2, 0);
        double B13 = this.b.get(3, 0);
        double B23 = this.b.get(4, 0);
        double B33 = this.b.get(5, 0);
        double temp0 = B12 * B13 - B11 * B23;
        double temp1 = B11 * B22 - B12 * B12;
        double v0 = temp0 / temp1;
        double lambda = B33 - (B13 * B13 + v0 * temp0) / B11;
        double a = Math.sqrt(Math.abs(lambda / B11));
        double b = Math.sqrt(Math.abs(lambda * B11 / temp1));
        double c = -B12 * b / B11;
        double u0 = c * v0 / a - B13 / B11;
        this.K.set(0, 0, a);
        this.K.set(0, 1, c);
        this.K.set(0, 2, u0);
        this.K.set(1, 1, b);
        this.K.set(1, 2, v0);
        this.K.set(2, 2, 1.0);
    }

    private void computeParam_ZeroSkew() {
        CommonOps_DDRM.divide(this.b, CommonOps_DDRM.elementMaxAbs(this.b));
        double B11 = this.b.get(0, 0);
        double B22 = this.b.get(1, 0);
        double B13 = this.b.get(2, 0);
        double B23 = this.b.get(3, 0);
        double B33 = this.b.get(4, 0);
        double temp0 = -B11 * B23;
        double temp1 = B11 * B22;
        double v0 = temp0 / temp1;
        double lambda = B33 - (B13 * B13 + v0 * temp0) / B11;
        double a = Math.sqrt(Math.abs(lambda / B11));
        double b = Math.sqrt(Math.abs(lambda * B11 / temp1));
        double u0 = -B13 / B11;
        this.K.set(0, 0, a);
        this.K.set(0, 1, 0.0);
        this.K.set(0, 2, u0);
        this.K.set(1, 1, b);
        this.K.set(1, 2, v0);
        this.K.set(2, 2, 1.0);
    }

    public DMatrixRMaj getCalibrationMatrix() {
        return this.K;
    }

    public SolveNullSpaceSvd_DDRM getSolverNull() {
        return this.solverNull;
    }
}

