/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareEdge;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.misc.CircularIndex;
import georegression.metric.Intersection2D_F64;
import georegression.metric.UtilAngle;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector2D_F64;
import org.ddogleg.struct.RecycleManager;

public class SquareGraph {
    protected RecycleManager<SquareEdge> edgeManager = new RecycleManager<SquareEdge>(SquareEdge.class);
    Vector2D_F64 vector0 = new Vector2D_F64();
    Vector2D_F64 vector1 = new Vector2D_F64();
    double parallelThreshold = UtilAngle.radian(45.0f);

    public void computeNodeInfo(SquareNode n) {
        if (null == Intersection2D_F64.intersection(n.square.get(0), n.square.get(2), n.square.get(1), n.square.get(3), n.center)) {
            throw new RuntimeException("BAD");
        }
        n.largestSide = 0.0;
        n.smallestSide = Double.MAX_VALUE;
        int j = 0;
        int i = 3;
        while (j < 4) {
            double l;
            n.sideLengths[i] = l = n.square.get(j).distance(n.square.get(i));
            n.largestSide = Math.max(n.largestSide, l);
            n.smallestSide = Math.min(n.smallestSide, l);
            i = j++;
        }
    }

    public void detachEdge(SquareEdge edge) {
        edge.a.edges[edge.sideA] = null;
        edge.b.edges[edge.sideB] = null;
        edge.distance = 0.0;
        this.edgeManager.recycleInstance(edge);
    }

    public int findSideIntersect(SquareNode n, LineSegment2D_F64 line, Point2D_F64 intersection, LineSegment2D_F64 storage) {
        int j = 0;
        int i = 3;
        while (j < 4) {
            storage.a = n.square.get(i);
            storage.b = n.square.get(j);
            if (Intersection2D_F64.intersection(line, storage, intersection) != null) {
                return i;
            }
            i = j++;
        }
        return -1;
    }

    public void checkConnect(SquareNode a, int indexA, SquareNode b, int indexB, double distance) {
        if (a.edges[indexA] != null && a.edges[indexA].distance > distance) {
            this.detachEdge(a.edges[indexA]);
        }
        if (b.edges[indexB] != null && b.edges[indexB].distance > distance) {
            this.detachEdge(b.edges[indexB]);
        }
        if (a.edges[indexA] == null && b.edges[indexB] == null) {
            this.connect(a, indexA, b, indexB, distance);
        }
    }

    void connect(SquareNode a, int indexA, SquareNode b, int indexB, double distance) {
        SquareEdge edge = this.edgeManager.requestInstance();
        edge.reset();
        edge.a = a;
        edge.sideA = indexA;
        edge.b = b;
        edge.sideB = indexB;
        edge.distance = distance;
        a.edges[indexA] = edge;
        b.edges[indexB] = edge;
    }

    public boolean almostParallel(SquareNode a, int sideA, SquareNode b, int sideB) {
        double selected = this.acuteAngle(a, sideA, b, sideB);
        return !(selected > this.parallelThreshold);
    }

    public double acuteAngle(SquareNode a, int sideA, SquareNode b, int sideB) {
        Point2D_F64 a0 = a.square.get(sideA);
        Point2D_F64 a1 = a.square.get(SquareGraph.add(sideA, 1));
        Point2D_F64 b0 = b.square.get(sideB);
        Point2D_F64 b1 = b.square.get(SquareGraph.add(sideB, 1));
        this.vector0.set(a1.x - a0.x, a1.y - a0.y);
        this.vector1.set(b1.x - b0.x, b1.y - b0.y);
        double acute = this.vector0.acute(this.vector1);
        return Math.min(UtilAngle.dist(Math.PI, acute), acute);
    }

    private static int add(int index, int value) {
        return CircularIndex.addOffset(index, value, 4);
    }

    public RecycleManager<SquareEdge> getEdgeManager() {
        return this.edgeManager;
    }

    public double getParallelThreshold() {
        return this.parallelThreshold;
    }

    public void setParallelThreshold(double parallelThreshold) {
        this.parallelThreshold = parallelThreshold;
    }
}

