/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.line.HoughTransformParameters;
import boofcv.alg.feature.detect.line.ImageLinePruneMerge;
import boofcv.alg.feature.detect.peak.MeanShiftPeak;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.weights.WeightPixelGaussian_F32;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.struct.QueueCorner;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F32;

public class HoughTransformGradient<D extends ImageGray<D>> {
    NonMaxSuppression extractor;
    FastQueue<LineParametric2D_F32> linesAll = new FastQueue<LineParametric2D_F32>(10, LineParametric2D_F32.class, true);
    List<LineParametric2D_F32> linesMerged = new ArrayList<LineParametric2D_F32>();
    GrayF32 transform = new GrayF32(1, 1);
    final QueueCorner foundLines = new QueueCorner(10);
    final QueueCorner candidates = new QueueCorner(10);
    GrowQueue_F32 foundIntensity = new GrowQueue_F32(10);
    MeanShiftPeak<GrayF32> refine = new MeanShiftPeak<GrayF32>(10, 0.001f, new WeightPixelGaussian_F32(), true, GrayF32.class, BorderType.ZERO);
    HoughTransformParameters parameters;
    GImageGray _derivX;
    GImageGray _derivY;
    ImageLinePruneMerge post = new ImageLinePruneMerge();
    double mergeAngle = 0.15707963267948966;
    double mergeDistance = 10.0;
    int maxLines = 0;

    public HoughTransformGradient(NonMaxSuppression extractor, HoughTransformParameters parameters, Class<D> derivType) {
        this.extractor = extractor;
        this.parameters = parameters;
        this.refine.setImage(this.transform);
        this.refine.setRadius(3);
        this._derivX = FactoryGImageGray.create(derivType);
        this._derivY = FactoryGImageGray.create(derivType);
    }

    public <D extends ImageGray<D>> void transform(D derivX, D derivY, GrayU8 binary) {
        InputSanityCheck.checkSameShape(derivX, derivY, binary);
        this.parameters.initialize(derivX.width, derivX.height, this.transform);
        ImageMiscOps.fill(this.transform, 0.0f);
        this.candidates.reset();
        this._derivX.wrap(derivX);
        this._derivY.wrap(derivY);
        this.transform(binary);
        this.extractLines();
        if (this.maxLines <= 0) {
            this.linesMerged.clear();
            this.linesMerged.addAll(this.linesAll.toList());
        } else {
            this.mergeLines(binary.width, binary.height);
        }
    }

    protected void extractLines() {
        this.linesAll.reset();
        this.foundLines.reset();
        this.foundIntensity.reset();
        this.extractor.process(this.transform, null, this.candidates, null, this.foundLines);
        for (int i = 0; i < this.foundLines.size(); ++i) {
            Point2D_I16 p = (Point2D_I16)this.foundLines.get(i);
            if (!this.parameters.isTransformValid(p.x, p.y)) continue;
            LineParametric2D_F32 l = this.linesAll.grow();
            l.p.set(p.x, p.y);
            this.refine.search(p.x, p.y);
            if (l.p.distance(this.refine.getPeakX(), this.refine.getPeakY()) < (float)(this.refine.getRadius() * 2)) {
                l.p.set(this.refine.getPeakX(), this.refine.getPeakY());
            }
            this.parameters.transformToLine(l.p.x, l.p.y, l);
            this.foundIntensity.push(this.transform.get(p.x, p.y));
        }
    }

    protected void mergeLines(int width, int height) {
        this.post.reset();
        for (int i = 0; i < this.linesAll.size(); ++i) {
            this.post.add(this.linesAll.get(i), this.foundIntensity.get(i));
        }
        this.post.pruneSimilar((float)this.mergeAngle, (float)this.mergeDistance, width, height);
        this.post.pruneNBest(this.maxLines);
        this.post.createList(this.linesMerged);
    }

    protected final void parameterize(QueueCorner candidates, int x, int y, float derivX, float derivY) {
        Point2D_F32 parameter = new Point2D_F32();
        this.parameters.parameterize(x, y, derivX, derivY, parameter);
        int x0 = (int)parameter.x;
        int y0 = (int)parameter.y;
        float wx = parameter.x - (float)x0;
        float wy = parameter.y - (float)y0;
        this.addParameters(candidates, x0, y0, (1.0f - wx) * (1.0f - wy));
        this.addParameters(candidates, x0 + 1, y0, wx * (1.0f - wy));
        this.addParameters(candidates, x0, y0 + 1, (1.0f - wx) * wy);
        this.addParameters(candidates, x0 + 1, y0 + 1, wx * wy);
    }

    protected final void addParameters(QueueCorner candidates, int x, int y, float amount) {
        if (this.transform.isInBounds(x, y)) {
            int index = this.transform.startIndex + y * this.transform.stride + x;
            if (this.transform.data[index] == 0.0f) {
                candidates.add(x, y);
            }
            int n = index;
            this.transform.data[n] = this.transform.data[n] + amount;
        }
    }

    public GrayF32 getTransform() {
        return this.transform;
    }

    public FastQueue<LineParametric2D_F32> getLinesAll() {
        return this.linesAll;
    }

    public float[] getFoundIntensity() {
        return this.foundIntensity.data;
    }

    void transform(GrayU8 binary) {
        for (int y = 0; y < binary.height; ++y) {
            int start = binary.startIndex + y * binary.stride;
            int end = start + binary.width;
            for (int index = start; index < end; ++index) {
                if (binary.data[index] == 0) continue;
                int x = index - start;
                this.parameterize(this.candidates, x, y, this._derivX.unsafe_getF(x, y), this._derivY.unsafe_getF(x, y));
            }
        }
    }

    public void setRefineRadius(int radius) {
        this.refine.setRadius(radius);
    }

    public int getRefineRadius() {
        return this.refine.getRadius();
    }

    public double getMergeAngle() {
        return this.mergeAngle;
    }

    public void setMergeAngle(double mergeAngle) {
        this.mergeAngle = mergeAngle;
    }

    public double getMergeDistance() {
        return this.mergeDistance;
    }

    public void setMergeDistance(double mergeDistance) {
        this.mergeDistance = mergeDistance;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public List<LineParametric2D_F32> getLinesMerged() {
        return this.linesMerged;
    }

    public NonMaxSuppression getExtractor() {
        return this.extractor;
    }

    public MeanShiftPeak<GrayF32> getRefine() {
        return this.refine;
    }

    public HoughTransformParameters getParameters() {
        return this.parameters;
    }
}

