/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AssignPixelValue_SB;
import boofcv.alg.distort.ImageDistortBasic;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;
import java.util.Stack;

public class ImageDistortBasic_SB_MT<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
extends ImageDistortBasic<Input, Output, InterpolatePixelS<Input>> {
    private AssignPixelValue_SB<Output> assigner;
    private final Stack<BlockDistort> queue = new Stack();

    public ImageDistortBasic_SB_MT(AssignPixelValue_SB<Output> assigner, InterpolatePixelS<Input> interp) {
        super(interp);
        this.assigner = assigner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockDistort pop() {
        Stack<BlockDistort> stack = this.queue;
        synchronized (stack) {
            if (this.queue.isEmpty()) {
                return new BlockDistort();
            }
            return this.queue.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycle(BlockDistort b) {
        Stack<BlockDistort> stack = this.queue;
        synchronized (stack) {
            this.queue.push(b);
        }
    }

    @Override
    protected void init(Input srcImg, Output dstImg) {
        super.init(srcImg, dstImg);
        this.assigner.setImage(dstImg);
    }

    @Override
    public void applyAll() {
        BoofConcurrency.loopBlocks(this.y0, this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyAll(y0, y1);
            this.recycle(b);
        });
    }

    @Override
    public void applyAll(GrayU8 mask) {
        BoofConcurrency.loopBlocks(this.y0, this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyAll(y0, y1, mask);
            this.recycle(b);
        });
    }

    @Override
    public void applyOnlyInside() {
        BoofConcurrency.loopBlocks(this.y0, this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyOnlyInside(y0, y1);
            this.recycle(b);
        });
    }

    @Override
    public void applyOnlyInside(GrayU8 mask) {
        BoofConcurrency.loopBlocks(this.y0, this.y1, (y0, y1) -> {
            BlockDistort b = this.pop();
            b.applyOnlyInside(y0, y1, mask);
            this.recycle(b);
        });
    }

    private class BlockDistort {
        Point2D_F32 distorted = new Point2D_F32();
        PixelTransform<Point2D_F32> dstToSrc;
        InterpolatePixelS<Input> interp;

        private BlockDistort() {
            this.interp = ((InterpolatePixelS)ImageDistortBasic_SB_MT.this.interp).copy();
        }

        public void init() {
            this.dstToSrc = ImageDistortBasic_SB_MT.this.dstToSrc.copyConcurrent();
            this.interp.setImage(ImageDistortBasic_SB_MT.this.srcImg);
        }

        void applyAll(int y0, int y1) {
            this.init();
            for (int y = y0; y < y1; ++y) {
                int indexDst = ((ImageGray)ImageDistortBasic_SB_MT.this.dstImg).startIndex + ((ImageGray)ImageDistortBasic_SB_MT.this.dstImg).stride * y + ImageDistortBasic_SB_MT.this.x0;
                int x = ImageDistortBasic_SB_MT.this.x0;
                while (x < ImageDistortBasic_SB_MT.this.x1) {
                    this.dstToSrc.compute(x, y, this.distorted);
                    ImageDistortBasic_SB_MT.this.assigner.assign(indexDst, this.interp.get(this.distorted.x, this.distorted.y));
                    ++x;
                    ++indexDst;
                }
            }
        }

        void applyAll(int y0, int y1, GrayU8 mask) {
            this.init();
            float maxWidth = ((ImageGray)ImageDistortBasic_SB_MT.this.srcImg).getWidth() - 1;
            float maxHeight = ((ImageGray)ImageDistortBasic_SB_MT.this.srcImg).getHeight() - 1;
            for (int y = y0; y < y1; ++y) {
                int indexDst = ((ImageGray)ImageDistortBasic_SB_MT.this.dstImg).startIndex + ((ImageGray)ImageDistortBasic_SB_MT.this.dstImg).stride * y + ImageDistortBasic_SB_MT.this.x0;
                int indexMsk = mask.startIndex + mask.stride * y + ImageDistortBasic_SB_MT.this.x0;
                int x = ImageDistortBasic_SB_MT.this.x0;
                while (x < ImageDistortBasic_SB_MT.this.x1) {
                    this.dstToSrc.compute(x, y, this.distorted);
                    ImageDistortBasic_SB_MT.this.assigner.assign(indexDst, this.interp.get(this.distorted.x, this.distorted.y));
                    mask.data[indexMsk] = this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight ? (byte)1 : 0;
                    ++x;
                    ++indexDst;
                    ++indexMsk;
                }
            }
        }

        void applyOnlyInside(int y0, int y1) {
            this.init();
            float maxWidth = ((ImageGray)ImageDistortBasic_SB_MT.this.srcImg).getWidth() - 1;
            float maxHeight = ((ImageGray)ImageDistortBasic_SB_MT.this.srcImg).getHeight() - 1;
            for (int y = y0; y < y1; ++y) {
                int indexDst = ((ImageGray)ImageDistortBasic_SB_MT.this.dstImg).startIndex + ((ImageGray)ImageDistortBasic_SB_MT.this.dstImg).stride * y + ImageDistortBasic_SB_MT.this.x0;
                int x = ImageDistortBasic_SB_MT.this.x0;
                while (x < ImageDistortBasic_SB_MT.this.x1) {
                    this.dstToSrc.compute(x, y, this.distorted);
                    if (this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight) {
                        ImageDistortBasic_SB_MT.this.assigner.assign(indexDst, this.interp.get(this.distorted.x, this.distorted.y));
                    }
                    ++x;
                    ++indexDst;
                }
            }
        }

        void applyOnlyInside(int y0, int y1, GrayU8 mask) {
            this.init();
            float maxWidth = ((ImageGray)ImageDistortBasic_SB_MT.this.srcImg).getWidth() - 1;
            float maxHeight = ((ImageGray)ImageDistortBasic_SB_MT.this.srcImg).getHeight() - 1;
            for (int y = y0; y < y1; ++y) {
                int indexDst = ((ImageGray)ImageDistortBasic_SB_MT.this.dstImg).startIndex + ((ImageGray)ImageDistortBasic_SB_MT.this.dstImg).stride * y + ImageDistortBasic_SB_MT.this.x0;
                int indexMsk = mask.startIndex + mask.stride * y + ImageDistortBasic_SB_MT.this.x0;
                int x = ImageDistortBasic_SB_MT.this.x0;
                while (x < ImageDistortBasic_SB_MT.this.x1) {
                    this.dstToSrc.compute(x, y, this.distorted);
                    if (this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight) {
                        ImageDistortBasic_SB_MT.this.assigner.assign(indexDst, this.interp.get(this.distorted.x, this.distorted.y));
                        mask.data[indexMsk] = 1;
                    } else {
                        mask.data[indexMsk] = 0;
                    }
                    ++x;
                    ++indexDst;
                    ++indexMsk;
                }
            }
        }
    }
}

