/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.BackgroundAlgorithmGmm;
import boofcv.alg.background.BackgroundGmmCommon;
import boofcv.alg.background.BackgroundModelMoving;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;

public abstract class BackgroundMovingGmm<T extends ImageBase<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundModelMoving<T, Motion>
implements BackgroundAlgorithmGmm {
    BackgroundGmmCommon common;

    public BackgroundMovingGmm(float learningPeriod, float decayCoef, int maxGaussians, Point2Transform2Model_F32<Motion> transformImageType, ImageType<T> imageType) {
        super(transformImageType, imageType);
        this.common = new BackgroundGmmCommon(learningPeriod, decayCoef, maxGaussians, imageType);
    }

    @Override
    public void reset() {
        this.common.model.zero();
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.common.model.reshape(backgroundHeight, backgroundWidth * this.common.modelStride);
        this.common.model.zero();
        this.homeToWorld.set(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public float getInitialVariance() {
        return this.common.initialVariance;
    }

    @Override
    public void setInitialVariance(float initialVariance) {
        this.common.initialVariance = initialVariance;
    }

    @Override
    public float getLearningPeriod() {
        return 1.0f / this.common.learningRate;
    }

    @Override
    public void setLearningPeriod(float period) {
        this.common.learningRate = 1.0f / period;
    }

    @Override
    public void setSignificantWeight(float value) {
        this.common.significantWeight = value;
    }

    public float getMaxDistance() {
        return this.common.maxDistance;
    }

    public void setMaxDistance(float maxDistance) {
        this.common.maxDistance = maxDistance;
    }

    public BackgroundGmmCommon getCommon() {
        return this.common;
    }
}

