/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.tracker;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.tracker.combined.CombinedTrack;
import boofcv.alg.tracker.combined.CombinedTrackerScalePoint;
import boofcv.alg.transform.pyramid.PyramidOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.util.ArrayList;
import java.util.List;

public class PointTrackerCombined<I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc>
implements PointTracker<I> {
    CombinedTrackerScalePoint<I, D, Desc> tracker;
    PyramidDiscrete<I> pyramid;
    D[] derivX;
    D[] derivY;
    Class<D> derivType;
    ImageGradient<I, D> gradient;
    int reactivateThreshold;
    int previousSpawn;
    boolean detected;

    public PointTrackerCombined(CombinedTrackerScalePoint<I, D, Desc> tracker, int reactivateThreshold, Class<I> imageType, Class<D> derivType) {
        this.tracker = tracker;
        this.reactivateThreshold = reactivateThreshold;
        this.derivType = derivType;
        int[] pyramidScaling = tracker.getTrackerKlt().pyramidScaling;
        this.pyramid = FactoryPyramid.discreteGaussian(pyramidScaling, -1.0, 2, true, ImageType.single(imageType));
        this.gradient = FactoryDerivative.sobel(imageType, derivType);
        this.reset();
    }

    @Override
    public void reset() {
        this.tracker.reset();
        this.previousSpawn = 0;
        this.detected = false;
    }

    @Override
    public void process(I image) {
        this.detected = false;
        this.pyramid.process(image);
        if (this.derivX == null) {
            this.derivX = PyramidOps.declareOutput(this.pyramid, this.derivType);
            this.derivY = PyramidOps.declareOutput(this.pyramid, this.derivType);
        }
        PyramidOps.gradient(this.pyramid, this.gradient, this.derivX, this.derivY);
        this.tracker.updateTracks((ImageGray)image, this.pyramid, (ImageGray[])this.derivX, (ImageGray[])this.derivY);
        int numActive = this.tracker.getPureKlt().size() + this.tracker.getReactivated().size();
        if (this.previousSpawn - numActive > this.reactivateThreshold) {
            this.detected = true;
            this.tracker.associateAllToDetected();
            this.previousSpawn = this.tracker.getPureKlt().size() + this.tracker.getReactivated().size();
        }
        for (CombinedTrack<Desc> t : this.tracker.getPureKlt()) {
            ((PointTrack)t.getCookie()).set(t);
        }
        for (CombinedTrack<Desc> t : this.tracker.getReactivated()) {
            ((PointTrack)t.getCookie()).set(t);
        }
    }

    @Override
    public void spawnTracks() {
        if (!this.detected) {
            this.tracker.associateAllToDetected();
        }
        this.tracker.spawnTracksFromDetected();
        List<CombinedTrack<Desc>> spawned = this.tracker.getSpawned();
        for (CombinedTrack<Desc> t : spawned) {
            PointTrack p = (PointTrack)t.getCookie();
            if (p == null) {
                p = new PointTrack();
                t.setCookie(p);
            }
            p.set(t);
            p.setDescription(t);
            p.featureId = t.featureId;
        }
        this.previousSpawn = this.tracker.getPureKlt().size() + this.tracker.getReactivated().size();
    }

    @Override
    public void dropAllTracks() {
        this.tracker.dropAllTracks();
    }

    @Override
    public boolean dropTrack(PointTrack track) {
        if (this.tracker.dropTrack((CombinedTrack)track.getDescription())) {
            --this.previousSpawn;
            return true;
        }
        return false;
    }

    @Override
    public List<PointTrack> getAllTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.tracker.getReactivated(), list);
        this.addToList(this.tracker.getPureKlt(), list);
        this.addToList(this.tracker.getDormant(), list);
        return list;
    }

    @Override
    public List<PointTrack> getActiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.tracker.getReactivated(), list);
        this.addToList(this.tracker.getPureKlt(), list);
        return list;
    }

    @Override
    public List<PointTrack> getInactiveTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.tracker.getDormant(), list);
        return list;
    }

    @Override
    public List<PointTrack> getDroppedTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        return list;
    }

    @Override
    public List<PointTrack> getNewTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        this.addToList(this.tracker.getSpawned(), list);
        return list;
    }

    private void addToList(List<CombinedTrack<Desc>> in, List<PointTrack> out) {
        for (int i = 0; i < in.size(); ++i) {
            out.add((PointTrack)in.get(i).getCookie());
        }
    }
}

