/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.disparity;

import boofcv.abst.feature.disparity.StereoDisparity;
import boofcv.alg.feature.disparity.sgm.SgmStereoDisparity;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class WrapDisparitySgm<DI extends ImageGray<DI>>
implements StereoDisparity<GrayU8, DI> {
    SgmStereoDisparity<GrayU8, ?> sgm;
    GrayF32 subpixel;

    public WrapDisparitySgm(SgmStereoDisparity<GrayU8, ?> sgm, boolean subPixel) {
        this.sgm = sgm;
        this.subpixel = subPixel ? new GrayF32(1, 1) : null;
    }

    @Override
    public void process(GrayU8 imageLeft, GrayU8 imageRight) {
        this.sgm.process(imageLeft, imageRight);
    }

    @Override
    public DI getDisparity() {
        if (this.subpixel != null) {
            this.sgm.subpixel(this.sgm.getDisparity(), this.subpixel);
            return (DI)this.subpixel;
        }
        return (DI)this.sgm.getDisparity();
    }

    @Override
    public int getDisparityMin() {
        return this.sgm.getDisparityMin();
    }

    @Override
    public int getDisparityRange() {
        return this.sgm.getDisparityRange();
    }

    @Override
    public int getInvalidValue() {
        return this.sgm.getInvalidDisparity();
    }

    @Override
    public int getBorderX() {
        return 0;
    }

    @Override
    public int getBorderY() {
        return 0;
    }

    @Override
    public ImageType<GrayU8> getInputType() {
        return ImageType.SB_U8;
    }

    @Override
    public Class<DI> getDisparityType() {
        return this.subpixel == null ? GrayF32.class : GrayU8.class;
    }

    public SgmStereoDisparity<GrayU8, ?> getAlgorithm() {
        return this.sgm;
    }
}

