(function () {
	angular.module('datetimeboot', ['datetimepicker'])
		.config(['datetimepickerProvider',
			function (datetimepickerProvider) {
				datetimepickerProvider.setOptions({
					locale: 'fr',
					format: 'YYYY-MM-DD HH:mm'
				});
			}
		]);
		moment.locale('fr', {
			week: { dow: 0 }
		  });
	var widget = angular.module("widgets", []);

	widget.filter('exposeEmoji', function ($sce) {
		return function (val) {
			val = "&#x" + val + ";";
			return $sce.trustAsHtml(val);
		};
	});

	widget.filter('replacechar', function () {
		return function (val) {
			var v = val.replace('\\u2606', '').replace('\\u00E9', 'é').replace('\\u00E0', 'à');
			return v;
		};
	});

	widget.filter('daysFrom1970ToStr', function () {
		return function (val) {
			if (val) {
			 return OfysUtils.daysFrom1970ToStr(val);				
			}
			return '';
		};
	});

	widget.filter('daysFrom1970ToStrPartial', function () {
		return function (val) {
			if (val) {
				 var d = OfysUtils.daysFrom1970ToStr(val);
				 d = d.replace('-01-01','');
				 return d;
			}
			return '';
		};
	});

	widget.filter('dxcode', function () {
		return function (item) {
			if ('icd9,cim9'.indexOf(item.classificationDiagnostic)>-1 && item.code && item.code.length>3) {
				return item.code.substring(0,3) + '.' + item.code.substring(3,4);
			}
			return item.code;
		};
	});

	widget.filter('maxchar', function () {
		return function (input, count) {
			input = input || '';
			count = count || 30;
			if (input.length > count) {
				return input.substring(0, count) + "...";
			} else {
				return input;
			}
		};
	});

	widget.filter('cleanUnseenStatus', function () {
		return function (input, count) {
			input = input || [];
			count = count || 30;
			var s = $.inArray("SEEN", input);
			var u = $.inArray("UNSEEN", input);
			if (s > -1 && u > -1) {
				input.splice(u, 1);
				return input;
			} else {
				return input;
			}
		};
	});

	/*TODO pour modal draggable. voir http://plnkr.co/edit/cu1TVKCY8ucYcT2AScJb?p=preview */
	widget.directive('modaldraggable', function ($document) {
		"use strict";
		return function (scope, element) {
			var startX = 0,
				startY = 0,
				x = 0,
				y = 0;
			element = angular.element(document.getElementsByClassName("viewZone"));
			//		     element= angular.element(document.getElementsByClassName("modal-dialog"));
			console.log("added directive");
			element.css({
				position: 'fixed',
				cursor: 'move'
			});

			element.on('mousedown', function (event) {
				// Prevent default dragging of selected content
				event.preventDefault();
				startX = event.screenX - x;
				startY = event.screenY - y;
				$document.on('mousemove', mousemove);
				$document.on('mouseup', mouseup);
			});

			function mousemove(event) {
				y = event.screenY - startY;
				x = event.screenX - startX;
				element.css({
					top: y + 'px',
					left: x + 'px'
				});
			}

			function mouseup() {
				$document.unbind('mousemove', mousemove);
				$document.unbind('mouseup', mouseup);
			}
		};
	});

	widget.directive('contenteditable', ['$sce', function ($sce) {
		return {
			restrict: 'A', // only activate on element attribute
			require: '?ngModel', // get a hold of NgModelController
			link: function (scope, element, attrs, ngModel) {
				if (!ngModel) return; // do nothing if no ng-model

				// Specify how UI should be updated
				ngModel.$render = function () {
					element.html($sce.getTrustedHtml(ngModel.$viewValue || ''));
					read(); // initialize
				};

				// Listen for change events to enable binding
				element.on('blur keyup change', function () {
					scope.$evalAsync(read);
				});

				// Write data to the model
				function read() {
					var html = element.html();
					// When we clear the content editable the browser leaves a <br> behind
					// If strip-br attribute is provided then we strip this out
					if (attrs.stripBr && html == '<br>') {
						html = '';
					}
					ngModel.$setViewValue(html);
				}
			}
		};
	}]);
	
	//fonctionne uniquement sur les input de type "text" à cause du 'selectionStart'
	widget.directive('numberonly', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, element, attrs, modelCtrl) {
				function cleanUnwantedChars(input){
					var pos =  element[0].selectionStart;
					input = input.replaceAll(/[^0-9]/, "");
					modelCtrl.$setViewValue(input);
					modelCtrl.$render(input);
					element[0].setSelectionRange(pos, pos);
					return input;
				}
				modelCtrl.$parsers.push(function (input) {
					return input ? cleanUnwantedChars(input) : "";
				});
			}
		};
	});

	widget.directive('phonewithnumberonly', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, element, attrs, modelCtrl) {
				function cleanUnwantedChars(input){
					return input.replaceAll(/[^0-9.]/, "")
				}
				modelCtrl.$parsers.push(function (input) {
					return input ? cleanUnwantedChars(input) : "";
				});
			}
		};
	});

	widget.directive('uppercase', function () {
		return {
			require: 'ngModel',
			link: function (scope, element, attrs, modelCtrl) {
				modelCtrl.$parsers.push(function (input) {
					return input ? input.toUpperCase() : "";
				});
				element.css("text-transform", "uppercase");
			}
		};
	});
	
	widget.directive('selectOnClick', ['$window', function ($window) {
	    return {
	        restrict: 'A',
	        link: function (scope, element, attrs) {
	            element.on('click', function () {
	                if (!$window.getSelection().toString()) {
	                    // Required for mobile Safari
	                    this.setSelectionRange(0, this.value.length)
	                }
	            });
	        }
	    };
	}]);

	widget.directive('convertToInt', function () {
		return {
			require: 'ngModel',
			link: function (scope, element, attrs, modelCtrl) {
				modelCtrl.$parsers.push(function(val) {
					return val != null ? parseInt(val, 10) : null;
				});
				modelCtrl.$formatters.push(function(val) {
					return val != null ? '' + val : null;
				});
			}
		};
	});

	widget.directive('ofystimeFormatparse', function () {
		return {
			require: 'ngModel',
			link: function (scope, element, attrs, modelCtrl) {
				function startOfDay(){
					return moment().startOf('day');
				}
				modelCtrl.$parsers.push(function (input) {
					if(input){
						var start = startOfDay();
						var time = moment(input, 'HH:mm');
						if(time.isValid()){
							var timeInMins = time.diff(start, 'minutes');
							return timeInMins;
						}
					}
				});

				modelCtrl.$formatters.push(OfysUtils.ofysTimeToString);
			}
		};
	});

	widget.directive('myClickOnce', function ($timeout) {
	    var delay = 500;   // min milliseconds between clicks

	    return {
	        restrict: 'A',
	        priority: -1,   // cause out postLink function to execute before native `ngClick`'s
	                        // ensuring that we can stop the propagation of the 'click' event
	                        // before it reaches `ngClick`'s listener
	        link: function (scope, elem, attr) {
	            var disabled = false;

	            function onClick(evt) {
					if(attr.myClickOnce){
						delay = parseInt(attr.myClickOnce);
					}
	                if (disabled) {
	                    evt.preventDefault();
	                    evt.stopImmediatePropagation();
	                } else {
	                    disabled = true;
	                    $timeout(function () { disabled = false; }, delay, false);
	                }
	            }

	            scope.$on('$destroy', function () { elem.off('click', onClick); });
	            elem.on('click', onClick);
	        }
	    };
	});
	
	widget.directive('restrictSpecialChar', [ function(){
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, element, attrs, ngModel){
				ngModel.$parsers.push(function(viewValue) {
	            	var pattern = /[^A-Za-zÀ-ÖØ-öø-ÿ\s\d\.\-\/]/g;
		            // if view values matches regexp, update model value
		            if (!viewValue) {
		              return viewValue;
		            }
		            // keep the model value as it is
		            var transformedValue = viewValue.replace(pattern, "");
		            ngModel.$setViewValue(transformedValue);
		            ngModel.$render();
		            return transformedValue;
	            });
			}
		};
	}])
	
//	widget.directive('multipleKeyPress', function() {
//		return {
//			restrict: 'A',
//			link: function(scope, element, attrs) {
//				//Doit passer dans les attributs une liste d'action et une fonction à appliquer.
//				listener = function(e){
//					if(((OfysUtils.isWin && e.ctrlKey) || (OfysUtils.isMac && e.metaKey )) && scope.$eval(attrs.actions).includes(e.key)){
//						e.preventDefault();
//						scope.$eval(attrs.multipleKeyPress)(e.key);
//						scope.$apply();
//					}
//				};
//				angular.element(window).on('keydown', listener)
//				scope.$on('$destroy', function () {
//					angular.element(window).off('keydown', listener);
//				});
//			}
//		};
//	})
	
	widget.directive('loadOnScroll', [ function(){
		return {
			restrict: 'A',
			link: function(scope, element, attrs){
				raw = element[0]
	            	
	            element.on("scroll", function(){
					if(raw.scrollTop+raw.offsetHeight+5 >= raw.scrollHeight){
    					scope.$apply(attrs.loadOnScroll);
					}
				})
			}
		};
	}])

	widget.directive('actionbtn', [ function() {
		return {
			restrict: 'AE',
			// scope: {
			// 	actions: '=',
			// },
			templateUrl:'actionbtn_index.html',
			link: function(scope, element, attrs, modelCtrl) {
				function watchScp(){
					scope.actions = scope.$eval(attrs.actions);
				}
				scope.$watch(attrs.actions, watchScp);
			}
		};
	}]);

	widget.directive('resizeToContent', ['$timeout', function ($timeout) {
		return {
			link: function (scope, element, attrs) {

				function vhTOpx(value) {
					var w = window,
						d = document,
						e = d.documentElement,
						g = d.getElementsByTagName('body')[0],
						x = w.innerWidth || e.clientWidth || g.clientWidth,
						y = w.innerHeight || e.clientHeight || g.clientHeight;

					var result = (y * value) / 100;
					return result;
				}

				var defaultOptions = {
					maxHeight: vhTOpx(50),

				};

				element.addClass("resizeToFit");

				function fitContent() {
					var elemH = element[0].clientHeight;
					var contentH = element[0].scrollHeight;
					// console.log("ElemH: "+ elemH);
					// console.log("contentH: "+ elemH);
					// console.log("jqH: "+ element.height());
					var lessThanMax = contentH < scope.resizeOptions.maxHeight;
					if (contentH > elemH && lessThanMax) {
						$(element).height(contentH + 80);
					} else if (!lessThanMax) {
						$(element).height(scope.resizeOptions.maxHeight + 80);
						activated = false;
					}
				}
				var activated = false;

				function check() {
					$timeout(function () {
						if (activated) {
							fitContent()
							check();
						}
					}, 500)
				}

				function activate() {
					activated = true;
					check();
				}
				$(element).focus(activate);
				$(element).blur(function () {
					activated = false;
				});

				function update(n) {
					scope.resizeOptions = $.extend(defaultOptions, n);
				}
				$timeout(function () {
					fitContent();
				}, 0);
				scope.$watch(attrs.resizeToContent, update);
			}
		};
	}]);

	widget.directive('resizeToastToContent', ['$timeout', function ($timeout) {
		return {
			link: function (scope, element, attrs) {
				scope.resizeToastToContentIf = function (element, editor) {
					fitContent($(element).find('.te-ww-container .te-editor'), editor)
				}
				function vhTOpx(value) {
					var w = window,
						d = document,
						e = d.documentElement,
						g = d.getElementsByTagName('body')[0],
						x = w.innerWidth || e.clientWidth || g.clientWidth,
						y = w.innerHeight || e.clientHeight || g.clientHeight;

					var result = (y * value) / 100;
					return result;
				}

				var defaultOptions = {
					maxHeight: vhTOpx(65),
				};

				element.addClass("resizeToFit");

				function fitContent(parent, editor) {
					var elemH = parent[0].clientHeight;
					var contentH = parent[0].scrollHeight;
					var lessThanMax = contentH < scope.resizeOptions.maxHeight;
					if (contentH > elemH && lessThanMax) {
						editor.height(contentH + 80);
					} else if (!lessThanMax) {
						editor.height(scope.resizeOptions.maxHeight + 80)
					}
				}

				function update(n) {
					scope.resizeOptions = $.extend(defaultOptions, n);
				}
				scope.$watch(attrs.resizeToContent, update);
			}
		};
	}]);

	widget.directive('resizeToastToContentReadOnly', ['$timeout', function ($timeout) {
		return {
			link: function (scope, element, attrs) {
				function fitContent(parent, editor) {
					var elemH = parent[0].clientHeight;
					var contentH = parent[0].scrollHeight;
					if ((contentH-1) > elemH ) {
						editor.height(contentH);
					}
				}
				$timeout(function name() {
					fitContent($(element).find('.te-ww-container .te-editor'), element)
				}, 100)
			}
		};
	}]);

	widget.directive('multiswitchWhen', function () {
		return {
			transclude: 'element',
			priority: 800,
			require: '^ngSwitch',
			link: function (scope, element, attrs, ctrl, $transclude) {
				var selectTransclude = {
					transclude: $transclude,
					element: element
				};
				angular.forEach(attrs.multiswitchWhen.split('|'), function (switchWhen) {
					ctrl.cases['!' + switchWhen] = (ctrl.cases['!' + switchWhen] || []);
					ctrl.cases['!' + switchWhen].push(selectTransclude);
				});
			}
		};
	});

	widget.directive('ignoreDirty', [function() {
	    return {
	    restrict: 'A',
	    require: 'ngModel',
	    link: function(scope, elm, attrs, ctrl) {
	      ctrl.$setPristine = function() {};
	      ctrl.$pristine = false;
	      ctrl.$dirty = false;
	    }
	  }
	}]);

	widget.directive('checkPostal', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, elem, attr, ngModel) {
				ngModel.$validators.postalcode = function (val) {
					var regexp = /^[ABCEFGHJKLMNPRSTVXY][0-9][ABCEFGHJKLMNPRSTVWXYZ][ ]?[0-9][ABCEFGHJKLMNPRSTVWXYZ][0-9]$/i;
					if (val) {
						return regexp.test(val);
					} else {
						return true;
					}
				};
			}
		};
	});

	widget.directive('checkNarcoticRenewal', [function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, elem, attr, ngModel) {
				scope.$watch(function () {
					return scope.$eval(attr.checkNarcoticRenewal);
				}, function () {
					ngModel.$validate();
				});

				ngModel.$validators.checkNarcoticRenewal = function (val) {
					var isNarcotic = scope.$eval(attr.checkNarcoticRenewal) === 1
					if(isNarcotic && val > 0){
						return false
					}
					return true;
				};
			}
		};
	}]);

	widget.directive('checkPosInt', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, elem, attr, ngModel) {
				ngModel.$validators.checkint = function (val) {
					var regexp = /^[0-9]*$/;
					if (val) {
						return regexp.test(val);
					} else {
						return true;
					}
				};
			}
		};
	});

	widget.directive('checkInt', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, elem, attr, ngModel) {
				ngModel.$validators.checkint = function (val) {
					var regexp = /^-?[0-9][^\.]*$/;
					if (val) {
						return regexp.test(val);
					} else {
						return true;
					}
				};
			}
		};
	});

	widget.directive('validfn', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, elem, attr, ngModel) {
				ngModel.$validators.validfn = function (val) {
					var fn = scope.$eval(attr.validfn);
					if(fn){
						return fn(val,ngModel,scope )
					}else{
						console.error("No validation function found");
						return true;
					}
				};
			}
		};
	});

	widget.directive('expirationcam', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, elem, attr, ngModel) {
				ngModel.$validators.expirationcam = function (val) {
					if (val) {
						val = val.replace("-", "").replace("/","")
						if(val.length > 4){
							return false;
						}
						return moment(val, "YYMM").isValid();
					} else {
						return true;
					}
				};
			}
		};
	});

	widget.directive('inputSelectorList', ['$q', function ($q) {
		return {
			restrict: 'AE',
			templateUrl:'/dashboard/resources/ofys/widgets/input_selector_list.html?v=bj',
			scope:{
				options: '=',
				model: '='
			},
			link: function (scope, elem, attr) {
				function update(params) {
					if(scope.options){
						scope.options.update = updateFromModel;
						if(scope.options.selectedList === undefined ||
								typeof scope.options.selectedList !== 'array'){
							scope.options.selectedList = [];
						}
						if(scope.options.addDupes === undefined ){
							scope.options.addDupes = false;
						}
						if (scope.options.selectable === undefined) {
							scope.options.selectable = true;
						}
						if(scope.options.checkEquals === undefined ){
							scope.options.checkEquals = function (obj1, obj2) {
								return scope.options.selectorName(obj1) === scope.options.selectorName(obj2)
							}
						}
						if(!scope.options.toModel){
							scope.options.toModel = function(i){
								return i;
							}
						}
						scope.options.select = function (obj) {
							var selectedIndex = isSelectedIndex(obj);
							if (scope.options.addDupes ||
								(!scope.options.addDupes && selectedIndex === -1)) {
								var n = getSelectedListObject(obj);
								if(scope.model && scope.options.toModel){
									var x = scope.options.toModel(obj);
									if(scope.model.indexOf(x) === -1){
										scope.model.push(x);
									}
								}
								if (scope.options.onSelect) {
									scope.options.onSelect(n);
								}
								scope.options.selectedList.push(n)
								if (scope.options.onSelected) {
									scope.options.onSelected(n);
								}
								listUpdated()
								scope.setCurrent(n);
							} else if (!scope.options.addDupes && selectedIndex > -1) {
								scope.setCurrent(scope.options.selectedList[selectedIndex]);
							}
						};


						function arrayFilter(arr, q) {
							if(q !== undefined && q !== ''){
								var res = arr.filter(function (el) {
									return scope.options.selectorName(el).toLowerCase().indexOf(q) > -1
								});
								return res;
							}else{
								return arr;
							}
						}

						if(scope.options.list ){
							scope.selectorSearchAssist = {
								nextTabOnTab: true,
								nextTabOnEnter: false,
								hasDetails: false,
								hasHeader: false,
								trigger: 'focus',
								minChar: 0,
								getAsyncData: function(query, assist){
									query = query.replace(',', '').toLowerCase();//make sure that composed names with commas are searchable too
									if(scope.options.list && typeof scope.options.list === 'function'){
										return scope.options.list(query)
									}else{
										return $q(function(resolve, reject) {
											resolve(arrayFilter(scope.options.list, query))
										});
									}
								},
								getKey: function(obj) {
									return scope.options.selectorName(obj)
								},
								selection: function(obj, assistObject) {
									if(scope.options.select){
										scope.options.select(obj)
										setDirty();
									}
									// return scope.patName(pat);
								}
							};

							updateFromModel();
						}
					}
				}
				function setDirty(){
					if(scope.options.setDirty){
						scope.options.setDirty()
					}
				}

				function getSelectedListObject(obj){
					return {
						name: scope.options.selectorName(obj),
						obj: obj
					}
				}

				function updateFromModel(){
					if(scope.model){
						scope.options.selectedList = [];
						var selectables = scope.options.list.map(function(i){
							return scope.options.toModel(i);
						})
						scope.model.forEach(function(i){
							var index = selectables.indexOf(i)
							if(index !== -1){
								scope.options.selectedList.push(getSelectedListObject(scope.options.list[index]))
							}
						});
						listUpdated();
					}
				}

				function listUpdated(){
					if (scope.options.updatedList) {
						scope.options.updatedList(scope.options.selectedList)
					}
				}

				function isSelectedIndex(item) {
					for (var i = 0; i < scope.options.selectedList.length; i++) {
						if(scope.options.checkEquals(item, scope.options.selectedList[i].obj)){
							return i;
						}
					}
					return -1;
				}

				scope.remove = function (elem) {
					if(scope.options.current === elem){
						delete scope.options.current
					}

					if(scope.model && scope.options.toModel){
						var x = scope.model.indexOf(scope.options.toModel(elem.obj));
						if(x !== -1){
							scope.model.splice(x, 1);
						}
					}
					scope.options.selectedList.splice(scope.options.selectedList.indexOf(elem), 1);
					setDirty();
					listUpdated();
				}

				scope.setCurrent = function (elem) {
					scope.options.current = elem
				}

				scope.$watch(scope.options, update)
			}
		};
	}]);

	/*
	 * first stab at a 'click to edit' element based on
	 * Atlassian/Jira's amazing interface elements.
	 * i tried getting clever with transclusion of the input fields but had
	 * to move forward because it was getting over my head (even more).
	 */
	widget.directive('clickToEdit', function ($timeout) {
		return {
			require: 'ngModel',
			scope: {
				model: '=ngModel',
				options: '=clickToEdit',
				type: '@type'
			},
			replace: true,
			transclude: false,
			// includes our template
			templateUrl: "clickToEdit_index.html",
			link: function (scope, element, attrs) {
				scope.editState = false;
				var editModeClass = "edit";
				var readModeClass = "read";

				// apply the changes to the real model
				scope.save = function () {
					//console.log(scope.localModel);
					scope.toggle();
					scope.options.save(scope.model);

				};

				// don't apply changes
				scope.cancel = function () {
					scope.localModel = scope.model;
					scope.toggle();
					scope.options.cancel();
				};

				/*
				 * toggles the editState of our field
				 */
				scope.toggle = function () {
					if (!scope.editState) {
						//						scope.localModel = $.extend({}, scope.model);
						scope.localModel = angular.copy(scope.model);

					}
					scope.setMode(!scope.editState);
				};

				scope.setMode = function (mode) {
					scope.editState = mode;
					var trigger = element[0].querySelector(".hover-edit-trigger");
					$(trigger).removeClass(scope.editState ? readModeClass : editModeClass);
					$(trigger).addClass(scope.editState ? editModeClass : readModeClass);

					if(scope.editState &&
						scope.localModel &&
						scope.localModel.viewbag &&
						scope.localModel.viewbag.onChangeEditState){
							scope.localModel.viewbag.onChangeEditState();
					}
				};
			}
		};
	});


	/*
	 * first stab at a 'click to edit' element based on
	 * Atlassian/Jira's amazing interface elements.
	 * i tried getting clever with transclusion of the input fields but had
	 * to move forward because it was getting over my head (even more).
	 */
	widget.directive('clickToEditObject', function ($timeout) {
		return {
			scope: {
				options: '=clickToEditObject',
				type: '@type'
			},
			templateUrl: "clickToEditObject_index.html",
			link: function (scope, element, attrs) {
				if (scope.options.viewbag) {
					$.extend(scope, scope.options.viewbag);
				}
				scope.editState = false;
				var editModeClass = "edit";
				var readModeClass = "read";
				scope.qconfirm = {
					messages: {}
				};
				if (scope.qconfirm.messages) {
					scope.qconfirm.messages.list = scope.qconfirm.messages.list ? scope.qconfirm.messages.list : [];

					scope.qconfirm.messages.add = function (msgObj) {
						if (Array.isArray(msgObj)) {
							scope.qconfirm.messages.list = msgObj;
						} else if (typeof msgObj === 'object') {
							scope.qconfirm.messages.list.push(msgObj);
						}
					};

					scope.qconfirm.messages.clear = function () {
						scope.qconfirm.messages.list = [];
					};
					scope.qconfirm.messages.clearAndAdd = function (msgObj) {
						scope.qconfirm.messages.clear();
						scope.qconfirm.messages.add(msgObj);
					};
				}

				// apply the changes to the real model
				scope.ok = function () {
					if ((scope.qconfirm.okToClose && scope.qconfirm.okToClose()) || !(scope.qconfirm.okToClose)) {
						scope.save(scope.model);
						return true;
					}
					return false;
				};

				scope.okAndNew = function () {
					if (scope.ok() && scope.addObjectFn) {
						scope.addObjectFn()
					}
				}

				// don't apply changes
				scope.no = function () {
					scope.cancel();
				};
			}
		};
	});

	/*
	 * first stab at a 'click to edit' element based on
	 * Atlassian/Jira's amazing interface elements.
	 * i tried getting clever with transclusion of the input fields but had
	 * to move forward because it was getting over my head (even more).
	 */
	widget.directive('clickToEditTask', function ($timeout) {
		return {
			scope: {
				objectToModify: '=objet',
				field: '@field',
				options: '=clickToEditTask',
				state: '=',
				type: '@type'
			},
			replace: true,
			transclude: false,
			templateUrl: "clickToEditTask_index.html",
			link: function (scope, element, attrs) {
				scope.state = scope.state ? scope.state : false;
				var editModeClass = "edit";
				var readModeClass = "read";
				scope.localModel = $.extend({}, scope.objectToModify);

				scope.save = function () {
					$.extend(scope.objectToModify, scope.localModel);
					scope.options.save(scope.localModel);
					scope.toggle();
				};
				// don't apply changes
				scope.cancel = function () {
					scope.options.cancel(scope.objectToModify);
					scope.toggle();
				};
				/*
				 * toggles the editState of our field
				 */
				scope.toggle = function () {
					if (!scope.state) {
						scope.localModel = $.extend({}, scope.objectToModify);
					}
					scope.setMode(!scope.state);
				};
				scope.setMode = function (mode) {
					scope.state = mode;
					var trigger = element[0].querySelector(".hover-edit-trigger");
					$(trigger).removeClass(scope.state ? readModeClass : editModeClass);
					$(trigger).addClass(scope.state ? editModeClass : readModeClass);
				};
			}
		};
	});

	widget.directive("compareTo", function () {
		return {
			require: "ngModel",
			scope:
			{
				repeatPassword: "=compareTo"
			},
			link: function (scope, element, attributes, paramval) {
				paramval.$validators.compareTo = function (val) {
					return val == scope.repeatPassword;
				};
				scope.$watch("repeatPassword", function () {
					paramval.$validate();
				});
			}
		};
	});

	/*
	 * first stab at a 'click to edit' element based on
	 * Atlassian/Jira's amazing interface elements.
	 * i tried getting clever with transclusion of the input fields but had
	 * to move forward because it was getting over my head (even more).
	 */
	widget.directive('clickToEditPlan', ['model', '$timeout', 'QValidation', function (model, $timeout, QValidation) {
		return {
			require: 'ngModel',
			scope: {
				model: '=ngModel',
				options: '=quickSave', // si  data-quick-save="quickSavePlan" dans directive. options = PatientView...
				list: '=list',
				type: '@type',
				allowEdit: '='
			},
			replace: true,
			transclude: false,
			// includes our template
			templateUrl: "clickToEditPlan_index.html",
			link: function (scope, element, attrs) {
				if (scope.allowEdit === undefined) {
					scope.allowEdit = true;
				}
				// apply the changes to the real model
				scope.save = function () {
					unregisterDirty();
					saveEdit();
				}

				function saveEdit() {
					scope.toggle();
					if (!OfysUtils.compare(scope.localModel, scope.model)) {
						angular.copy(scope.localModel, scope.model);
						delete scope.localModel;
						scope.model.tag = model.atomicInt();
						scope.options.save(scope.model); // call le save dans PatientView
					} else {
						delete scope.localModel;
					}
					delete scope.model.isNew
					delete scope.model.localModel

				};

				scope.dataModel = model;
				// don't apply changes
				scope.cancel = function () {
					cancelEdit();
					unregisterDirty();
				}
				function cancelEdit() {
					if (!scope.localModel.isNew) {
						// scope.model = scope.localModel;
					} else {
						scope.list.pop();
					}
					delete scope.model.isNew;
					delete scope.localModel;
					scope.toggle();
					scope.options.cancel();
				};
				function generateUIDNotMoreThan1million() {
					return ("00000" + (Math.random() * Math.pow(36, 5) << 0).toString(36)).slice(-5);
				}
				/*
				 * toggles the editState of our field
				 */
				scope.toggle = function () {
					if (!scope.allowEdit) {
						return;
					}
					if (!scope.editState) {
						// make a local ref so we can back out changes, this only happens once and persists
						if(scope.model && scope.model.localModel){
							scope.localModel = scope.model.localModel;
						}else{
							scope.localModel = $.extend({}, scope.model);
							scope.model.planId = generateUIDNotMoreThan1million();
						}
						scope.model.localModel = scope.localModel;
						scope.localModel.createDateS = moment().format("YYYY-MM-DD HH:mm");
					}
					scope.setMode(!scope.editState);
				};

				function registerDirty() {
					QValidation.registerDirty("plan_" + scope.model.planId, function (status) {
						console.log(this.arguments);
						saveEdit();
						return true;
					}, function () {
						cancelEdit();
						return true;
					});
					scope.model.localModel = scope.localModel;
				}

				function unregisterDirty() {
					QValidation.unregisterDirty("plan_" + scope.model.planId);
					delete scope.model.localModel
				}

				scope.setMode = function (mode) {
					scope.editState = mode;
					var trigger = element[0].querySelector(".hover-edit-trigger");
					$(trigger).removeClass(scope.editState ? readModeClass : editModeClass);
					$(trigger).addClass(scope.editState ? editModeClass : readModeClass);

					$timeout(function(){
						if(scope.localModel && scope.localModel.focusPlan){
							scope.localModel.focusPlan();
						}
					}, 100);
					if(scope.editState){
						if (scope.model.planId){
							QValidation.unregisterDirty("plan_" + scope.model.planId);
						}
						registerDirty()
					}
				};

				// je le mets à la fin car scope.toggle n'existe pas encore au début.
				if (scope.model.isNew || scope.model.localModel) {
					scope.toggle();
				} else {
					scope.editState = false;
				}
				var editModeClass = "edit";
				var readModeClass = "read";
			}
		};
	}]);

	/**
	 * Borrowed from Syra-Med
	 * Allows to set focus on an input by calling a function.
	 * e.g
	 * '<button ng-click="setPatientInputFocus()">My button</button>
	 * <input type="text" input-focus-function="setPatientInputFocus"/>'
	 *
	 * in the above example clicking the button would set focus on the input
	 *
	 * The function can be called in angular code.
	 * e.g
	 * '$scope.setPatientInputFocus();'
	 * the above code would also set focus on the input.
	 *
	 * Note that the scope has to be the same.
	 */
	widget.directive('inputFocusFunction', ['WidgetService', function (WidgetService) {
		'use strict';
		var lastFocused = Date.now();
		return {
			restrict: 'A',
			link: function (scope, element, attr) {
				function inputFocusFunc(b) {
					var newFocused = Date.now();

					if (arguments.length) { // setfocus appelé juste pour avoir un lieu de focus lors de certaines tâches
						f()
					} else if (newFocused - lastFocused > 300) {
						// if (MyNamespace.helpers.isEmpty(element[0].value)) {
							lastFocused = newFocused;
							f()
						// }
					}
				}

				function f(){
					if (scope.toastTextAreaInput){
						scope.toastTextAreaInput.focus()
					}else{
						element[0].focus();
					}
				}

				WidgetService.callableFunction(scope, attr.inputFocusFunction, inputFocusFunc)

			}
		};
	}]);


	widget.directive('setElement', ['WidgetService', function (WidgetService) {
		'use strict';
		return {
			restrict: 'A',
			link: function (scope, element, attr) {
				WidgetService.callableFunction(scope, attr.setElement, element)
			}
		};
	}]);

	widget.directive('scrollOnScreenFunction', ['WidgetService', function (WidgetService) {
		'use strict';
		var lastFocused = Date.now();
		return {
			restrict: 'A',
			link: function (scope, element, attr) {
				function scrollOnScreenFunc(b) {
					var newFocused = Date.now();
					if (arguments.length) { // setfocus appelé juste pour avoir un lieu de focus lors de certaines tâches
						if(OfysUtils.isSafariBrowser){
							element[0].scrollIntoView();
						}else{
							element[0].scrollIntoView({
								behavior: "smooth",
								block: "end",
								inline: "nearest"
							});
						}
					} else if (newFocused - lastFocused > 300) {
						lastFocused = newFocused;
						if(OfysUtils.isSafariBrowser()){
							element[0].scrollIntoView();
						}else{
							element[0].scrollIntoView({
								behavior: "smooth",
								block: "end",
								inline: "nearest"
							});
						}
					}
				}
				WidgetService.callableFunction(scope, attr.scrollOnScreenFunction, scrollOnScreenFunc)
			}
		};
	}]);
	
	widget.directive('ngRightClick', function($parse) {
	    return function(scope, element, attrs) {
	        var fn = $parse(attrs.ngRightClick);
	        element.bind('contextmenu', function(event) {
	            scope.$apply(function() {
	                event.preventDefault();
	                fn(scope, {$event:event});
	            });
	        });
	    };
	});

	widget.directive('isolate',[function(){
		return {
			restrict:'AE',
			scope:true,
			link:function(scope, element, attr){
				function update(){
					$.extend(scope, scope.$eval(attr.isolate));
				}
				scope.$watch(scope.$eval(attr.isolate), update);
			}
		}
	}])

	// widget.directive('toastEditor', ['WidgetService', function (WidgetService) {
	// 	'use strict';
	// 	return {
	// 		restrict: 'EA',
	// 		templateUrl: "/dashboard/resources/ofys/widgets/toasteditor.html",
	// 		link: function (scope, element, attr) {
	// 			console.log("Jam session")
	// 			var editor = new tui.Editor({
	// 					el: scope.editorElement[0],
	// 					initialEditType: 'markdown',
	// 					previewStyle: 'vertical',
	// 					height: '300px'
	// 			});
	// 			scope.$watch(attr.model, function (model) {
	// 				editor.md = model
	// 			})
	// 		}
	// 	};
	// }]);

	widget.directive("ngScopeElement", function () {
		var directiveDefinitionObject = {

			restrict: "A",

			compile: function compile(tElement, tAttrs, transclude) {
				return {
						pre: function preLink(scope, iElement, iAttrs, controller) {
							scope[iAttrs.ngScopeElement] = iElement;
						}
					};
			}
		};

		return directiveDefinitionObject;
	});

	widget.directive('clickFunction', ['WidgetService', function (WidgetService) {
		'use strict';
		var lastFocused = Date.now();
		return {
			restrict: 'A',
			link: function (scope, element, attr) {
				function clickElement(b) {
					$(element).click();
				}
				WidgetService.callableFunction(scope, attr.clickFunction, clickElement)
			}
		};
	}]);

	widget.directive('fileModel', ['$parse', function ($parse) {
		return {
			 restrict: 'A',
			 link: function(scope, element, attrs) {
				var updater;
					var model = $parse(attrs.fileModel);

					var modelSetter = model.assign;

					element.bind('change', function() {
						 scope.$apply(function() {
								modelSetter(scope, element[0].files[0]);
								// if(updater){
								// 	updater()
								// }
								if(attrs.fileChanged){
									scope.$eval(attrs.fileChanged);
								}
						 });
					});
					scope.$watch(model, function(file){
						if(!file){ // only for clearing the file
							element.val(file)
						}
					})
			 }
		};
 }]);

	widget.factory('WidgetService', [function () {
		var accessor = {
			/** This function allows adding a callable to a ui element that can be called programmatically. ie.
			 *
			 * <input input-focus-function="item.focusThisElement" type="text">
			 * <input scroll-on-screen-function="item.scrollToThisElement" type="text">
			 * <input click-function="item.clickThisElement" type="text">
			 *
			 * ****
			 * In javascript :
			 *
			 * item.focusThisElement()
			 * item.scrollToThisElement()
			 * item.clickThisElement()
			 *
			 */
			callableFunction: function (scope, fnname, fn) {
				function getobj(sc, treeArray) {
					var i;
					var obj = sc;
					for (i = 0; i < treeArray.length - 1; i++) {
						if (obj[treeArray[i]]) {
							obj = obj[treeArray[i]];
						}
					}
					return obj;
				}
				//Allows creating the function in the right scope.
				// If the current scope does not have the object defined.
				// The parent scopes are searched for the object definition.
				if (fnname.indexOf(".") > -1) {
					var split = fnname.split(".");
					var elemScope = scope;
					while (angular.isUndefined(elemScope[split[0]]) && angular.isDefined(scope.parent)) {
						elemScope = elemScope.parent;
					}
					if (angular.isDefined(elemScope[split[0]])) {
						var object = getobj(elemScope, split);
						object[split[split.length - 1]] = fn;
					}
				} else {
					scope[fnname] = fn;
				}
			}
		}
		return accessor;
	}]);

	widget.directive('infiniteScrollContainer', [function () {
		return {
			restrict: 'A',
			controller: ['$scope', '$element', '$timeout', function ($scope, $element, $timeout) {
				this.parent = $element;
			}]
		}
	}]);

	widget.directive('infiniteScroll', [
		'$rootScope', '$window', '$timeout',
		function ($rootScope, $window, $timeout) {
			return {
				restrict: 'A',
				require: '^^infiniteScrollContainer',
				link: function (scope, elem, attrs, ctrl) {
					var checkWhenEnabled, handler, scrollDistance, scrollEnabled;
					elem = angular.element(elem);
					scrollDistance = 0;
					if (attrs.infiniteScrollDistance != null) {
						scope.$watch(attrs.infiniteScrollDistance, function (value) {
							return scrollDistance = parseInt(value, 10);
						});
					}
					scrollEnabled = true;
					checkWhenEnabled = false;
					if (attrs.infiniteScrollDisabled != null) {
						scope.$watch(attrs.infiniteScrollDisabled, function (value) {
							scrollEnabled = !value;
							if (scrollEnabled && checkWhenEnabled) {
								checkWhenEnabled = false;
								return handler();
							}
						});
					}
					handler = function () {
						var remaining, max, ch, shouldScrollDown, shouldScrollUp, windowBottom;
						var offset = elem.offset();
						var sh = ctrl.parent[0].scrollHeight;
						var h = ctrl.parent.height();
						remaining = sh + (offset.top - h);
						ch = ctrl.parent[0].clientHeight
						max = ch * scrollDistance;
						shouldScrollDown = remaining <= max;
						shouldScrollUp = offset.top > 95;
						if (scrollEnabled===true) {
							if (shouldScrollDown) {
								if ($rootScope.$$phase) {
									return scope.$eval(attrs.infiniteScrollDown);
								} else {
									return scope.$apply(attrs.infiniteScrollDown);
								}
							} else if (shouldScrollUp) {
								if ($rootScope.$$phase) {
									return scope.$eval(attrs.infiniteScrollUp);
								} else {
									return scope.$apply(attrs.infiniteScrollUp);
								}
							}
						} else if (shouldScrollDown || shouldScrollUp) {
							return checkWhenEnabled = true;
						}
					};
					ctrl.parent.on('scroll', handler);
					scope.$on('$destroy', function () {
						return ctrl.parent.off('scroll', handler);
					});
					return $timeout((function () {
						if (attrs.infiniteScrollImmediateCheck) {
							if (scope.$eval(attrs.infiniteScrollImmediateCheck)) {
								return handler();
							}
						} else {
							return handler();
						}
					}), 0);
				}
			};
		}
	]);

	widget.directive('dynaDate', ['$timeout', '$filter', function ($timeout, $filter) {
		return {
			restrict: 'A',
			require: '?ngModel',
			link: function (scope, element, attrs, ngModelCtrl) {
				$timeout(function () {
					scope.dynaDate = scope.$eval(attrs.dynaDate);
					if (scope.dynaDate === undefined) {
						scope.dynaDate = {};
					}
					scope.dynaDate.elem = element;
					scope.dynaDate.elem[0].title = $filter('translate')('dynadate_keyboard_shortcuts')

					scope.dynaDate.angularRefresh = function () {
						if (!scope.$$phase) {
							scope.$digest();
						}
					};

					if (ngModelCtrl && !scope.dynaDate.onDateSelected) {
						scope.dynaDate.onDateSelected = function (mDate, dAssist) {
							if (mDate !== false) {
								ngModelCtrl.$setViewValue(mDate.format(dAssist.format));
							}else{
								ngModelCtrl.$setViewValue("");
							}
						};
					}

					var dateAssist = new DynaDate(scope.dynaDate);
				}, 150);
			}

		};
	}]);

	widget.directive('partialdate', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, elem, attr, ngModel) {
				ngModel.$validators.partialDate = function (val) {
					if (val) {
						function orLast(n){
							if(dateStr.length > n){
								return n;
							}else{
								return dateStr.length

							}
						}
						var year, month, day;
						var dateStr = val.replaceAll('-', '').replaceAll('\\', '').replaceAll('/', '');
						if(dateStr.length > 8){
							return false
						}
						if(dateStr.length > 4){
							year = dateStr.substring(0, orLast(4))*1;
						}else {
							year = dateStr*1;
						}
						if(dateStr.length > 4){
							month = dateStr.substring(4, orLast(6))*1;
						}
						if(dateStr.length > 6){
							day = dateStr.substring(6, orLast(8))*1
						}

						if(month === undefined){
							month = '01';
						}
						if(day === undefined){
							day = '01';
						}
						if(isNaN(year) || isNaN(month) || isNaN(day)){
							return false;
						}
						var validity = moment(year+"-"+ month +"-"+day, "YYYY-MM-DD").isValid();
						return validity;
					} else {
						return true;
					}
				};
			}
		};
	});

	widget.directive('dynaAssist', ['$timeout', function ($timeout) {
		return {
			restrict: 'EA',
			transclude: true,
			scope: {
				id: '@',
				assistId: '@',
				dynaAssist: '='
			},
			link: function (scope, element, attrs) {
				$timeout(function () {
					if (typeof scope.dynaAssist != "undefined") {
						if (!scope.dynaAssist.assistId) {
							var autoId = Math.floor((Math.random() * 1000) + 1) + 'autoId' + Math.floor((Math.random() * 1000) + 1);
							$(element).parent().append('<div id="' + autoId + '"></div>')
							scope.dynaAssist.assistId = autoId;
						}
						scope.assistOptions = scope.dynaAssist;
						if (typeof scope.assistOptions != "undefined") {
							scope.assistOptions.elem = element.get(0);
							if(scope.assistOptions.parentWidth){
								scope.assistOptions.listWidth = scope.assistOptions.elem.offsetWidth;
							}
							scope.assistOptions.angular = true;
							if ($.isEmptyObject(scope.assistOptions.assistId)) scope.assistOptions.assistId =
								typeof scope.assistId !== 'undefined' ? scope.assistId : scope.id + "_assist";
							var assist = new AssistDynaText(scope.assistOptions);
							scope.$on('$destroy', function () {
								assist.destroy();
							});
						}
					} else {
						//Occurs in nested directives where the options are declared in the parent directive
						//but are not initialised until after the assist widget(child directive) is run.
						//Occurs also when the dynaAssist expression is not defined in scope.
						console.error("Assist option " + attrs.dynaAssist + " is undefined");
					}
				}, 0);
			}
		};
	}]);

	widget.filter('toTrusted', ['$sce', function ($sce) {
		return function (text) {
			return $sce.trustAsHtml(text);
		};
	}]);

	widget.filter('textToHtmlSummray', ['Markdown', function (Markdown) {
		return function (text) {
			if (text.length>0 && text.charAt(0)==='≖') {
				var m = Markdown.toHTML(text.substring(1));//del markdown marker
				m = m.substring(0,3)==='<p>' ? m.substring(3, m.length-5) : m;// del <p>  et </p> car ça fait sauter une ligne
				return m;
			}
			var lines = text.replaceAll(/^[ \t]*\r?\n/, '').split('\n');
			var res = "";
			for (var i = 0; i < lines.length; i++) {
				if (lines[i]) {
					res = res + '<span class="list-item-nowrap">' + lines[i] + '</span>';
				}
			}
			return res;
		};
	}]);

	widget.filter('noteTextToHtmlSum', [function () {
		return function (text) {
			var note = text.replaceAll(/^[ \t]*\r?\n/, '').replaceAll('\n', '<br>');
			note = note ? ((note.match(/<br>/g) || []).length > 0 ? "<br>" + note : ' - ' + note): note;
			return note;
		};
	}]);
	widget.filter('textToHtmlSum', [function () {
		return function (text) {
			return text.replaceAll(/^[ \t]*\r?\n/, '').replaceAll('\n', '<br>');
		};
	}]);

	widget.filter('textToHtml', [function () {
		return function (text) {
			if(text){
				// return text.replaceAll('\n', '<br>');
				return text.replace(/[&<>"'\/]/g, function (s) {
					var entityMap = {
						"&": "&amp;",
						"<": "&lt;",
						">": "&gt;",
						'"': '&quot;',
						"'": '&#39;',
						"/": '&#x2F;'
					};

					return entityMap[s];
				}).replaceAll('\n', '<br>');
			} else {
				return ""
			}
		};
	}]);

	widget.filter('nan', function () {
		return function (input) {
			input = input || -1;
			if (input >= 0) {
				return input;
			} else {
				return '-';
			}
		};
	});

	widget.filter('clvdate', function ($translate) {
		return function (input, format) {
			input = input || '';
			format = format || 'YYYY-MM-DD';
			var out = '';
			var d = moment(input, format);
			if (d.isValid && moment().isSame(d, 'day')) {
				out = $translate.instant("Today");
			} else if (moment().add(1, 'd').isSame(d, 'day')) {
				out = $translate.instant("Tomorrow");
			} else if (moment().subtract(1, 'd').isSame(d, 'day')) {
				out = $translate.instant("Yesterday");
			} else {
				out = d.format(format);
			}
			return out;
		};
	});

	widget.filter('showNotePatient', function () {
		return function (rv, format) {
			if (rv===undefined || rv===null) return '';
			var notePt = (OfysUtils.isEmpty(rv.notePatient)?'':rv.notePatient) + (OfysUtils.isEmpty(rv.consultationReason)?'':rv.consultationReason);
			return notePt;
		};
	});

	widget.filter('clvtime', function () {
		return function (input, format) {
			if (input===undefined || input===null) return '';
			input = input || 0;
			var hour = (input/60) | 0;
			var minutes = input%60;
			return (hour<10?'0':'')+hour+'h'+(minutes<10?'0':'')+minutes;
		};
	});

	widget.directive('navCompass', function () {
		return {
			restrict: 'E',
			templateUrl: 'navcompass_index.html',
			scope: true,
			link: function (scope, element, attrs) {
				scope.move = function (direction) {
					var act = scope.$eval(attrs.action);
					act(direction);
				};
			}
		};
	});

	widget.directive('objBsPopover', ['$popover', function ($popover) {
		return {
			restrict: 'A',
			link: function (scope, element, attrs) {
				function update(){
					scope.popOpt = scope.$eval(attrs.objBsPopover);
					if(scope.popOpt && scope.popOpt.bsOptions){
						scope.popOpt.api = $popover(element, scope.popOpt.bsOptions);
					}

				}
				scope.$watch(attrs.objBsPopover, update);
			}
		};
	}]);

	widget.directive('keyboardnavigation', [function () {
		return {
			restrict: 'A',
			scope: {
				keyboardnavigation: '='
			},
			link: function (scope, element, attrs) {
				$(element).attr("tabindex", "0");
				var listeItems;
				var currentIndex;
				var isActive = false;

				if (!scope.keyboardnavigation) {
					scope.keyboardnavigation = {};
				}

				scope.keyboardnavigation = {
					select: function (index) {
						if (listeItems && listeItems.length > 0 && listeItems.length > index) {
							$(listeItems).removeClass("hover");
							$(listeItems[index]).click();
						}
					},
					move: function (index) {
						if (listeItems && listeItems.length > 0 && listeItems.length > index) {
							currentIndex = index; //Seems repetitive but makes sure the api always sets the currentIndex
							$(listeItems).removeClass("hover");
							$(listeItems[index]).addClass("hover");
						}
					}
				};

				function hover(e) {
					$(listeItems).find(".hover").removeClass("hover");
					currentIndex = $(listeItems).index($(e.target));
					$(e.target).addClass("hover");
				}

				function unhover(e) {
					$(listeItems).removeClass("hover");
				}

				function moveUp() {
					if (currentIndex > 0) {
						currentIndex = currentIndex - 1;
					} else if (listeItems.length === 0) {
						currentIndex = 0;
					} else {
						currentIndex = listeItems.length - 1;
					}
					scope.keyboardnavigation.move(currentIndex);
				}

				function moveDown() {
					currentIndex = currentIndex < listeItems.length - 1 ? currentIndex + 1 : 0;
					scope.keyboardnavigation.move(currentIndex);
				}

				function activate() {
					if (!isActive) {
						isActive = true;
						listeItems = $(element).children();
						currentIndex = currentIndex ? currentIndex : 0;
						listeItems.hover(hover, unhover);
						$(element).keydown(function (e) {
							if (e.which == 40) { //Down key
								moveDown();
							} else if (e.which == 38) { //Up key
								moveUp();
							}
						}).keyup(function (e) {
							if (e.which == 13) { //Enter key
								if (currentIndex < 0 && currentIndex > listeItems.length) {
									currentIndex = 0;
								}
								scope.keyboardnavigation.select(currentIndex);
							}
						});
						scope.keyboardnavigation.move(currentIndex);
					}
				}

				function deactivate() {
					if (isActive) {
						isActive = false;
						$(listeItems).removeClass("hover");
						$(element).off('keydown');
						$(element).off('keyup');
						$(listeItems).off('hover');
					}
				}

				$(element).focus(activate).blur(deactivate);

			}
		};
	}]);

	/**
	 * Jbox Tooltip wrapper for angular.
	 * Allows the use of template, templateUrl used as an attribute to another element
	 * eg.
	 * 		<div j-Tooltip="myOptions">Hello Tooltip</div>
	 *
	 * in the example the 'myOptions' sets the variable with tooltip options
	 * for a complete list of possible options visit: https://stephanwagner.me/jBox/options
	 * the 'content' option is overriden as template or templateUrl
	 */
	widget.directive('jTooltip', ['$templateCache', '$timeout', '$http', 'utils',
		function ($templateCache, $timeout, $http, utils) {
			return {
				restrict: 'A',
				link: function (scope, element, attrs) {
					$timeout(function () {
						if (attrs.jTooltip !== undefined && attrs.jTooltip !== "") {
							var s = scope.$eval(attrs.jTooltip);
							s.attach = element;
							s.ngscope = scope;

							if (angular.isDefined(s.templateUrl)) {
								s.content = $templateCache.get(s.templateUrl);
								utils.getTemplate(s.templateUrl, function (html) {
									s.content = html;
									new jBox('Tooltip', s);
								});
							} else {
								s.content = angular.isDefined(s.template) ? s.template : s.content;
								new jBox('Tooltip', s);
							}

						}

					}, 0);
				}
			};
		}
	]);

	widget.factory('FlView', ['$uibModal', 'model', function ($uibModal, model) {
		var service = {
			open: function (input, opt) {
				var mObj = input;
				var modalOptions = {
					animation: true,
					templateUrl: "/dashboard/resources/ofys/widgets/fl_modal.html?v=bj",
					controller: 'ModalInstanceCtrl',
					keyboard: false,
					size: "fl",
					resolve: {
						mObject: function () {
							//Object with quickview specific functions
							mObj.fl = mObj.fl ? mObj.fl : {};

							//Pour fermer le modal et retourner un objet
							mObj.fl.ok = function (res) {
								modalInstance.close(res);
							};

							mObj.fl.minimize = function () {
								modalInstance.dismiss('cancel');
							};

							//Pour fermer le modal
							mObj.fl.cancel = function () {
								var allow = true;
								if (mObj.beforeCancel) {
									mObj.beforeCancel({prevent: function(){
										allow = false;
									}}, mObj).then(function(close){
										if(!allow || !close)return;
										modalInstance.dismiss('cancel');
									});
									
								}else{
									modalInstance.dismiss('cancel');
								}
							};

							return mObj;
						}
					}
				};
				if (opt) {
					$.extend(modalOptions, opt);
				}

				var modalInstance = $uibModal.open(modalOptions);
				return modalInstance.result;
			}
		};

		return service;
	}]);

	widget.factory('QValidation', ['$q','QConfirm','model', '$filter', 'Event',
	                             function($q, QConfirm, model, $filter, Event) {
		var isDirty = false;
		var isDirtyList = {};


		window.addEventListener("beforeunload", function(e){
			if(isDirty || !model.webSocketActivity().val){
				var confirmationMessage = "\o/";

				e.returnValue = confirmationMessage;     // Gecko, Trident, Chrome 34+
				return confirmationMessage;
			}
		}, {once: true, capture:false});

		/**
		 * @ngdoc method
		 * @name recursiveAction
		 * @param {string} type the type of recursicve action either 'save' or 'cancel'
		 * @param {string} key the key identifying the action element (Must be in the isDirtyList of elements)
		 * @param {object} masterDeffered a deffered object that tracks the whole transaction.
		 * 			is set to resolved when operation is successful and is rejected when the operation fails.
		 */
		function recursiveAction(type, key, masterDeffered){
			var recurse = true;
			var recursivePromise = false;//can be a promise or a boolean

			if(isDirtyList[key][type] != undefined){
				recursivePromise = isDirtyList[key][type]();
				if(recursivePromise === undefined){
					QValidationService.unregisterDirty(key);
					throw "Action must return a type either a boolean value or a promise. " +
							"This occurs if a 'QValidation.registerDirty' method was passed a function that does not have a return type.";
				}else if(typeof(recursivePromise) === "boolean"){
					QValidationService.unregisterDirty(key);
					recurse = recursivePromise ? true : type === 'cancel';
				}else if(typeof(recursivePromise) === "object"){
					recurse = Object.keys(isDirtyList).length > 0;
					if(!recurse){
						masterDeffered.resolve(true);
					}
				}
			}else if(type === 'cancel'){
				QValidationService.unregisterDirty(key);
				recurse = true;
			}

			//Failed to save with recursive strategy
			//TODO show message that save could not be completed successfully
			if(!recurse && Object.keys(isDirtyList).length > 0){
				masterDeffered.reject();
			}

			if(typeof(recursivePromise) === 'object'){
				//Save next element in the list of unsaved elements i.e recurse.
				recursivePromise.then(function(){
					QValidationService.unregisterDirty(key);
					if(recurse && Object.keys(isDirtyList).length > 0){
						recursiveAction(Object.keys(isDirtyList)[0], masterDeffered);
					}else{
						masterDeffered.resolve(true);
					}
				}, function(res){
					model.notice().fail($filter('translate')('FailedSave'));
					masterDeffered.reject(res);
				});
			}else if(recurse && Object.keys(isDirtyList).length > 0){
				recursiveAction(Object.keys(isDirtyList)[0], masterDeffered);
			}else{
				masterDeffered.resolve(true);
			}
		}
		Event.addEvent('closeContext', {});

		var QValidationService = {
			/**
			 * @ngdoc method
			 * @description register dirty state of an element.
			 * @param {key} should be unique to dirty element idealy a savable entity
			 * @param {method}saveCallback is called to save dirty element should return
			 * 		a promise for async saving or true or false in case of a fail or success.
			 * @param {method}cancelCallback is called to discard changes to return data
			 * 			to original state or do clean up operations.
			*/
			registerDirty:function(key, saveCallback, cancelCallback, msg){
				isDirty = true;
				if(saveCallback == undefined){
					throw "A save call back is required when registering a dirty sate";
				}
				if(isDirtyList[key] == undefined){
					isDirtyList[key] = {save: saveCallback, cancel: cancelCallback, msg: msg};
				}
			},
			/**
			 * @ngdoc method
			 * @description unregister dirty state of an element
			 * @param {key} should be unique to dirty element idealy a savable entity
			 * @param {cancelCallback} is called
			*/
			unregisterDirty: function(key){
				if(isDirtyList[key] != undefined){
					delete isDirtyList[key];
				}

				if(Object.keys(isDirtyList).length == 0){
					isDirty = false;
				}
			},
			saveOrCancel: function(key, type){
				var recursivePromise = false;
				if(isDirtyList[key][type] != undefined){
					recursivePromise = isDirtyList[key][type]();
					if(recursivePromise === undefined){
						QValidationService.unregisterDirty(key);
						throw "Action must return a type either a boolean value or a promise. " +
								"This occurs if a 'QValidation.registerDirty' method was passed a function that does not have a return type.";
					}else if(typeof(recursivePromise) === "boolean"){
						QValidationService.unregisterDirty(key);
						return recursivePromise ? true : type === 'cancel';;
					}
				}else if(type === 'cancel'){
					QValidationService.unregisterDirty(key);
				}
				if(typeof(recursivePromise) === 'object'){
					return recursivePromise.then(function(){
						QValidationService.unregisterDirty(key);
						return true;
					}, function(res){
						model.notice().fail($filter('translate')('FailedSave'));
						return $q.reject(res)
					});
				}else{
					return true;
				}
			},
			saveAll: function(){
				var deferred = $q.defer();
				recursiveAction('save', Object.keys(isDirtyList)[0], deferred);
				return deferred.promise;
			},
			cancelAll: function(){
				var deferred = $q.defer();
				recursiveAction('cancel', Object.keys(isDirtyList)[0], deferred);
				return deferred.promise;
			},
			closeContext: function(message, key){
				function cleanZombieActivies(){
					keys = Object.keys(isDirtyList);
					for(let i = keys.length-1; i >= 0; i--){
						if(keys[i].includes("externalPatMedSum") && model.summaryExternalViewer
								&& keys[i].match(/(\d+)/g).join('') === model.summaryExternalViewer.groupId.match(/(\d+)/g).join('')
								&& model.summaryExternalViewer.qv && model.summaryExternalViewer.qv.externalViewer 
								&& model.summaryExternalViewer.qv.externalViewer.closed){
							QValidationService.unregisterDirty(keys[i]);
						}
					}
				}
				var deferred = $q.defer();
				cleanZombieActivies();
				Event.emit('closeContext', {}, function (){
					if(isDirty && (!key || isDirtyList[key])){
						QConfirm.open({title: message , 
								descriptions: _.values(isDirtyList).filter(function(e){return e.msg}).map(function(e){return e.msg}) }, {windowClass:'top-modal2'}).then(function(save){
							try{
								if(key){
									return save ? QValidationService.saveOrCancel(key, 'save') : QValidationService.saveOrCancel(key, 'cancel');
								}
								else return save ? QValidationService.saveAll() : QValidationService.cancelAll();
							}catch(e){
								console.error(e);
								deferred.resolve(false);
							}
						}).then(
							function(res){
								deferred.resolve(res);
							}, function(){
								deferred.reject("Cancelled context switch. Resume for further modifications.");
							}
						);
					}else{
						deferred.resolve(true);
					}

				});
				return deferred.promise;
			},
			isDirty: function(){
				return isDirty;
			},
		};

		return QValidationService;
	}]);

	widget.factory('QConfirm', ['$uibModal', 'model', function ($uibModal, model) {
		var service = {
			open: function (input, opt) {
				mObj = {
					title: 'ConfirmMessage',
				};

				$.extend(mObj, input);

				var modalOptions = {
					animation: true,
					templateUrl: "qconfirm_index.html",
					controller: 'ModalInstanceCtrl',
					size: "qconfirm",
					backdrop: 'static',
					keyboard: false,
					resolve: {
						mObject: function () {
							mObj.qconfirm = mObj.qconfirm ? mObj.qconfirm : {};

							mObj.qconfirm.cancel = function () {
								var allow = true;
								if (mObj.qconfirm.beforeCancel) {
									mObj.qconfirm.beforeCancel({prevent: function(){
										allow = false;
									}}, mObj);
									if(!allow)return;
								}
								modalInstance.dismiss('cancel');
							};
							mObj.qconfirm.no = function () {
								var allow = true;
								if (mObj.qconfirm.beforeNo) {
									mObj.qconfirm.beforeNo({prevent: function(){
										allow = false;
									}}, mObj);
									if(!allow)return;
								}
								modalInstance.close(false);
							};
							mObj.qconfirm.yes = function () {
								var allow = true;
								if (mObj.qconfirm.beforeYes) {
									mObj.qconfirm.beforeYes({prevent: function(){
										allow = false;
									}}, mObj);
									if(!allow)return;
								}

								modalInstance.close(true);
							};

							if (mObj.qconfirm.messages) {
								mObj.qconfirm.messages.list = mObj.qconfirm.messages.list ? mObj.qconfirm.messages.list : [];

								mObj.qconfirm.messages.add = function (msgObj) {
									if (Array.isArray(msgObj)) {
										mObj.qconfirm.messages.list = msgObj;
									} else if (typeof msgObj === 'object') {
										mObj.qconfirm.messages.list.push(msgObj);
									}
								};

								mObj.qconfirm.messages.clear = function () {
									mObj.qconfirm.messages.list = [];
								};
								mObj.qconfirm.messages.clearAndAdd = function (msgObj) {
									mObj.qconfirm.messages.clear();
									mObj.qconfirm.messages.add(msgObj);
								};
							}
							return mObj;
						}
					}
				};

				if (opt) {
					$.extend(modalOptions, opt);
				}

				var modalInstance = $uibModal.open(modalOptions);

				return modalInstance.result;
			}
		};

		return service;
	}]);

	widget.controller('ModalInstanceCtrl', function ($scope, $uibModal, $uibModalInstance, mObject) {
		$scope.modal = {};
		mObject.update = function(mObj){
			mObject = mObj;
			$.extend($scope, mObj);
		}

		mObject.update(mObject);
		$('html').addClass('freezePage');
		$('body').addClass('freezePage'); //https://stackoverflow.com/questions/43563795/bootstrap-modal-background-scroll-on-ios

		//Pour faire un action avant le close du modal redefinir la fonction $scope.modal.closing()
		//event.preventDefault() pour annuler la fermeture
		$scope.$on('modal.closing', function (event, reason, closed) {
			$('html').removeClass('freezePage');
			$('body').removeClass('freezePage');
			if (angular.isDefined($scope.modal.closing)) {
				$scope.modal.closing(event, reason, closed, $scope);
			}
		});
	});

	widget.controller('ModalInstanceCtrlB2b', function ($scope, $uibModal, $uibModalInstance, mObject) {
		$scope.modal = {};
		$scope.mObject = mObject;

		//Pour fermer le modal et retourner un objet
		$scope.modal.ok = function (res) {
			$uibModalInstance.close(res);
		};

		//Pour fermer le modal
		$scope.modal.cancel = function () {
			$uibModalInstance.dismiss('cancel');
		};

		//Pour faire un action avant le close du widget redefinir la fonction $scope.modal.closing()
		//event.preventDefault() pour annuler la fermeture
		$scope.$on('modal.closing', function (event, reason, closed) {
			if (angular.isDefined($scope.modal.closing)) {
				$scope.modal.closing(event, reason, closed);
			}
		});
	});



	widget.directive('firstChange', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, element, attrs, ctrl) {
				var changed = false;
				var hasFocus = false;
				element.on('focus', function () {
					changed = false;
					hasFocus = true;
				});
				element.on('blur', function () {
					hasFocus = false;
				});
				ctrl.$viewChangeListeners.push(function () {
					if (hasFocus) {
						if (!changed) {
							var callback = scope.$eval(attrs.firstChange);
							callback();
						}
						changed = true;
					}
				});
			}
		};
	});
	
	widget.directive('firstChangeKeypress', function () {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function (scope, element, attrs, ctrl) {
				var changed = false;
				var hasFocus = false;
				element.on('focus', function () {
					changed = false;
					hasFocus = true;
				});
				element.on('blur', function () {
					hasFocus = false;
				});
				element.on('keypress', function (e) {
					if (hasFocus) {
						if (!changed) {
							var callback = scope.$eval(attrs.firstChangeKeypress);
							callback();
						}
						changed = true;
					}	
				});
				element.on('keydown', function (e) {
					if (e.key === 'Delete' || e.key === 'Backspace') {
						if (hasFocus) {
							if (!changed) {
								var callback = scope.$eval(attrs.firstChangeKeypress);
								callback();
							}
							changed = true;
						}	
					}
				});
			}
		};
	});

	widget.directive('ripple', function () {
		return {
			restrict: 'A',
			link: function (scope, element, attrs) {
				$(element).click(tabClick);
				/*Tabs selection*/
				function tabClick(e) {

					// make sure we cannot click empty tabs
					//				  if ($(element).hasClass('tabs')) {
					//				    return;
					//				  }
					/* Add the ripple */

					// Remove olds ones
					$(".ripple").remove();


					// Setup
					var posX = $(this).offset().left,
						posY = $(this).offset().top,
						buttonWidth = $(this).width(),
						buttonHeight = $(this).height();

					// Add the element
					$(this).prepend("<span class='ripple'></span>");

					// Make it round!
					if (buttonWidth >= buttonHeight) {
						buttonHeight = buttonWidth;
					} else {
						buttonWidth = buttonHeight;
					}

					// Get the center of the element
					var x = e.pageX - posX - buttonWidth / 2;
					var y = e.pageY - posY - buttonHeight / 2;

					// Add the ripples CSS and start the animation
					$(".ripple").css({
						width: buttonWidth,
						height: buttonHeight,
						top: y + 'px',
						left: x + 'px'
					}).addClass("rippleEffect");

					$(".bar-one .bar").progress();
				}
			}
		};
	});

	widget.directive('iframeOnload', [function () {
		return {
			scope: {
				callBack: '=iframeOnload'
			},
			link: function (scope, element, attrs) {
				element.on('load', function () {
					if (scope.callBack)	return scope.callBack(element);
				});
			}
		};
	}]);

	widget.directive('listKeyboardSupport', [function () {
		return {
			link: function (scope, element, attrs) {}
		};
	}]);

	// directive pour tabber au next contrôle lorsque l'attribut maxLength est atteint.
	// pour fonctionner, donner un id focus9... aux contrôles qui doivent avoir un lien next.
	// ex, si on a 2 controles, le premier sera id focus1 et l'autre focus2.
	// ça pourrait être, p.ex., focus13 et focus14 (noter l'augmentation du chiffre qui permet de savoir quel controle est le next
	widget.directive("moveNextOnMaxlength", function() {
	    return {
	        restrict: "A",
	        link: function($scope, element, attrs) {
	            element.on("input", function(e) {
	            	var partsId = attrs.id.match(/focus(\d+)/);
	                var currentId = parseInt(partsId[1]);
	                if(element.val().length == element.attr("maxlength")) {
	                	var nextElement = document.querySelector('#focus' + (currentId + 1));
	                    nextElement.focus();
	                }
	            });
	        }
	    }
	});

	widget.filter('abbreviate', function() {
		  return function(n, l) {
			  return n ? MyNamespace.helpers.abbreviate(n, l) : "";
		  };
		});

	widget.filter('orderObjectBy', function() {
		return function(items, field, reverse) {
			var filtered = [];
			angular.forEach(items, function(item) {
				filtered.push(item);
			});
			filtered.sort(function (a, b) {
				return (a[field] > b[field] ? 1 : -1);
			});
			if(reverse) filtered.reverse();
			return filtered;
		};
	});

	widget.filter('cp', function () {
		return function (n) {
			if (!n) {
				return '';
			}
			var v = n.toString().trim().replace(/^\+/, '');
			var cp = v;
			switch (v.length) {
				case 6:
					return v.substr(0, 3) + ' ' + v.substr(3, 3);
				default:
					return cp;
			}
		};
	});

	widget.filter('FirstMaj', function () {
		return function (n) {
			if (!n) {
				return '';
			}
			if (n.length==1) return n.toUpperCase();
			return n.substring(0,1).toUpperCase() + n.substring(1).toLowerCase();
		};
	});

	widget.filter('nam', function () {
		return function (n) {
			if (!n) {
				return '';
			}
			var v = n.toString().trim().replace(/^\+/, '');
			var nam = v;
			switch (v.length) {
				case 12:
					return v.substr(0, 4) + ' ' + v.substr(4, 4) + ' ' + v.substr(8, 4);
				default:
					return nam;
			}
		};
	});

	widget.filter('tel', function () {
		return function (tel) {
			if (!tel) {
				return '';
			}

			var value = tel.toString().trim().replace(/^\+/, '');

			if (value.match(/[^0-9]/)) {
				return tel;
			}

			var country, city, number;

			switch (value.length) {
				case 10: // +1PPP####### -> C (PPP) ###-####
					country = 1;
					city = value.slice(0, 3);
					number = value.slice(3);
					break;

				case 11: // +CPPP####### -> CCC (PP) ###-####
					country = value[0];
					city = value.slice(1, 4);
					number = value.slice(4);
					break;

				case 12: // +CCCPP####### -> CCC (PP) ###-####
					country = value.slice(0, 3);
					city = value.slice(3, 5);
					number = value.slice(5);
					break;

				default:
					return tel;
			}

			if (country == 1) {
				country = "";
			}

			number = number.slice(0, 3) + '-' + number.slice(3);

			return (country + " (" + city + ") " + number).trim();
		};
	});

	widget.directive('telephone10validator', function($filter, model) {
		return {
		  require: 'ngModel',
		  link: function(scope, elm, attrs, ctrl) {

			var validators = {
				tel: function(modelValue, viewValue){
					//Valide seulement les contacts telephone
					if(scope.isNotPhone)return true;

					if(modelValue){
						var val = modelValue+"";
						val = val.replaceAll("(", "");
						val = val.replaceAll(")", "");
						val = val.replaceAll(" ", "");
						val = val.replaceAll("-", "");
						if(modelValue != val){
							ctrl.$setViewValue(val);
							ctrl.$render();
							// ctrl.$validate();
						}

						var isValid = !(modelValue.match(/[^0-9]/) || !(modelValue.length === 10));
						return isValid;
					}
					return true;
				},
			};
			ctrl.$validators.tel = validators.tel;

		  }
		};
	});


	widget.filter('showNoteTitle', ['$filter', 'model', 'Markdown', function ($filter, model, Markdown) {
		return function (item) {
//			var s = item.note ? item.note.trim() : "";
//			if (s.length>0 && s.charAt(0)==='≖') {
//				s = Markdown.toHTML(s.substring(1));//del markdown marker
//				s = s.substring(3,3)==='<p>' ? s.substring(3, m.length-5) : s;// del <p>  et </p> car ça fait sauter une ligne
//			}
			var prof = model.store.profs.get(item.idProfessionnalAnchor);
//			if (item.entryDateS) s += '\n' + '—'.repeat(10) + '\n' + $filter('translate')('ADDED_ON') + ' ' + item.entryDateS + (prof ? " " + $filter('translate')('By').toLowerCase() + " " + prof.lastName + " " + prof.firstName : "");
			if (item.entryDateS) var s = $filter('translate')('ADDED_ON') + ' ' + item.entryDateS + (prof ? " " + $filter('translate')('By').toLowerCase() + " " + prof.lastName + " " + prof.firstName : "");
			return s;
		}
	}]);

	widget.filter('showSuiviPrevTitle', ['$filter', 'model', function ($filter, model) {
		return function (item) {
			var prof = model.store.profs.get(item.idProfessionnal);
			// var dateStr = '';// il faudrait la date provenant du modification_entry... on ne l'a pas ici et ça risque de ralentir+++ la requête. Pas vraiment important, non?
			// item.doneDate==undefined ? '' : $filter('translate')('ADDED_ON') + ' ' + OfysUtils.daysFrom1970ToStr(item.doneDate) + ' ';
			var  addedBy = $filter('translate')('added_by');
			return prof ? addedBy.substring(0,1).toUpperCase() + addedBy.substring(1).toLowerCase() + " " + prof.lastName + " " + prof.firstName : "";
		}
	}]);
	widget.filter('showAllergyTitle', ['$filter', 'model', function ($filter, model) {
		return function (item) {
			var s = $filter('showAllergy')(item);
			var prof = model.store.profs.get(item.idProfessionnalAnchor);
			if (item.entryDateSD) s += '\n' + '—'.repeat(10) + '\n' + $filter('translate')('ADDED_ON') + ' ' + item.entryDateSD + (prof ? " " + $filter('translate')('By').toLowerCase() + " " + prof.lastName + " " + prof.firstName : "");
			return s;
		}
	}]);
	widget.filter('showAllergy', function () {
		return function (item) {
			var arr = []
			if (OfysUtils.isNotEmpty(item.drugrefDesc)) arr.push(item.drugrefDesc.trim());
			if (OfysUtils.isNotEmpty(item.note)) arr.push(item.note.trim());
			var s = arr.join(', ');
			item.descr = item.descr ? item.descr : [];
			item.descr[1] = s;
			return s;
		}
	});

	widget.filter('showRxTitle', ['$filter', 'model', function ($filter, model) {
		return function (item) {
			try{
				if (item && item != null) {
					var s = (item.dsqStatusStr ? item.dsqStatusStr : '') + $filter('showRx')(item) +
						'\n' + $filter('showSigRx')(item) + '\n' + $filter('translate')('Start') + ": " + item.startDateSD  +
						(item.expiredDateSD ? '\n' + $filter('translate')('End') + ": " + item.expiredDateSD : "");
					if (item.allergy && item.allergy * 1 > 0) {
						s += '\n' + item.allergyString;
					}
					if (item.stopReason) {
						s += '\n' + $filter('translate')('MedStop_Reason') + ": " + item.stopReason;
					}
					var prof = item.idProfessionnalAnchor ? model.store.profs.get(item.idProfessionnalAnchor) : undefined;
					if (item.entryDateSD){
						s += '\n' + '—'.repeat(10) + '\n' + $filter('translate')('ADDED_MODIFIED_ON') +
							item.entryDateSD + (prof ? " " + $filter('translate')('By').toLowerCase() +
							" " + prof.lastName + " " + prof.firstName : "");
					}
					return s;
				}
			}catch(e){
				console.log(e);
			}
			return '';
		}
	}]);

	widget.filter('showWithAddedLang',[ 'DashAPI', function (DashAPI) {
		return function (item, prop) {
			try{
				if (item && item != null) {
					var n = DashAPI.lang;
					s = item[prop + n.substring(0,1).toUpperCase() + n.substring(1).toLowerCase()];
					return s;
				}
			}catch(e){
				console.log(e);
			}
			return '';
		}
	}]);

	widget.filter('showSumSuiviPrevPat',[ 'DashAPI', function (DashAPI) {
		return function (item) {
			try{
				if (item && item != null) {
					var n = DashAPI.lang;
					s = item['titre' + n.substring(0,1).toUpperCase() + n.substring(1).toLowerCase()];
					return s;
				}
			}catch(e){
				console.log(e);
			}
			return '';
		}
	}]);

	widget.filter('showFavRxTitle', ['$filter', function ($filter) {
		return function (item) {
			try{
				if (item && item != null) {
					var s = (item.dsqStatusStr ? item.dsqStatusStr : '') + $filter('showRx')(item) +
						'\n' + $filter('showSigRx')(item);
					if (item.allergy && item.allergy * 1 > 0) {
						s += '\n' + item.allergyString;
					}
					return s;
				}
			}catch(e){
				console.log(e);
			}
			return '';
		}
	}]);

	widget.filter('showRx', ['$filter', 'model', function ($filter, model) {
		return function (item) {
			if (item && item != null) {
				if (item.baseDrugType == 3) { // fourniture
					var qty = (OfysUtils.isEmpty(item.quantity) ? "" : " # " + item.quantity);
					var dur = (OfysUtils.isEmpty(item.treatmentDuration) ? "" : " x " + item.treatmentDuration + " " + $filter('translate')('JRS'));
					var name = item.name + " " + qty + dur;
					item.descr = item.descr ? item.descr : [];
					item.descr[1] = name;
					return name;
				} else {
					var format = model.user().sessionUser.user.userPreferences.drugNameFormatSummary;
					var commercialName = item.name || (item.strength ? item.strength.name : "");
					var vGenericName = item.baseDrugName || (item.strength ? item.strength.baseName : "");
					var genericName = vGenericName ? MyNamespace.helpers.abbreviate(vGenericName, 60) : "";
					var nodata = "?";
					var name = "";
					switch (format) {
						case 'COMMERCIAL':
							name += OfysUtils.isNotEmpty(commercialName) ? commercialName : genericName;
							break;
						case 'GENERIC':
							name += OfysUtils.isNotEmpty(genericName) ? genericName : commercialName;
							break;
						case 'COMMERCIAL_AND_GENERIC':
							if (OfysUtils.isNotEmpty(commercialName)) {
								name += commercialName;
							}
							if (OfysUtils.isNotEmpty(genericName) && !genericName.equalsIgnoreCase(commercialName)) {
								name += " (" + genericName + ") ";
							}
							break;
						case 'GENERIC_AND_COMMERCIAL':
							if (OfysUtils.isNotEmpty(genericName)) {
								name += genericName;
							}
							if (OfysUtils.isNotEmpty(commercialName) && !commercialName.equalsIgnoreCase(genericName)) {
								name += " (" + commercialName + ") ";
							}
							break;
					}
					if (OfysUtils.isEmpty(name)) {
						name += nodata;
					} else {
						var strength = MyNamespace.helpers.abbreviate(OfysUtils.isEmpty(item.strength) ? "" : (item.strength.strength ? item.strength.strength : item.strength), 20);
						var qty = (OfysUtils.isEmpty(item.quantity) ? "" : " # " + item.quantity);
						var dur = (OfysUtils.isEmpty(item.treatmentDuration) ? "" : " x " + item.treatmentDuration + " " + $filter('translate')('JRS'));
						// parfois la force se trouve dans le nom - il ne faut donc pas l'additionner une 2e fois!
						if (OfysUtils.isNotEmpty(name)) {
							if (name.toUpperCase().indexOf(strength.toUpperCase()) === -1) {
								name += " " + strength;
							}
						} else {
							name += strength;
						}
						name += " " + qty + dur;
					}
					item.descr = item.descr ? item.descr : [];
					item.descr[1] = name;
					return name;
				}
			}
			return '';
		}
	}]);

	widget.filter('showFavRx', ['$filter', 'model', function ($filter, model) {
		return function (item) {
			if (item && item != null) {
				if (item.baseDrugType == 3) { // fourniture
					var qty = (OfysUtils.isEmpty(item.quantity) ? "" : " # " + item.quantity);
					var dur = (OfysUtils.isEmpty(item.treatmentDuration) ? "" : " x " + item.treatmentDuration + " " + $filter('translate')('JRS'));
					var name = item.name + " " + qty + dur;
					item.descr = item.descr ? item.descr : [];
					item.descr[1] = name;
					return name;
				} else {
					var format = model.user().sessionUser.user.userPreferences.drugNameFormatSummary;
					var vCommercialName = item.name || (item.strength ? item.strength.name : "");
					var commercialName = vCommercialName ? MyNamespace.helpers.abbreviate(vCommercialName, 32) : "";
					var vGenericName = item.baseDrugName || (item.strength ? item.strength.baseName : "");
					var genericName = vGenericName ? MyNamespace.helpers.abbreviate(vGenericName, 32) : "";
					var nodata = "?";
					var name = "";
					switch (format) {
						case 'COMMERCIAL':
							name += OfysUtils.isNotEmpty(commercialName) ? commercialName : genericName;
							break;
						case 'GENERIC':
							name += OfysUtils.isNotEmpty(genericName) ? genericName : commercialName;
							break;
						case 'COMMERCIAL_AND_GENERIC':
							if (OfysUtils.isNotEmpty(commercialName)) {
								name += commercialName;
							}
							if (OfysUtils.isNotEmpty(genericName) && !genericName.equalsIgnoreCase(commercialName)) {
								name += " (" + genericName + ") ";
							}
							name = MyNamespace.helpers.abbreviate(name, 32);
							break;
						case 'GENERIC_AND_COMMERCIAL':
							if (OfysUtils.isNotEmpty(genericName)) {
								name += genericName;
							}
							if (OfysUtils.isNotEmpty(commercialName) && !commercialName.equalsIgnoreCase(genericName)) {
								name += " (" + commercialName + ") ";
							}
							name = MyNamespace.helpers.abbreviate(name, 32);
							break;
					}
					if (OfysUtils.isEmpty(name)) {
						name += nodata;
					} else {
						var qty = (OfysUtils.isEmpty(item.quantity) ? "" : " # " + item.quantity);
						var dur = (OfysUtils.isEmpty(item.treatmentDuration) ? "" : " x " + item.treatmentDuration + " " + $filter('translate')('JRS'));
						// parfois la force se trouve dans le nom - il ne faut donc pas l'additionner une 2e fois!
						name += " " + qty + dur;
					}
					item.descr = item.descr ? item.descr : [];
					item.descr[1] = name;
					return name;
				}
			}
			return '';
		}
	}]);

	widget.filter('showRxForHx', ['$filter', 'model', function ($filter) {
		return function (item) {
			var str = OfysUtils.isEmpty(item.strength) ? "" : (item.strength.strength ? item.strength.strength : item.strength) + " ";
			var qty = (OfysUtils.isEmpty(item.quantity) ? "" : " # " + item.quantity + " ");
			var dur = (OfysUtils.isEmpty(item.treatmentDuration) ? "" : " x " + item.treatmentDuration + " " + $filter('translate')('JRS') + " ");
			return str + qty + dur;
		}
	}]);

	widget.filter('showSigFavRx', ['$filter', function ($filter) {
		return function (item) {
			if (item && item != null) {
				var poso = item.posology ? item.posology + " " : "";
				var freq = item.frequency ? item.frequency + " " : "";
				//var route = item.routeString ? item.routeString + " " : "";
				var format = item.baseDrugType!==3 && item.formatString ? item.formatString : "";
				var format1 = format.length>0 ? format + ' ' : '';
				var format2 =  $filter('maxchar')(format, 10) + ' ';
				var strength = item.strength ? item.strength + ", " : "";
				//var rx = item.rx ? "Ren x " + item.rx : "";
				var ss = strength + poso + format2 + freq;
				
				var strength2 = item.strength ? "(" + item.rstrength + ") " : "";
				var s = 'sig : ' + strength2 + poso + format1 + freq; // + rx;
				item.descr = item.descr ? item.descr : [];
				item.descr[2] = s;
				return ss;
			}
			return '';
		}
	}]);
	
	widget.filter('showSigRx', function () {
		return function (item) {
			if (item && item != null) {
				var poso = item.posology ? item.posology + " " : "";
				// var format = item.baseDrugType!==3 && item.formatString ? item.formatString + " " : "";
				var freq = item.frequency ? item.frequency + " " : "";
				var route = item.routeString ? item.routeString + " " : "";
				//var rx = item.rx ? "Ren x " + item.rx : "";
				var s = 'sig : ' + poso + route + freq; // + rx;
				item.descr = item.descr ? item.descr : [];
				item.descr[2] = s;
				return s;
			}
			return '';
		}
	});
	// reçoit un objet DispenseDetails
	widget.filter('show1LineDispDetails', function () {
		return function (item) {
			if (item && item != null) {
				var poso = item.posology ? item.posology + " " : "";
				var format = item.baseDrugType!==3 && item.formatString ? item.formatString + " " : "";
				var freq = item.frequency ? item.frequency + " " : "";
				var route = item.routeString ? item.routeString + " " : "";
				//var rx = item.rx ? "Ren x " + item.rx : "";
				var s = 'sig : ' + poso + route + freq; // + rx;
				item.descr = item.descr ? item.descr : [];
				item.descr[2] = s;
				return s;
			}
			return '';
		}
	});
	widget.filter('showSigFavRen', function () {
		return function (item) {
			if (item && item != null) {
				var s = item.rx ? 'R x ' + item.rx : "NR";
				item.descr = item.descr ? item.descr : [];
				item.descr[3] = s;
				return s;
			}
			return '';
		}
	});
	
	widget.filter('showSigRen', ['$filter', function ($filter) {
		return function (item) {
			if (item && item != null) {
				var s = item.rx ? $filter('translate')('RenX_') + item.rx : "NR";
				item.descr = item.descr ? item.descr : [];
				item.descr[3] = s;
				return s;
			}
			return '';
		}
	}]);

	widget.filter('showDxTitle', ['$filter', 'model', function ($filter, model) {
		return function (item) {
			var s = "";
			if (OfysUtils.isNotEmpty(item.descrLong)) {
				s = s.append(item.descrLong);
			}
			if (OfysUtils.isNotEmpty(item.note)) {
				s = s.append(s.length > 0 ? " - " : "").append(item.note.trim());
			}
			if (item.sinceDateSP) s += "\n" + $filter('translate')('DECLARED_ON') + " " + item.sinceDateSP;
			var prof = model.store.profs.get(item.idProfessionnalAnchor);
			if (item.entryDateSD) s += '\n' + '—'.repeat(10) + '\n' + $filter('translate')('ADDED_ON') + ' ' + item.entryDateSD + (prof ? " " + $filter('translate')('By').toLowerCase() + " " + prof.lastName + " " + prof.firstName : "");
			return s;
		}
	}]);
	widget.filter('showDx', function () {
		return function (item) {
			var s = "";
			if (OfysUtils.isNotEmpty(item.descrShort)) {
				s = s.append(item.descrShort);
			}
			if (OfysUtils.isNotEmpty(item.note)) {
				var notes = item.note.replaceAll(/^[ \t]*\r?\n/, '');
				s = s.append(s.length > 0 ? " - " : "").append(notes);
			}
			item.descr = item.descr ? item.descr : [];
			item.descr[1] = s;
			return s;
		}
	});

	widget.filter('showCxTitle', ['$filter', 'model', function ($filter, model) {
		return function (item) {
			var s = "";
			s += OfysUtils.isNotEmpty(item.descrLong) ? item.descrLong + (OfysUtils.isEmpty(item.note) ? "" :
				" - ") : "";
			s = (OfysUtils.isNotEmpty(s) ? s : "") + (OfysUtils.isEmpty(item.note) ? "" : item.note.trim());
			if (item.declaredDateSP) {
				s += $filter('translate')('DECLARED_ON') + " " + item.declaredDateSP;
			}
			var prof = model.store.profs.get(item.idProfessionnalAnchor);
			if (item.entryDateSD) s += '\n' + '—'.repeat(10) + '\n' + $filter('translate')('ADDED_ON') + ' ' + item.entryDateSD + (prof ? " " + $filter('translate')('By').toLowerCase() + " " + prof.lastName + " " + prof.firstName : "");
			return s;
		}
	}]);
	widget.filter('showCx', function () {
		return function (item) {
			var s = "";
			var s = "";
			var arr = []
			var note;
			if (OfysUtils.isNotEmpty(item.note)) {
				var notes = item.note.replaceAll(/^[ \t]*\r?\n/, '').split('\n');
				for (n = 0; n < notes.length; n++) arr.push(notes[n]);
				note = arr.join(', ');
			}
			s += OfysUtils.isNotEmpty(item.descrShort) ? item.descrShort + (note===undefined ? "" : " - ") : "";
			s = (OfysUtils.isNotEmpty(s) ? s : "") + (note===undefined ? "" : note);
			item.descr = item.descr ? item.descr : [];
			item.descr[1] = s;
			return s;
		}
	});

	widget.filter('showHabTitle', ['EncounterAccessor', '$filter', 'model',
		function (EncounterAccessor, $filter, model) {
		return function (item) {
			var rep = "";
			var hab = EncounterAccessor.habitTypes[item.typeHabit];
			if (hab) {
				var freq = EncounterAccessor.frequencyOptions[item.typeHabit][item.frequency];
				var note = item.note ? item.note.trim() : undefined;
				var start = item.startDateSP ? item.startDateSP : "?";
				var end = item.endDateSP ? item.endDateSP : "?";
				rep = hab + ": " + (freq ? freq : "") + (item.startDateSP || item.endDateSP ?
					" [" + start + "-" + end + "]" : "" + (note ? '\n' + note : "") );
			}
			var prof = model.store.profs.get(item.idProfessionnalAnchor);
			if (item.entryDateSD) rep += '\n' + '—'.repeat(10) + '\n' + $filter('translate')('ADDED_ON') + ' ' + item.entryDateSD + (prof ? " " + $filter('translate')('By').toLowerCase() + " " + prof.lastName + " " + prof.firstName : "");
			item.descr = item.descr ? item.descr : [];
			item.descr[1] = rep;
			return rep;
		}
	}]);

	widget.filter('showHab', ['EncounterAccessor', '$filter', function (EncounterAccessor, $filter) {
		return function (item) {
			var rep = "";
			var hab = EncounterAccessor.habitTypes[item.typeHabit];
			if (hab) {
				var freq = EncounterAccessor.frequencyOptions[item.typeHabit][item.frequency];
				var note = item.note ? $filter('noteTextToHtmlSum')(item.note.trim()) : undefined;
				var start = item.startDateSP ? item.startDateSP : "";
				var end = item.endDateSP ? item.endDateSP : "";
				rep = hab + ": " + (freq ? freq : "") + (note ? note : "");
			}
			return rep;
		}
	}]);

	widget.filter('showImmTitle', ['$filter', 'model', function ($filter, model) {
		return function (item) {
			var s = "";
			if (item.vaccinationDateSP) s += "[" + item.vaccinationDateSP + "] ";
			var arr = []
			if (OfysUtils.isNotEmpty(item.descrLong)) arr.push(item.descrLong.trim());
			if (OfysUtils.isNotEmpty(item.vaccineName)) arr.push(item.vaccineName.trim());
			if (OfysUtils.isNotEmpty(item.note)) arr.push(item.note.trim());
			s += arr.join(', ');
			var prof = model.store.profs.get(item.idProfessionnalAnchor);
			if (item.entryDateSD) s += '\n' + '—'.repeat(10) + '\n' + $filter('translate')('ADDED_ON') + ' ' + item.entryDateSD + (prof ? " " + $filter('translate')('By').toLowerCase() + " " + prof.lastName + " " + prof.firstName : "");
			return s;
		}
	}]);


	widget.filter('showImm', ['$filter', function ($filter) {
		return function (item) {
			var s = "";
			//if (item.vaccinationDateSP) s += "[" + item.vaccinationDateSP + "] ";
			var arr = []
			if (OfysUtils.isNotEmpty(item.descrShort)) arr.push(item.descrShort.trim());
			if (OfysUtils.isNotEmpty(item.vaccineName)) {
				var note = item.vaccineName.replaceAll(/^[ \t]*\r?\n/, '').split('\n');
				for (n = 0; n < note.length; n++) arr.push(note[n]);
			}
			if (OfysUtils.isNotEmpty(item.note)) {
				var note = item.note.replaceAll(/^[ \t]*\r?\n/, '').split('\n');
				for (n = 0; n < note.length; n++) arr.push(note[n]);
			}
			s += arr.join(', ');
			item.descr = item.descr ? item.descr : [];
			item.descr[0] = item.vaccinationDateSP ? item.vaccinationDateSP : "";
			item.descr[1] = s;
			item.descr[2] = this.refused ? $filter('translate')('VACCIN_REFUSED') : "";
			return s;
		}
	}]);

	widget.filter('showRappelTitle', ['$filter', 'model', function ($filter, model) {
		return function (item) {
			var s = item.note ? item.note.trim() : "";
			var prof = model.store.profs.get(item.idProfessionnalAnchor);
			if (item.entryDateSD){
				s += '\n' + '—'.repeat(10) + '\n' + $filter('translate')('ADDED_ON') + ' ' +
				item.entryDateSD + (prof ? " " + $filter('translate')('By').toLowerCase() + " " +
				prof.lastName + " " + prof.firstName : "");
			}
			item.descr = item.descr ? item.descr : [];
			item.descr[1] = s;
			return s;
		}
	}]);

	widget.filter('showBloodPressure', function () {
		return function (item) {
			if (item) {
				var bp = [];
				if (OfysUtils.isNotEmpty(item.systolic)) bp.push(item.systolic);
				if (OfysUtils.isNotEmpty(item.diastolic)) bp.push(item.diastolic);
				return bp.join("/");
			}
			return '';
		}
	});

	widget.filter('showrc', function () {
		return function (item) {
			var ret = '';
			if (item && item != null) {
				var s = (item.encounterType!=36 && item.encounterType!=37 ? item.encounterTypeS : '');
				if (item.lstRaison && item.lstRaison.length>0) {
					var arr = [];
					if (s.length>0) arr.push(s);
					for(var j=0; j<item.lstRaison.length; j++) {
						arr.push(item.lstRaison[j].descr);
					}
					ret = arr.join(', ');
				} else {
					ret = s;
				}
			}
			return ret;
		}
	});

	// pour afficher la raison de consultation dans patientData_enc
	widget.filter('showrcof', ['$filter', function ($filter) {
		return function (item) {
			var s = (item.encounterType!=36 && item.encounterType!=37 ? item.encounterTypeS : '');
			if (item.lstRaison) {
				var r = "",
					i = 0,
					c = item.lstRaison.length,
					arr = [];
				if (s.length>0) arr.push(s);
				for (; i < c; i++) {
					if (item.lstRaison[i].reason) {
						arr.push(item.lstRaison[i].reason);
					} else if (item.lstRaison[i].visitReason) {
						arr.push(item.lstRaison[i].visitReason.descriptionShort);
					}
				}
				return arr.join(', ');
			} else {
//				return $filter('encEnum')(item.encounterType, 'encounterType');
				return s;
			}
		}
	}]);

	widget.filter('dec0', function () {
		return function (value) {
			var decimals = 0;
			return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(decimals);
		};
	});
	widget.filter('dec1', function () {
		return function (value) {
			var decimals = 1;
			return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(decimals);
		};
	});
	widget.filter('dec2', function () {
		return function (value) {
			var decimals = 2;
			return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(decimals);
		};
	});

})();

/**
 * @license Angular UI Tree v2.22.5
 * (c) 2010-2017. https://github.com/angular-ui-tree/angular-ui-tree
 * License: MIT
 */
! function () {
	"use strict";
	angular.module("ui.tree", []).constant("treeConfig", {
		treeClass: "angular-ui-tree",
		emptyTreeClass: "angular-ui-tree-empty",
		dropzoneClass: "angular-ui-tree-dropzone",
		hiddenClass: "angular-ui-tree-hidden",
		nodesClass: "angular-ui-tree-nodes",
		nodeClass: "angular-ui-tree-node",
		handleClass: "angular-ui-tree-handle",
		placeholderClass: "angular-ui-tree-placeholder",
		dragClass: "angular-ui-tree-drag",
		dragThreshold: 3,
		defaultCollapsed: !1,
		appendChildOnHover: !0
	})
}(),
function () {
	"use strict";
	angular.module("ui.tree").controller("TreeHandleController", ["$scope", "$element", function (e, n) {
		this.scope = e, e.$element = n, e.$nodeScope = null, e.$type = "uiTreeHandle"
	}])
}(),
function () {
	"use strict";
	angular.module("ui.tree").controller("TreeNodeController", ["$scope", "$element", function (e, n) {
		function t(e) {
			if (!e) return 0;
			var n, o, l, r = 0,
				a = e.childNodes();
			if (!a || 0 === a.length) return 0;
			for (l = a.length - 1; l >= 0; l--) n = a[l], o = 1 + t(n), r = Math.max(r, o);
			return r
		}
		this.scope = e, e.$element = n, e.$modelValue = null, e.$parentNodeScope = null, e.$childNodesScope = null, e.$parentNodesScope = null, e.$treeScope = null, e.$handleScope = null, e.$type = "uiTreeNode", e.$$allowNodeDrop = !1, e.collapsed = !1, e.expandOnHover = !1, e.init = function (t) {
			var o = t[0];
			e.$treeScope = t[1] ? t[1].scope : null, e.$parentNodeScope = o.scope.$nodeScope, e.$modelValue = o.scope.$modelValue[e.$index], e.$parentNodesScope = o.scope, o.scope.initSubNode(e), n.on("$destroy", function () {
				o.scope.destroySubNode(e)
			})
		}, e.index = function () {
			return e.$parentNodesScope.$modelValue.indexOf(e.$modelValue)
		}, e.dragEnabled = function () {
			return !(e.$treeScope && !e.$treeScope.dragEnabled)
		}, e.isSibling = function (n) {
			return e.$parentNodesScope == n.$parentNodesScope
		}, e.isChild = function (n) {
			var t = e.childNodes();
			return t && t.indexOf(n) > -1
		}, e.prev = function () {
			var n = e.index();
			return n > 0 ? e.siblings()[n - 1] : null
		}, e.siblings = function () {
			return e.$parentNodesScope.childNodes()
		}, e.childNodesCount = function () {
			return e.childNodes() ? e.childNodes().length : 0
		}, e.hasChild = function () {
			return e.childNodesCount() > 0
		}, e.childNodes = function () {
			return e.$childNodesScope && e.$childNodesScope.$modelValue ? e.$childNodesScope.childNodes() : null
		}, e.accept = function (n, t) {
			return e.$childNodesScope && e.$childNodesScope.$modelValue && e.$childNodesScope.accept(n, t)
		}, e.remove = function () {
			return e.$parentNodesScope.removeNode(e)
		}, e.toggle = function () {
			e.collapsed = !e.collapsed, e.$treeScope.$callbacks.toggle(e.collapsed, e)
		}, e.collapse = function () {
			e.collapsed = !0
		}, e.expand = function () {
			e.collapsed = !1
		}, e.depth = function () {
			var n = e.$parentNodeScope;
			return n ? n.depth() + 1 : 1
		}, e.maxSubDepth = function () {
			return e.$childNodesScope ? t(e.$childNodesScope) : 0
		}
	}])
}(),
function () {
	"use strict";
	angular.module("ui.tree").controller("TreeNodesController", ["$scope", "$element", function (e, n) {
		this.scope = e, e.$element = n, e.$modelValue = null, e.$nodeScope = null, e.$treeScope = null, e.$type = "uiTreeNodes", e.$nodesMap = {}, e.nodropEnabled = !1, e.maxDepth = 0, e.cloneEnabled = !1, e.initSubNode = function (n) {
			return n.$modelValue ? void(e.$nodesMap[n.$modelValue.$$hashKey] = n) : null
		}, e.destroySubNode = function (n) {
			return n.$modelValue ? void(e.$nodesMap[n.$modelValue.$$hashKey] = null) : null
		}, e.accept = function (n, t) {
			return e.$treeScope.$callbacks.accept(n, e, t)
		}, e.beforeDrag = function (n) {
			return e.$treeScope.$callbacks.beforeDrag(n)
		}, e.isParent = function (n) {
			return n.$parentNodesScope == e
		}, e.hasChild = function () {
			return e.$modelValue.length > 0
		}, e.safeApply = function (e) {
			var n = this.$root.$$phase;
			"$apply" == n || "$digest" == n ? e && "function" == typeof e && e() : this.$apply(e)
		}, e.removeNode = function (n) {
			var t = e.$modelValue.indexOf(n.$modelValue);
			return t > -1 ? (e.safeApply(function () {
				e.$modelValue.splice(t, 1)[0]
			}), e.$treeScope.$callbacks.removed(n)) : null
		}, e.insertNode = function (n, t) {
			e.safeApply(function () {
				e.$modelValue.splice(n, 0, t)
			})
		}, e.childNodes = function () {
			var n, t = [];
			if (e.$modelValue)
				for (n = 0; n < e.$modelValue.length; n++) t.push(e.$nodesMap[e.$modelValue[n].$$hashKey]);
			return t
		}, e.depth = function () {
			return e.$nodeScope ? e.$nodeScope.depth() : 0
		}, e.outOfDepth = function (n) {
			var t = e.maxDepth || e.$treeScope.maxDepth;
			return t > 0 && e.depth() + n.maxSubDepth() + 1 > t
		}
	}])
}(),
function () {
	"use strict";
	angular.module("ui.tree").controller("TreeController", ["$scope", "$element", function (e, n) {
		this.scope = e, e.$element = n, e.$nodesScope = null, e.$type = "uiTree", e.$emptyElm = null, e.$dropzoneElm = null, e.$callbacks = null, e.dragEnabled = !0, e.emptyPlaceholderEnabled = !0, e.maxDepth = 0, e.dragDelay = 0, e.cloneEnabled = !1, e.nodropEnabled = !1, e.dropzoneEnabled = !1, e.isEmpty = function () {
			return e.$nodesScope && e.$nodesScope.$modelValue && 0 === e.$nodesScope.$modelValue.length
		}, e.place = function (n) {
			e.$nodesScope.$element.append(n), e.$emptyElm.remove()
		}, this.resetEmptyElement = function () {
			e.$nodesScope.$modelValue && 0 !== e.$nodesScope.$modelValue.length || !e.emptyPlaceholderEnabled ? e.$emptyElm.remove() : n.append(e.$emptyElm)
		}, this.resetDropzoneElement = function () {
			e.$nodesScope.$modelValue && 0 === e.$nodesScope.$modelValue.length || !e.dropzoneEnabled ? e.$dropzoneElm.remove() : n.append(e.$dropzoneElm)
		}, e.resetEmptyElement = this.resetEmptyElement, e.resetDropzoneElement = this.resetDropzoneElement
	}])
}(),
function () {
	"use strict";
	angular.module("ui.tree").directive("uiTree", ["treeConfig", "$window", function (e, n) {
		return {
			restrict: "A",
			scope: !0,
			controller: "TreeController",
			link: function (t, o, l, r) {
				var a, d, i, c = {
						accept: null,
						beforeDrag: null
					},
					s = {};
				angular.extend(s, e), s.treeClass && o.addClass(s.treeClass), "table" === o.prop("tagName").toLowerCase() ? (t.$emptyElm = angular.element(n.document.createElement("tr")), d = o.find("tr"), i = d.length > 0 ? angular.element(d).children().length : 1e6, a = angular.element(n.document.createElement("td")).attr("colspan", i), t.$emptyElm.append(a)) : (t.$emptyElm = angular.element(n.document.createElement("div")), t.$dropzoneElm = angular.element(n.document.createElement("div"))), s.emptyTreeClass && t.$emptyElm.addClass(s.emptyTreeClass), s.dropzoneClass && t.$dropzoneElm.addClass(s.dropzoneClass), t.$watch("$nodesScope.$modelValue.length", function (e) {
					angular.isNumber(e) && (r.resetEmptyElement(), r.resetDropzoneElement())
				}, !0), t.$watch(l.dragEnabled, function (e) {
					"boolean" == typeof e && (t.dragEnabled = e)
				}), t.$watch(l.emptyPlaceholderEnabled, function (e) {
					"boolean" == typeof e && (t.emptyPlaceholderEnabled = e, r.resetEmptyElement())
				}), t.$watch(l.nodropEnabled, function (e) {
					"boolean" == typeof e && (t.nodropEnabled = e)
				}), t.$watch(l.dropzoneEnabled, function (e) {
					"boolean" == typeof e && (t.dropzoneEnabled = e, r.resetDropzoneElement())
				}), t.$watch(l.cloneEnabled, function (e) {
					"boolean" == typeof e && (t.cloneEnabled = e)
				}), t.$watch(l.maxDepth, function (e) {
					"number" == typeof e && (t.maxDepth = e)
				}), t.$watch(l.dragDelay, function (e) {
					"number" == typeof e && (t.dragDelay = e)
				}), c.accept = function (e, n, t) {
					return !(n.nodropEnabled || n.$treeScope.nodropEnabled || n.outOfDepth(e))
				}, c.beforeDrag = function (e) {
					return !0
				}, c.expandTimeoutStart = function () {}, c.expandTimeoutCancel = function () {}, c.expandTimeoutEnd = function () {}, c.removed = function (e) {}, c.dropped = function (e) {}, c.dragStart = function (e) {}, c.dragMove = function (e) {}, c.dragStop = function (e) {}, c.beforeDrop = function (e) {}, c.toggle = function (e, n) {}, t.$watch(l.uiTree, function (e, n) {
					angular.forEach(e, function (e, n) {
						c[n] && "function" == typeof e && (c[n] = e)
					}), t.$callbacks = c
				}, !0)
			}
		}
	}])
}(),
function () {
	"use strict";
	angular.module("ui.tree").directive("uiTreeHandle", ["treeConfig", function (e) {
		return {
			require: "^uiTreeNode",
			restrict: "A",
			scope: !0,
			controller: "TreeHandleController",
			link: function (n, t, o, l) {
				var r = {};
				angular.extend(r, e), r.handleClass && t.addClass(r.handleClass), n != l.scope && (n.$nodeScope = l.scope, l.scope.$handleScope = n)
			}
		}
	}])
}(),
function () {
	"use strict";
	angular.module("ui.tree").directive("uiTreeNode", ["treeConfig", "UiTreeHelper", "$window", "$document", "$timeout", "$q", function (e, n, t, o, l, r) {
		return {
			require: ["^uiTreeNodes", "^uiTree"],
			restrict: "A",
			controller: "TreeNodeController",
			link: function (a, d, i, c) {
				var s, u, p, m, f, h, $, g, b, v, N, S, y, E, x, C, T, w, D, H, O, Y, A, X, V, k, z, M = {},
					I = "ontouchstart" in window,
					P = null,
					L = document.body,
					W = document.documentElement;
				angular.extend(M, e), M.nodeClass && d.addClass(M.nodeClass), a.init(c), a.collapsed = !!n.getNodeAttribute(a, "collapsed") || e.defaultCollapsed, a.expandOnHover = !!n.getNodeAttribute(a, "expandOnHover"), a.scrollContainer = n.getNodeAttribute(a, "scrollContainer") || i.scrollContainer || null, a.sourceOnly = a.nodropEnabled || a.$treeScope.nodropEnabled, a.$watch(i.collapsed, function (e) {
					"boolean" == typeof e && (a.collapsed = e)
				}), a.$watch("collapsed", function (e) {
					n.setNodeAttribute(a, "collapsed", e), i.$set("collapsed", e)
				}), a.$watch(i.expandOnHover, function (e) {
					"boolean" != typeof e && "number" != typeof e || (a.expandOnHover = e)
				}), a.$watch("expandOnHover", function (e) {
					n.setNodeAttribute(a, "expandOnHover", e), i.$set("expandOnHover", e)
				}), i.$observe("scrollContainer", function (e) {
					"string" == typeof e && (a.scrollContainer = e)
				}), a.$watch("scrollContainer", function (e) {
					n.setNodeAttribute(a, "scrollContainer", e), i.$set("scrollContainer", e), $ = document.querySelector(e)
				}), a.$on("angular-ui-tree:collapse-all", function () {
					a.collapsed = !0
				}), a.$on("angular-ui-tree:expand-all", function () {
					a.collapsed = !1
				}), S = function (e) {
					if ((I || 2 !== e.button && 3 !== e.which) && !(e.uiTreeDragging || e.originalEvent && e.originalEvent.uiTreeDragging)) {
						var l, r, i, c, $, g, S, y, E, x = angular.element(e.target);
						if (l = n.treeNodeHandlerContainerOfElement(x), l && (x = angular.element(l)), r = d.clone(), y = n.elementIsTreeNode(x), E = n.elementIsTreeNodeHandle(x), (y || E) && !(y && n.elementContainsTreeNodeHandler(x) || (i = x.prop("tagName").toLowerCase(), "input" == i || "textarea" == i || "button" == i || "select" == i))) {
							for (V = angular.element(e.target), k = V[0].attributes["ui-tree"]; V && V[0] && V[0] !== d && !k;) {
								if (V[0].attributes && (k = V[0].attributes["ui-tree"]), n.nodrag(V)) return;
								V = V.parent()
							}
							a.beforeDrag(a) && (e.uiTreeDragging = !0, e.originalEvent && (e.originalEvent.uiTreeDragging = !0), e.preventDefault(), $ = n.eventObj(e), s = !0, u = n.dragInfo(a), z = u.source.$treeScope.$id, c = d.prop("tagName"), "tr" === c.toLowerCase() ? (m = angular.element(t.document.createElement(c)), g = angular.element(t.document.createElement("td")).addClass(M.placeholderClass).attr("colspan", d[0].children.length), m.append(g)) : m = angular.element(t.document.createElement(c)).addClass(M.placeholderClass), f = angular.element(t.document.createElement(c)), M.hiddenClass && f.addClass(M.hiddenClass), p = n.positionStarted($, d), m.css("height", d.prop("offsetHeight") + "px"), h = angular.element(t.document.createElement(a.$parentNodesScope.$element.prop("tagName"))).addClass(a.$parentNodesScope.$element.attr("class")).addClass(M.dragClass), h.css("width", n.width(d) + "px"), h.css("z-index", 9999), S = (d[0].querySelector(".angular-ui-tree-handle") || d[0]).currentStyle, S && (document.body.setAttribute("ui-tree-cursor", o.find("body").css("cursor") || ""), o.find("body").css({
								cursor: S.cursor + "!important"
							})), a.sourceOnly && m.css("display", "none"), d.after(m), d.after(f), u.isClone() && a.sourceOnly ? h.append(r) : h.append(d), o.find("body").append(h), h.css({
								left: $.pageX - p.offsetX + "px",
								top: $.pageY - p.offsetY + "px"
							}), b = {
								placeholder: m,
								dragging: h
							}, O(), a.$apply(function () {
								a.$treeScope.$callbacks.dragStart(u.eventArgs(b, p))
							}), v = Math.max(L.scrollHeight, L.offsetHeight, W.clientHeight, W.scrollHeight, W.offsetHeight), N = Math.max(L.scrollWidth, L.offsetWidth, W.clientWidth, W.scrollWidth, W.offsetWidth))
						}
					}
				}, y = function (e) {
					var o, r, d, i, c, f, S, y, E, x, C, T, w, D, H, O, Y, A, V, k, I, L, W, q, F = n.eventObj(e);
					if (h) {
						if (e.preventDefault(), t.getSelection ? t.getSelection().removeAllRanges() : t.document.selection && t.document.selection.empty(), d = F.pageX - p.offsetX, i = F.pageY - p.offsetY, d < 0 && (d = 0), i < 0 && (i = 0), i + 10 > v && (i = v - 10), d + 10 > N && (d = N - 10), h.css({
								left: d + "px",
								top: i + "px"
							}), $ ? (S = $.getBoundingClientRect(), c = $.scrollTop, f = c + $.clientHeight, S.bottom < F.clientY && f < $.scrollHeight && (H = Math.min($.scrollHeight - f, 10), $.scrollTop += H), S.top > F.clientY && c > 0 && (O = Math.min(c, 10), $.scrollTop -= O)) : (c = window.pageYOffset || t.document.documentElement.scrollTop, f = c + (window.innerHeight || t.document.clientHeight || t.document.clientHeight), f < F.pageY && f < v && (H = Math.min(v - f, 10), window.scrollBy(0, H)), c > F.pageY && (O = Math.min(c, 10), window.scrollBy(0, -O))), n.positionMoved(e, p, s), s) return void(s = !1);
						if (E = F.pageX - (t.pageXOffset || t.document.body.scrollLeft || t.document.documentElement.scrollLeft) - (t.document.documentElement.clientLeft || 0), x = F.pageY - (t.pageYOffset || t.document.body.scrollTop || t.document.documentElement.scrollTop) - (t.document.documentElement.clientTop || 0), angular.isFunction(h.hide) ? h.hide() : (C = h[0].style.display, h[0].style.display = "none"), t.document.elementFromPoint(E, x), w = angular.element(t.document.elementFromPoint(E, x)), X = n.treeNodeHandlerContainerOfElement(w), X && (w = angular.element(X)), angular.isFunction(h.show) ? h.show() : h[0].style.display = C, n.elementIsTree(w) ? T = w.controller("uiTree").scope : n.elementIsTreeNodeHandle(w) ? T = w.controller("uiTreeHandle").scope : n.elementIsTreeNode(w) ? T = w.controller("uiTreeNode").scope : n.elementIsTreeNodes(w) ? T = w.controller("uiTreeNodes").scope : n.elementIsPlaceholder(w) ? T = w.controller("uiTreeNodes").scope : n.elementIsDropzone(w) ? (T = w.controller("uiTree").scope, q = !0) : w.controller("uiTreeNode") && (T = w.controller("uiTreeNode").scope), V = T && T.$treeScope && T.$treeScope.$id && T.$treeScope.$id === z, V && p.dirAx) p.distX > 0 && (o = u.prev(), o && !o.collapsed && o.accept(a, o.childNodesCount()) && (o.$childNodesScope.$element.append(m), u.moveTo(o.$childNodesScope, o.childNodes(), o.childNodesCount()))), p.distX < 0 && (r = u.next(), r || (y = u.parentNode(), y && y.$parentNodesScope.accept(a, y.index() + 1) && (y.$element.after(m), u.moveTo(y.$parentNodesScope, y.siblings(), y.index() + 1))));
						else {
							if (D = !1, !T) return;
							if (!T.$treeScope || T.$parent.nodropEnabled || T.$treeScope.nodropEnabled || m.css("display", ""), "uiTree" === T.$type && T.dragEnabled && (D = T.isEmpty()), "uiTreeHandle" === T.$type && (T = T.$nodeScope), "uiTreeNode" !== T.$type && !D && !q) return void(M.appendChildOnHover && (r = u.next(), !r && g && (y = u.parentNode(), y.$element.after(m), u.moveTo(y.$parentNodesScope, y.siblings(), y.index() + 1), g = !1)));
							P && m.parent()[0] != P.$element[0] && (P.resetEmptyElement(), P.resetDropzoneElement(), P = null), D ? (P = T, T.$nodesScope.accept(a, 0) && u.moveTo(T.$nodesScope, T.$nodesScope.childNodes(), 0)) : q ? (P = T, T.$nodesScope.accept(a, T.$nodesScope.childNodes().length) && u.moveTo(T.$nodesScope, T.$nodesScope.childNodes(), T.$nodesScope.childNodes().length)) : T.dragEnabled() && (angular.isDefined(a.expandTimeoutOn) && a.expandTimeoutOn !== T.id && (l.cancel(a.expandTimeout), delete a.expandTimeout, delete a.expandTimeoutOn, a.$callbacks.expandTimeoutCancel()), T.collapsed && (a.expandOnHover === !0 || angular.isNumber(a.expandOnHover) && 0 === a.expandOnHover ? (T.collapsed = !1, T.$treeScope.$callbacks.toggle(!1, T)) : a.expandOnHover !== !1 && angular.isNumber(a.expandOnHover) && a.expandOnHover > 0 && angular.isUndefined(a.expandTimeoutOn) && (a.expandTimeoutOn = T.$id, a.$callbacks.expandTimeoutStart(), a.expandTimeout = l(function () {
								a.$callbacks.expandTimeoutEnd(), T.collapsed = !1, T.$treeScope.$callbacks.toggle(!1, T)
							}, a.expandOnHover))), w = T.$element, Y = n.offset(w), I = n.height(w), L = T.$childNodesScope ? T.$childNodesScope.$element : null, W = L ? n.height(L) : 0, I -= W, k = M.appendChildOnHover ? .25 * I : n.height(w) / 2, A = F.pageY < Y.top + k, T.$parentNodesScope.accept(a, T.index()) ? A ? (w[0].parentNode.insertBefore(m[0], w[0]), u.moveTo(T.$parentNodesScope, T.siblings(), T.index())) : M.appendChildOnHover && T.accept(a, T.childNodesCount()) ? (T.$childNodesScope.$element.prepend(m), u.moveTo(T.$childNodesScope, T.childNodes(), 0), g = !0) : (w.after(m), u.moveTo(T.$parentNodesScope, T.siblings(), T.index() + 1)) : !A && T.accept(a, T.childNodesCount()) && (T.$childNodesScope.$element.append(m), u.moveTo(T.$childNodesScope, T.childNodes(), T.childNodesCount())))
						}
						a.$apply(function () {
							a.$treeScope.$callbacks.dragMove(u.eventArgs(b, p))
						})
					}
				}, E = function (e) {
					var n = u.eventArgs(b, p);
					e.preventDefault(), Y(), l.cancel(a.expandTimeout), a.$treeScope.$apply(function () {
						r.when(a.$treeScope.$callbacks.beforeDrop(n)).then(function (e) {
							e !== !1 && a.$$allowNodeDrop ? (u.apply(), a.$treeScope.$callbacks.dropped(n)) : H()
						}).catch(function () {
							H()
						}).finally(function () {
							f.replaceWith(a.$element), m.remove(), h && (h.remove(), h = null), a.$treeScope.$callbacks.dragStop(n), a.$$allowNodeDrop = !1, u = null;
							var e = document.body.getAttribute("ui-tree-cursor");
							null !== e && (o.find("body").css({
								cursor: e
							}), document.body.removeAttribute("ui-tree-cursor"))
						})
					})
				}, x = function (e) {
					a.dragEnabled() && S(e)
				}, C = function (e) {
					y(e)
				}, T = function (e) {
					a.$$allowNodeDrop = !0, E(e)
				}, w = function (e) {
					E(e)
				}, D = function () {
					var e;
					return {
						exec: function (n, t) {
							t || (t = 0), this.cancel(), e = l(n, t)
						},
						cancel: function () {
							l.cancel(e)
						}
					}
				}(), A = function (e) {
					27 === e.keyCode && T(e)
				}, H = function () {
					d.bind("touchstart mousedown", function (e) {
						a.dragDelay > 0 ? D.exec(function () {
							x(e)
						}, a.dragDelay) : x(e)
					}), d.bind("touchend touchcancel mouseup", function () {
						a.dragDelay > 0 && D.cancel()
					})
				}, H(), O = function () {
					angular.element(o).bind("touchend", T), angular.element(o).bind("touchcancel", T), angular.element(o).bind("touchmove", C), angular.element(o).bind("mouseup", T), angular.element(o).bind("mousemove", C), angular.element(o).bind("mouseleave", w), angular.element(o).bind("keydown", A)
				}, Y = function () {
					angular.element(o).unbind("touchend", T), angular.element(o).unbind("touchcancel", T), angular.element(o).unbind("touchmove", C), angular.element(o).unbind("mouseup", T), angular.element(o).unbind("mousemove", C), angular.element(o).unbind("mouseleave", w), angular.element(o).unbind("keydown", A)
				}
			}
		}
	}])
}(),
function () {
	"use strict";
	angular.module("ui.tree").directive("uiTreeNodes", ["treeConfig", "$window", function (e) {
		return {
			require: ["ngModel", "?^uiTreeNode", "^uiTree"],
			restrict: "A",
			scope: !0,
			controller: "TreeNodesController",
			link: function (n, t, o, l) {
				var r = {},
					a = l[0],
					d = l[1],
					i = l[2];
				angular.extend(r, e), r.nodesClass && t.addClass(r.nodesClass), d ? (d.scope.$childNodesScope = n, n.$nodeScope = d.scope) : i.scope.$nodesScope = n, n.$treeScope = i.scope, a && (a.$render = function () {
					n.$modelValue = a.$modelValue
				}), n.$watch(function () {
					return o.maxDepth
				}, function (e) {
					"number" == typeof e && (n.maxDepth = e)
				}), n.$watch(function () {
					return o.nodropEnabled
				}, function (e) {
					"undefined" != typeof e && (n.nodropEnabled = !0)
				}, !0)
			}
		}
	}])
}(),
function () {
	"use strict";

	function e(e, n) {
		if (void 0 === n) return null;
		for (var t = n.parentNode, o = 1, l = "function" == typeof t.setAttribute && t.hasAttribute(e) ? t : null; t && "function" == typeof t.setAttribute && !t.hasAttribute(e);) {
			if (t = t.parentNode, l = t, t === document.documentElement) {
				l = null;
				break
			}
			o++
		}
		return l
	}
	angular.module("ui.tree").factory("UiTreeHelper", ["$document", "$window", "treeConfig", function (n, t, o) {
		return {
			nodesData: {},
			setNodeAttribute: function (e, n, t) {
				if (!e.$modelValue) return null;
				var o = this.nodesData[e.$modelValue.$$hashKey];
				o || (o = {}, this.nodesData[e.$modelValue.$$hashKey] = o), o[n] = t
			},
			getNodeAttribute: function (e, n) {
				if (!e.$modelValue) return null;
				var t = this.nodesData[e.$modelValue.$$hashKey];
				return t ? t[n] : null
			},
			nodrag: function (e) {
				return "undefined" != typeof e.attr("data-nodrag") && "false" !== e.attr("data-nodrag")
			},
			eventObj: function (e) {
				var n = e;
				return void 0 !== e.targetTouches ? n = e.targetTouches.item(0) : void 0 !== e.originalEvent && void 0 !== e.originalEvent.targetTouches && (n = e.originalEvent.targetTouches.item(0)), n
			},
			dragInfo: function (e) {
				return {
					source: e,
					sourceInfo: {
						cloneModel: e.$treeScope.cloneEnabled === !0 ? angular.copy(e.$modelValue) : void 0,
						nodeScope: e,
						index: e.index(),
						nodesScope: e.$parentNodesScope
					},
					index: e.index(),
					siblings: e.siblings().slice(0),
					parent: e.$parentNodesScope,
					resetParent: function () {
						this.parent = e.$parentNodesScope
					},
					moveTo: function (e, n, t) {
						this.parent = e, this.siblings = n.slice(0);
						var o = this.siblings.indexOf(this.source);
						o > -1 && (this.siblings.splice(o, 1), this.source.index() < t && t--), this.siblings.splice(t, 0, this.source), this.index = t
					},
					parentNode: function () {
						return this.parent.$nodeScope
					},
					prev: function () {
						return this.index > 0 ? this.siblings[this.index - 1] : null
					},
					next: function () {
						return this.index < this.siblings.length - 1 ? this.siblings[this.index + 1] : null
					},
					isClone: function () {
						return this.source.$treeScope.cloneEnabled === !0
					},
					clonedNode: function (e) {
						return angular.copy(e)
					},
					isDirty: function () {
						return this.source.$parentNodesScope != this.parent || this.source.index() != this.index
					},
					isForeign: function () {
						return this.source.$treeScope !== this.parent.$treeScope
					},
					eventArgs: function (e, n) {
						return {
							source: this.sourceInfo,
							dest: {
								index: this.index,
								nodesScope: this.parent
							},
							elements: e,
							pos: n
						}
					},
					apply: function () {
						var e = this.source.$modelValue;
						this.parent.nodropEnabled || this.parent.$treeScope.nodropEnabled || this.isDirty() && (this.isClone() && this.isForeign() ? this.parent.insertNode(this.index, this.sourceInfo.cloneModel) : (this.source.remove(), this.parent.insertNode(this.index, e)))
					}
				}
			},
			height: function (e) {
				return e.prop("scrollHeight")
			},
			width: function (e) {
				return e.prop("scrollWidth")
			},
			offset: function (e) {
				var o = e[0].getBoundingClientRect();
				return {
					width: e.prop("offsetWidth"),
					height: e.prop("offsetHeight"),
					top: o.top + (t.pageYOffset || n[0].body.scrollTop || n[0].documentElement.scrollTop),
					left: o.left + (t.pageXOffset || n[0].body.scrollLeft || n[0].documentElement.scrollLeft)
				}
			},
			positionStarted: function (e, n) {
				var t = {},
					o = e.pageX,
					l = e.pageY;
				return e.originalEvent && e.originalEvent.touches && e.originalEvent.touches.length > 0 && (o = e.originalEvent.touches[0].pageX, l = e.originalEvent.touches[0].pageY), t.offsetX = o - this.offset(n).left, t.offsetY = l - this.offset(n).top, t.startX = t.lastX = o, t.startY = t.lastY = l, t.nowX = t.nowY = t.distX = t.distY = t.dirAx = 0, t.dirX = t.dirY = t.lastDirX = t.lastDirY = t.distAxX = t.distAxY = 0, t
			},
			positionMoved: function (e, n, t) {
				var o, l = e.pageX,
					r = e.pageY;
				return e.originalEvent && e.originalEvent.touches && e.originalEvent.touches.length > 0 && (l = e.originalEvent.touches[0].pageX, r = e.originalEvent.touches[0].pageY), n.lastX = n.nowX, n.lastY = n.nowY, n.nowX = l, n.nowY = r, n.distX = n.nowX - n.lastX, n.distY = n.nowY - n.lastY, n.lastDirX = n.dirX, n.lastDirY = n.dirY, n.dirX = 0 === n.distX ? 0 : n.distX > 0 ? 1 : -1, n.dirY = 0 === n.distY ? 0 : n.distY > 0 ? 1 : -1, o = Math.abs(n.distX) > Math.abs(n.distY) ? 1 : 0, t ? (n.dirAx = o, void(n.moving = !0)) : (n.dirAx !== o ? (n.distAxX = 0, n.distAxY = 0) : (n.distAxX += Math.abs(n.distX), 0 !== n.dirX && n.dirX !== n.lastDirX && (n.distAxX = 0), n.distAxY += Math.abs(n.distY), 0 !== n.dirY && n.dirY !== n.lastDirY && (n.distAxY = 0)), void(n.dirAx = o))
			},
			elementIsTreeNode: function (e) {
				return "undefined" != typeof e.attr("ui-tree-node")
			},
			elementIsTreeNodeHandle: function (e) {
				return "undefined" != typeof e.attr("ui-tree-handle")
			},
			elementIsTree: function (e) {
				return "undefined" != typeof e.attr("ui-tree")
			},
			elementIsTreeNodes: function (e) {
				return "undefined" != typeof e.attr("ui-tree-nodes")
			},
			elementIsPlaceholder: function (e) {
				return e.hasClass(o.placeholderClass)
			},
			elementIsDropzone: function (e) {
				return e.hasClass(o.dropzoneClass)
			},
			elementContainsTreeNodeHandler: function (e) {
				return e[0].querySelectorAll("[ui-tree-handle]").length >= 1
			},
			treeNodeHandlerContainerOfElement: function (n) {
				return e("ui-tree-handle", n[0])
			}
		}
	}])
}();




/**
 * ngSticky - https://github.com/d-oliveros/ngSticky
 *
 * A simple, pure javascript (No jQuery required!) AngularJS directive
 * to make elements stick when scrolling down.
 *
 * Credits: https://github.com/d-oliveros/ngSticky/graphs/contributors
 */
(function () {
	'use strict';

	var module = angular.module('sticky', []);

	/**
	 * Directive: sticky
	 */
	module.directive('sticky', ['$window', '$timeout', function ($window, $timeout) {
		return {
			restrict: 'A', // this directive can only be used as an attribute.
			scope: {
				disabled: '=disabledSticky'
			},
			link: function linkFn($scope, $elem, $attrs) {

				// Initial scope
				var scrollableNodeTagName = 'sticky-scroll';
				var initialPosition = $elem.css('position');
				var initialStyle = $elem.attr('style') || '';
				var stickyBottomLine = 0;
				var isSticking = false;
				var onStickyHeighUnbind;
				var originalInitialCSS;
				var originalOffset;
				var placeholder;
				var stickyLine;
				var initialCSS;

				// Optional Classes
				var stickyClass = $attrs.stickyClass || '';
				var unstickyClass = $attrs.unstickyClass || '';
				var bodyClass = $attrs.bodyClass || '';
				var bottomClass = $attrs.bottomClass || '';

				// Find scrollbar
				var scrollbar = deriveScrollingViewport($elem);

				// Define elements
				var windowElement = angular.element($window);
				var scrollbarElement = angular.element(scrollbar);
				var $body = angular.element(document.body);

				// Resize callback
				var $onResize = function () {
					if ($scope.$root && !$scope.$root.$$phase) {
						$scope.$apply(onResize);
					} else {
						onResize();
					}
				};

				// Define options
				var usePlaceholder = ($attrs.usePlaceholder !== 'false');
				var anchor = $attrs.anchor === 'bottom' ? 'bottom' : 'top';
				var confine = ($attrs.confine === 'true');

				// flag: can react to recalculating the initial CSS dimensions later
				// as link executes prematurely. defaults to immediate checking
				var isStickyLayoutDeferred = $attrs.isStickyLayoutDeferred !== undefined ?
					($attrs.isStickyLayoutDeferred === 'true') :
					false;

				// flag: is sticky content constantly observed for changes.
				// Should be true if content uses ngBind to show text
				// that may vary in size over time
				var isStickyLayoutWatched = $attrs.isStickyLayoutWatched !== undefined ?
					($attrs.isStickyLayoutWatched === 'true') :
					true;


				var offset = $attrs.offset ?
					parseInt($attrs.offset.replace(/px;?/, '')) :
					0;

				/**
				 * Trigger to initialize the sticky
				 * Because of the `timeout()` method for the call of
				 * @type {Boolean}
				 */
				var shouldInitialize = true;

				/**
				 * Initialize Sticky
				 */
				function initSticky() {

					if (shouldInitialize) {

						// Listeners
						scrollbarElement.on('scroll', checkIfShouldStick);
						windowElement.on('resize', $onResize);

						memorizeDimensions(); // remember sticky's layout dimensions

						// Setup watcher on digest and change
						$scope.$watch(onDigest, onChange);

						// Clean up
						$scope.$on('$destroy', onDestroy);
						shouldInitialize = false;
					}
				};

				/**
				 * need to recall sticky's DOM attributes (make sure layout has occured)
				 */
				function memorizeDimensions() {
					// immediate assignment, but there is the potential for wrong values if content not ready
					initialCSS = $scope.getInitialDimensions();

					// option to calculate the dimensions when layout is 'ready'
					if (isStickyLayoutDeferred) {

						// logic: when this directive link() runs before the content has had a chance to layout on browser, height could be 0
						if (!$elem[0].getBoundingClientRect().height) {

							onStickyHeighUnbind = $scope.$watch(
								function () {
									return $elem.height();
								},

								// state change: sticky content's height set
								function onStickyContentLayoutInitialHeightSet(newValue, oldValue) {
									if (newValue > 0) {
										// now can memorize
										initialCSS = $scope.getInitialDimensions();

										if (!isStickyLayoutWatched) {
											// preference was to do just a one-time async watch on the sticky's content; now stop watching
											onStickyHeighUnbind();
										}
									}
								}
							);
						}
					}
				}

				/**
				 * Determine if the element should be sticking or not.
				 */
				var checkIfShouldStick = function () {
					if ($scope.disabled === true || mediaQueryMatches()) {
						if (isSticking) unStickElement();
						return false;
					}

					// What's the document client top for?
					var scrollbarPosition = scrollbarYPos();
					var shouldStick;

					if (anchor === 'top') {
						if (confine === true) {
							shouldStick = scrollbarPosition > stickyLine && scrollbarPosition <= stickyBottomLine;
						} else {
							shouldStick = scrollbarPosition > stickyLine;
						}
					} else {
						shouldStick = scrollbarPosition <= stickyLine;
					}

					// Switch the sticky mode if the element crosses the sticky line
					// $attrs.stickLimit - when it's equal to true it enables the user
					// to turn off the sticky function when the elem height is
					// bigger then the viewport
					var closestLine = getClosest(scrollbarPosition, stickyLine, stickyBottomLine);

					if (shouldStick && !shouldStickWithLimit($attrs.stickLimit) && !isSticking) {
						stickElement(closestLine);
					} else if (!shouldStick && isSticking) {
						unStickElement(closestLine, scrollbarPosition);
					} else if (confine && !shouldStick) {
						// If we are confined to the parent, refresh, and past the stickyBottomLine
						// We should 'remember' the original offset and unstick the element which places it at the stickyBottomLine
						originalOffset = elementsOffsetFromTop($elem[0]);
						unStickElement(closestLine, scrollbarPosition);
					}
				};

				/**
				 * determine the respective node that handles scrolling, defaulting to browser window
				 */
				function deriveScrollingViewport(stickyNode) {
					// derive relevant scrolling by ascending the DOM tree
					var match = findAncestorTag(scrollableNodeTagName, stickyNode);
					return (match.length === 1) ? match[0] : $window;
				}

				/**
				 * since jqLite lacks closest(), this is a pseudo emulator (by tag name)
				 */
				function findAncestorTag(tag, context) {
					var m = []; // nodelist container
					var n = context.parent(); // starting point
					var p;

					do {
						var node = n[0]; // break out of jqLite
						// limit DOM territory
						if (node.nodeType !== 1) {
							break;
						}

						// success
						if (node.tagName.toUpperCase() === tag.toUpperCase()) {
							return n;
						}

						p = n.parent();
						n = p; // set to parent
					} while (p.length !== 0);

					return m; // empty set
				}

				/**
				 * Seems to be undocumented functionality
				 */
				function shouldStickWithLimit(shouldApplyWithLimit) {
					return shouldApplyWithLimit === 'true' ?
						($window.innerHeight - ($elem[0].offsetHeight + parseInt(offset)) < 0) :
						false;
				}

				/**
				 * Finds the closest value from a set of numbers in an array.
				 */
				function getClosest(scrollTop, stickyLine, stickyBottomLine) {
					var closest = 'top';
					var topDistance = Math.abs(scrollTop - stickyLine);
					var bottomDistance = Math.abs(scrollTop - stickyBottomLine);

					if (topDistance > bottomDistance) {
						closest = 'bottom';
					}

					return closest;
				}

				/**
				 * Unsticks the element
				 */
				function unStickElement(fromDirection) {
					if (initialStyle) {
						$elem.attr('style', initialStyle);
					}
					isSticking = false;

					initialCSS.width = $scope.getInitialDimensions().width;

					$body.removeClass(bodyClass);
					$elem.removeClass(stickyClass);
					$elem.addClass(unstickyClass);
					$elem[0].style.width = null;

					if (fromDirection === 'top') {
						$elem.removeClass(bottomClass);
						$elem
							.css('z-index', 10)
							.css('top', initialCSS.top)
							.css('position', initialCSS.position)
							.css('left', initialCSS.cssLeft)
							.css('margin-top', initialCSS.marginTop)
							.css('height', initialCSS.height);

					} else if (fromDirection === 'bottom' && confine === true) {
						$elem.addClass(bottomClass);

						// It's possible to page down page and skip the 'stickElement'.
						// In that case we should create a placeholder so the offsets don't get off.
						createPlaceholder();
						$elem
							.css('z-index', 10)
							.css('top', '')
							.css('bottom', 0)
							.css('position', 'absolute')
							.css('left', initialCSS.cssLeft)
							.css('margin-top', initialCSS.marginTop)
							.css('margin-bottom', initialCSS.marginBottom)
							.css('height', initialCSS.height);

					}

					if (placeholder && fromDirection === anchor) {
						placeholder.remove();
					}
				}

				/**
				 * Sticks the element
				 */
				function stickElement(closestLine) {
					// Set sticky state
					isSticking = true;
					$timeout(function () {
						initialCSS.offsetWidth = $elem[0].offsetWidth;
					}, 0);
					$body.addClass(bodyClass);
					$elem.removeClass(unstickyClass);
					$elem.removeClass(bottomClass);
					$elem.addClass(stickyClass);

					createPlaceholder();

					$elem
						.css('z-index', '10')
						.css('width', $elem[0].offsetWidth + 'px')
						.css('position', 'fixed')
						.css('left', $elem.css('left').replace('px', '') + 'px')
						.css(anchor, (offset + elementsOffsetFromTop(scrollbar)) + 'px')
						.css('margin-top', 0);

					if (anchor === 'bottom') {
						$elem.css('margin-bottom', 0);
					}
				}

				/**
				 * Clean up directive
				 */
				var onDestroy = function () {
					scrollbarElement.off('scroll', checkIfShouldStick);
					windowElement.off('resize', $onResize);

					$onResize = null;

					$body.removeClass(bodyClass);

					if (placeholder) {
						placeholder.remove();
					}
				};

				/**
				 * Updates on resize.
				 */
				function onResize() {
					unStickElement(anchor);
					checkIfShouldStick();
				}

				/**
				 * Triggered on load / digest cycle
				 * return `0` if the DOM element is hidden
				 */
				var onDigest = function () {
					if ($scope.disabled === true) {
						return unStickElement();
					}
					var offsetFromTop = elementsOffsetFromTop($elem[0]);
					if (offsetFromTop === 0) {
						return offsetFromTop;
					}
					if (anchor === 'top') {
						return (originalOffset || offsetFromTop) - elementsOffsetFromTop(scrollbar) + scrollbarYPos();
					} else {
						return offsetFromTop - scrollbarHeight() + $elem[0].offsetHeight + scrollbarYPos();
					}
				};

				/**
				 * Triggered on change
				 */
				var onChange = function (newVal, oldVal) {

					/**
					 * Indicate if the DOM element is showed, or not
					 * @type {boolean}
					 */
					var elemIsShowed = !!newVal;

					/**
					 * Indicate if the DOM element was showed, or not
					 * @type {boolean}
					 */
					var elemWasHidden = !oldVal;
					var valChange = (newVal !== oldVal || typeof stickyLine === 'undefined');
					var notSticking = (!isSticking && !isBottomedOut());

					if (valChange && notSticking && newVal > 0 && elemIsShowed) {
						stickyLine = newVal - offset;
						//Update dimensions of sticky element when is showed
						if (elemIsShowed && elemWasHidden) {
							$scope.updateStickyContentUpdateDimensions($elem[0].offsetWidth, $elem[0].offsetHeight);
						}
						// IF the sticky is confined, we want to make sure the parent is relatively positioned,
						// otherwise it won't bottom out properly
						if (confine) {
							$elem.parent().css({
								'position': 'relative'
							});
						}

						// Get Parent height, so we know when to bottom out for confined stickies
						var parent = $elem.parent()[0];

						// Offset parent height by the elements height, if we're not using a placeholder
						var parentHeight = parseInt(parent.offsetHeight) - (usePlaceholder ? 0 : $elem[0].offsetHeight);

						// and now lets ensure we adhere to the bottom margins
						// TODO: make this an attribute? Maybe like ignore-margin?
						var marginBottom = parseInt($elem.css('margin-bottom').replace(/px;?/, '')) || 0;

						// specify the bottom out line for the sticky to unstick
						var elementsDistanceFromTop = elementsOffsetFromTop($elem[0]);
						var parentsDistanceFromTop = elementsOffsetFromTop(parent)
						var scrollbarDistanceFromTop = elementsOffsetFromTop(scrollbar);

						var elementsDistanceFromScrollbarStart = elementsDistanceFromTop - scrollbarDistanceFromTop;
						var elementsDistanceFromBottom = parentsDistanceFromTop + parentHeight - elementsDistanceFromTop;

						stickyBottomLine = elementsDistanceFromScrollbarStart +
							elementsDistanceFromBottom -
							$elem[0].offsetHeight -
							marginBottom -
							offset +
							+scrollbarYPos();

						checkIfShouldStick();
					}
				};

				/**
				 * Helper Functions
				 */

				/**
				 * Create a placeholder
				 */
				function createPlaceholder() {
					if (usePlaceholder) {
						// Remove the previous placeholder
						if (placeholder) {
							placeholder.remove();
						}

						placeholder = angular.element('<div>');
						var elementsHeight = $elem[0].offsetHeight;
						var computedStyle = $elem[0].currentStyle || window.getComputedStyle($elem[0]);
						elementsHeight += parseInt(computedStyle.marginTop, 10);
						elementsHeight += parseInt(computedStyle.marginBottom, 10);
						elementsHeight += parseInt(computedStyle.borderTopWidth, 10);
						elementsHeight += parseInt(computedStyle.borderBottomWidth, 10);
						placeholder.css('height', $elem[0].offsetHeight + 'px');

						$elem.after(placeholder);
					}
				}

				/**
				 * Are we bottomed out of the parent element?
				 */
				function isBottomedOut() {
					if (confine && scrollbarYPos() > stickyBottomLine) {
						return true;
					}

					return false;
				}

				/**
				 * Fetch top offset of element
				 */
				function elementsOffsetFromTop(element) {
					var offset = 0;

					if (element.getBoundingClientRect) {
						offset = element.getBoundingClientRect().top;
					}

					return offset;
				}

				/**
				 * Retrieves top scroll distance
				 */
				function scrollbarYPos() {
					var position;

					if (typeof scrollbar.scrollTop !== 'undefined') {
						position = scrollbar.scrollTop;
					} else if (typeof scrollbar.pageYOffset !== 'undefined') {
						position = scrollbar.pageYOffset;
					} else {
						position = document.documentElement.scrollTop;
					}

					return position;
				}

				/**
				 * Determine scrollbar's height
				 */
				function scrollbarHeight() {
					var height;

					if (scrollbarElement[0] instanceof HTMLElement) {
						// isn't bounding client rect cleaner than insane regex mess?
						height = $window.getComputedStyle(scrollbarElement[0], null)
							.getPropertyValue('height')
							.replace(/px;?/, '');
					} else {
						height = $window.innerHeight;
					}

					return parseInt(height) || 0;
				}

				/**
				 * Checks if the media matches
				 */
				function mediaQueryMatches() {
					var mediaQuery = $attrs.mediaQuery || false;
					var matchMedia = $window.matchMedia;

					return mediaQuery && !(matchMedia('(' + mediaQuery + ')').matches || matchMedia(mediaQuery).matches);
				}

				/**
				 * Get more accurate CSS values
				 */
				function getCSS($el, prop) {
					var el = $el[0],
						computed = window.getComputedStyle(el),
						prevDisplay = computed.display,
						val;

					// hide the element so that we can get original css
					// values instead of computed values
					el.style.display = "none";

					// NOTE - computed style declaration object is a reference
					// to the element's CSSStyleDeclaration, so it will always
					// reflect the current style of the element
					val = computed[prop];

					// restore previous display value
					el.style.display = prevDisplay;

					return val;
				}

				// public accessors for the controller to hitch into. Helps with external API access
				$scope.getElement = function () {
					return $elem;
				};
				$scope.getScrollbar = function () {
					return scrollbar;
				};
				$scope.getInitialCSS = function () {
					return initialCSS;
				};
				$scope.getAnchor = function () {
					return anchor;
				};
				$scope.isSticking = function () {
					return isSticking;
				};
				$scope.getOriginalInitialCSS = function () {
					return originalInitialCSS;
				};
				// pass through aliases
				$scope.processUnStickElement = function (anchor) {
					unStickElement(anchor)
				};
				$scope.processCheckIfShouldStick = function () {
					checkIfShouldStick();
				};

				/**
				 * set the dimensions for the defaults of the content block occupied by the sticky element
				 */
				$scope.getInitialDimensions = function () {
					return {
						zIndex: $elem.css('z-index'),
						top: $elem.css('top'),
						position: initialPosition, // revert to true initial state
						marginTop: $elem.css('margin-top'),
						marginBottom: $elem.css('margin-bottom'),
						cssLeft: getCSS($elem, 'left'),
						width: $elem[0].offsetWidth,
						height: $elem.css('height')
					};
				};

				/**
				 * only change content box dimensions
				 */
				$scope.updateStickyContentUpdateDimensions = function (width, height) {
					if (width && height) {
						initSticky();
						initialCSS.width = width + 'px';
						initialCSS.height = height + 'px';
					}
				};

				// ----------- configuration -----------

				$timeout(function () {
					originalInitialCSS = $scope.getInitialDimensions(); // preserve a copy
					// Init the directive
					initSticky();
				}, 0);
			},

			/**
			 * +++++++++ public APIs+++++++++++++
			 */
			controller: ['$scope', '$window', function ($scope, $window) {

				/**
				 * integration method allows for an outside client to reset the pinned state back to unpinned.
				 * Useful for when refreshing the scrollable DIV content completely
				 * if newWidth and newHeight integer values are not supplied then function will make a best guess
				 */
				this.resetLayout = function (newWidth, newHeight) {

					var scrollbar = $scope.getScrollbar(),
						initialCSS = $scope.getInitialCSS(),
						anchor = $scope.getAnchor();

					function _resetScrollPosition() {

						// reset means content is scrolled to anchor position
						if (anchor === 'top') {
							// window based scroller
							if (scrollbar === $window) {
								$window.scrollTo(0, 0);
								// DIV based sticky scroller
							} else {
								if (scrollbar.scrollTop > 0) {
									scrollbar.scrollTop = 0;
								}
							}
						}
						// todo: need bottom use case
					}

					// only if pinned, force unpinning, otherwise height is inadvertently reset to 0
					if ($scope.isSticking()) {
						$scope.processUnStickElement(anchor);
						$scope.processCheckIfShouldStick();
					}
					// remove layout-affecting attribures that were modified by this sticky
					$scope.getElement().css({
						'width': '',
						'height': '',
						'position': '',
						'top': '',
						zIndex: ''
					});
					// model resets
					initialCSS.position = $scope.getOriginalInitialCSS().position; // revert to original state
					delete initialCSS.offsetWidth; // stickElement affected

					// use this directive element's as default, if no measurements passed in
					if (newWidth === undefined && newHeight === undefined) {
						var e_bcr = $scope.getElement()[0].getBoundingClientRect();
						newWidth = e_bcr.width;
						newHeight = e_bcr.height;
					}

					// update model with new dimensions (if supplied from client's own measurement)
					$scope.updateStickyContentUpdateDimensions(newWidth, newHeight); // update layout dimensions only

					_resetScrollPosition();
				};

				/**
				 * return a reference to the scrolling element (window or DIV with overflow)
				 */
				this.getScrollbar = function () {
					return $scope.getScrollbar();
				};
			}]
		};
	}]);

	// Shiv: matchMedia
	window.matchMedia = window.matchMedia || (function () {
		var warning = 'angular-sticky: This browser does not support ' +
			'matchMedia, therefore the minWidth option will not work on ' +
			'this browser. Polyfill matchMedia to fix this issue.';

		if (window.console && console.warn) {
			console.warn(warning);
		}

		return function () {
			return {
				matches: true
			};
		};
	}());
}());