(function(){
	var template = angular.module('template', ['widgets']);

	template.controller('TemplateController', ['$scope', 'model', 'TempAssistAccessor', '$filter', '$window', '$q',
									function($scope, model, templateAccessor, $filter, $window, $q){
										
		model.activeController('template');
		model.activeMenu('Template');
		
		$scope.activePanels = [];
		$scope.isActive = function(type){
			if(model.template().chosenType && model.template().chosenType.value){
				return model.template().chosenType.value == type.value;
			}
		}
		
		$scope.templateList = [
			{name:'Enc_And_sum', sections:[]},
			{name:'Fax', sections:[]},
			{name:'lab_result', sections:[]},
			{name:'doc_num', sections:[]},
			{name:'PRESCRIPTIONS', sections:[]},
			{name:'form_consutation', sections:[]},
			{name:'Schedule', sections:[]},
			{name:'Misc', sections:[]}
		]
		$scope.templateFilteredList;
		
		function getTemplateList(){
			if(model.enums().templateList){
				var arrayTemplateList = Object.values(model.enums().templateList);
				for(i=0; i<arrayTemplateList.length;i++){
					var fields = arrayTemplateList[i].type.split('_')
					if(fields[0] == "ENCOUNTER"){
						$scope.templateList[0].sections.push(arrayTemplateList[i])
					}else if(fields[1] == "CVFAX"){
						$scope.templateList[1].sections.push(arrayTemplateList[i])
					}else if(fields[0] == "LABO"){
						$scope.templateList[2].sections.push(arrayTemplateList[i])
					}else if(fields[0] == "SCAN"){
						$scope.templateList[3].sections.push(arrayTemplateList[i])
					}else if(fields[0] == "PRESCRIPTION"){
						$scope.templateList[4].sections.push(arrayTemplateList[i])
					}else if(fields[0] == "CONSULTATION"){
						$scope.templateList[5].sections.push(arrayTemplateList[i])
//					}else if(fields[0] == "PATIENT"){
//						$scope.templateList[6].sections.push(arrayTemplateList[i])
					}else if(fields[0] == "APPOINTMENT" || (fields[0] == "PATIENT" && fields[1] != "DIRECTIVE") 
							|| fields[0] == "OTHER"){
						$scope.templateList[6].sections.push(arrayTemplateList[i])
//					}else if(fields[fields.length-1] == "NOTE"){
//						$scope.templateList[7].sections.push(arrayTemplateList[i])
					}else{
						$scope.templateList[7].sections.push(arrayTemplateList[i])
					}
				}
				$scope.templateFilteredList = angular.copy($scope.templateList);
				if(templateListWatcher)templateListWatcher();
			}
		}
		
		$scope.getFilteredList = function(){
			$scope.templateFilteredList = angular.copy($scope.templateList);
			for(let i=0;i<$scope.templateFilteredList.length;i++){
				$scope.templateFilteredList[i].sections = $scope.templateFilteredList[i].sections.filterFast(filterSearchType)
			}
		}
		
		var offsetJump = 50;
		var templateToAdd = []
		$scope.selectTemplateType = function(type){
			$window.scrollTo(0, 0)
			$scope.isSearching = true
			data = {
				idType : type.value,
				offset : null
			}
			model.template().offset = 0;
			model.template().chosenType = type;
			model.template().searchMoreTemplate = true;
			model.template().searchMoreGlobalTemplate = true;
			model.template().chosenTypeList = [];
			model.template().chosenTypeGlobalList = [];
			getUser(data).then(function(){
				return getClient(data);
			}).then(function(){
				return getGlobal(data);
			}).then(function(){
				resolveTemplateData()
			})
		}
		
		$scope.getNextTemplate = function(){
			if(model.template().searchMoreTemplate && !$scope.isSearching){
				$scope.isSearching = true
				data = {
					idType : model.template().chosenType.value,
					offset : model.template().offset
				}
				getUser(data).then(function(){
					return getClient(data);
				}).then(function(){
					return getGlobal(data);
				}).then(function(){
					resolveTemplateData()
				})
			}
		}
		function resolveTemplateData(){
			$scope.isSearching = false
			if(templateToAdd.length == 0){
				model.template().searchMoreTemplate = false
			}else{
				model.template().chosenTypeList.push(...templateToAdd);
				templateToAdd = []
				model.template().offset += offsetJump;
			}
			model.templateLstUpdated(true);
		}
		function getGlobal(data){
			if(model.template().searchMoreGlobalTemplate){
				return templateAccessor.getGlobal(data,function(res){
					if (res.data && res.data.success===false) {
						model.notice().warn(res.data.ms);
						model.template().searchMoreGlobalTemplate = false
					}else if(res.data == 0){
						model.template().searchMoreGlobalTemplate = false
					}else{
						model.template().chosenTypeGlobalList.push(...res.data)
					}
					return true;
				},function(err) {
					console.log(err);
					model.notice().warn($filter('translate')('error') + ": " + err);										
					$scope.isSearching = false;			
				});
			}else{
				return true;
			}
		}
		function getClient(data){
			return templateAccessor.getClient(data,function(res){
				if (res.data && res.data.success===false) {
					model.notice().warn(res.data.ms);
				}else{
					templateToAdd.push(...res.data);
				}
				return true;
			},function(err) {
				console.log(err);
				model.notice().warn($filter('translate')('error') + ": " + err);										
				$scope.isSearching = false;			
			});
		}
		function getUser(data){
			return templateAccessor.getUser(data,function(res){
				if (res.data && res.data.success===false) {
					model.notice().warn(res.data.ms);
				}else{
					templateToAdd.push(...res.data);
				}
				return true;
			},function(err) {
				console.log(err);
				model.notice().warn($filter('translate')('error') + ": " + err);										
				$scope.isSearching = false;			
			});
		}
		
		$scope.searchTextType = "";
		$scope.searchUpdatedType = function(v) {
			if (v && v.length>2) {
				var x = v.split(' '); 
				var len = x.length;
				$scope.searchTextTypeRegExp = [];
				for(var i=0;i<len;i++) {
					$scope.searchTextTypeRegExp.push(new RegExp(x[i], 'i'));
				}
			} else {
				delete $scope.searchTextTypeRegExp;
			}
			$scope.getFilteredList();
			model.templateLstUpdated(true);
		};
		
		filterSearchType = function(e){
			return matchInArray($filter('translate')(e.type))
		}
		
		function matchInArray(string) {
			if($scope.searchTextTypeRegExp) {
				var len = $scope.searchTextTypeRegExp.length
				for (var i=0; i < len; i++) {
					if (!$scope.searchTextTypeRegExp[i].test(string)) {
						return false;
					}
				}
				return true;
			}
			return true;
		}
		
		model.callDashBoardCount();
		var templateListWatcher =  $scope.$watch('model.enums().templateList', getTemplateList);
		
	}]);
	
	template.directive('templateList', ['$filter', 'model', 'TempAssistAccessor', '$q',
							function($filter, model, templateAccessor, $q){
		return {
			restrict: 'E',
            templateUrl:'/dashboard/resources/ofys/template/template_list.html?v=bj',
            scope:{
                type: '=',
                list: '=?',
            },
			link: function(scope){
				
				scope.showFilters = false;
				scope.editDisplay = {inEditMode : false};
				scope.user = model.user().sessionUser.user;
				
				scope.showSearchFilters = function(){
					scope.showFilters = !scope.showFilters;
				}
				
				scope.selectedFilter = {
					user: true,
					client: false,
					global: false,
				}
				
				scope.refreshList = function(){
					model.templateLstUpdated(true);
				}
				
				scope.getFilteredListLength = function(){
					return model.template().chosenTypeFilteredList.length;
				}
				
				scope.getFilteredTemplateList = function(){
					if(model.template().chosenTypeList){
						if(scope.chosenTypeSearchList && scope.chosenTypeSearchList.length > 0){
							model.template().chosenTypeFilteredList = scope.chosenTypeSearchList;
						}else {
							if(scope.selectedFilter.user && scope.selectedFilter.client){
								model.template().chosenTypeFilteredList = model.template().chosenTypeList;
							}else if(scope.selectedFilter.user){
								model.template().chosenTypeFilteredList = model.template().chosenTypeList.filter(template => template.userId == scope.user.id);
							}else if(scope.selectedFilter.client){
								model.template().chosenTypeFilteredList = model.template().chosenTypeList.filter(template => template.userId != scope.user.id);
							}else{
								model.template().chosenTypeFilteredList = [];
							}
							if(scope.selectedFilter.global && model.template().chosenTypeGlobalList  && model.template().chosenTypeGlobalList.length > 0){
								model.template().chosenTypeFilteredList.push(...model.template().chosenTypeGlobalList)
							}
						}
						//model.template().chosenTypeFilteredList = model.template().chosenTypeFilteredList.filterFast(filterSearchText)
					}else{
						model.template().chosenTypeFilteredList = []
					}
					return model.template().chosenTypeFilteredList;
				}
				
				scope.isSearching = false;
				scope.noDataFound = false;
				scope.textTooShort = false;
				scope.searchTextTemplate = "";
				scope.chosenTypeSearchList = []
				scope.searchUpdatedTemplate = function(v) {
					if (v && v.length>=4 && !scope.isSearching && scope.type) {
						scope.chosenTypeSearchList = []
						scope.noDataFound = false;
						scope.textTooShort = false;
						data = {
							idType: scope.type.value,
							offset : null,
							txt: v
						}
						function getUser(data){
							if(scope.selectedFilter.user){
								return templateAccessor.getUser(data,function(res){
									if (res.data && res.data.success===false) {
										model.notice().warn(res.data.ms);
									}else{
										scope.chosenTypeSearchList.push(...res.data);
									}
									return true;
								},function(err) {
									console.log(err);
									model.notice().warn($filter('translate')('error') + ": " + err);	
								});
							}else{
								return true;
							}
						}
						function getClient(data){
							if(scope.selectedFilter.client){
								return templateAccessor.getClient(data,function(res){
									if (res.data && res.data.success===false) {
										model.notice().warn(res.data.ms);
									}else{
										scope.chosenTypeSearchList.push(...res.data);
									}
									return true;
								},function(err) {
									console.log(err);
									model.notice().warn($filter('translate')('error') + ": " + err);	
								});
							}else{
								return true
							}
						}
						function getGlobal(data){
							if(scope.selectedFilter.global){
								return templateAccessor.getClient(data,function(res){
									if (res.data && res.data.success===false) {
										model.notice().warn(res.data.ms);
									}else{
										scope.chosenTypeSearchList.push(...res.data);
									}
									return true;
								},function(err) {
									console.log(err);
									model.notice().warn($filter('translate')('error') + ": " + err);		
								});
							}else{
								return true
							}
						}
						function resolveTemplateData(){
							return $q(function(resolve, reject){
								scope.isSearching = false
								if(!scope.chosenTypeSearchList || scope.chosenTypeSearchList.length == 0){
									scope.noDataFound = true
								}
								model.template().searchMoreTemplate = false;
								model.templateLstUpdated(true);
								return true;
							})
						}
						getUser(data).then(function(){
							return getClient(data);
						}).then(function(){
							return getGlobal(data);
						}).then(function(){
							resolveTemplateData()
						});
					} else if(!scope.isSearching){
						model.template().searchMoreTemplate = true;
						scope.noDataFound = false;
						scope.textTooShort = true;
						delete scope.chosenTypeSearchList;
						scope.chosenTypeSearchList = [];
						model.templateLstUpdated(true);
					}
				};
				
				filterSearchText = function(e){
					return matchInArray(e.name+'~'+e.text)
				}
				
				function matchInArray(string) {
					if (model.template().searchTextTemplateRegExp) {
						var len = model.template().searchTextTemplateRegExp.length
						for (i=0; i < len; i++) {
							if (!model.template().searchTextTemplateRegExp[i].test(string)) {
								return false;
							}
						}
						return true;
					}
					return true;
				}
				
				scope.openTemplate = function(template){
					scope.template = angular.copy(template);
					scope.editDisplay.inEditMode = true;
					model.templateLstUpdated(true);
				}
				
				scope.openNewTemplate = function(){
					var template = {isNew: true, className: "CTemplate", type:model.template().chosenType.value, sections: [], isClientPrivate: true};
					scope.template = template;
					scope.editDisplay.inEditMode = true;
					model.templateLstUpdated(true);
				}
				
				scope.isShare = function(template){
					return !template.isClientPrivate ? $filter('translate')("Yes") : $filter('translate')("No");
				}
				
				scope.getText = function(template){
					var text = "";
					for(let i = 0; i < template.sections.length; i++){
						if(template.sections[i].className =="DRaw"){
							text += template.sections[i].raw + " ";
						}else if(OfysUtils.isNotEmpty(template.sections[i].m) && template.sections[i].m !== "undefined"){
							text += template.sections[i].m + " ";
						}else if(template.isHtml){
							text += "<b>[" + template.sections[i].name + "]</b> ";
						}else{
							text += "[" + template.sections[i].name + "] ";
						}
					}
					return text;
				}
            }
        }
    }]);

	template.directive('templateEdit', ['$filter', 'FlView', 'model',
							function($filter, FlView, model){
		return {
			restrict: 'E',
            templateUrl:'/dashboard/resources/ofys/template/template_edit.html?v=bj',
			link: function(scope){
				
			}
        }
    }]);
	
	template.controller('TemplateEditController', ['$scope', 'model', 'PatientFormService', 'QConfirm', 'TempAssistAccessor',
			'$filter', 'FlView', 'QValidation', '$q',
		function($scope, model, PatientFormService, QConfirm, templateAccessor, $filter, FlView, QValidation, $q){
			$scope.templateText = {}
			
			$scope.canDelete = function(){
				return $scope.template.userId == model.user().sessionUser.user.id
			}
			
			$scope.createNewSection = function(className){
				var templateSection = {className : className, required: false, isNew: true}
				if(className == "DNum")templateSection.typeDeMesure = 'S_O';templateSection.max = 99;templateSection.digits = 99;
				if(className == "DList")templateSection.items = []; templateSection.separator = ", "
				if(className == "DDate")templateSection.allowPast = true;templateSection.allowFuture = true;
				$scope.openTemplateSection(templateSection)
			}
			
			var allMeasurementType = [
				{name:'S_O', id:0},
				{name:'TAs', id:1},
				{name:'TAd', id:2},
				{name:'POULS', id:3},
				{name:'POIDSKG', id:4},
				{name:'POIDSLBS', id:41},
				{name:'TAILLECM', id:5},
				{name:'TAILLEPCE', id:51},
				{name:'TOUR_TAILLECM', id:6},
				{name:'TOUR_TAILLEPCE', id:61},
				{name:'CIRC_TCM', id:7},
				{name:'CIRC_TPCE', id:71},
				{name:'FR', id:8},
				{name:'TEMP_AXI', id:9},
				{name:'TEMP_BUC', id:10},
				{name:'TEMP_REC', id:11},
				{name:'TEMP_TYM', id:12},
				{name:'SATUR', id:13}
			]
			
			$scope.seePreview = function(){
				$scope.template.sections = $scope.templateText.updateSections();
				$scope.template.text = createTemplateText();
				return FlView.open({templateUrl: "/dashboard/resources/ofys/widgets/template_assist_fill.html?v=bj", 
						template: angular.copy($scope.template), preview: true}, {windowClass: 'gabarit to-top', backdrop:'static'});
			}
			
			/**
			 * COMMENT: TEMPLATES EDITEMPLATE @function
			 *
			 * Façon simple de setup les QValidation, sert à vérifier si la form est "dirty" 
			 * À implémenter sur tout ce qui est édition
			 * 
			 */
			var registeredDirtyId;
			function registerDirty(){
				registeredDirtyId = "templates_"+$scope.template.type;
				QValidation.registerDirty(registeredDirtyId, $scope.saveTemplate, function(){
					return true;
				});
			}
			function unregisterDirty(){
				if(registeredDirtyId){
					QValidation.unregisterDirty(registeredDirtyId);
					registeredDirtyId = undefined;
				}
			}
			$scope.isDirty = false;
			var isFormDirty = false;
			$scope.formDirty = function(){
				var dirty = $scope.isDirty || 
					($scope.templateFrm && $scope.templateFrm.$dirty)
				if(isFormDirty !== dirty){
					if(dirty){
						registerDirty();
					}else{
						unregisterDirty();
					}
				}
				isFormDirty = dirty;
				return isFormDirty;
			};
			//find du setup de la QValidation
			
			$scope.openTemplateSection = function(templateSection){
				let itemToAddName = undefined;
				if(templateSection.className == "DList" && templateSection.defaultItem){
					itemToAddName = templateSection.items[templateSection.defaultItem]
				}
				var qconfirmOptions = {templateUrl: 'addTemplate_'+ templateSection.className +'_index.html',
					section: templateSection,
					allMeasurementType: allMeasurementType,
					showMeasurementType: $scope.template.type == 20,
					itemToAdd : {
						name : itemToAddName,
					},
					selectDefaultItem: function(key){
						this.section.defaultItem = key;
						this.itemToAdd.name = this.section.items[key];
					},
					updateItemInItems: function(){
						if(this.section.defaultItem !== undefined){
							this.section.items[this.section.defaultItem] = this.itemToAdd.name;
						}else{
							this.section.items.push(this.itemToAdd.name);
							this.section.defaultItem = this.section.items.length -1;
						}
					},
					updateAndAddOnEnter: function(event){
						if(event.key === 'Enter') {
							if(this.section.defaultItem){
								this.section.items[this.section.defaultItem] = this.itemToAdd.name;
							}
							this.section.defaultItem = undefined;
							this.itemToAdd.name = undefined;
							angular.element(document.getElementById('itemToAddId')).focus();
						}
					},
					addItemInItems: function(){
						this.section.defaultItem = undefined;
						this.itemToAdd.name = undefined;
						angular.element(document.getElementById('itemToAddId')).focus();
					},
					deleteItemInItems: function(){
						this.section.items.splice(this.section.defaultItem, 1)
						if(this.section.items.length > 0){
							this.section.defaultItem = 0
							this.itemToAdd.name = this.section.items[0];
						}else{
							this.section.defaultItem = undefined;
							this.itemToAdd.name = undefined;
						}
					},
					moveUpInArray: function(){
						if(this.section.defaultItem>0){
							[this.section.items[this.section.defaultItem-1], this.section.items[this.section.defaultItem]] 
								= [this.section.items[this.section.defaultItem], this.section.items[this.section.defaultItem-1]];
							this.section.defaultItem = this.section.defaultItem-1
						}
					},
					moveDownInArray: function(){
						if(this.section.defaultItem<this.section.items.length-1){
							[this.section.items[this.section.defaultItem+1], this.section.items[this.section.defaultItem]] 
								= [this.section.items[this.section.defaultItem], this.section.items[this.section.defaultItem+1]];
							this.section.defaultItem = this.section.defaultItem+1;
						}
					},
					qconfirm: {
						hideNo: true,
						yesTitle: "Add",
						beforeYes: function(e, obj){
							if(obj.qconfirm.frm && obj.qconfirm.frm.$valid){
								if(obj.section.className === "DList" && !obj.section.defaultItem){
									obj.section.defaultItem = 0;
								}
								if(obj.section.isNew){
									indexInserted = $scope.templateText.addElementToTemplateText(obj.section)
									obj.section.isNew = false;
									$scope.template.sections.splice(indexInserted, 0, obj.section);
								}else{
									index = $scope.template.sections.findIndex((x)=> x.templateSectionID == obj.section.templateSectionID);
									$scope.template.sections[index] = obj.section;
									$scope.templateText.updateElementInTemplateText(obj.section)
								}
							}else{
								obj.qconfirm.frm.errorMsgs = PatientFormService.getFormErrors(obj.qconfirm.frm);
								e.prevent();
							}
						}
					}
				};
				QConfirm.open(qconfirmOptions, {windowClass:'templatSectionemodal'}).then(function(){});
			}
			
			function checkTemplateOwnership(){
				if($scope.template.userId != model.user().sessionUser.user.id && !$scope.template.isNew){
					var qconfirmOptions = {
						title: $filter('translate')('editAnotherUserTemplateAlert'),
						qconfirm:{
							hideCancel: true
						}
					};
					QConfirm.open(qconfirmOptions, {windowClass:'templatSectionemodal'}).then(function(proceed){
						if(!proceed){
							$scope.closeEditMode()
						}
					});
				}
			}
			
			$scope.closeEditMode = function(){
				unregisterDirty();
				$scope.editDisplay.inEditMode = false;
				model.templateLstUpdated(true);
			}
			
			$scope.isSaving = false;
			$scope.saveTemplate = function(){
				$scope.template.sections = $scope.templateText.updateSections();
				if($scope.templateFrm && $scope.templateFrm.$valid 
						&& $scope.template.sections && $scope.template.sections.length > 0){
					$scope.isSaving = true;
					$scope.template.text = createTemplateText();
					toSave = angular.copy($scope.template);
					delete toSave.sections;
					return templateAccessor.saveTemplate(toSave, function(res){
						$scope.isSaving = false;
						if(res.data){
							if($scope.template.isNew){
								model.template().chosenTypeList.unshift(res.data)
							}else{
								index = model.template().chosenTypeList.findIndex((e) => e.id == $scope.template.id);
								if(index != -1) model.template().chosenTypeList[index] = res.data;
							}
						}
						$scope.closeEditMode();
					}, function(err) {
						model.notice().fail($filter('translate')('error') + ": " + err);										
						$scope.isSaving = false;
					});
				}else{
					var msg = 'PatientSaveInvalidForm';
					model.notice().fail($filter('translate')(msg));
					return $q(function(resolve, reject) {
						reject($filter('translate')(msg));
					});
				}
			}
			
			$scope.deleteTemplate = function(){
				var qconfirmOptions = {
					title: $filter('translate')('delete_num_file'),
				};
				QConfirm.open(qconfirmOptions, {windowClass:'templatSectionemodal'}).then(function(proceed){
					if(proceed){
						$scope.isSaving = true;
						toSave = angular.copy($scope.template);
						delete toSave.sections;
						toSave.isActif = false;
						templateAccessor.saveTemplate(toSave, function(){
							$scope.isSaving = false;
							let i = model.template().chosenTypeList.findIndex((e) =>e.id == $scope.template.id);
							model.template().chosenTypeList.splice(i, 1);
							$scope.closeEditMode();
						}, function(err) {
							console.log(err);
							model.notice().warn($filter('translate')('error') + ": " + err);										
							$scope.isSaving = false;			
						});
					}
				});
			
			}
			
			function createTemplateText(){
				var pos = 0;
				var text = ""; 
				for(let i = 0; i < $scope.template.sections.length; i++){
					let sectionText = buildSectionText($scope.template.sections[i]);
					$scope.template.sections[i].start = pos;
					pos += sectionText.length;
					$scope.template.sections[i].end = pos;
					pos++; 
					text += sectionText;
				}
				return text;
			}
			
			function buildSectionText(section){
				if(section.className == 'DRaw'){
					return section.raw.replace(/([\u200B]+|[\u200C]+|[\u200D]+|[\u200E]+|[\u200F]+|[\uFEFF]+)/g, '');
				}else if(section.className == 'DRawBreak'){
					return "\n"
				}else if(section.className == 'DText'){
					return ("<text name=\"" + section.name + "\""
							+ (section.maxLen ? " maxlen=" + section.maxLen : "")
							+ (section.width ? " width=" + section.width : "")
							+ (section.height ? " height=" + section.height : "")
							+ " typeDeDonnee=0"
							+ (section.wrap ? " wrap=1" : " wrap=0")
							+ (section.required ?" required" : "")
							+ " />");
				}else if(section.className == 'DNum'){
					return "<num name=\""+ section.name + "\""
							+ (section.max ? " max="+ section.max : "")
							+ (section.digits ? " digits="+ section.digits : "")
							+ " typeDeMesure=" + allMeasurementType.find(e => e.name ==section.typeDeMesure).id
							+ (section.required ?" required" : "")
							+ " />";
				}else if(section.className == 'DDate'){
					return "<date name=\"" + section.name + "\"" 
							+ (section.allowPast ? " allowPast=1" : "")
							+ (section.allowFuture ?" allowFuture=1" : "")
							+ (section.todayAuto ?" todayAuto=1" : "")
							+ (section.required ?" required" : "")
							+ " />";
				}else if(section.className == 'DList'){
					innerText = "";
					for(let i = 0; i < section.items.length; i++){
						if(i!=0){
							innerText += ";";
						}
						innerText+=section.items[i];
					}
					return "<list name=\""+ section.name + "\""
							+ " separator=\", \""
							+ (section.multiple ?" multiple=1" : " multiple=0")
							+ " typeDeDonnee=0"
							+ (section.required ?" required" : "")
							+ " defaultItem=" + section.defaultItem + ">"
							+ innerText
							+ "</list>";
				}else{
					return "";
				}
			}
			
			checkTemplateOwnership();
			
		}
	]);
	
	/**
	 * COMMENT: TEMPLATE TEXT @directive
	 *
	 * Cette directive gère la section texte du gabarit. Le texte est séparé en plusieurs sections avec le 
	 * principe de tokenisation afin de créer un éditeur de texte personnalisé
	 *
	 */
	template.directive('templateText', ['$compile', 'model',
							function($compile, model){
		return {
			restrict: 'E',
			scope: true,
			link: function(scope, element, attrs){
				
				
				function loadTemplateSection(){
					let templateSectionRaw = {className : "DRaw", required: false, isNew: true, raw:""};
					if(scope.template.sections && scope.template.sections){
						for(let i = 0; i < scope.template.sections.length; i++){
							if(scope.template.sections[i].className == "DRaw"){
								split = scope.template.sections[i].raw.split(/(\n)/g);
								for(let j = 0; j < split.length; j++){
									let newSection;
									if(split[j] == "\n"){
										newSection = {className : "DRawBreak", required: false, isNew: true, raw:"\n"};
									}else{
										newSection = {className : "DRaw", required: false, isNew: true, raw:split[j]};
									}
									if(j == 0){
										scope.template.sections[i] = newSection;
									}else{
										scope.template.sections.splice(i+j, 0, newSection);
									}
								}
							}
							scope.templateText.addElementToTemplateText(scope.template.sections[i]);
							if(!scope.template.sections[i].className.includes("DRaw")){
								scope.templateText.addElementToTemplateText(templateSectionRaw);
							}
						}
					}
				}
				
				function prepareRawTextForHtml(string){
					string = string.replace(/([\u200B]+|[\u200C]+|[\u200D]+|[\u200E]+|[\u200F]+|[\uFEFF]+)/g, '')
//					string = string.replace(/([\n])/g, '<span class="pre-line" name="DRawBreak" contenteditable="false">\u200D\n\u200D</span>')
					return string;
				}
				
				//Token utilisé pour les line-break
				var htmlBreakString = '<span class="pre-line" name="DRawBreak" contenteditable="false">\n\u200D</span>';
				var templateSectionID = 0;
				//-1 si position non trouvé ou template-text non touché
				var caretLastPosition = -1;
				var selectedCaretElement = undefined;

				scope.templateText.addElementToTemplateText = function(templateSection){
					var span;
					if(templateSection.className =="DRaw"){
						let raw = prepareRawTextForHtml(templateSection.raw);
						span = angular.element('<span id="section_'+ templateSectionID +'" class="pre-line" name='+ templateSection.className +'>'+ raw +'</span>')
					}else if(templateSection.className =="DRawBreak"){
						span = angular.element('<span id="section_'+ templateSectionID +'" class="pre-line" name='+ templateSection.className +' contenteditable="false">\u200D\n\u200D</span>')
					}else{
						span = angular.element('<span id="section_'+ templateSectionID +'" class="pointer-only" contenteditable="false" name='+ templateSection.className +' data-ng-click="selectSection('+ templateSectionID +')"><b><u>['+ templateSection.name +']</u></b></span>')
					}
					templateSection.templateSectionID = templateSectionID;
					templateSectionID++;
					let temp = $compile(span)(scope);
					elementSelected = selectedCaretElement ? element.find("#" + selectedCaretElement)[0] : undefined;
					if(caretLastPosition == -1 || (!elementSelected && selectedCaretElement != 'template-text')){
						element.append(temp[0]);
					}else if(selectedCaretElement == 'template-text'){
						element[0].childNodes[caretLastPosition].insertAdjacentElement('beforeBegin', temp[0]);
					}else if((!elementSelected.getAttribute || elementSelected.getAttribute("name") == "DRaw") && caretLastPosition > 0){
						let firstPart = prepareRawTextForHtml(elementSelected.textContent.substring(0, caretLastPosition));
						let secondPart = prepareRawTextForHtml(elementSelected.textContent.substring(caretLastPosition));
						span = angular.element('<span id="section_'+ templateSectionID +'" class="pre-line" name="DRaw">'+ secondPart +'</span>')
						let temp2 = $compile(span)(scope);
						elementSelected.insertAdjacentElement('afterend', temp2[0]);
						elementSelected.insertAdjacentElement('afterend', temp[0]);
						elementSelected.innerText = firstPart;
						templateSectionID++;
					}else{
						elementSelected.insertAdjacentElement('afterend', temp[0]);
					}
					return Array.from(element[0].childNodes).findIndex(e => e == temp[0]);
				}
				
				scope.templateText.updateElementInTemplateText = function(templateSection){
					if(templateSection.className =="DRaw"){
						element[0].querySelector('#section_'+ templateSection.templateSectionID).innerText = templateSection.raw;
					} else {
						element.find('#section_'+ templateSection.templateSectionID).html('<b><u>[' + templateSection.name + ']</u></b>');
					}
				}
				
				//Synchronise les champs texte et les sections dans l'objet "template"
				scope.templateText.updateSections = function(){
					var newTemplateSection = []
					for(let i = 0; i < element[0].childNodes.length; i++){
						if(element[0].childNodes[i].getAttribute("name") == "DRaw" || element[0].childNodes[i].getAttribute("name") == "DRawBreak"){
							if(scope.template.sections.findIndex(e => ("section_" + e.templateSectionID) == element[0].childNodes[i].id) == -1){
								let section = {
									className: "DRaw",
									raw: element[0].childNodes[i].textContent,
									required: false,
									templateSectionID: parseInt(element[0].childNodes[i].id.slice(8)),
								}
								scope.template.sections.splice(i, 0, section);
								newTemplateSection.push(section);
							}else{
								newTemplateSection.push(scope.template.sections.find(e => {
									if(("section_" + e.templateSectionID) == element[0].childNodes[i].id){
										e.raw = element[0].childNodes[i].textContent;
										return e;
									}
								}));
							}
						}else{
							let index = scope.template.sections.findIndex(e => ("section_" + e.templateSectionID) == element[0].childNodes[i].id);
							if(index != -1){
								newTemplateSection.push(scope.template.sections[index]);
							}
						}
					}
					return newTemplateSection;
//					for(let i = scope.template.sections.length - 1; i >= 0; i--){
//						if(!templateID.includes(scope.template.sections[i].templateSectionID)){
//							scope.template.sections.splice(i, 1)
//						}
//					}
				}
				
				var arrowPosition = -1;
				scope.addLineBreak = function(event){
					var doc = element[0].document || element[0].ownerDocument
					var win = doc.defaultView || doc.parentWindow;
					var sel = win.getSelection();
					var range = sel.getRangeAt(0).cloneRange();
					var updateRange = false;
					if(event.key === 'Enter') {
						event.preventDefault();
						updateRange = true;
						let span = angular.element(htmlBreakString);
						let temp = $compile(span)(scope);
						let offset;
						if(range.endContainer.parentElement.nodeName == "SPAN"){
							let firstPart = prepareRawTextForHtml(range.endContainer.parentElement.textContent.substring(0, range.endOffset));
							let secondPart = prepareRawTextForHtml(range.endContainer.parentElement.textContent.substring(range.endOffset));
							span = angular.element('<span id="section_'+ templateSectionID +'" class="pre-line" name="DRaw">'+ secondPart +'</span>')
							let temp2 = $compile(span)(scope);
							range.endContainer.parentElement.insertAdjacentElement('afterend', temp2[0]);
							range.endContainer.parentElement.insertAdjacentElement('afterend', temp[0]);
							range.endContainer.parentElement.innerText = firstPart;
							templateSectionID++;
							offset = Array.from(element[0].childNodes).indexOf(range.startContainer)+2;
						}else if(range.endContainer.parentElement.id == "template-text" && range.endContainer.nodeName == "SPAN"){
							span = angular.element('<span id="section_'+ templateSectionID +'" class="pre-line" name="DRaw"></span>')
							let temp2 = $compile(span)(scope);
							if(range.startOffset===0){
								range.endContainer.insertAdjacentElement('beforebegin', temp2[0]);
								range.endContainer.insertAdjacentElement('beforebegin', temp[0]);
							}else{
								range.endContainer.insertAdjacentElement('afterend', temp[0]);
								range.endContainer.insertAdjacentElement('afterend', temp2[0]);
							}
							offset = Array.from(element[0].childNodes).indexOf(range.startContainer);
						}else{
							span = angular.element('<span id="section_'+ templateSectionID +'" class="pre-line" name="DRaw"></span>')
							let temp2 = $compile(span)(scope);
							range.insertNode(temp[0]);
							range.insertNode(temp2[0]);
							offset = range.endOffset
							templateSectionID++
						}
						if(element[0].childNodes.length < offset)offset = element[0].childNodes.length-1
						range.setStart(element[0].childNodes[offset], 0)
					}else if(event.key === "ArrowUp"){
						event.preventDefault();
						updateRange = true;
						let newPos = arrowPosition;
						if(arrowPosition == -1)newPos = range.startOffset;
						var endContainer = range.startContainer
						if(range.startContainer.nodeName === "#text")endContainer = endContainer.parentElement
						else if(range.startContainer.nodeName === "TEMPLATE-TEXT"){
							endContainer = endContainer.childNodes[range.startOffset];
							newPos = 0;
						}
						let lineBreakFound = false;
						if(endContainer.previousSibling)endContainer = endContainer.previousSibling;
						while(endContainer.previousSibling && endContainer.getAttribute("name") != "DRawBreak"){
							if(arrowPosition == -1){
								if(endContainer.getAttribute("name") == "DRaw"){
									newPos += endContainer.textContent.length;
								}else{
									newPos += 1;
								}
							}
							endContainer = endContainer.previousSibling
						}
						if(arrowPosition == -1)arrowPosition = newPos;
						if(endContainer.previousSibling){
							endContainer = endContainer.previousSibling
							lineBreakFound=true
							while(endContainer.previousSibling && endContainer.previousSibling.getAttribute("name") != "DRawBreak"){
								endContainer = endContainer.previousSibling;
							}
							while(endContainer.nextSibling){
								if(endContainer.getAttribute("name") == "DRawBreak"){
									endContainer = endContainer.previousSibling
									if(endContainer.childNodes[0])endContainer=endContainer.childNodes[0]
									newPos = endContainer.textContent.length;
									break;
								}else if(endContainer.getAttribute("name") == "DRaw"){
									if(endContainer.textContent.length >= newPos){
										if(endContainer.childNodes[0])endContainer=endContainer.childNodes[0]
										break
									}else{
										newPos -= endContainer.textContent.length;
									}
								}else{
									newPos -= 1;
								}
								endContainer = endContainer.nextSibling
							}
						}
						if(!lineBreakFound){
							newPos = 0
						}
						range.setStart(endContainer, newPos);
					}else if(event.key === "ArrowDown"){
						event.preventDefault();
						updateRange = true;
						let newPos = arrowPosition;
						if(arrowPosition == -1)newPos = range.startOffset;
						var endContainer = range.startContainer
						if(range.startContainer.nodeName === "#text")endContainer = endContainer.parentElement
						else if(range.startContainer.nodeName === "TEMPLATE-TEXT"){
							endContainer = endContainer.childNodes[range.startOffset];
							if(arrowPosition == -1)newPos = 0;
						}
						let lineBreakFound = false;
						startContainer = endContainer.previousSibling;
						if(arrowPosition == -1){
							while(startContainer && startContainer.getAttribute("name") != "DRawBreak"){
								if(startContainer.getAttribute("name") == "DRaw"){
									newPos += startContainer.textContent.length;
								}else{
									newPos += 1;
								}
								startContainer = startContainer.previousSibling
							}
							arrowPosition = newPos;
						}
						while(endContainer.nextSibling){
							endContainer = endContainer.nextSibling
							if(endContainer.getAttribute("name") == "DRawBreak" && !lineBreakFound){
								lineBreakFound=true;
							}else if(endContainer.getAttribute("name") == "DRawBreak" && lineBreakFound){
								endContainer = endContainer.previousSibling
								if(endContainer.childNodes[0])endContainer=endContainer.childNodes[0]
								newPos = endContainer.textContent.length;
								break;
							}else if(endContainer.getAttribute("name") == "DRaw" && lineBreakFound){
								if(endContainer.textContent.length >= newPos){
									if(endContainer.childNodes[0])endContainer=endContainer.childNodes[0]
									break
								}else{
									newPos -= endContainer.textContent.length;
								}
							}else if(lineBreakFound){
								newPos -= 1;
							}
						}
						if(!lineBreakFound || endContainer.textContent.length <= newPos){
							if(endContainer.childNodes[0]){
								endContainer = endContainer.childNodes[0]
							}
							newPos = endContainer.textContent.length
						}
						range.setStart(endContainer, newPos);
					}else{
						arrowPosition = -1;
					}
					if(updateRange){
						range.collapse(true);
						sel.removeAllRanges();
						sel.addRange(range);
						element.focus();
					}
				}
				
				var isParentTemplateText = false
				var openedSectionFromTemplateText = false;
				
				scope.getDRawChildNode = function(){
					scope.templateFrm.$setDirty()
					for(let i = 0; i < element[0].childNodes.length; i++){
						 if(element[0].childNodes[i].nodeName === "#text"){
							span = angular.element('<span id="section_'+ templateSectionID +'" class="pre-line" name="DRaw">'+ element[0].childNodes[i].textContent +'</span>');
							var templateSection = {className : "DRaw", required: false, isNew: true, raw:element[0].childNodes[i].textContent, templateSectionID: templateSectionID};
							let temp = $compile(span)(scope);
							element[0].replaceChild(temp[0], element[0].childNodes[i]);
							scope.template.sections.splice(i, 0, templateSection);
							templateSectionID++;
						}else if(element[0].childNodes[i].nodeName === "SPAN" && !element[0].childNodes[i].getAttribute("name")){
							span = angular.element('<span id="section_'+ templateSectionID +'" class="pre-line" name="DRaw">'+ element[0].childNodes[i].textContent +'</span>');
							var templateSection = {className : "DRaw", required: false, isNew: true, raw:element[0].childNodes[i].textContent, templateSectionID: templateSectionID};
							let temp = $compile(span)(scope);
							element[0].replaceChild(temp[0], element[0].childNodes[i]);
							scope.template.sections.splice(i, 0, templateSection);
							templateSectionID++;
						}else if(element[0].childNodes[i].nodeName === "SPAN" && element[0].childNodes[i].getAttribute("name") == "DRawBreak"){
							if(!element[0].childNodes[i].id){
								element[0].childNodes[i].id = "section_" + templateSectionID;
								var templateSection = {className : "DRawBreak", required: false, isNew: true, raw:"\n", templateSectionID: templateSectionID};
								scope.template.sections.splice(i, 0, templateSection);
								templateSectionID++;
							}
						}
					}
					if(isParentTemplateText){
						selectedCaretElement = element[0].childNodes[selectedCaretElement].id
					}
				}
				
				scope.getLastCaretPosition = function(){
					if(!openedSectionFromTemplateText){
//						arrowPosition = -1;
						caretLastPosition = -1;
						selectedCaretElement = undefined;
						isParentTemplateText = false;
						var doc = element[0].document || element[0].ownerDocument
						var win = doc.defaultView || doc.parentWindow;
						if (typeof win.getSelection != "undefined") {
					        sel = win.getSelection();
					        if (sel.rangeCount > 0) {
					            var range = sel.getRangeAt(0).cloneRange();
//					            var preCaretRange = range.cloneRange();
//					            preCaretRange.selectNodeContents(element[0]);
//					            preCaretRange.setEnd(range.endContainer, range.endOffset);
								if(range.endContainer.id == "template-text"){
					           		caretLastPosition = range.endContainer.childNodes.length == range.endOffset ? -1 : range.endOffset;
									selectedCaretElement = range.endContainer.id;
								}else if(range.endContainer.nodeName === "#text"){
									caretLastPosition = range.endOffset;
									if(range.endContainer.parentElement.id == "template-text"){
										isParentTemplateText = true;
										selectedCaretElement = Array.from(range.endContainer.parentElement.childNodes)
																	.indexOf(range.endContainer)
									}else{
										selectedCaretElement = range.endContainer.parentElement.id
									}
								}else{
					            	caretLastPosition = range.endOffset;
									selectedCaretElement = range.endContainer.id
								}
					        }
					    } else if ( (sel = doc.selection) && sel.type != "Control") {
					        var textRange = sel.createRange();
					        var preCaretTextRange = doc.body.createTextRange();
					        preCaretTextRange.moveToElementText(element[0]);
					        preCaretTextRange.setEndPoint("EndToEnd", textRange);
					        caretLastPosition = preCaretTextRange.text.length;
					    }
					    scope.getDRawChildNode();
					}else{
						openedSectionFromTemplateText = false;
					}
				}
				
				scope.selectSection = function(id){
					scope.getLastCaretPosition();
					openedSectionFromTemplateText = true;
					scope.openTemplateSection(scope.template.sections.find(e=> e.templateSectionID == id))
				}

				scope.getSectionToCopy = function(e){
					e = e.originalEvent;
					var selectedText = window.getSelection();
					e.clipboardData.setData('text/plain', selectedText.toString());
					e.preventDefault();
				}
				
				scope.pasteObj = function(event){
					window.getSelection().deleteFromDocument();
					scope.getLastCaretPosition();
					var text = event.originalEvent.clipboardData.getData("text/plain");
					var text2 = event.originalEvent.clipboardData.getData("text/html");
					event.preventDefault();
					text = text.replace(/(\r)/gm, "");
					text = text.split(/(\n)/g);
					if(caretLastPosition == -1)text.reverse();
					for(let i = text.length-1; i >= 0; i--){
						let newSection;
						if(text[i] == "\n"){
							newSection = {className : "DRawBreak", required: false, isNew: true, raw:"\n"};
						}else{
							newSection = {className : "DRaw", required: false, isNew: true, raw:text[i]};
						}
						scope.templateText.addElementToTemplateText(newSection);	
					}
				}
				loadTemplateSection();
				
            }
        }
    }]);
	
})();