(function(){
	var app = angular.module("site", []);

	app.factory('SiteAccessor', ['DashAPI', 'MessageLink','$filter', function(DashAPI, MessageLink, $filter) {
		var accessor = {
			findFixedPharmacies: function (queryObject, callback, error){
				var q = '?searchString='+queryObject.searchString;
				return DashAPI.get("/dashboard/site/ws/findFixedPharmacies" + q, callback, error);
			},
			get: function (queryObject, callback, error){
				var q = '?id='+queryObject.id;
				return DashAPI.get("/dashboard/site/ws/get" + q, callback, error);
			},
			findSiteB2bLogs: function(site, callback, error){
				var q = '?idSite='+site.id + '&limit=20';
				return DashAPI.get('/dashboard/site/ws/findSiteB2bLogHeaders'+q, callback, error);
			},
			readB2bSyncLog: function(logId, callback, error){
				var q = '?idB2bSiteLog='+logId ;
				return DashAPI.get('/dashboard/site/ws/readB2bSyncLog'+q, callback, error);
			},
			save: function(site, callback, error){
				return DashAPI.post('/dashboard/site/ws/save', site, callback, error);
			}
		};

//		SiteAccessor.findFixedPharmacies({searchString:stringToSearch}, function(){
//			scope. = 2;// Send success
//		});

		return accessor;
	}]);

	app.controller('SiteController', 
		['$scope', 'model', 'ModificationStatus', '$stateParams', '$timeout','hotkeys','UserAccessor','QValidation','$filter',
		function ($scope, model, ModificationStatus, $stateParams, $timeout, hotkeys, UserAccessor, QValidation, $filter) {
		
		model.activeController('st');
		model.activeMenu('Site');
		$scope.focusable = {};
		model.site().q = "";
		$scope.patientListPlaceholder =  "findUser";

		$scope.isLoadingList = false;
		$scope.listSize = function(){
			return model.site().tab.currList.length;
		}
		
		$scope.userSearchable = [];
		UserAccessor.listUsersForSelection(function(res){
		 	$scope.userSearchable = UserAccessor.cleanAndSortUsers(res.data);
		});

		$scope.addNewSite = function(){
			model.site().tab.currSite = {
				className: "CSite",
				modificationStatus: ModificationStatus.STATUS_NEW
			}
		}
		$scope.showSearchFilters = function(){
			model.site().tab.showFilters = !model.site().tab.showFilters;
		}
		
		function getWorkSites(){
			return _.values(model.user().sites).filter(e=>e.isWorkSite).sort(siteSortByName);
		}

		$scope.select = function(site){
			QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
				if(successful){
					model.site().tab.currSite = site;
				}
			});
		}

		$scope.isActive = function(site){
			if(model.site().tab.currSite){
				return site.id == model.site().tab.currSite.id;
			}
			return false;
		}

		function siteSortByName(a,b){
			return a.nameCommon.localeCompare(b.nameCommon);
		}

		$scope.search = function(){
			var q = "";
			if(model.site().tab.q != undefined && model.site().tab.q != ""){
				q = model.site().tab.q.toLowerCase().removeAccentsLc();
			}
			var txt;
			model.site().tab.currList = _.values(model.user().sites).filter(e=>{
				if(model.site().tab.searchFilters.type === "pharmacies" && !e.isDrugStore){
					return false;
				}
				if(model.site().tab.searchFilters.type === "workSite" && !e.isWorkSite){
					return false;
				}
				if(model.site().tab.searchFilters.type === "other" && (e.isDrugStore || e.isWorkSite)){
					return false;
				}
				if(e.isDeleted && !model.site().tab.searchFilters.inactive){
					return false;
				}
				txt = (e.nameOfficial + " " + e.nameCommon).toLowerCase().removeAccentsLc();
				return OfysUtils.matchInRegExpArray(OfysUtils.searchRegExpArray(q, 0), txt)
			}).sort(siteSortByName);
			model.searchSiteUpdated(true);
		}
		$scope.siteEditOptions = {
			showExit: true,
			exit: function(){
				delete model.site().tab.currSite;
			},
			onSave: function(p){
				var i = model.site().tab.currList.findIndex(function(e){
					return p.id == e.id;
				})
				if(i == -1){
					model.site().tab.currList.push(p);
				}
			}
		};
		model.site().tab.currList = getWorkSites();
		model.callDashBoardCount();
	}]);

})();