(function () {
    var mod = angular.module('mod', [])

	mod.constant('LoadStatus', 
	{
		UNLOADED : 0, 
		LOADING : 1,
		LOADED : 2, 
		FAILED : 3 ,
        RELOAD : 4,
        mustLoad: function(state){
            return state !== this.LOADING && state !== this.LOADED;
        }
    });
    
    mod.factory('model', ['$q','LoadStatus', '$log', '$http', '$timeout', '$interval', '$filter', '$location', 'PrefAccessor','Store',
        function ($q, LoadStatus, $log, $http, $timeout, $interval, $filter, $location, PrefAccessor, Store) {
            var m = this;
            m.activeMenu = $location.$$path.substring(1);

            if (AutoComplete) {
                AutoComplete.isWebVersion = true;
            }

            //When an external quickview is open, the model should not be recreated but the parent model is used.
            //		if(m.activeMenu == QV_EXTERNAL_PATH.substring(1)){
            //			return {};
            //		}

            m.appointment = {
                currList: [],
                loaded: false,
                showMenu: true,
				toCut: false
            };
			m.appointmentResearch = {
				currList: [],
				loaded: false,
				criteria: {},
				searchtype: 'simple',
				showSearchOption: true
			}
			m.research = {
				currList:[],
				loaded: 1,
				activity: true,
				activitiesType : [
					{name: 'Documents', selected: false, class: 'col-xs-6', icon:"fa-file-text-o", id:1},
					{name: 'Laboratories', selected: false, class: 'col-xs-6', icon:"fa-flask", id:2},
					{name: 'ENCOUNTERS', selected: false, class:'col-xs-6', icon:"fa-folder-o", id:4}
				],
				advanceResearchTypes : [
					{val:0,name:'Documents'},
					{val:1,name:'lab_results_search'}
				],
				advanceResearchSelected: 0,
				selectedOption : [],
				chosenTab: 1,
				docList:[],
				laboList:[]
			};
	
            m.schedule = {
                currList: [],
                loaded: false,
                showMenu: true,
                showSideBar: true,
				showRightSideBar: true,
				profPrefList: [],
                status:LoadStatus.UNLOADED // for initial loading of the templates and schedule init data.
            };
	
            m.site = {
                tab: {
                    isLoadingList: true,
                    showFilters: false,
                    searchFilters:{
                        type: "all",// possible values ["all","pharmacies","other"]
                        inactive: false,
                    },
                    currList: []
                },
                loaded: false,
            };
			m.template = {
				chosenType: undefined,
				chosenTypeFilteredList:[],
				chosenTypeList: undefined,
				chosenTypeGlobalList: []
            };
            m.admin = {
                currentTab: null
            }

            m.crds = {
                tab:{

                },
                crdsUserList : [{}],
                loaded: false
            }

			m.recall = {
				currList: [],
				currRecall: {},
				searchData: {status: 1},
				copyRecall: null,
				inEditMode: false,
				isEditView: false
			}
            m.ressource = {
        		currList: [],
        		loaded: false,
        		showMenu: true,
        		edit: {
					currTab : 0, // 1: taxes, 2: secteur, 3:resources
					search: {
						responsablePmt: "",
						serviceType: "",
						activeRess: true,
					}
				}
            };
            
            m.billed = {
				chosenTab: 1,
				chosenReport: null,
				isEditable: false,
				searchReport:{
					reportType: null,
					startDate: moment().startOf('day').valueOf(),
					startDateS: moment().format('YYYY-MM-DD'),
					endDate: null,
					endDateS: null
				},
				listBilled : {},
			};

			m.print = {
				currList: [],
				chosenReport: null,
				printDef: null,
				listId: null,
				properties: [],
				chosenReportList: [],
				type:{id: null, type: null, date: null}
			}
			
			m.scan = {
				seenByProf: false,
				seenByProfAlert: true,
				createTask: false,
				createTaskAlert: true,
				viewType: undefined,
				state: "SO",
				selectedLabels: [],
				files: {
					selected: undefined,
					list: []
				},
				filesToEdit: {
					selected: undefined,
					list: []
				},
			}
            
            m.onlyActive = {
                'spAll': false,
                'spToDo': false,
                'prescr': false,
                'immun': true
            };

            m.loadingOverlay = {
                visible: false,
                message: "",
                hide: function () {
                    m.loadingOverlay.visible = false;
                },
                show: function (text, isTranslateKey, hideAnimation) {
                    if (text) {
                        var text2 = text;
                        if (isTranslateKey) {
                            text2 = $filter('translate')(text);
                        }
                        m.loadingOverlay.message = text2;
                    } else {
                        m.loadingOverlay.message = undefined;
                    }
                    m.loadingOverlay.visible = true;
                    m.loadingOverlay.hideLoadAnimation = !!hideAnimation;
                }
            };
            m.roles = {
                hasOneOfRoles: function (list, user) {
                    if (!user) {
                        user = m.user.sessionUser.user;
                    }
                    for (var i = 0; i < list.length; i++) {
                        if (user.role.indexOf(list[i]) > -1) {
                            return true;
                        }
                    }
                    return false;
                }
            };
            m.review = {
                currReviewTypes: {
                    doc: 'd',
                    lab: 'l',
                    none: 'n'
                },
                currReviewType: 'n'
            };
			m.utilPat = {
				contactTypes: ['Phone', 'MainEmail', 'Fax', 'Pager', 'OtherEmail', 'Cellphone', 'OtherCellphone', 'Iphone', 'OtherPhone'],
			};
            // quand on appelle le patient du model (model.patient()...), ça retourne le patient du controleur actif (pt ou rv).
            m.patient = {
                load: false
            };
            var patientDataPt = {
                contactTypes: ['Phone', 'MainEmail', 'Fax', 'Pager', 'OtherEmail', 'Cellphone', 'OtherCellphone', 'Iphone', 'OtherPhone'],
                currPatient: {},
                currentActive: -9999999,
                currList: []
            };
            // pt, rv et ress pour data a/a controleur patient ou appointment ou secteur
            m.patient.pt = patientDataPt;
            m.patient.rv = $.extend({}, patientDataPt);
            m.patient.ress = $.extend({}, patientDataPt);
			m.patient.template = $.extend({}, patientDataPt);
            m.activeController = '';

            m.listApptSize = 1;	// 1=25em, 2=3em, 3 = non actif
            m.listPatSize = 1;	// 1=25em, 2=3em, 3 = non actif
			m.listResearchSize = 1;
			m.listResearchOption = 1;
            m.prefSettings = {};

            // les patients ayant une ou des données ouvertes dans un QuickView.
            // objet dont la key = pat.id et dont le contenu pt est le meme que le patient() lorsque la qv est ouverte.
            // ex. m.patientsInQv['27162'].pt =  model.patient();	// il faut checker avant si item pas deja la.
            // m.patientsInQv['27162'].count = le nombre de quickview utilisant le patient. A chaque initialisation de qv, count++
            // voir model.patientsInQv(idpat, currpat)
            m.patientsInQv = {
                clearPatientsQueue: {}
            };
            m.docCached = {}; // liste des doc chargés. la clé = ids 
            m.labCached = {}; // liste des lab chargés. la clé = ids
            m.msgCached = {}; // liste des msg chargés. la clé = ids
            m.taskCached = {}; // liste des task chargés. la clé = ids
            m.mailCached = {}; // liste des mails chargés. la clé = ids

            //Patient
            m.patientAllDataTabs = [{
                    title: 'PatientData',
                    template: '/dashboard/resources/ofys/pat/pat_data/patient_data.html?v=bj'
                },
                {
                    title: 'ActivityHeading',
                    template: '/dashboard/resources/ofys/pat/pat_data/patient_chrono.html?v=bj'
                },
                {
                    title: 'PatientTabDSQ',
                    template: '/dashboard/resources/ofys/pat/pat_data/patient_dsq.html?v=bj'
                }
            ];

            m.patientQvAllDataTabs = [{
                    title: 'PatientData',
                    template: 'qv_patientdata_index.html'
                },
                {
                    title: 'PatientMedSummary',
                    template: 'qv_medsummary_index.html'
                },
                {
                    title: 'PatientTabDSQ',
                    template: '/dashboard/resources/ofys/pat/pat_data/patient_dsq.html?v=bj'
                }
            ];
            m.patientAllDataTabs.activeTab = 'PatientData';
            m.patientQvAllDataTabs.activeTab = 'PatientData';

            //User
            m.userAllDataTabs = [{
                    title: 'UserData',
                    template: '/dashboard/resources/ofys/pat/pat_data/patient_data.html?v=bj'
                },
            ];
            m.userQvAllDataTabs = [{
                    title: 'UserData',
                    template: 'qv_userdata_index.html'
                }   
            ];
            m.userAllDataTabs.activeTab = 'UserData';
            m.userQvAllDataTabs.activeTab = 'UserData';

            m.faxQvAllDataTabs = [{
                title: 's_Fax',
                template: 'qv_faxdata_index.html'
            }
            ];
            m.faxQvAllDataTabs.activeTab = 's_Fax';

            m.suiviPrevQvAllDataTabs = [{
                title: 's_suiviPrev',
                template: 'qv_suiviPrevdata_index.html'
            }
            ];
            m.suiviPrevQvAllDataTabs.activeTab = 's_Fax';

            var allBindNotifiers = [
                'encounterUpdated',
                'userUpdated',
                'userDataUpdated',
                'patientUpdated',
                'patientDataUpdated',
                'courrielDataUpdate',
                'taskDataUpdate',
                'courrielViewUpdate',
                'formDataUpdated',
                'srvyDataUpdated',
                'docDataUpdated',
                'labDataUpdated',
                'patientChronoUpdated',
                'patientSumUpdated',
                'actUpdated',
                'translationUpdate',
                'formLinkUpdated',
                'editModeUpdated',
                'searchPtUpdated',
                'ressLstUpdated',
                'apptLstUpdated',
                'apptUpdated',
                'refreshCountsUpdated',
                'docCntsUpdated',
                'labCntsUpdated',
                'searchSiteUpdated',
				'templateLstUpdated',
                'adminPageUpdate',
                'invoiceUpdated',
                'sofiaUpdated',
            ];
            m.notifierTimers = {};
            allBindNotifiers.forEach(function(notifierKey){
                m[notifierKey] = {val: 0};
            })

            function notifierGetSet(key){
                return function (v) {
                    if (arguments.length && !m.notifierTimers[key]) {
                        m.notifierTimers[key] = $timeout(function () {
                            m[key].val++;
                            delete m.notifierTimers[key];
                        }, 100);
                    }
                    return m[key];
                }
            }
            // m.encounterUpdated = {
            //     val: 0
            // };
            // m.userUpdated = {
            //     val: 0
            // };
            // m.userDataUpdated = {
            //     val: 0
            // };
            // m.patientUpdated = {
            //     val: 0
            // };
            // m.patientDataUpdated = {
            //     val: 0
            // };
            // m.courrielDataUpdate = {
            //     val: 0
            // };
            // m.courrielViewUpdate = {
            //     val: 0
            // };
            // m.formDataUpdated = {
            //     val: 0
            // };
            // m.docDataUpdated = {
            //     val: 0
            // };
            // m.labDataUpdated = {
            //     val: 0
            // };
            // m.patientChronoUpdated = {
            //     val: 0
            // };
            // m.patientSumUpdated = {
            //     val: 0
            // };
            // m.actUpdated = {
            //     val: 0
            // };
            // m.translationUpdate = {
            //     val: 0
            // };
            // m.formLinkUpdated = {
            //     val: 0
            // };
            // m.editModeUpdated = {
            //     val: 0
            // };
            // m.searchPtUpdated = {
            //     val: 0
            // };
            // m.ressLstUpdated = {
            //     val: 0
            // };
            // m.apptLstUpdated = {
            //     val: 0
            // };
            // m.refreshCountsUpdated = {
            //     val: 0
            // };
            // m.docCntsUpdated = {
            //     val: 0
            // };
            // m.labCntsUpdated = {
            //     val: 0
            // };
            m.webSocketActivity = {
                val: 0,
                last: 0
            };

			m.suiviPrevs = {
				baseFetched: false,
				profFetched: false,
				textFetched: false,
				base: [],
				prof: [],
				text: [],
				pat: {}
			};
            m.laboratory = {
                currList: {}
            };
            m.document = {
                currList: {}
            };
            m.forms = {
                availables: [],
                favorites: [],
                crds: {
                    //array of cform
                    list: undefined,
                    //array of string -> cform.code
                    codes: undefined
                },
            };
            m.labels = {
                data: [],
                fetched: false
            };
            m.home = {
                dsqAppointmentCallInProgress: false
            };
            // removed allInbox:{}, allSent: {}, allArchived: {}, 
            // val set to null dans $interval afin de forcer un refresh après x min.
//            m.chat = {
//                linkContext: {},
//                currList: [],
//                currType: 'N',
//                currIds: [],
//                ids: {},
//                perPage: 10,
//                pageNb: 1
//            };
            // voir aussi m.msgCached

            m.task = {
                load: false,
                currFilterShorcut: 'NB_TASK_ALL',
                filterTypes: {
                    viewbag: {
                        completed: 0
                    }
                },
                listSubMenu: 'A',
                tabLoaded: false,
                //searchFilter: {}, null by default if it exist then the filters are applied
                todo: [],
            };
            m.courriel = {
        		load: false,
        		activeCourrielFolder: 1,
        		tabLoaded: false,
        		mails: [],
//        		folders:{'1':{name:'Nouveau',ids:[]}, '2':{name:'Inbox',ids:[]}, '3':{name:'Archivés',ids:[]}, '4':{name:'Envouyés',ids:[]},
//        				'5':{name:'Important',ids:[]}, '6':{name:'Patients',id:2}, '7':{name:'Médecins', ids:[]}, '8':{name:'Party',ids:[]}}
                folders:{'1':[], '2':[], '3':[], '4':[], '5':[], '6':[], '7':[], '8':[], '9':[], '10':[], '11':[], '12':[], '13':[], '14':[], '15':[], '16':[], '17':[], '18':[], '19':[], '20':[]},
                clearFolders: function(){
                    var courriels = this;
                    Object.keys(courriels.folders).forEach(function(key){
                        courriels.folders[key] = [];
                    });
                },
                setFolders: function(f){
                    var courriels = this;
                    // courriels.activeCourrielFolder = 1;
                    // this.clearFolders();
                    $.extend(courriels.folders, f);
                    model.courrielDataUpdate(true);
                }
            };
            m.search = {
                hasResult: false,
                query: ""
            };
            m.ress = {
            	secteur: [],
            	taxes: [],
            	defData: [],
                isActive: function(){
                    return this.secteur.length > 0 && this.defData.length > 0;
                }
            };
            m.user = {
                isMd: function () {
                	if (m.user.isMdVal!=undefined) return m.user.isMdVal;
                    if (m.user.profil && m.user.isProf && (m.user.profil.professionalType === "MD_OMNIPRATICIEN" || m.user.profil.professionalType === "MD_SPECIALISTE")) {
                    	m.user.isMdVal = true;
                    } else {
                    	m.user.isMdVal = false;
                    }
                    return m.user.isMdVal;
                },
                isIPS: function(){
                	if (m.user.isIPSVal!=undefined) return m.user.isIPSVal;
                    if (m.user.profil && m.user.isProf && (m.user.profil.professionalType === "INFIRMIERE_PRATICIENNE")) {
                    	m.user.isIPSVal = true;
                    }else{
                    	m.user.isIPSVal = false;
                    }
                    return m.user.isIPSVal;
                },
                isClinician: function () {
                	if (m.user.isClinicianVal!=undefined) return m.user.isClinicianVal;
                    if (m.user.profil && m.user.isProf) {
                    	m.user.isClinicianVal = true;
                    } else {
                    	m.user.isClinicianVal = false;
                    }
                    return m.user.isClinicianVal;
                },
                isClinicianNotStagiaire: function () {
                	if (m.user.isClinicianNotStagiaireVal!=undefined) return m.user.isClinicianNotStagiaireVal;
                	if (m.user.profil && m.user.isProf && m.user.profil.isStagiaire!==true) {
                    	m.user.isClinicianNotStagiaireVal = true;
                	} else {
                		m.user.isClinicianNotStagiaireVal = false;
                	}
                	return m.user.isClinicianNotStagiaireVal;
                },
                isStagiaire: function () {
                	if (m.user.isStagiaireVal!=undefined) return m.user.isStagiaireVal;
                    if (m.user.profil && m.user.profil.isStagiaire) {
                    	m.user.isStagiaireVal = true;
                    } else {
                    	m.user.isStagiaireVal = false;
                    }
                    return m.user.isStagiaireVal;
                },
                hasClinicalRights: function () {
                	if (m.user.hasClinicalRightsVal!=undefined) return m.user.hasClinicalRightsVal;
                    if (m.user.profil && m.user.isProf) {
                    	m.user.hasClinicalRightsVal = true;
                	} else if (m.user.session && m.user.session.user && m.user.session.user.role.includes('MEDICAL_SECRETARY')) {
                		m.user.hasClinicalRightsVal = true;
                	} else {
                		m.user.hasClinicalRightsVal = false;
                	}
                	return m.user.hasClinicalRightsVal;
                },
                list: {},
                profs: {},
                profsTx: {},
                profsAppt: {},
                groups: {},
                employees: {},
                persons: {},
                sites: {},
                tab: {
                    currUser: {},
                    currentActive: -9999999,
                    currList: []
                }
            };

            m.appointment.currDate = moment().format('YYYY-MM-DD');
			m.research.currDate = moment().format('YYYY-MM-DD');
            m.schedule.currDate = moment().format('YYYY-MM-DD');
			m.scan.currDate =  moment().format('YYYY-MM-DD');
			m.scan.currSearchDate = moment().format('YYYY-MM-DD');

			m.research.labosearch ={
				patientLab: null,
				contains: null,
				seen: null,
				otherValue: null,
				finalResult: [],
				labServiceAfterDate: null,
				labServiceBeforeDate: moment().format(OfysUtils.DATEFORMAT),
				labRequestAfterDate: null,
				labRequestBeforeDate: null,
				labSeenAfterDate: null,
				labSeenBeforeDate: null,
				labSignAfterDate: null,
				labSignBeforeDate: null,
				otherProfIdDoc: null,
				profIdDoc: null,
			}
			m.research.docsearch ={
				seen: null,
				normality: null,
				selectedLabels: [],
				docBeforeDate: moment().format(OfysUtils.DATEFORMAT),
				docAfterDate: null,
				patientDoc: null,
				userIdDoc: null,
				profIdDoc: null,
				docName: null,
				docCreateBeforeDate: null,
				docCreateAfterDate: null
				}

            m.currPatientData = {};
            m.currPatientData.prof = {};

            var initTag = -100000;

            function atomicInt() {
                return initTag--;
            }

            m.cnesstDV = [];
			m.crdsList = undefined;
            
            m.currentLaboDocMd = {};
            m.currentApptMd = {};
            m.currentCourrielUser = null;
            m.currentRess = {};
            m.currentSect = {};

            m.dayDataCntsLabDoc = {
                    lab_see: null,
                    lab_regl: null,
                    lab_see_id: [],
                    lab_regl_id: [],
                    doc_see: null,
                    doc_regl: null,
                    doc_see_id: [],
                    doc_regl_id: []
            };
            m.dayDataCntsAllButSafir = {
                rv_am: null,
                rv_pm: null,
                rv_soir: null,
                enc_term: null,
                enc_rev: null,
                enc_edits: null,
                enc_date_edits: null,
                enc_date_edits_id: [],
                enc_date_date:'',
                enc_term_id: [],
                enc_rev_id: [],
                enc_edits_id: [],
                msg_urg: null,
                msg_urg_id: [],
                msg_new: null,
                msg_new_id: [],
                msg_inbox: null,
                msg_inbox_id: [],
                mail_urg: null,
                mail_urg_id: [],
                mail_new: null,
                mail_new_id: [],
                fax_sent: null,
                fax_sent_id: [],
                fax_inprog: null,
                fax_inprog_id: [],
                fax_err: null,
                fax_err_id: [],
                crds_red: null,
                crds_red_id: [],
				attente_du: null,
				attente_du_id: [],
				
                task_late: null,
                task_late_id: [],
                task_late_group: null,
                task_late_group_id: [],
                task_late_total: null,
                task_late_id_total: [],

                task_sent_uncompleted: null,
                task_sent_uncompleted_id: [],
                task_sent_uncompleted_others: null,
                task_sent_uncompleted_others_id: [],
                task_sent_uncompleted_total: null,
                task_sent_uncompleted_id_total: [],

                task_sent_completed: null,
                task_sent_completed_id: [],
                task_sent_completed_others: null,
                task_sent_completed_others_id: [],
                task_sent_completed_total: null,
                task_sent_completed_id_total: [],

                task_received_completed: null,
                task_received_completed_id: [],
                task_received_completed_group: null,
                task_received_completed_group_id: [],
                task_received_completed_total: null,
                task_received_completed_id_total: [],
                
                task_tod: null,
                task_tod_id: [],
                task_tod_group: null,
                task_tod_group_id: [],
                task_tod_total: null,
                task_tod_id_total: [],

                task_sem: null,
                task_sem_id: [],
                task_sem_group: null,
                task_sem_group_id: [],
                task_sem_total: null,
                task_sem_id_total: [],

                task_sans: null,
                task_sans_id: [],
                task_sans_group: null,
                task_sans_group_id: [],
                task_sans_total: null,
                task_sans_id_total: [],
                
                task_urg: null,
                task_urg_id: [],
                task_urg_group: null,
                task_urg_group_id: [],
                task_urg_total: null,
                task_urg_total_fct: function() {// non utilisé. Si task_urg_total fonctionne, supprimer.
                    return (this.task_urg!=null ? this.task_urg : 0) + (this.task_urg_group!=null ? this.task_urg_group : 0);
				},
                task_urg_id_total: [],

                task_ecr: null,
                task_ecr_id: [],
                task_ecr_group: null,
                task_ecr_group_id: [],
                task_ecr_total: null,
                task_ecr_id_total: [],

                task_note: null,
                task_note_id: [],
                task_note_group: null,
                task_note_group_id: [],
                task_note_total: null,
                task_note_id_total: [],
                
                task_stat1: null,
                task_stat1_id: [],
                task_stat1_group: null,
                task_stat1_group_id: [],
                task_stat1_total: null,
                task_stat1_id_total: [],
                
                task_stat2: null,
                task_stat2_id: [],
                task_stat2_group: null,
                task_stat2_group_id: [],
                task_stat2_total: null,
                task_stat2_id_total: [],
                
                task_stat3: null,
                task_stat3_id: [],
                task_stat3_group: null,
                task_stat3_group_id: [],
                task_stat3_total: null,
                task_stat3_id_total: [],
                
                task_stat4: null,
                task_stat4_id: [],
                task_stat4_group: null,
                task_stat4_group_id: [],
                task_stat4_total: null,
                task_stat4_id_total: [],
                
                task_total: function () {
                    var c = this;
                    var cnt =
                        (c.task_late_total != null ? c.task_late_total : 0) +
                        (c.task_tod_total != null ? c.task_tod_total : 0) +
                        (c.task_sem_total != null ? c.task_sem_total : 0) +
                        (c.task_sans_total != null ? c.task_sans_total : 0)
                    return cnt;
                },
                
                task_id_total: function () {
                    var c = this;
                    return c.task_late_id_total.
                    concat(c.task_tod_id_total).
                    concat(c.task_sem_id_total).
                    concat(c.task_sans_id_total);
                },
                task_total_less: function() {
                	var c = this;
                	return c.task_id_total_less().length;
                },
                task_id_total_less: function() {
                	var c = this;
                	var r = _.union(c.task_urg_id_total,c.task_ecr_id_total,c.task_note_id_total,c.task_stat1_id_total,c.task_stat2_id_total,c.task_stat3_id_total,c.task_stat4_id_total);
                	var t = _.difference(c.task_id_total(), r);
                	return t;
                },
                
                task_less: function() {
                	var c = this;
                	return c.task_id_less().length;
                },
                task_id_less: function() {
                	var c = this;
                	var r = _.union(c.task_urg_id,c.task_ecr_id,c.task_note_id,c.task_stat1_id,c.task_stat2_id,c.task_stat3_id,c.task_stat4_id);
                	var q = _.union(c.task_late_id,c.task_tod_id,c.task_sem_id,c.task_sans_id);
                	var t = _.difference(q, r);
                	return t;
                },
                task_group_less: function() {
                	var c = this;
                	return c.task_group_id_less().length;
                },
                task_group_id_less: function() {
                	var c = this;
                	var r = _.union(c.task_urg_group_id,c.task_ecr_group_id,c.task_note_group_id,c.task_stat1_group_id,c.task_stat2_group_id,c.task_stat3_group_id,c.task_stat4_group_id);
                	var q = _.union(c.task_late_group_id,c.task_tod_group_id,c.task_sem_group_id,c.task_sans_group_id);
                	var t = _.difference(q, r);
                	return t;
                },
                
                task_group: function () {
                    var c = this;
                    var cnt =
                        (c.task_late_group != null ? c.task_late_group : 0) +
                        (c.task_tod_group != null ? c.task_tod_group : 0) +
                        (c.task_sem_group != null ? c.task_sem_group : 0) +
                        (c.task_sans_group != null ? c.task_sans_group : 0);
                    return cnt;
                },
                task_group_id: function () {
                    var c = this;
                    return c.task_late_group_id.
                    concat(c.task_tod_group_id).
                    concat(c.task_sem_group_id).
                    concat(c.task_sans_group_id);
                },
                task: function () {
                    var c = this;
                    var cnt =
                        (c.task_late != null ? c.task_late : 0) +
                        (c.task_tod != null ? c.task_tod : 0) +
                        (c.task_sem != null ? c.task_sem : 0) +
                        (c.task_sans != null ? c.task_sans : 0);
                    return cnt;
                },
                task_id: function () {
                    var c = this;
                    return c.task_late_id.
                    concat(c.task_tod_id).
                    concat(c.task_sem_id).
                    concat(c.task_sans_id);
                },
            };
            angular.extend(m.dayDataCntsAllButSafir, m.dayDataCntsLabDoc);
            
            m.dayDataCntsSafir = {
                saf_prer: null,
                saf_prer_id: [],
                saf_compl: null,
                saf_compl_id: [],
                saf_valid: null,
                saf_valid_id: [],
            };
            m.timeRefreshInterval = 300000; // 10 min
            m.dayData = {
                cnts: {},
                timeRefresh: 0,
                isLoading: true
            };
            angular.extend(m.dayData.cnts, m.dayDataCntsSafir);
            angular.extend(m.dayData.cnts, m.dayDataCntsAllButSafir);

            m.rxVigilance = {};
            
            m.metabase = {};
            
            var prefsToGet = 'eventByDate,nbEvents,periodShown,showDeletedForm,docShowLab,docShowDoc,docToSee,docToResolve,superviseurId,filterFormAnd,filterFormTerms,' +
                'ptedit_language,ptedit_dob,ptedit_numerised,ptedit_sensible,ptedit_sofy,ptedit_lastVerif,ptedit_lastActivity,ptedit_professional,ptedit_partner,ptedit_mother,' +
            	'ptedit_father,ptedit_tutor,ptedit_citizenship,ptedit_race,ptedit_civil,ptedit_appMsg,ptedit_childMsg,ptedit_address,ptedit_contacts,ptedit_otherProf,ptedit_sites,'+
            	'ptedit_ident,ptedit_pharma,ptedit_alerts,ptedit_limitations,ptedit_fusion,ptedit_note,ptedit_inactive,ptedit_isdead,ptedit_gender,ptedit_picture,ptedit_popover,' +
                'form_cnesst_lang,user_settings_ShowAllLabs,cnesstQuestions,enc_Order,language,mesure_system,' +
                'et_empty,et_SRV,et_ordonnances,et_renewOrdonnances,et_telephone,et_suiviGrossesse,et_cnesst,et_suiviAnnuel,et_visitePerPed,et_suiviClinique,et_suiviDiabete,et_suiviDiabeteCap,et_glycCap,et_suiviINR,et_all,' +
                'fav_tab_active,med_rx_times,med_rx_defaut,user_settings_ShowMoreDemoData,list_appt_size,list_pat_size,list_research_size,list_research_option_size,' + 
                'user_settings_ShowAllProfsInAppt,user_settings_ShowAllProfsInLaboDoc,user_settings_ShowProfsReplacedInLaboDoc,user_settings_ExcludeMySeenLaboDoc,user_settings_SearchMdProvNB,' +
                'user_settings_SetSeenAuto,et_immunization,et_raisonNoteConcl,user_settings_AlwaysAddBilling,list_ress_size,user_settings_AddSvInEnc,user_settings_AddMesuresInEnc,user_settings_DirectPrint,' +
                'task.toUserId,task.toGroupId,user_settings_PrintRxDevSep,user_settings_AddConclusionInEnc,user_settings_NoShowSignWarning,user_settings_AlwaysShowOtherProv,user_settings_ShowRecPos,user_settings_ShowSuggPos,user_settings_ShowCanceledAppt,'+
                'user_settings_ShowSummaryDxInEnc,user_settings_SiteAppointments,user_settings_SiteLaboDocs,user_settings_SitePatients,user_settings_SiteMessages,user_settings_SiteTasks,inspq_vaccin_tradeName,inspq_vaccin_locationPref,'+
				'inspq_vaccin_performer,inspq_vaccin_location,user_settings_LastUsedPrintFax,user_settings_labOneLine,user_settings_docOneLine,'+
                'schedule_settings_appointmentDayViewScale,schedule_settings_scheduleDayViewScale,schedule_settings_showAppTime,schedule_settings_showDeletedAppt,user_list_profFavorite,user_list_multiProfFavorite,' +
                'user_settings_UseNewPDFViewer,et_Stylet,user_settings_showLaboDocComments,user_settings_printReportProperties,user_settings_chosenReports,'+
                'task_settings_st0,task_settings_st1,task_settings_st2,task_settings_st20,task_settings_st40,task_settings_st60,task_settings_st80,task_settings_st100,'+
                'task_settings_stcol0,task_settings_stcol1,task_settings_stcol2,task_settings_stcol20,task_settings_stcol40,task_settings_stcol60,task_settings_stcol80,task_settings_stcol100,' + 
                'hideSuiviPrev,suiviPrev4Pt,labodoc_savenext,labo_hide_header,user_settings_medNoteType,user_settings_recordingLangue';

            function setPrefSettings(data) {
                var resData = data ? data.obj : [];
                var prefsToGetArr = prefsToGet.split(',');
                var prefsToGetLen = prefsToGetArr.length;
                if (resData.length === prefsToGetLen) {
                    for (var i = 0; i < resData.length; i++) {
                        m.prefSettings[prefsToGetArr[i]] = $.isNumeric(resData[i]) ? resData[i] * 1 : resData[i];
                    }
                }
            }

            function setTableauBordStatus(data, fct, idProf) {
                if (idProf) {
                    angular.extend(m.dayData[idProf].cnts, data);
                    m.rxVigilance.rxvLicence = data.rxvLicence;
                    m.rxVigilance.rxvUrl = data.rxvUrl;
                } else {
                    angular.extend(m.dayData.cnts, data);                		                		
                }
                if (fct) fct();
                m.refreshCountsUpdated.val++;
                m.labCntsUpdated.val++;
                m.docCntsUpdated.val++;
            }

            m.callDashBoardCount = function (fct, forceReload, md) {
            	if (m.user.profil===undefined) return;
            	var idProf = md===undefined ? m.user.profil.id : md.id;
            	if (idProf===undefined) {
					m.user.profil.id = -1;
					idProf=-1;
				}
                if (forceReload === true || m.dayData[idProf]===undefined || m.dayData[idProf].timeRefresh === 0) {
                	if (m.dayData[idProf]===undefined) {
                		m.dayData[idProf] = {cnts:{}, timeRefresh: 0, isLoading: true};
                		angular.extend(m.dayData[idProf].cnts, m.dayDataCntsSafir);
                	}
                	angular.extend(m.dayData[idProf].cnts, m.dayDataCntsAllButSafir);
                    m.dayData[idProf].isLoading = idProf == -1? false: true;
                    if(idProf != -1){
                        $timeout(function () {
                            m.refreshCountsUpdated.val++;
                        }, 10);
                        var excludeSeen =  false;
                        if (idProf!==m.user.profil.id && m.prefSettings.user_settings_ExcludeMySeenLaboDoc===true) {
                            excludeSeen = true;
                        }
                        if(m.dayData[idProf].callDashBoardCountReady != null && forceReload == false){
                            if (fct) m.dayData[idProf].callDashBoardCountReady.then(fct);// Empêche l'appel d'être appeller plusieur fois mm si forceLoad est false.
                        }else{
                            m.dayData[idProf].callDashBoardCountReady = $http.get("/dashboard/User/ws/userDashboardCountsAllButSafir?idProf=" + idProf + "&excludeMySeen=" + excludeSeen, {}).then(function (res) {
                                if (m.dayData[idProf] && m.dayData[idProf].cnts) {
                                    angular.extend(m.dayData[idProf].cnts, m.dayDataCntsLabDoc);
                                }
                                setTableauBordStatus(res.data, fct, idProf);
                                delete m.dayData[idProf].cnts.new_docs;
                                delete m.dayData[idProf].cnts.new_labs;
                                delete m.dayData[idProf].cnts.new_msgs;
                                m.dayData[idProf].timeRefresh = new Date();
                                m.dayData[idProf].isLoading = false;
                            });
                        }
                    }
                } else {
                    if (fct) fct();
                }
            };

            m.callDashBoardLabosDocsCount = function (fct, forceReload, md) {
            	var idProf = md===undefined ? m.user.profil.id : md.id;
            	if (forceReload === true || m.dayData[idProf]===undefined || m.dayData[idProf].timeRefresh === 0) {
            		if (m.dayData[idProf]===undefined) {
            			m.dayData[idProf] = {cnts:{}, timeRefresh: 0, isLoading: true};
            			angular.extend(m.dayData[idProf].cnts, m.dayDataCntsAllButSafir);
            		}
            		m.dayData[idProf].isLoading = true;
            		$timeout(function () {
            			m.refreshCountsUpdated.val++;
            		}, 10);
            		var excludeSeen =  false;
            		if (idProf!==m.user.profil.id && m.prefSettings.user_settings_ExcludeMySeenLaboDoc===true) {
            			excludeSeen = true;
            		}
                    if(m.dayData[idProf].callDashBoardLabosDocsCountReady != null && forceReload == false){
                        if (fct) m.dayData[idProf].callDashBoardLabosDocsCountReady.then(fct);// Empêche l'appel d'être appeller plusieur fois mm si forceLoad est false.
                    }else{
                        m.dayData[idProf].callDashBoardLabosDocsCountReady = $http.get("/dashboard/User/ws/userDashboardDocsLabosOnlyCounts?idProf=" + idProf + "&excludeMySeen=" + excludeSeen, {}).then(function (res) {
                            if (m.dayData[idProf] && m.dayData[idProf].cnts) {
                                // il faut remettre à 0 les valeurs de ces données.
                                angular.extend(m.dayData[idProf].cnts, m.dayDataCntsLabDoc);
                            }
                            setTableauBordStatus(res.data, fct, idProf);
                            delete m.dayData[idProf].cnts.new_docs;
                            delete m.dayData[idProf].cnts.new_labs;
                            delete m.dayData[idProf].cnts.new_msgs;
                            m.dayData[idProf].timeRefresh = new Date();
                            m.dayData[idProf].isLoading = false;
                        });
                    }
            	} else {
            		if (fct) fct();
            	}
            };
            
            m.callDashBoardCountSafir = function (fct, forceReload) {
                if (forceReload === true || m.dayData===undefined ||  m.dayData.cnts.saf_prer === null) {
                    angular.extend(m.dayData.cnts, m.dayDataCntsSafir);
                    m.dayData.isLoadingSafir = true;
                    $timeout(function () {
                        m.refreshCountsUpdated.val++;
                    }, 10);
                    
                    if(m.dayData.callDashBoardCountSafirReady != null && forceReload == false){
                        if (fct) m.dayData.callDashBoardCountSafirReady.then(fct);// Empêche l'appel d'être appeller plusieur fois mm si forceLoad est false.
                    }else{
                        m.dayData.callDashBoardCountSafirReady = $http.get("/dashboard/User/ws/userDashboardCountsSafir", {}).then(function (res) {
                            setTableauBordStatus(res.data, fct);
                            m.dayData.isLoadingSafir = false;
                        });
                    }
                } else {
                    if (fct) fct();
                }
            };

            var dashBoardCountInterval;
            var dashBoardCountIntervalExe = function () {
                if (angular.isDefined(dashBoardCountInterval)) return;
                dashBoardCountInterval = $interval(function () {
                    m.callDashBoardCount();
                }, m.timeRefreshInterval); // repeat every 5 min. en TEST - mettre 900000 (every 15 min) en prod
            };

            // called ds dashwebsocket - suite au ws.onclose
            m.stopDashBoardCountInterval = function () {
                if (angular.isDefined(dashBoardCountInterval)) {
                    $interval.cancel(dashBoardCountInterval);
                    dashBoardCountInterval = undefined;
                }
            };
            m.resetDashBoardCountInterval = function () {
                m.stopDashBoardCountInterval();
                dashBoardCountIntervalExe();
            };
            dashBoardCountIntervalExe();

            // pour épurer caches

            var cacheCountInterval;
            var cacheCountIntervalExe = function () {
                if (angular.isDefined(cacheCountInterval)) return;
                cacheCountInterval = $interval(function () {
                    var isReview = m.activeController === 'review'; // si ds review, il ne faut pas effacer la cache. On la prolonge
                    var isChat = m.activeController === 'msg'; // si ds review, il ne faut pas effacer la cache. On la prolonge
                    var isTask = m.activeController === 'task';
                    var isMail = m.activeController === 'mail';
                    var now = new Date();
                    for (var [cle, valeur] of Object.entries(m.docCached)){
                          Object.keys(m.docCached[cle]).forEach(function (key, index) {
                              if (isReview) {
                                  //console.log("prolongation de docCache: " + key);
                                  m.docCached[cle][key].expires_on = m.docCached[cle][key].expires_on + 60 * 5; // + 5 min.
                              } else if (m.docCached[cle][key].expires_on > now) {
                                  //console.log("effacement de docCache: " + key);
                                  delete m.docCached[cle][key];
                              }
                          });
                	}
                    for (var [cle, valeur] of Object.entries(m.labCached)){
                        Object.keys(m.labCached[cle]).forEach(function (key, index) {
                        	if (isReview) {
                        		//console.log("prolongation de labCache: " + key);
                        		m.labCached[cle][key].expires_on = m.labCached[cle][key].expires_on + 60 * 5; // + 5 min.
                        	} else if (m.labCached[cle][key].expires_on > now) {
                        		//console.log("effacement de labCache: " + key);
                        		delete m.labCached[cle][key];
                        	}
                        });
                    }
                    Object.keys(m.msgCached).forEach(function (key, index) {
                        if (isChat) {
                            //console.log("prolongation de msgCache: " + key);
                            m.msgCached[key].expires_on = m.msgCached[key].expires_on + 60 * 5; // + 5 min.
                        } else if (m.msgCached[key].expires_on > now) {
                            //console.log("effacement de msgCache: " + key);
                            delete m.msgCached[key];
                        }
                    });
                    Object.keys(m.taskCached).forEach(function (key, index) {
                        if (isTask) {
                            //console.log("prolongation de taskCached: " + key);
                            m.taskCached[key].expires_on = m.taskCached[key].expires_on + 60 * 5; // + 5 min.
                        } else if (m.taskCached[key].expires_on > now) {
                            //console.log("effacement de taskCached: " + key);
                            delete m.taskCached[key];
                        }
                    });
                    Object.keys(m.mailCached).forEach(function (key, index) {
                    	if (isMail) {
                    		//console.log("prolongation de mailCached: " + key);
                    		m.mailCached[key].expires_on = m.mailCached[key].expires_on + 60 * 5; // + 5 min.
                    	} else if (m.mailCached[key].expires_on > now) {
                    		//console.log("effacement de mailCached: " + key);
                    		delete m.mailCached[key];
                    	}
                    });

                }, 300000); // repeat every 5 min. 900000 
            };
            cacheCountIntervalExe();

            // pour savoir si websocket actif, le serveur envoi aux 1 sec un ping. ce ping call 
            var webSocketActivityInterval;
            var webSocketActivityExe = function () {
                webSocketActivityInterval = $interval(function () {
                    var t = Date.now();
                    if (m.webSocketActivity.last + 20000 < t) {
                        // on a un probleme de websocket non updaté. Donc lien mort
                        m.webSocketActivity.val = 0;
                        console.log("websocket mort...");
                        //				} else {
                        //					console.log("websocket actif!");			
                    }
                }, 5000); // repeat every 5 sec
            };
            webSocketActivityExe();

			function handlePrint(callback) {
				return function (res) {
					var i = -1;
					function doPrint() {
						i++;
						if (res && res.length > i) {
							printUrl(res[i]).then(doPrint);
						}
					}
					if (res.data && res.data.success==true && res.config && res.config.url.indexOf('save')!=-1){
							// do nothing. Retour vide d'un save. Pas une affaire de print.
					} else {						
	                    if(m.prefSettings.user_settings_DirectPrint){
							if(res && res.length > 0 && res[0].length !== 0){
	//							m.notice.note($filter('translate')('DirectPrintError'));
								doPrint();
							}else{
	                       		m.notice.success($filter('translate')('PrintInProgress'));
							}
	                    }else if (Array.isArray(res) && res.length > 0) {
							// res.push("/temp/3ee90124-8c3e-44c2-978a-43457bd87668.pdf");// test 
							doPrint();
						}
					}
					if (callback !== undefined) {
						callback(res);
					}
				}
			}

			function printUrl(url) {
				return $q(function (resolve, reject) {
					try {
						var objFra = $('<iframe src="' + url + '" class="hide"></iframe>');
						// objFra[0].src = url;
						var body = $("body");
						body.append(objFra);
						objFra.on('load', function () {
							var printSuccessful = false;
							var timer;
							function cleanUp() {
								if (!printSuccessful) {
									// clean up dom
									objFra.remove();
									printSuccessful = true;
									if (timer) { $timeout.cancel(timer); };
								}
							}
							var wx = objFra[0].contentWindow;
							wx.focus();
							try {
								wx.print();
								resolve();
								$timeout(cleanUp, 60000 * 5)//5 minutes pour imprimer. sinon le clear se fait
							} catch (e) {// firefox doesnt seem to allow direct printing the pdf.
								window.open(url, '_blank');// fallback to opening the url
								// var wx = window.open(url, '_blank');// fallback to opening the url
								// wx.print();
								resolve();
								cleanUp();
							}
						});
					} catch (e) {

						$log.error(e);
						reject();
					}
				});
			}

            // TODO où mettre ça??? nécessaire?
            //		$scope.$on('$destroy', function() {
            //			m.stopDashBoardCountInterval();
            //	    });
            m.debug = {
                dev: false, // equivalent du devMode de GlobalInstance.
                isActive: debugActiveState(),
                pre: false,
                c: 0,
                co: function () {
                    m.debug.c = m.debug.c + 1;
                },
                debugActiveState: debugActiveState,
                pinMenu: debugActiveState(),
                activate: function () {
                    m.debug.pre = true;
                    $timeout(function () {
                        m.debug.pre = false;
                        if (m.debug.c > 2) {
                            m.debug.isActive = true;
                        }
                        m.debug.c = 0;
                    }, 3000);
                },
                deactivate: function () {
                    m.debug.isActive = false
                }
            };

            //Model bootstrapping. Ensures that all the necessary user data is up to date before application start.
            //If the first level promise are not resolved the application should not start.
            var ready = $q.all([
                $http.get("/dashboard/User/ws/profil", {}),
//                $http.get("/dashboard/User/ws/getSessionUser", {}),
                $http.get("/dashboard/User/ws/getSession", {}),
                $http.post("/dashboard/pref/ws/user/get", {
                    k: prefsToGet
                }, {})
            ]).then(function (res) {
            	
            	// code déplacé ici car si appelé trop tôt, ne tient pas compte de la langue du navigateur.
            	let key =  OfysUtils.isMac? " (CMD+": " (CTRL+";
                m.patientStatuses = [];
                m.patientStatuses.push({
                    key: 'NONE',
                    index: 0,
                    text: $filter('translate')('AppPatientStatus_NONE')
                });
                m.patientStatuses.push({
                    key: 'CANCEL',
                    index: 1,
                    text: $filter('translate')('AppPatientStatus_CANCEL'),
                    hotkey:  key + "L)"
                });
                m.patientStatuses.push({
                    key: 'SEEN',
                    index: 2,
                    text: $filter('translate')('AppPatientStatus_SEEN'),
                    hotkey: key + "U)"
                });
                m.patientStatuses.push({
                    key: 'NOT_CAME',
                    index: 3,
                    text: $filter('translate')('AppPatientStatus_NOT_CAME'),
                    hotkey: key + "E)"
                });
                m.patientStatuses.push({
                    key: 'ARRIVED',
                    index: 4,
                    text: $filter('translate')('AppPatientStatus_ARRIVED'),
                    hotkey: key + "A)"
                });
                m.patientStatuses.push({
                    key: 'PLACED',
                    index: 5,
                    text: $filter('translate')('AppPatientStatus_PLACED'),
                    hotkey: key + "K)"
                });
                m.patientStatuses.push({
                    key: 'ARRIVED_LATE',
                    index: 6,
                    text: $filter('translate')('AppPatientStatus_ARRIVED_LATE')
                });
                m.patientStatuses.push({
                    key: 'LEFT_WITHOUT_BEING_SEEN',
                    index: 7,
                    text: $filter('translate')('AppPatientStatus_LEFT_WITHOUT_BEING_SEEN')
                });
                m.patientStatuses.push({
                	key: 'CANCEL_LESS_24H',
                	index: 8,
                	text: $filter('translate')('AppPatientStatus_CANCEL_LESS_24H')
                });
                m.patientStatuses.push({
                	key: 'TRIE',
                	index: 9,
                	text: $filter('translate')('AppPatientStatus_TRIE')
                });
                m.patientStatuses.push({
                	key: 'SEEN_INF',
                	index: 10,
                	text: $filter('translate')('AppPatientStatus_SEEN_INF')
                });
                m.patientStatuses.push({
                	key: 'SEEN_RES',
                	index: 11,
                	text: $filter('translate')('AppPatientStatus_SEEN_RES')
                });
                m.patientStatuses.push({
                	key: 'ATTENTE_REV',
                	index: 12,
                	text: $filter('translate')('AppPatientStatus_ATTENTE_REV')
                });

				m.appAllStatus = [];
                m.appAllStatus.push({
                    key: 'NORMAL',
                    index: 0,
                    text: $filter('translate')('AppStatus_NORMAL')
                });
                m.appAllStatus.push({
                    key: 'MESSAGE_LEAVED',
                    index: 1,
                    text: $filter('translate')('AppStatus_MESSAGE_LEAVED'),
                    hotkey: key + "G)"
                });
                m.appAllStatus.push({
                    key: 'CONFIRMED',
                    index: 2,
                    text: $filter('translate')('AppStatus_CONFIRMED'),
                    hotkey: key + "I)"
                });
                m.appAllStatus.push({
                    key: 'TO_MOVE',
                    index: 3,
                    text: $filter('translate')('AppStatus_TO_MOVE')
                });
                m.appAllStatus.push({
                    key: 'WANT_TO_MOVE_AHEAD',
                    index: 4,
                    text: $filter('translate')('AppStatus_WANT_TO_MOVE_AHEAD')
                });
                m.appAllStatus.push({
                    key: 'NO_ANSWER',
                    index: 5,
                    text: $filter('translate')('AppStatus_NO_ANSWER'),
                    hotkey: key + "D)"
                });
//                m.appAllStatus.push({
//                    key: 'CONFIRMATION_MAIL_ENVOI',
//                    index: 6,
//                    text: $filter('translate')('AppStatus_CONFIRMATION_MAIL_ENVOI')
//                });
//                m.appAllStatus.push({
//                    key: 'CONFIRMATION_MAIL_RECUE',
//                    index: 7,
//                    text: $filter('translate')('AppStatus_CONFIRMATION_MAIL_RECUE')
//                });
                m.appAllStatus.push({
                    key: 'LIGNE_OCCUPEE',
                    index: 8,
                    text: $filter('translate')('AppStatus_LIGNE_OCCUPEE')
                });
                m.appAllStatus.push({
                    key: 'BOITE_VOCALE',
                    index: 9,
                    text: $filter('translate')('AppStatus_BOITE_VOCALE')
                });
                m.appAllStatus.push({
                    key: 'PAS_DE_SERVICE',
                    index: 10,
                    text: $filter('translate')('AppStatus_PAS_DE_SERVICE')
                });
//                m.appAllStatus.push({
//                    key: 'CONFIRMATION_TEXTO_ENVOI',
//                    index: 12,
//                    text: $filter('translate')('AppStatus_CONFIRMATION_TEXTO_ENVOI')
//                });
//                m.appAllStatus.push({
//                    key: 'CONFIRMATION_TEXTO_RECUE',
//                    index: 13,
//                    text: $filter('translate')('AppStatus_CONFIRMATION_TEXTO_RECUE')
//                });

                m.patientStatusColors = [];

            	
                //Set user's profile required for application start up
                //Profil could be a CBaseProfessional object or a CBaseEmployee object depending on the connected user.
                m.user.profil = res[0].data;
                m.user.session = res[1].data;
                m.user.sessionUser = res[1].data;
                m.user.sofia = {
                    enabled: function(){
                        return m.user.sofia.clientLicense()
                                || m.user.sofia.userLicence()
                                || m.user.sofia.manualLicense();
                    },
                    clientLicense: function(){
                        return model.clientPreferences() && model.clientPreferences().aiEnabled;
                    },
                    manualLicense: function(){
                        return !!model.user().sessionUser.user.userPreferences.aiEnabled;
                    },
                    userLicence: function(){   
                        return model.user().sofia.subscription && 
                        !!model.user().sofia.subscription.auth &&
                        !!model.user().sofia.subscription.auth.valid;
                    }
                }

                if (m.user.profil.className === 'CBaseEmployee') {
                    m.user.isProf = false;
					m.user.isMdSecretary = m.user.sessionUser.user.role.indexOf("MEDICAL_SECRETARY") > -1;
                } else if (m.user.profil.className === 'CBaseProfessionnal') {
                    m.user.isProf = true;
                    m.currentLaboDocMd = m.user.profil;
                    m.currentApptMd = m.user.profil;
                }

                if(m.user.sessionUser){
					m.user.isRoleInfodata = m.user.sessionUser.user.role.indexOf("INFODATA") > -1;
                    m.user.isUserAdmin = m.user.sessionUser.user.role.indexOf("USER_MANAGEMENT") > -1 || m.user.isRoleInfodata;
                    m.user.isAdmin = m.user.sessionUser.user.role.indexOf("ADMIN") > -1;
                    m.user.hasBilling =  m.user.sessionUser.user.role.indexOf("BILLING") > -1;
                    // m.currentCourrielUser = m.user.sessionUser.user;
                    // m.currentCourrielUser.courrielDossiers = m.user.sessionUser.user.userPreferences.courrielDossiers;
                }
                
                try {
                    // les pref d'affichage de patientData
                    setPrefSettings(res[2].data);
                } catch (e) {
                    console.error("Could not initiate preference settings object", e);
                }

                m.enums = {};
                var enumList = [
                    ["b2bInscriptionStatus","ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus"],
                    ["b2bInscriptionCategory","ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionCategory"],
                    ["b2bnscriptionEndReason","ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionEndReason"],
                    ["b2bDisabilityCode","ca.infodata.ofys.data.middle.dataobjects.b2b.XDisabilityCode"],
                    ["b2bPatientRepresentativeType","ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientRepresentativeType"],
                    ["b2bPatientB2bModifActionType","ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModifActionType"],
					["recallStatus","ca.infodata.ofys.data.middle.dataobjects.appointment.XStatus"],
					["recallPriority","ca.infodata.ofys.data.middle.dataobjects.appointment.XPriority"],
					["recallPreferredTime","ca.infodata.ofys.data.middle.dataobjects.appointment.XPreferredTime"],
					["historyDocNormality","ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType"],
					["historyState","ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalStatus"],
					["crdsStatut","ca.infodata.ofys.data.middle.dataobjects.eform.XEnumCrdsStatut"],
					["crdsSousStatut","ca.infodata.ofys.data.middle.dataobjects.eform.XEnumCrdsSousStatut"],
					["templateList","ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType"],
					["ressServiceType","ca.infodata.ofys.data.middle.dataobjects.service.XServiceType"],
					["responsablePmt","ca.infodata.ofys.data.middle.dataobjects.service.XResponsablePmt"],
					["ressStatus","ca.infodata.ofys.data.middle.dataobjects.service.XRessourceStatus"],
					["ressUnit","ca.infodata.ofys.data.middle.dataobjects.service.XRessourceUnit"],
					["modePaiement","ca.infodata.ofys.data.middle.dataobjects.service.XModePaiement"],
					["prescriptionPrintFormat","ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionPrintFormat"],
					["prescriptionDrugNameFormat","ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat"],
					["currency","ca.infodata.ofys.data.middle.dataobjects.preferences.XDeviseSymbol"]
                ];
                var INITCALLS = {
                    users: {url: "/dashboard/User/ws/list"},
                    profs: {url: "/dashboard/Prof/ws/profs"},
                    groups: {url: "/dashboard/User/ws/groups"},
                    sites: {url: "/dashboard/User/ws/sites"},
                    debugMode: {url: "/dashboard/pref/ws/debugMode"},
                    patientStatusColor: {url: "/dashboard/apps/ws/patientStatusColor"},
                    // clientPref: {url: "/dashboard/pref/ws/clientPref"},
                    secteur: {url: "/dashboard/ress/ws/secteur/list"},
                    taxes: {url: "/dashboard/ress/ws/tax/list"},
                    defData: {url: "/dashboard/ress/ws/defData/list"},
                    isWeb: {url: "/dashboard/Login/ws/isWeb"},
                    allemployees: {url: "/dashboard/User/ws/allemployees"},
                    replacements: {url: "/dashboard/User/ws/replacements?id_prof=" + (m.user.isProf===true ? m.user.profil.id : null)},
                    allEnums: {httpMethod: "post", url: "/dashboard/encs/ws/allEnumListObj",payload:enumList},
                    lostDictation: {httpMethod: "post", url: "/dashboard/ia/ws/dictation"}
                };
                var initCallOrdered = Object.keys(INITCALLS);
                function getPromise(e){
                    if(INITCALLS[e].httpMethod === undefined){
                        return $http.get(INITCALLS[e].url, {})
                    }else if(INITCALLS[e].httpMethod === "post"){
                        return $http.post(INITCALLS[e].url, INITCALLS[e].payload);
                    }
                }
                //Set cache lists (users and professionals)
                // not important for startup and can be constructed later
                $q.all(initCallOrdered.map(getPromise)).then(function (res) {
                    res.forEach(function(e, i){
                        INITCALLS[initCallOrdered[i]].res = e;
                    });
                    // [ RENAMED : call
                    //     $http.get("/dashboard/User/ws/list", {}), /*0 */
                    //     $http.get("/dashboard/Prof/ws/profs", {}), /*1 -- to be removed*/
                    //     $http.get("/dashboard/User/ws/groups", {}), /*2 */
                    //     $http.get("/dashboard/User/ws/sites", {}), /*3 */
                    //     $http.get("/dashboard/pref/ws/debugMode", {}), /*4 */
                    //     $http.post("/dashboard/apps/ws/patientStatusColor", {}), /*5 */
                    //     $http.get("/dashboard/pref/ws/clientPref", {}), /*6 */
                    //     $http.get("/dashboard/ress/ws/secteur/list", {}), /*7 */
                    //     $http.get("/dashboard/ress/ws/defData/list", {}), /*8 */
                    //     $http.get("/dashboard/Login/ws/isWeb", {}), /*9 */
                    //     $http.get("/dashboard/User/ws/allemployees", {}), /*10 */
                    //     $http.get("/dashboard/User/ws/replacements?id_prof=" + (m.user.isProf===true ? m.user.profil.id : null), {}) /*11 */
                    //     //$http.get("/dashboard/User/ws/userDashboardCounts",{})
                    // ]
                    var i;

                    try {
                        var users = INITCALLS.users.res.data;

                        //Set user cache
                        for (i = 0; i < users.length; i++) {
                            m.user.list[users[i].id] = users[i];
                        }
                    } catch (e) {
                        console.error("Could not initiate Users object", e);
                    }
                    try {
                    	var emps = INITCALLS.allemployees.res.data.obj;
                    	for (i = 0; i < emps.length; i++) {
                    		m.user.employees[emps[i].id] = emps[i];
                    	}
                    } catch (e) {
                    	console.error("Could not initiate Employee object", e);
                    }

                    try {
                    	if (INITCALLS.replacements.res && INITCALLS.replacements.res.data && INITCALLS.replacements.res.data.obj && INITCALLS.replacements.res.data.obj.length>0) {
                    		m.user.profil.lstReplacement = INITCALLS.replacements.res.data.obj;
                    		m.user.profil.replacedIds = [];
                        	for (i = 0; i < m.user.profil.lstReplacement.length; i++) {
                        		m.user.profil.replacedIds.push(m.user.profil.lstReplacement[i].idPerson);
                        	}
                    		
                    	}
                    		
                    } catch (e) {
                    	console.error("Could not initiate isWeb object", e);
                    }
                    
                    try {
//                         var profs = res[1].data;	// la liste est déjà triée au backend
//                         //Set professional cache
//                         if (profs != null) {
//                             for (i = 0; i < profs.length; i++) {
//                             	if (profs[i].lastName===undefined) profs[i].lastName='-';
//                             	if (profs[i].firstName===undefined) profs[i].firstName='-';
//                            	}
//                         }
//                         //Set professional cache
//                         if (profs != null) {
//                         	var profsActif = profs.filter(function (p) {
//                                 return p.isDeleted!==true;
//    						});
// //                            .sort(function(o1,o2) {
// //                            	var ln1 = o1.lastName.toUpperCase();
// //                            	var ln2 = o2.lastName.toUpperCase();
// //                            	var lnc = ln1.localeCompare(ln2);
// //                            	if (lnc===0) {
// //                                	var fn1 = o1.firstName.toUpperCase();
// //                                	var fn2 = o2.firstName.toUpperCase();
// //                            		return fn1.localeCompare(fn2);
// //                            	}
// //                           	return lnc;
// //    						});
//                             for (i = 0; i < profsActif.length; i++) {
//                             	// if (profsActif[i].lastName===undefined) profsActif[i].lastName='-';
//                             	// if (profsActif[i].firstName===undefined) profsActif[i].firstName='-';
//                             	if (profsActif[i].id>0 && profsActif[i].isProfTx===true) {
//                             		m.user.profs[profsActif[i].id] = profsActif[i];
//                             	}
//                             }
//                             m.user.profsTx = profsActif.filter(function (p) {
//                                 return p.isProfTx===true;
//                             });
//                             m.user.md = m.user.profsTx.filter(function (p) {
//                             	return p.professionalType === "MD_OMNIPRATICIEN" || p.professionalType === "MD_SPECIALISTE";
//                             });
//                             m.user.profsAppt = profsActif.filter(function (p) {
//                             	return p.useAppointment===true;
//                             });
//                         }
                    } catch (e) {
                        console.error("Could not initiate professionals object", e);
                    }

                    try {                    		
                        var groups = INITCALLS.groups.res.data;
                        //Set group cache
                        if (groups != null) {
                            for (i = 0; i < groups.length; i++) {
    							if (groups[i].name) {
    								groups[i].nameLc = groups[i].name.toLowerCase().removeAccentsLc();
    							}
                                m.user.groups[groups[i].id] = groups[i];
                            }
                        }
                    } catch (e) {
                        console.error("Could not initiate user groups object", e);
                    }

                    try {
                        var sites = INITCALLS.sites.res.data;
                        //set sites cache
                        if (sites != null) {
                            for (i = 0; i < sites.length; i++) {
                                m.user.sites[sites[i].id] = sites[i];
                            }
                        }
                        m.user.session.setWorkSite = function(site){
                            m.user.session.site = site.id
                            site.colorStr = "rgb("+site.color.join(",")+")"
                            m.user.session.workSite = site;
                            // console.log(site);

                        }
                        m.user.session.setWorkSite(m.user.sites[m.user.session.site]);
                        m.site.tab.isLoadingList = false;

                    } catch (e) {
                        console.error("Could not initiate sites object", e);
                    }

                    try {
                        m.debug.dev = INITCALLS.debugMode.res.data;
                    } catch (e) {
                        console.error("Could not initiate dev object", e);
                    }

                    m.patientStatusColors = INITCALLS.patientStatusColor.res.data;

                    // INITCALLS.clientPref.res.data =  dashboard/pref/ws/clientPref. TODO N'est plus utilisé??? Erreur de merge???
                    try {
                        var sss = INITCALLS.secteur.res.data;
                        m.ress.secteur.push(...sss);;
                        m.ress.secteurObj = {};
                        if (sss != null) {
                            for (i = 0; i < sss.length; i++) {
                                m.ress.secteurObj[sss[i].id] = sss[i];
                            }
                            m.currentSect = sss[0];
                        }
                    } catch (e) {
                        console.error("Could not initiate Secteur object", e);
                    }
                    try {
                        var sss = INITCALLS.taxes.res.data;
                        m.ress.taxes.push(...sss);;
                        m.ress.taxesObj = {};
                        if (sss != null) {
                            for (i = 0; i < sss.length; i++) {
                                m.ress.taxesObj[sss[i].id] = sss[i];
                            }
                        }
                    } catch (e) {
                        console.error("Could not initiate Taxes object", e);
                    }

                    try {
                    	m.ress.defData.push(...INITCALLS.defData.res.data);
                    	m.ressource.currList = m.currentSect ? m.ress.defData.filterFast(function(a){return a.idSecteur===m.currentSect.id;}) : m.ress.defData;
                        m.ressource.currRessource = m.ressource.currList.length>0 ? m.ressource.currList[0] : undefined;
                    } catch (e) {
                    	console.error("Could not initiate Ressource object", e);
                    }

                    try {
                        m.isWeb = INITCALLS.isWeb.res.data.obj;
                    } catch (e) {
                        console.error("Could not initiate isWeb object", e);
                    }

                    try {
                        m.enums = INITCALLS.allEnums.res.data;
                        //Rachel Charron-Drolet: Allo Albert! Le code 14 n'existe plus depuis 2019, je suggère de le laisser mais de mettre un tirer ("-") comme description seulement ? 
                        model.enums().b2bDisabilityCode.C14.i18n = "-";
                    } catch (e) {
                        console.error("Could not initiate backendEnums object", e);
                    }
                    //List are saved as an object and not an array for faster access.
                    try {
                        var audioResponse = INITCALLS.lostDictation.res.data;
                        if (audioResponse && audioResponse.length>0) {
							OfysUtils.openTextWindow(audioResponse);
						}
                    } catch (e) {
                        console.error("Could not initiate backendEnums object", e);
                    }
                });

                // prend plus de temps à se faire - je les mets ici car pas important pour l'affichage immédiat
                $q.all([
                    $http.post("/dashboard/forms/ws/getCnesstDV", {}), /*0 */
					// $http.get("/dashboard/crds/ws/listForm", {})
                    //$http.get("/dashboard/User/ws/userDashboardCounts",{})
                ]).then(function (res) {
                    try {
                        // cnesst domain values
                        var cnesst = res[0].data.obj;
                        if (cnesst !== undefined) {
                            Object.keys(cnesst).forEach(function (k, index) {
                                m.cnesstDV.push({
                                    key: k,
                                    text: cnesst[k]
                                });
                            });
                        }
                    } catch (e) {
                        console.error("Could not initiate cnesst object", e);
                    }
					// try{
					// 	var crds = res[1].data.obj;
                    //     if (crds !== undefined) {
                    //         crds.forEach(function(k) {
                    //             m.crdsList.push(k);
                    //         });
                    //     }
					// }catch (e){
					// 	console.error("Could not initiate crds object", e);
					// }
                });

                
            }, error);

            
            function error() {
                alert("Erreur de communication avec le serveur, veuillez rafraichir la page. Si le problème persiste contactez Infodata.")
            }

            var isIE = OfysUtils.isMicrosoftBrowser();
            var inEmbededBrowser = (typeof EmbededBrowser != 'undefined' && typeof EmbededBrowser === 'function');

            m.notifAlert = {
                show: true,
                notify: function(){

                }
            };

            m.notice = {};
            m.notice.ifEmbeded = function (msg) {
                if (!inEmbededBrowser) {
                    new jBox('Notice', {
                        color: 'green',
                        content: msg,
                    });
                }
            };
            m.notice.success = function (msg) {
                new jBox('Notice', {
                    color: 'green',
                    content: msg,
                    closeOnClick: true,
                    closeOnEsc: true,
                    attributes: {
                        x: 'right',
                        y: 'bottom'
                    }
                });
            };
            m.notice.info = function (msg, options) {
                options = $.extend({
            		color: 'blue',
            		content: msg,
            		closeOnClick: true,
            		closeOnEsc: true,
                    closeButton: true,
                    autoClose: false,
            		attributes: {
            			x: 'right'
            		}
            	}, (options === undefined ? {}: options))
            	new jBox('Notice', options);
            };
            m.notice.fail = function (msg, title, keepOpen) {
                if(keepOpen === undefined){
                    keepOpen = false;
                }
                new jBox('Notice', {
                    color: 'red',
                    content: msg.replace(/</g,'').replace(/>/g,'').replace(/\n/g, "<br>"),
                    title: title,
                    offset: {
                        y: 80
                    },
                    closeOnClick: false,
                    closeOnEsc: true,
                    closeButton: true,
                    autoClose: keepOpen
                });
            };
            m.notice.warn = function (msg, options) {
				options = $.extend({
					color: 'yellow',
                    content: msg.replace(/</g,'').replace(/>/g,'').replace(/\n/g, "<br>"),
                    closeOnClick: false,
                    closeOnEsc: true,
                    closeButton: true,
                    autoClose: false
				}, (options === undefined ? {}: options))
                new jBox('Notice', options);
            };
			m.notice.note = function (msg) {
                new jBox('Notice', {
                    addClass: 'jBox-yellowGreen',
                    content: msg.replace(/</g,'').replace(/>/g,'').replace(/\n/g, "<br>"),
                    closeOnClick: true,
                    closeOnEsc: true,
                    closeButton: true,
                    autoClose: false
                });
            }

            //Getter setter for debug menu state for permanent pin. 
            //if a state (Boolean value) is passed as parameter, it is set as the new value value and is returned 
            function debugActiveState(state) {
                var isDebugActive = "ShowOfysAppDebugMode";
                if (state !== undefined) {
                    if (state) {
                        localStorage.setItem(isDebugActive, state);
                    } else {
                        localStorage.removeItem(isDebugActive, state);
                    }
                    m.debug.pinMenu = state;
                }
                return localStorage.getItem(isDebugActive) ? true : false;
            }

            m.qv = {
                itemsGroupCount: 0,
                items: {},
                group: {}
            };

            m.qe = {
                items: {}
            };

            function setUpPrefrencesGetterSetters(settings, getterSetterObject, prefix) {
                if (!prefix) prefix = "";
                for (var i = 0; i < settings.length; i++) {
                    //Closure to keep the context of the current pref fetched from the array
                    (function (pref) {
                        getterSetterObject[pref] = function (val) {
                            if (arguments.length) {
                                model.prefSettings(prefix + pref, val);
                            } else {
                                return model.prefSettings(prefix + pref);
                            }
                        };

                    })(settings[i]);
                }
            }

            var model = {
                //True when all initial promises have been resolved.
                ready: ready,
                store: Store,
                logout: function(){
                    if(this.isWeb()){
                        this.redirectToLogout();
                    }else{
                        window.close();
                    }
                },
                redirectToLogout: function (){
                    location.href = "/login.html"
                },
                fromStore: function(cache, filter){
                    var res = Store;
                    if(res[cache]){
                        if(res.filter[filter]){
                            return res.filter[filter];
                        }
                        return res[cache].list;
                    }
                },
                isWeb: function (){
                    return m.isWeb
                },
                atomicInt: function () {
                    return atomicInt();
                },
                dayDataCntsSafir: function () {
                    return m.dayDataCntsSafir;
                },
                dayDataCntsAllButSafir: function () {
                    return m.dayDataCntsAllButSafir;
                },
                browserSettings: function (key, value) {
                    if (arguments.length === 2) {
                        PrefAccessor.setBrowserProp(key, value);
                    } else if (arguments.length === 1) {
                        return PrefAccessor.browserSettings[key];
                    } else {
                        return PrefAccessor.browserSettings;
                    }
                },
                prefSettings: function (key, value) {
                    if (arguments.length === 2) {
                        m.prefSettings[key] = value;
                        PrefAccessor.setUserProp({
                            k: key,
                            v: value
                        }, function (resData) {
                            // console.log(resData);
                        });
                    } else if (arguments.length === 1) {
                        return m.prefSettings[key];
                    } else {
                        return m.prefSettings;
                    }
                },
                /* 
                Helper function to add multiple getter and setter preferences eg

                model.addPrefSettings([
                 'language','dob', 'numerised'
                ], scope.preferences, 'ptedit_');

                The above example adds three getter setter functions to the scope.preferences variable
                scope.preferences.language() -- returns the value of the preference ptedit_language
                scope.preferences.language(value) -- sets the value of the preference ptedit_language
                scope.preferences.dob() -- returns the value of the preference ptedit_dob
                scope.preferences.numerised() -- returns the value of the preference ptedit_numerised

                @Params 
                settings : an array of getter and setter variable names.
                getterSetterObject: the object to which the getter and setters are added.
                prefix : a prefix for the full name of a prefrences. (this param is optional)
                */
                addPrefSettings: function (settings, getterSetterObject, prefix) {
                    setUpPrefrencesGetterSetters(settings, getterSetterObject, prefix);
                },

                enums: function(){
                    return m.enums;
                },
                appointment: function () {
                    return m.appointment;
                },
				appointmentResearch: function () {
                    return m.appointmentResearch;
                },
				research: function() {
					return m.research;
				},
				utilPat: function(){
					return m.utilPat;
				},
                schedule: function () {
                    return m.schedule;
                },
				recall: function(){
					return m.recall;
				},
                ressource: function () {
                	return m.ressource;
                },
                billed: function () {
                	return m.billed;
                },
                onlyActive: function () {
                    return m.onlyActive;
                },
				print: function(){
					return m.print;
				},
				scan: function(){
					return m.scan;
				},
                patientStatuses: function () {
                    return m.patientStatuses;
                },
                appAllStatus: function () {
                    return m.appAllStatus;
                },
                patientStatusColors: function (v) {
                    return m.patientStatusColors[v];
                },
                currentPatientData: function () {
                    return m.currPatientData;
                },
                setCurrPatientData: function (obj) {
                    if (angular.isUndefined(obj.b2bPatientData)) {
                        obj.b2bPatientData = {};
                    }
                    if (angular.isUndefined(obj.b2bPatientData.prof)) {
                        obj.prof = {};
                    }
                    if (angular.isUndefined(obj.b2bPatientData.lieuSuiv)) {
                        obj.b2bPatientData.lieuSuiv = {};
                    }
                    if (angular.isUndefined(obj.b2bPatientData.lieuSuiv.local)) {
                        obj.b2bPatientData.lieuSuiv.local = {};
                    }
                    if (angular.isUndefined(obj.b2bPatientData.lieuSuiv.etab)) {
                        obj.b2bPatientData.lieuSuiv.etab = {};
                    }
                   m.currPatientData = obj;
                },
                client: function (v) {
                    return v ? m.user.session.client[v] : m.user.session.client;
                },
                clientPreferences: function (v) {
					if (m.user && m.user.session) {
			            return v ? m.user.session.clientPreferences[v] : m.user.session.clientPreferences;
					}						
                },
                ramqInscriptionUpdated: notifierGetSet('ramqInscriptionUpdated'),
                encounterUpdated: notifierGetSet('encounterUpdated'),
                userUpdated: notifierGetSet('userUpdated'),
                userDataUpdated: notifierGetSet('userDataUpdated'),
                patientUpdated: notifierGetSet('patientUpdated'),
                patientDataUpdated: notifierGetSet('patientDataUpdated'),
                courrielDataUpdate: notifierGetSet('courrielDataUpdate'),
                taskDataUpdate: notifierGetSet('taskDataUpdate'),
                courrielViewUpdate: notifierGetSet('courrielViewUpdate'),
                formDataUpdated: notifierGetSet('formDataUpdated'),
                srvyDataUpdated: notifierGetSet('srvyDataUpdated'),
                adminPageUpdate: notifierGetSet('adminPageUpdate'),
                cnesstDV: function () {
                    return m.cnesstDV;
                },				
                docDataUpdated: function (v, d, f) {
                    if (arguments.length) {
                        if (arguments.length > 1) {
                            m.docDataUpdated.doc = d;
                        } else if (m.docDataUpdated.doc) {
                            delete m.docDataUpdated.doc;
                        }
                        if (arguments.length > 2) {
                            m.docDataUpdated.noteFrm = f;
                        } else if (m.docDataUpdated.noteFrm) {
                            delete m.docDataUpdated.noteFrm;
                        }
                        $timeout(function () {
                            m.docDataUpdated.val++;
                            // console.log('val=' + m.docDataUpdated.val);
                        }, 100);
                    }
                    return m.docDataUpdated;
                },
                labDataUpdated: function (v, d) {
                    if (arguments.length) {
                        if (arguments.length > 1) {
                            m.labDataUpdated.doc = d;
                            //} else if (m.labDataUpdated.doc) {
                            //delete m.labDataUpdated.doc;
                        }
                        $timeout(function () {
                            m.labDataUpdated.val++;
                            //console.log('val=' + m.labDataUpdated.val);
                        }, 100);
                    }
                    return m.labDataUpdated;
                },
                patientChronoUpdated: notifierGetSet('patientChronoUpdated'),
                patientSumUpdated: notifierGetSet('patientSumUpdated'),
                actUpdated: notifierGetSet('actUpdated'),
                translationUpdate: notifierGetSet('translationUpdate'),
                formLinkUpdated: notifierGetSet('formLinkUpdated'),
                editModeUpdated: notifierGetSet('editModeUpdated'),
                searchPtUpdated: notifierGetSet('searchPtUpdated'),
                searchSiteUpdated: notifierGetSet('searchSiteUpdated'),
				templateLstUpdated: notifierGetSet('templateLstUpdated'),
				invoiceUpdated: notifierGetSet('invoiceUpdated'),
                ressLstUpdated: notifierGetSet('ressLstUpdated'),
                apptLstUpdated: notifierGetSet('apptLstUpdated'),
                apptUpdated: notifierGetSet('apptUpdated'),
                refreshCountsUpdated: notifierGetSet('refreshCountsUpdated'),
                sofiaUpdated: notifierGetSet('sofiaUpdated'),
                docCntsUpdated: notifierGetSet('docCntsUpdated'),
                labCntsUpdated: notifierGetSet('labCntsUpdated'),
                labels: function (v, d) {
                    if (arguments.length) {
                        if (arguments.length > 1) m.labels.data = d;
                        m.labels.fetched = v;
                    }
                    return m.labels;
                },
                activeController: function (v) {
                    // pour savoir quel controleur est actif, soit pt ou rv. Cette valeur est ensuite utiliser pour conserver 
                    // le patient a/a son controleur.
                    if (arguments.length) {
                        m.activeController = v;
                    }
                    return m.activeController;
                },
                activeMenu: function (v) {
                    // pour savoir quel menu est actif, soit Patients ou Appointments. Cette valeur est ensuite utiliser pour les liens des sections 
                    if (arguments.length) {
                        m.activeMenu = v;
                    } else {
                        m.activeMenu = $location.$$path.substring(1);
                    }
                    return m.activeMenu;
                },
				isSumEdit: function (v) {
					if (arguments.length) {
                        m.isSumEdit = v;
                    }
                    return m.isSumEdit;
				},
                patientAllDataTabs: function () {
                    return m.patientAllDataTabs;
                },
                patientQvAllDataTabs: function () {
                    return m.patientQvAllDataTabs;
                },
                userAllDataTabs: function () {
                    return m.userAllDataTabs;
                },
                userQvAllDataTabs: function () {
                    return m.userQvAllDataTabs;
                },
                faxQvAllDataTabs: function () {
                	return m.faxQvAllDataTabs;
                },
                crds: function(){
                    return m.crds;
                },
                patient: function (c) {
                    if (arguments.length) {
                        return m.patient[c];
                    }
//					if(m.activeController == "template")return m.patient['pt']
                    return m.patient[m.activeController];
                },
                currentSect: function (c) {
                	if (arguments.length) {
                		return m.currentSect = c;
                	}
                	return m.currentSect;
                },
                currentRess: function (c) {
                	if (arguments.length) {
                		return m.currentRess = c;
                	}
                	return m.currentRess;
                },
                currentApptMd: function (c) {
                	if (arguments.length) {
                		return m.currentApptMd = c;
                	}
                	return m.currentApptMd;
                },
                currentLaboDocMd: function (c) {
                	if (arguments.length) {
                		return m.currentLaboDocMd = c;
                	}
                	return m.currentLaboDocMd;
                },
                currentCourrielUser: function (c) {
                	if (arguments.length) {
                		return m.currentCourrielUser = c;
                	}
                	return m.currentCourrielUser;
                },
                getPatNameDdn: function (p) {
                    return p.lastName + ", " + p.firstName + " " + (p.birthDate ? p.birthDate : "");
                },
                getPatIdTitle: function (p) {
                    return p.lastName + ", " + p.firstName + " " + (p.birthDate ? p.birthDate : "") + "/" + p.gender;
                },
                getPatIdTitle2: function (p) {
                    return p.lastName + ", " + p.firstName + " " + p.birthDate + " (" + p.gender + "), " + p.healthInsuranceNumber;
                },
                getIdentifiers: function (p) {
                    var ident = "";
                    if (p && OfysUtils.isNotEmpty(p.lstPatientIdentifier) && p.lstPatientIdentifier.length > 0) {
                        ident = " (";
                        for (var i = 0, len = p.lstPatientIdentifier.length; i < len; i++) {
                            ident += p.lstPatientIdentifier[i].identifier + ",";
                        }
                        ident = ident.slice(0, -1) + ")";
                    }
                    return ident;
                },
                getOtherProv: function (p) {
                	var prov = "";
                	//var infobulle = "";
                	if (p) {
                		var infos = [];
                        var provLabel = $filter('translate')('Professionals') + ": ";
                		if (p.treatingProfessionnal) {
        					Store.profs.get(p.treatingProfessionnal, function(prof, loadedFromServer){
                                if(loadedFromServer){
                                    model.patientUpdated(true);
                                }
        						prov += "<b>" + prof.firstName.charAt(0)+' '+prof.lastName + "</b>, ";
                            });
        					}
                		if (OfysUtils.isNotEmpty(p.lstPatientProfessionnal) && p.lstPatientProfessionnal.length > 0) {
	                		for (var i = 0, len = p.lstPatientProfessionnal.length; i < len; i++) {
	                			var idProf = p.lstPatientProfessionnal[i].idProfessionnal;
	        					Store.profs.get(idProf, function(prof, loadedFromServer){
                                if(loadedFromServer){
                                    model.patientUpdated(true);
                                }
	        					var type = "";
	        					switch(prof.professionalType) {
	        					  case 'INFIRMIERE':
	        					    type = ' (Inf)';
	        						//infos.push("I = Infirmière");
	        					    break;
	        					  case 'INFIRMIERE_PRATICIENNE':
	        						  type = ' (InfPr)';
		        					  //infos.push("Ip = Infirmière praticienne");
	        						  break;
	        					  case 'RESIDENT':
	        						  type = ' (Res)';
		        					  //infos.push("R = Résident");
	        					    break;
	        					  case 'PHARMACIEN':
	        						  type = ' (Pha)';
		        						//infos.push("Ph = Pharmacien");
	        						  break;
	        					  case 'PSYCHOLOGUE':
	        						  type = ' (Psyc)';
		        						//infos.push("Ps = Psychologue");
	        						  break;
	        					  case 'TRAVAILLEUR_SOCIAL':
	        						  type = ' (TrSoc)';
		        						//infos.push("Ts = Travailleur social");
	        						  break;
	        					  case 'MD_OMNIPRATICIEN':
	        						  type = ' (Omni)';
		        						//infos.push("Mo = Médecin omnipraticien");
	        						  break;
	        					  case 'MD_SPECIALISTE':
	        						  type = ' (Spec)';
		        						//infos.push("Ms = Médecin spécialiste");
	        						  break;
	        					  default:
	        					    // code block
	        					}
	        						prov += prof.firstName.charAt(0)+' '+prof.lastName + type;
                                });
	        					prov += ", ";
	                		}
	                	}
                		//var uniqueInfo = _.uniq(infos);
                		//infobulle = uniqueInfo.join(" \n");
                		prov = prov.length>4 ? prov.slice(0, -2) : prov;
                		if (prov.length>0) {
                			prov = provLabel + prov;
                		}
                	}
                	return prov;
                },
                docCached: function (idProf, ids, currList) {
                    if (ids===undefined) return;
                    if (ids===null && m.docCached[idProf]) {
                    	delete m.docCached[idProf];
                    	return;
                    }
                    if (arguments.length === 2 && m.docCached[idProf]) {
                        if (m.docCached[idProf][ids]) {
                            return m.docCached[idProf][ids].lst;
                        }
                    } else if (arguments.length === 3) { // donc nouvelle liste
                        if (currList === null) {
                            if (m.docCached[idProf] && angular.isDefined(m.docCached[idProf][ids])) {
                                delete m.docCached[idProf][ids];
                            }
                            return;
                        }
                    }
                     if (angular.isUndefined(m.docCached[idProf])) {
                    	m.docCached[idProf] = {};
                    }
                    if (angular.isUndefined(m.docCached[idProf][ids])) {
                    	m.docCached[idProf][ids] = {};
                    }
                    m.docCached[idProf][ids].lst = currList;
                    m.docCached[idProf][ids].expires_on = new Date(new Date().getTime() + 60000 * 5); // expire dans 5 min
                },
                labCached: function (idProf, ids, currList) {
                    if (ids===undefined) return;
                    if (ids===null && m.labCached[idProf]) {
                    	delete m.labCached[idProf];
                    	return;
                    }
                    if (arguments.length === 2 && m.labCached[idProf]) {
                        if (m.labCached[idProf] && m.labCached[idProf][ids]) {
                            return m.labCached[idProf][ids].lst;
                        }
                    }
                    if (arguments.length === 3) { // donc nouvelle liste
                        if (currList === null) {
                            if (m.labCached[idProf] && angular.isDefined(m.labCached[idProf][ids])) {
                                delete m.labCached[idProf][ids];
                            }
                            return;
                        }
                    }
                     if (angular.isUndefined(m.labCached[idProf])) {
                        m.labCached[idProf] = {};
                    }
                    if (angular.isUndefined(m.labCached[idProf][ids])) {
                    	m.labCached[idProf][ids] = {};
                    }
                    m.labCached[idProf][ids].lst = currList;
                    m.labCached[idProf][ids].expires_on = new Date(new Date().getTime() + 60000 * 5); // expire dans 5 min
                },
                msgCached: function (ids, currList) {
                    if (!ids) return;
                    if (arguments.length === 1) {
                        if (m.msgCached[ids]) {
                            return m.msgCached[ids].lst;
                        }
                    } else if (arguments.length === 2) { // donc nouvelle liste
                        if (currList === null) {
                            if (angular.isDefined(m.msgCached[ids])) {
                                delete m.msgCached[ids];
                            }
                        } else if (angular.isUndefined(m.msgCached[ids])) {
                            m.msgCached[ids] = {};
                        }
                        m.msgCached[ids].lst = currList;
                        m.msgCached[ids].expires_on = new Date(new Date().getTime() + 60000 * 5); // expire dans 5 min
                    }
                },
                taskCached: function (ids, currList) {
                    if (!ids) return;
                    if (arguments.length === 1) {
                        if (m.taskCached[ids]) {
                            return m.taskCached[ids].lst;
                        }
                    } else if (arguments.length === 2) { // donc nouvelle liste
                        if (currList === null) {
                            if (angular.isDefined(m.taskCached[ids])) {
                                delete m.taskCached[ids];
                            }
                        } else if (angular.isUndefined(m.taskCached[ids])) {
                            m.taskCached[ids] = {};
                        }
                        m.taskCached[ids].lst = currList;
                        m.taskCached[ids].expires_on = new Date(new Date().getTime() + 60000 * 5); // expire dans 5 min
                    }
                },
                taskCachedAllTasks: function () {
					var arrTasks = _.values(m.taskCached);
					var tasks = [];
					for(var i = 0; i < arrTasks.length; i++){
						tasks = _.union(tasks,arrTasks[i].lst);
					}
					return tasks
                },
                mailCached: function (ids, currList) {
                	if (arguments.length ===0) {
                		// on efface tout.
                        Object.keys(m.mailCached).forEach(function (key, index) {
                    		delete m.mailCached[key];
                        });
                		return;
                	}
                	if (arguments.length === 1) {
                		if (m.mailCached[ids]) {
                			return m.mailCached[ids].lst;
                		}
                	} else if (arguments.length === 2) { // donc nouvelle liste
                		if (currList === null) {
                			if (angular.isDefined(m.mailCached[ids])) {
                				delete m.mailCached[ids];
                			}
                		} else if (angular.isUndefined(m.mailCached[ids])) {
                			m.mailCached[ids] = {};
                		}
                		m.mailCached[ids].lst = currList;
                		m.mailCached[ids].expires_on = new Date(new Date().getTime() + 60000 * 5); // expire dans 5 min
                	}
                },
                patientsInQv: function (idPat, currPat) { // currPat null si on veut retirer l'objet

                    //idPat doit être definie et si currPat est passé le viewbag doit exister.
                    if (!idPat) return;
                    var cache = m.patientsInQv;
                    if (arguments.length === 1) {
                        if (cache[idPat]) {
                            return cache[idPat].pt;
                        }
                    } else if (arguments.length === 2) { // donc ouverture ou fermeture d'un QV

                        // debounceClear();//s'active seulement si j'ajoute une autre element dans le cache ou que je veut supprimer un autre patient.
                        if (currPat === null) {
                            if (angular.isDefined(cache[idPat])) {
                                cache[idPat].count--;
                                var pat = cache[idPat].pt;
                                $log.log("CACHE -- (" + cache[idPat].count + ") " + idPat + ": " + pat.lastName + " " + pat.firstName);
                                if (cache[idPat].count === 0) {
                                    // setForClear(idPat);
                                    clearPatientData(cache[idPat].pt)
                                }
                            }
                        } else if (angular.isDefined(cache[idPat])) {
                            // 2e param peut être simplement un boolean car parfois, on sait que le pat est là mais pas dans la méthode appelante.
                            cache[idPat].count++;
                            var pat = cache[idPat].pt;
                            $log.log("CACHE ++ (" + cache[idPat].count + ") " + idPat + ": " + pat.lastName + " " + pat.firstName);
                            return pat;
                        } else if (angular.isUndefined(cache[idPat]) && currPat.id && currPat.viewbag) {
                            cache[idPat] = {};
                            cache[idPat].count = 1;
                            cache[idPat].pt = currPat;
                            $log.log("CACHE add " + idPat + ": " + currPat.lastName + " " + currPat.firstName);
                            return currPat;
                        }
                    }

                    function setForClear(id) {
                        if (id !== undefined && id !== null) {
                            cache.clearPatientsQueue[id] = moment();
                        } else {
                            $log.error("Invalid patient id set for clear in quickview patient cache.");
                        }
                    }

                    function debounceClear() {
                        Object.keys(cache.clearPatientsQueue).forEach(function (id) {
                            if (isInvalid(id)) {
                                clearPatientData(cache[id].pt);
                            }
                        });
                    }

                    function isInvalid(id) {
                        if (cache[id] && cache.clearPatientsQueue[id]) {
                            var lastCacheClear = cache.clearPatientsQueue[id];
                            var secSinceLastClear = moment().diff(lastCacheClear, 'second')
                            return cache[id].count < 1 &&
                                secSinceLastClear > 5;
                        } else {
                            return false; // le cache n'as pas été supprimé.
                        }
                    }

                    function clearPatientData(pat) {
                        delete cache.clearPatientsQueue[pat.id]
                        delete pat.viewbag;
                        $log.log("CACHE del " + pat.id + ": " + pat.lastName + " " + pat.firstName);
                        delete cache[pat.id];
                        if (m.suiviPrevs) {
	                        if (m.suiviPrevs.pat[pat.id]) delete m.suiviPrevs.pat[pat.id];
    	                    if (m.suiviPrevs.base && m.suiviPrevs.base) {
								var dones = m.suiviPrevs.base.filter(function(e) {return e.dones!=undefined;});
								if (dones.length>0) {
									dones.forEach(function(e) {
										if (e.dones[pat.id]) {
											delete e.dones[pat.id];
										}
									});
									
								}
							}
						}
                    }
                },
                dayData: function (idProf) {
                    return idProf===undefined ? m.dayData : m.dayData[idProf];
                },
                rxVigilance: function() {
                	return m.rxVigilance;
                },
                metabase: function() {
                	return m.metabase;
                },
                safeCall: function(fn){
                    try{
                        if(fn){
                            return fn();
                        }
                    }catch(e){
                        $log.error(e);
                    }
                },
                roles: function () {
                    return m.roles;
                },
                suiviPrevs: function () {
                    return m.suiviPrevs;
                },
                forms: function () {
                    return m.forms;
                },
                document: function () {
                    return m.document;
                },
                labo: function () {
                    return m.laboratory;
                },
                user: function () {
                    return m.user;
                },
                site: function () {
                    return m.site;
                },
				template: function(){
					return m.template;
				},
                admin: function () {
                    return m.admin;
                },
                ress: function () {
                	return m.ress;
                },
                review: function () {
                    return m.review;
                },
//                chat: function () {
//                    return m.chat;
//                },
                courriel: function () {
                	return m.courriel;
                },
                task: function () {
                    return m.task;
                },
                search: function () {
                    return m.search;
                },
                notifAlert:function(){
                    return m.notifAlert;
                },
                notice: function () {
                    return m.notice;
                },
                qv: function () {
                    return m.qv;
                },
                screenClass: function () {
                    if (OfysUtils.MOBILE.matches) {
                        return 'mobile';
                    } else {
                        return 'ecran_large'
                    }
                },
                isMobile: function () {
                    return OfysUtils.MOBILE.matches
                },
                isLargeScreen: function () {
                    return !OfysUtils.MOBILE.matches
                },
                listQvPatSize: function(ls) {
                	if (arguments.length) {
                		this.browserSettings('list_qv_size', ls);
                		this.patientSumUpdated(true);
                	} else {
            			var s = this.browserSettings('list_qv_size');
            			return s===undefined ? 1 : s;
                	}
                },
                listApptSize: function(ls) {
                	if (arguments.length) {
                		this.prefSettings('list_appt_size', ls);
                		this.patientSumUpdated(true);
                	} else {
            			var s = this.prefSettings('list_appt_size');
            			return s===undefined ? 1 : s;
                	}
                },
                listRessSize: function(ls) {
                	if (arguments.length) {
                		this.prefSettings('list_ress_size', ls);
                		this.patientSumUpdated(true);
                	} else {
            			var s = this.prefSettings('list_ress_size');
            			return s===undefined ? 1 : s;
                	}
                },
				listResearchSize: function(ls) {
                	if (arguments.length) {
                		this.prefSettings('list_research_size', ls);
                		this.patientSumUpdated(true);
                	} else {
            			var s = this.prefSettings('list_research_size');
            			return s===undefined ? 1 : s;
                	}
                },
				listResearchOptionSize: function(ls) {
                	if (arguments.length) {
                		this.prefSettings('list_research_option_size', ls);
                		this.patientSumUpdated(true);
                	} else {
            			var s = this.prefSettings('list_research_option_size');
            			return s===undefined ? 1 : s;
                	}
                },
                listPatSize: function(ls) {	// si liste de recherche est 0, on ne permet pas de diminuer
                    if (arguments.length) {
                    	if (this.patient().currList.length > 0) {
                    		this.prefSettings('list_pat_size', ls);                    		
                    	} else {
                    		this.prefSettings('list_pat_size', 1);                 		
                    	}
                    	this.patientSumUpdated(true);
                    } else {
                    	var lps = this.prefSettings('list_pat_size');
                    	if (this.patient().currList.length === 0 && lps!==1) {
                    		this.prefSettings('list_pat_size', 1);
                    		return 1;
                    	}
                    	return this.prefSettings('list_pat_size');
                    }
                },
                qe: function () {
                    return m.qe;
                },
                home: function () {
                    return m.home;
                },
                debug: function () {
                    return m.debug;
                },
                handlePrint: handlePrint,
                loadingOverlay: function () {
                    return m.loadingOverlay;
                },//Doit être ajouter à toute les pages pour afficher les counts du nav
                callDashBoardCount: function (fct, forceReload, md) {
                    m.callDashBoardCount(fct, forceReload, md);
                },
                callDashBoardLabosDocsCount: function (fct, forceReload, md) {
                	m.callDashBoardLabosDocsCount(fct, forceReload, md);
                },
                callDashBoardCountSafir: function (fct, forceReload) {
                    m.callDashBoardCountSafir(fct, forceReload);
                },
                stopDashBoardCountInterval: function () {
                    m.stopDashBoardCountInterval();
                },
                resetDashBoardCountInterval: function () {
                    m.resetDashBoardCountInterval();
                },
                openRxViglanceService: function(fct, item) {
//        			if (m.rxVigilance().rxvLicence>0 && m.rxVigilance().rxvUrl) {
//        				var now = Date.now();
//        				var fullDaysSinceEpoch = Math.floor(now/8.64e7);
//        				if (m.rxVigilance().token===undefined || m.rxVigilance().daySince1970!=fullDaysSinceEpoch) {
//        					UserAccessor.rxVigilanceToken(function (resp) {
//        						if (resp && resp.data && resp.data.token) {
//        							m.rxVigilance().token = resp.data.token;
//        							m.rxVigilance().daySince1970 = resp.data.daySince1970;
//        							fct(item);
//        						}
//        					});
//        				} else {
//        					fct(item);
//        				}
//        			}
                },
                webSocketActivity: function (v) {
                    if (arguments.length) {
                        m.webSocketActivity.last = Date.now(); // time ms since epoch
                        m.webSocketActivity.val = 1;
                        //m.webSocketActivity.val++;
                        //m.webSocketActivity.val = m.webSocketActivity.val>2 ? 1 : 2;
                        // si === 0 -> pas de communication avec backend
                        // si > 0 et pair / impair, permet de setter un icon qui 'bouge'
                        return
                    }
                    return m.webSocketActivity;
                },
                isIE: isIE,
                isEmbeded: inEmbededBrowser,
                fosucSearchTimeout: 600,
            };
            return model;
        }
    ]);

})();