 var APPLANG = 'fr';
(function () {
	var dashapi = angular.module('dash.api', []);
	

	dashapi.factory('SessionWatch', [function () {
		return {
			appStartDate: moment().format('YYYY-MM-DD HH:mm:ss'),
			status: 'ACTIVE',// possible values: ACTIVE, EXPIRED
			dialogOpen: false,
		}
	}]);

	dashapi.config(['$httpProvider', function($httpProvider) {
		// alternatively, register the interceptor via an anonymous factory
		$httpProvider.interceptors.push(['$q','SessionWatch','$log',
			 function($q, SessionWatch, $log) {
				 function getUrl(r){
					 if(r && r.config && r.config.url){
						 return r.config.url;
					 }
					 return "";
				 }
			return {
				'responseError': function(rejection) {
					if(rejection.status === 401 && 
						rejection.headers()["www-authenticate"] === "Ofys OfysConnect"){
							SessionWatch.status = 'EXPIRED';
							$log.error("Failed authorization: locked session"+
								" ##App start : "+ SessionWatch.appStartDate + 
								" ##Requested url : "+ getUrl(rejection) + 
								" ##Request date time : "+  moment().format('YYYY-MM-DD HH:mm:ss')
								)
					}
					return $q.reject(rejection);
				}
			};
		}]);
	}]);

	dashapi.factory('DashAPI', 
		['$http', '$translate','$q','$log','$timeout','$cookies', 
		function ($http, $translate, $q, $log, $timeout, $cookies) {
			var defaultConfigs = {
				showErrors: true,
				showWarnings: true,
				jsonActionResultFailAsError: false,
				getMessage: function (status, msg) {
					return msg;
				}
			};
			function isProd(v) {
				if (arguments.length) {
					$cookies.put("isProd", v);
				} else {
					var p = $cookies.get("isProd");
					return "false" !== p;
				}
			}

			//sets default configs
			function setUpRequestConfig(config) {
				if (config == undefined) {
					config = angular.copy(defaultConfigs);
				} else {
					config = $.extend(angular.copy(defaultConfigs), config)
				}
				return config;
			}

			function getConfig(config) {
				if (config === undefined) {
					return setUpRequestConfig();
				} else {
					return config;
				}
			}

			/**
			 * Make a http get call
			 * @param {*} url - http url 
			 * @param {*} rescallback - success function 
			 * @param {*} error - error function
			 * @param {*} config - request configurations e.g show response errors on result
			 */
			function getRes(url, rescallback, error, config) {
				config = setUpRequestConfig(config);
				//If resolution callbacks are not defined the promise is returned and the user should handle the call(error handling and resolving).
				if (rescallback !== undefined) {
					return $http.get(url, config).then(function (res) {
						if (isReturnObject(res.data)) {
							var msgLst = []
							var statusError = handleStatus(res.data.status, msgLst, config);

							if (statusError == 'OK') {
								rescallback(res.data.obj);
							}
							else if (statusError == 'WARNING') {
								// avec un returObject, le callBack reçoit l'objet direct. Pas besoin d'ajouter .data
								// warning(res.data.status.message.replaceAll("\n","<br>"));
								rescallback(res.data.obj, msgLst);
							}
							else {
								// fail(res.data.status.message.replaceAll("\n","<br>"));
								if (error) error(msgLst);
							}
						} else if(config.jsonActionResultFailAsError && isJsonActionResult(res.data) && res.data.success == false){
							if (error) error(res.data.ms);
						} else {
							rescallback(res);
						}
						return res;
					}, error);
				} else {
					return $http.get(url);
				}
			}

			// function postUidObjRes(path, obj, type, fct, error, config) {
			// 	var uidObj = {'o': obj, 'u': DashWebSocket.clientUid, 't' : type};
			// 	postRes(path, uidObj, fct, error, config);
			// $http({method : "POST",
			// 	url : path,
			// 	data:  JSON.stringify(uidObj),
			// 	headers: {'Content-Type': 'application/json; charset=utf-8'}
			// }).then(function(res) {
			// 	if (isReturnObject(res.data)) {
			// 		// un ReturnObject 
			// 		var statusError = handleStatus(res.data.status);

			// 		// un ReturnObject 
			// 		if (res.data.status.severity=='OK') {
			// 			if (fct) {
			// 				fct(res.data.obj);
			// 			}
			// 		} else {
			// 			fail(res.data.status.message.replaceAll("\n","<br>"));
			// 		}
			// 	} else if (fct) {
			// 		fct(res);		
			// 	}
			// }, function myError(response) {
			// 	warning(response.statusText);
			// });
			// }

			function postRes(url, data, rescallback, error, config) {
				config = setUpRequestConfig(config);
				//If resolution callbacks are not defined the promise is returned and the user should handle the call(error handling and resolving).
				if (rescallback !== undefined) {
					return $http.post(url, data, config).then(function (res) {
						if (isReturnObject(res.data)) {
							// un ReturnObject 
							var msgLst = []
							var statusError = handleStatus(res.data.status, msgLst, config);

							if (statusError == 'OK') {
								// avec un returObject, le callBack reçoit l'objet direct. Pas besoin d'ajouter .data
								rescallback(res.data.obj);
							}
							else if (statusError == 'WARNING') {
								// avec un returObject, le callBack reçoit l'objet direct. Pas besoin d'ajouter .data
								// warning(res.data.status.message.replaceAll("\n","<br>"));
								rescallback(res.data.obj, msgLst);
							}
							else {
								// fail(res.data.status.message.replaceAll("\n","<br>"));
								if (error) error(res, msgLst);
							}
						} else if(config.jsonActionResultFailAsError && isJsonActionResult(res.data) && res.data.success == false){
							if (error) error(res.data.ms);
						} else {
							rescallback(res);
						}
						return res;
					}, error);
				} else {
					return $http.post(url, data, config);
				}

			}

			function isReturnObject(data) {
				return !!(data && data.status && data.status.severity);
			}
			function isJsonActionResult(data) {
				return !!(data && data.success !== undefined && data.ms !== undefined);
			}

			var errorRank = { OK: 1, INFO: 2, WARNING: 3, NEED_MORE_INFO: 4, ERROR: 5, BUG: 6 };
			var errorRankInv = { 1: 'OK', 2: 'INFO', 3: 'WARNING', 4: 'NEED_MORE_INFO', 5: 'ERROR', 6: 'BUG' };
			function handleStatus(status, msgLst, config) {
				config = getConfig(config)//error handling in case the config is not yet set.
				if (!msgLst) {
					msgLst = [];
				}
				var highestError = "OK";
				if (status) {
					if (status.childrens) {
						var statusError;
						for (var i = 0; i < status.childrens.length; i++) {
							statusError = handleStatus(status.childrens[i], msgLst, config);
							if (errorRank[statusError] && errorRank[statusError] > errorRank[highestError]) {
								highestError = statusError;
							}
						}
					}

					if (errorRank[status.severity] && errorRank[status.severity] > 4) {
						msgLst.push(status);
						if (config.showErrors && status.message) {
							var msg = config.getMessage(status, status.message.replaceAll("\n", "<br>"))
							msg && fail(msg, config.errorNoticeConfig);
						}
					} else if (status.severity == 'WARNING') {
						msgLst.push(status);
						if (config.showWarnings && status.message) {
							var msg = config.getMessage(status, status.message.replaceAll("\n", "<br>"))
							msg && warning(msg, config.warnNoticeConfig);
						}
					} else if (status.severity == 'NEED_MORE_INFO') {
						msgLst.push(status);
					}
					if (errorRank[status.severity] && errorRank[status.severity] > errorRank[highestError]) {
						highestError = status.severity;
					}
				}
				return highestError;
			}

			//var errorRank = {OK: 1, INFO: 2, NEED_MORE_INFO:3, WARNING: 4,  ERROR:5, BUG:6};
			//return {'severity': string , 'warnings': list<string> , 'errors': list<string>, 'codes': list<string> }
			function newSimpleStatus(status) {

				function getStatusArray(status, arr) {
					if(arr == undefined){
						arr = [];
					}
					if (status && status.childrens) {
						for (var i = 0; i < status.childrens.length; i++) {
							getStatusArray(status.childrens[i], arr);
						}
						delete status.childrens;
					}
					arr.push(status);
					return arr;
				}

				function getHighestError(errors) {
					var rank = errorRank['OK'];
					for (var i = 0; i < errors.length; i++) {
						if (errorRank[errors[i]] && errorRank[errors[i]] > rank) {
							rank = errorRank[errors[i]]
						}
					}
					return rank;
				}

				function getMessageByType(groupByServerity, types) {
					function hasMessage(e){return e.message}
					function getMessage(e){return e.message}
					let res = types.reduce(function(res, type){
						if(groupByServerity[type]){
							res = res.concat(groupByServerity[type].filter(hasMessage).map(getMessage));
						}
						return res;
					}, []);
					return res;
				}
				var r = {
					status: getStatusArray(status),
					updateStatus: function(){
						function hasCode(e){return e && e.code && e.code !== 'NULL_CODE'; }
						function getCode(e){return e.code;}
						function getData(e){return e.data;}
						var groupBySeverity = _.groupBy(this.status, 'severity');
						this.severity = errorRankInv[getHighestError(Object.keys(groupBySeverity))];
						this.infos = getMessageByType(groupBySeverity, ['OK','INFO', 'NEED_MORE_INFO']);
						this.warnings = getMessageByType(groupBySeverity, ['WARNING']);
						this.errors = getMessageByType(groupBySeverity, ['ERROR', 'BUG']);
						this.codes = this.status.filter(hasCode).map(getCode);
						this.datas = this.status.filter(hasCode).map(getData);
					},
					'severity': errorRank['OK'],
					'infos': [],
					'warnings': [],
					'errors': [],
					'codes': [],
					'hasCode': function hasCode(code) {
						return this.codes.indexOf(code) != -1;
					},
					'getData': function getData(code) {
						let index = this.codes.indexOf(code);
						if (index != -1) {
							return this.datas[index];
						}
						return undefined;
					},
					'addError' : function addError(error) {
						this.severity = "ERROR";
						this.errors.push(error);
						return this;
					},
					'isOk': function () {
						return this.severity == 'OK' || this.severity == 'INFO';
					},
					'isError': function () {
						return this.severity == 'ERROR' || this.severity == 'BUG';
					},
					'isWarning': function () {
						return this.severity == 'WARNING';
					},
					'isInfo': function () {
						return this.severity == 'OK' || this.severity == 'INFO' || this.severity == 'NEED_MORE_INFO';
					},
					'notice' : function(errorCallback, warningCallback, infoCallback) {
						if (this.infos.length > 0 && infoCallback !== undefined) {
							this.infos.forEach(element => {
								infoCallback(element);
							});
						}
						if (this.warnings.length > 0 && warningCallback !== undefined) {
							this.warnings.forEach(element => {
								warningCallback(element);
							});
						}
						if (this.errors.length > 0 && errorCallback !== undefined) {
							this.errors.forEach(element => {
								errorCallback(element);
							});
						}
					},
					'removeStatusByCode': function(code){
						let resIndex = this.status.findIndex(function(e){return e.code === code});
						if(resIndex !== -1){
							var res = this.status.splice(resIndex, 1)[0];//splice returns table of removed elements.
							this.updateStatus();
							return res;
						}
					},	
					'getMessage': function () {
						var msg = "";
						for (let index = 0; index < this.warnings.length; index++) {
							const element = this.warnings[index];
							if (index > 0) {
								msg += "<br>";
							}
							msg += element.replaceAll("\n", "<br>");
						}
						for (let index = 0; index < this.errors.length; index++) {
							const element = this.errors[index];
							if (index > 0) {
								msg += "<br>";
							}
							msg += element.replaceAll("\n", "<br>");
						}
						return msg;
					},
					'merge' : function(otherSimpleStatus) {
						if (otherSimpleStatus === undefined) {
							//do nothing
						} else {
							this.infos.concat(otherSimpleStatus.infos)
							this.warnings.concat(otherSimpleStatus.warnings)
							this.errors.concat(otherSimpleStatus.errors)
							this.codes.concat(otherSimpleStatus.codes)
							//take most severe rank
							if (this.severity <= otherSimpleStatus.severity) {
								this.severity = otherSimpleStatus.severity;
							}
						}
						return this;
					}
				};
				r.updateStatus();

				return r;
			}

			//return {'severity': string , 'warnings': list<string> , 'errors': list<string>, 'codes': list<string> }
			function getSimpleStatus(status) {
				return newSimpleStatus(status);
			}

			function jboxNotice(defaultConfig, msgconfig){
				msgconfig = msgconfig == undefined ? {}:msgconfig;
				new jBox('Notice', angular.extend(defaultConfig, msgconfig));
			}
			function warning(msg, msgconfig) {
				jboxNotice({
					color: 'yellow',
					content: msg,
					closeOnClick: false,
					closeOnEsc: true,
					closeButton: true,
					autoClose: false
				}, msgconfig);
			}

			function fail(msg, msgconfig) {
				jboxNotice({
					color: 'red',
					content: msg,
					closeOnClick: false,
					closeOnEsc: true,
					closeButton: true,
					autoClose: false
				}, msgconfig);
			}

			function setLanguage() {
				var langCookie = "lang";
				var lang = $cookies.get(langCookie);
				if (lang === undefined) {
					$http.get('/dashboard/User/ws/lang').success(updateLanguage);
				} else {
					updateLanguage(lang)
				}
			}
			function updateLanguage(lang) {
				$translate.use(lang);
				moment.locale(lang);
				accessor.lang = lang;
				APPLANG = lang;
				var langCookie = "lang";
				// //In some cases multiple cookies have been created with diffrent paths. So to be sure to remove all previous instances multiple removes are applied.
				$cookies.remove(langCookie,{path:"/" ,expires:new Date('2099-12-31T12:00:00')});
				$cookies.remove(langCookie,{path:"/dashboard" ,expires:new Date('2099-12-31T12:00:00')});
				$cookies.remove(langCookie,{path:"/dashboard/" ,expires:new Date('2099-12-31T12:00:00')});
				$cookies.put(langCookie, lang, { expires: new Date('2099-12-31T12:00:00') });
			}

			function defaultLang() {
				var langCookie = "lang";
				var lang = $cookies.get(langCookie);
				var userLang = navigator.language || navigator.userLanguage;
				if (lang) {
					return lang;
				} else if (userLang) {
					return userLang === "fr-Fr" ? "fr" : "en";
				} else {
					return "fr";
				}
			}

			function hideMsg() {
				return { showErrors: false, showWarnings: false };
			}
			var accessor = { lang: defaultLang(), updateLanguage: updateLanguage, get: getRes, post: postRes, handleReturnObject: handleStatus, hideMsg: hideMsg, getSimpleStatus: getSimpleStatus, newSimpleStatus: newSimpleStatus, isProd: isProd };

			setLanguage();

			return accessor;
		}]);

})();