/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import java.util.Calendar;

public class CConsentement
extends CEditableDataObject {
    private static final long serialVersionUID = 1L;
    public Integer id;
    public Integer idPatientAnchor;
    public Integer idUserAnchor;
    public Long datetimeStart;
    public Long datetimeEnd;
    public Integer droits;
    private Boolean isActive = null;

    public CConsentement() {
    }

    public CConsentement(XConsentement cons) {
        this.init(cons);
    }

    private void init(XConsentement cons) {
        super.init((IEditableDataObject)cons);
        this.id = cons.getId();
        this.idPatientAnchor = cons.getIdPatientAnchor();
        this.idUserAnchor = cons.getIdUserAnchor();
        this.datetimeStart = cons.getDatetimeStart();
        this.datetimeEnd = cons.getDatetimeEnd();
        this.droits = cons.getDroits();
    }

    public XConsentement x() {
        XConsentement x = new XConsentement();
        super.x((EditableDataObject)x);
        x.id = this.id == null ? -1 : this.id;
        x.idPatientAnchor = this.idPatientAnchor == null ? -1 : this.idPatientAnchor;
        x.idUserAnchor = this.idUserAnchor == null ? -1 : this.idUserAnchor;
        x.datetimeStart = this.datetimeStart == null ? -1L : this.datetimeStart;
        x.datetimeEnd = this.datetimeEnd == null ? -1L : this.datetimeEnd;
        x.droits = this.droits == null ? -1 : this.droits;
        return x;
    }

    public boolean getIsActive() {
        if (this.isActive == null) {
            long t = Calendar.getInstance().getTimeInMillis();
            this.isActive = this.datetimeStart < t && (this.datetimeEnd == null || this.datetimeEnd > t);
        }
        return this.isActive;
    }

    public boolean getHasRightPatient() {
        return (this.droits & XConsentement.RIGHT_PATIENT) == XConsentement.RIGHT_PATIENT && this.getIsActive();
    }

    public boolean getHasRightComm() {
        return (this.droits & XConsentement.RIGHT_COMMUNICATION) == XConsentement.RIGHT_COMMUNICATION && this.getIsActive();
    }

    public boolean getHasRightAddres() {
        return (this.droits & XConsentement.RIGHT_ADDRESS) == XConsentement.RIGHT_ADDRESS && this.getIsActive();
    }

    public boolean getHasRightPatientOther() {
        return (this.droits & XConsentement.RIGHT_PATIENT_OTHER) == XConsentement.RIGHT_PATIENT_OTHER && this.getIsActive();
    }

    public boolean getHasRightDossier() {
        return (this.droits & XConsentement.RIGHT_DOSSIER) == XConsentement.RIGHT_DOSSIER && this.getIsActive();
    }

    public boolean getHasRightLabo() {
        return (this.droits & XConsentement.RIGHT_LABO) == XConsentement.RIGHT_LABO && this.getIsActive();
    }

    public boolean getHasRightDocument() {
        return (this.droits & XConsentement.RIGHT_DOCUMENT) == XConsentement.RIGHT_DOCUMENT && this.getIsActive();
    }

    public boolean getHasRightEForm() {
        return (this.droits & XConsentement.RIGHT_EFORM) == XConsentement.RIGHT_EFORM && this.getIsActive();
    }

    public boolean getHasRightRdvs() {
        return (this.droits & XConsentement.RIGHT_RDVS) == XConsentement.RIGHT_RDVS && this.getIsActive();
    }

    public boolean getHasRightBilling() {
        return (this.droits & XConsentement.RIGHT_BILLING) == XConsentement.RIGHT_BILLING && this.getIsActive();
    }

    public static CConsentement c(XConsentement x) {
        return x == null ? null : new CConsentement(x);
    }

    public <T> CEditableDataObject convertc(T type) {
        XConsentement x = (XConsentement)XConsentement.class.cast(type);
        this.init(x);
        return this;
    }

    public XConsentement convertx() {
        return this.x();
    }
}

