/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util.notification;

import ca.infodata.ofys.client.util.ClosureAE;
import ca.infodata.ofys.client.util.ClosureE;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsumerAdapter
implements IConsumerListener {
    private static final Logger logger = Logger.getLogger(ConsumerAdapter.class.getName());
    private ClosureAE<Notification> handleOtherMethod;
    private ClosureAE<DataObjectUpdatedNotification> handleMethod;
    private ClosureE forceRefreshMethod;

    public ConsumerAdapter() {
        this(null, null, null);
    }

    public ConsumerAdapter(ClosureAE<Notification> handleOtherMethod, ClosureAE<DataObjectUpdatedNotification> handleMethod, ClosureE forceRefreshMethod) {
        this.handleOtherMethod = handleOtherMethod;
        this.handleMethod = handleMethod;
        this.forceRefreshMethod = forceRefreshMethod;
    }

    @Override
    public void handleOther(Notification notification) {
        if (this.handleOtherMethod != null && notification != null) {
            try {
                this.handleOtherMethod.execute(notification);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "notification=" + StringUtils.safeToString((Logger)logger, (Object)notification), e);
            }
        }
    }

    @Override
    public void handle(DataObjectUpdatedNotification notification) {
        if (this.handleMethod != null && notification != null) {
            try {
                this.handleMethod.execute(notification);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "notification=" + StringUtils.safeToString((Logger)logger, (Object)notification), e);
            }
        }
    }

    @Override
    public void forceRefresh() {
        if (this.forceRefreshMethod != null) {
            try {
                this.forceRefreshMethod.execute();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while forceRefresh", e);
            }
        }
    }

    public ClosureAE<Notification> getHandleOtherMethod() {
        return this.handleOtherMethod;
    }

    public void setHandleOtherMethod(ClosureAE<Notification> handleOtherMethod) {
        this.handleOtherMethod = handleOtherMethod;
    }

    public ClosureAE<DataObjectUpdatedNotification> getHandleMethod() {
        return this.handleMethod;
    }

    public void setHandleMethod(ClosureAE<DataObjectUpdatedNotification> handleMethod) {
        this.handleMethod = handleMethod;
    }

    public ClosureE getForceRefreshMethod() {
        return this.forceRefreshMethod;
    }

    public void setForceRefreshMethod(ClosureE forceRefreshMethod) {
        this.forceRefreshMethod = forceRefreshMethod;
    }
}

