/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

public class StandardAnd503HttpRequestRetryHandler
extends StandardHttpRequestRetryHandler {
    private static final Logger logger = Logger.getLogger(StandardAnd503HttpRequestRetryHandler.class.getName());
    private long delayBeforeRetry;

    public StandardAnd503HttpRequestRetryHandler() {
    }

    public StandardAnd503HttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        super(retryCount, requestSentRetryEnabled);
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        HttpResponseException httpResponseException;
        boolean retry = super.retryRequest(exception, executionCount, context);
        if (!retry && exception instanceof HttpResponseException && (httpResponseException = (HttpResponseException)exception).getStatusCode() == 503) {
            retry = true;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpRequest request = clientContext.getRequest();
        logger.info(executionCount + " Retrying request " + request.getRequestLine().getUri());
        return retry;
    }

    public long getDelayBeforeRetry() {
        return this.delayBeforeRetry;
    }

    public void setDelayBeforeRetry(long delayBeforeRetry) {
        this.delayBeforeRetry = delayBeforeRetry;
    }
}

