/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.client;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICnesstAccessor;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEformData;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.Pair;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CnesstAccessorClient {
    private static final Logger logger = Logger.getLogger(CnesstAccessorClient.class.getName());
    private final ICnesstAccessor accessor;

    public CnesstAccessorClient() {
        this(Application.get().getDataAccessors().getCnesstAccessor());
    }

    public CnesstAccessorClient(ICnesstAccessor accessor) {
        this.accessor = accessor;
    }

    public ICnesstAccessor getAccessor() {
        return this.accessor;
    }

    public Pair<XEformData, MultiStatus> sendEformData(Integer idEformData) throws Exception {
        ReturnObject response = this.accessor.sendEformData(idEformData);
        this.manageNonOkResponse(response);
        XEformData xData = (XEformData)response.getObj();
        String s = xData.getData();
        if (s != null && s.length() > 0) {
            String u8 = "";
            try {
                u8 = Application.get().getBase64Processor().decodeUTF8(s);
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.SEVERE, "unable to decode EformData", e);
            }
            xData.setData(u8);
        }
        return Pair.newPair((Object)((XEformData)response.getObj()), (Object)response.getStatus());
    }

    public Map<String, String> getDomainValues() throws Exception {
        ReturnObject response = this.accessor.getDomainValues();
        this.manageNonOkResponse(response);
        return (Map)response.getObj();
    }

    private void manageNonOkResponse(ReturnObject r) throws Exception {
        if (r == null) {
            throw new Exception("Null response");
        }
        if (r.getStatus() == null) {
            throw new Exception("No status response");
        }
        if (!r.getStatus().isOkToProceed()) {
            throw new StatusException((IStatus)r.getStatus());
        }
    }
}

