/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.IPrintController;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.controller.DSQController;
import ca.infodata.ofys.client.web.core.ActionResult;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.IWebResource;
import ca.infodata.ofys.client.web.core.IWebResourcesDelegate;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.client.web.core.WebApplication;
import ca.infodata.ofys.client.web.core.WebSocketFilterByRequest;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.CDsqDmeObjectList;
import ca.infodata.ofys.data.middle.dataobjects.LightweightReport;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.ReportProperties;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedDocument;
import ca.infodata.ofys.data.middle.dataobjects.XFinishedReport;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XMeasurement;
import ca.infodata.ofys.data.middle.dataobjects.encounter.growthChart.MeasurementGraph;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelResType;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.patient.Age;
import ca.infodata.ofys.data.middle.dataobjects.pdf.PdfUtil;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.properties.IReportProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.FaxData;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.FaxDataProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.OutputProperty;
import ca.infodata.ofys.data.middle.dataobjects.properties.report.PrintMode;
import ca.infodata.ofys.data.middle.dataobjects.scan.XBasePatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageContainer;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.data.middle.dataobjects.scan.XScanImageContainer;
import ca.infodata.ofys.data.middle.dataobjects.scan.XScanImageNumberContainer;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.dashboard.accessor.CommonSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.accessor.PatientImageSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.accessor.PatientSyncAccessorClient;
import ca.infodata.ofys.ui.dashboard.models.CBasePatientImage;
import ca.infodata.ofys.ui.dashboard.models.CDocumentNote;
import ca.infodata.ofys.ui.dashboard.models.CLabelDef;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CPatientImage;
import ca.infodata.ofys.ui.dashboard.models.CPatientImageProfessionnal;
import ca.infodata.ofys.ui.dashboard.models.CQueryPatientImageSearch;
import ca.infodata.ofys.ui.dashboard.models.CQueryScanImage;
import ca.infodata.ofys.ui.dashboard.models.CScanImageNumberContainer;
import ca.infodata.ofys.ui.dashboard.models.IdsProf;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.ofys.util.LZMAClientSerialiser;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateRange;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.math.NumberUtils;

public class DocumentsController
extends AbstractWebController {
    private static final Logger logger = Logger.getLogger(DocumentsController.class.getName());
    private PatientImageSyncAccessorClient patientImageAccessor;
    private CommonSyncAccessorClient commonAccessor;
    private PatientSyncAccessorClient patientAccessor;
    private Supplier<DSQController> dsqController;

    public DocumentsController(Supplier<DSQController> dsqController) {
        this.dsqController = dsqController;
        this.patientImageAccessor = new PatientImageSyncAccessorClient();
        this.commonAccessor = new CommonSyncAccessorClient();
        this.patientAccessor = new PatientSyncAccessorClient();
        this.getNotificationSystemConsumer().setHandleMethod(this::handleNotification);
    }

    private void handleNotification(DataObjectUpdatedNotification notification) throws Exception {
        IDataObject object = notification.getObject();
        if (object instanceof XPatientImage) {
            XPatientImage ximage = (XPatientImage)object;
            String docId = ximage.id.toString();
            CPatientImage cimage = this.getCPatientImage(docId, new CPatientImage(ximage));
            ServerResponses.sendJsonToClient(notification.getClientId(), "patient.image.update", (Object)cimage);
        }
    }

    public XBaseProfessionnal getProfById(int idProf) {
        return Application.get().getPersonPluginController().getBaseProfessionnal(idProf);
    }

    public XPatient getPatient(int id) {
        try {
            return this.patientAccessor.getPatient(id);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while retreiving patient", e);
            return null;
        }
    }

    public XScanImageContainer documentStatusQuery(XPatientImageProfessionnalStatus status) throws ParseException {
        EnumSet<XPatientImageProfessionnalStatus> statusList = EnumSet.noneOf(XPatientImageProfessionnalStatus.class);
        statusList.add(status);
        return this.documentQuery(-2, -1, null, statusList, null);
    }

    public XScanImageContainer documentSearchQuery(String q) throws ParseException {
        return this.documentQuery(-2, -1, null, null, null);
    }

    public XScanImageContainer documentSearchQuery(CQueryScanImage q) throws ParseException {
        return this.documentQuery(q.idProfessionnal, q.idPatient, q.types, q.status, q.date);
    }

    private XScanImageContainer documentSearchQuery(CQueryPatientImageSearch data) throws ParseException {
        XScanImageContainer criteria = new XScanImageContainer(0);
        criteria.setDocumentDateRange(this.createLocalDateRange(data.startDocDate, data.endDocDate));
        criteria.setCreationDateRange(this.createLocalDateRange(data.startCreateDate, data.endCreateDate));
        EnumSet<XPatientImageResultType> setResult = EnumSet.noneOf(XPatientImageResultType.class);
        if (data.getResults() != null) {
            setResult.add(XPatientImageResultType.from((Integer)data.getResults()));
        }
        criteria.setResults(setResult);
        EnumSet<XPatientImageProfessionnalStatus> setStatus = EnumSet.noneOf(XPatientImageProfessionnalStatus.class);
        if (data.getStatus() != null) {
            setStatus.add(XPatientImageProfessionnalStatus.from((Integer)data.getStatus()));
        }
        criteria.setStatus(setStatus);
        ArrayList<XLabelDef> labels = new ArrayList<XLabelDef>();
        if (data.getListTypes() != null) {
            for (Integer typeInt : data.getListTypes()) {
                XLabelDef label = new XLabelDef();
                label.setId(typeInt);
                labels.add(label);
            }
        }
        criteria.setLabels(labels);
        criteria.setName(data.getName());
        criteria.setIdPatient(data.getIdPatient());
        criteria.setIdProfessionnal(data.getIdProfessionnal());
        criteria.setIdUser(data.getIdUser());
        criteria.setOffsetPage(Integer.valueOf(0));
        criteria.setFuturAppts(data.getFuturAppts);
        return criteria;
    }

    private LocalDateRange createLocalDateRange(Long startDate, Long endDate) throws ParseException {
        if (startDate != null || endDate != null) {
            LocalDate localStartDate = null;
            LocalDate LocalEndDate = null;
            if (startDate != null) {
                localStartDate = LocalDate.fromTimeInMillisUTC((Long)startDate);
            }
            if (endDate != null) {
                LocalEndDate = LocalDate.fromTimeInMillisUTC((Long)endDate);
            }
            return new LocalDateRange(localStartDate, LocalEndDate, RangeNotation.CLOSED);
        }
        return null;
    }

    public XScanImageContainer documentQuery(Integer idProf, Integer idPatient, List<XLabelDef> types, EnumSet<XPatientImageProfessionnalStatus> status, String sdate) throws ParseException {
        XScanImageContainer query = new XScanImageContainer(Application.get().getPreferencesPluginController().getNB_RESULT_BY_PAGE());
        if (sdate != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(sdate));
            LocalDate date = LocalDate.fromCalendar((Calendar)cal);
            query.setDocumentDateRange(new LocalDateRange(date, date, RangeNotation.CLOSED));
        }
        if (idProf != null) {
            if (idProf == -1) {
                query.setProfessionnal(null);
            } else if (idProf > 0) {
                query.setProfessionnal(this.getProfById(idProf));
            } else {
                query.setProfessionnal(Application.get().getPersonPluginController().getSessionProfessionnal());
            }
        }
        if (idPatient != null && idPatient > 0) {
            query.setPatient((IPatient)this.getPatient(idPatient));
        }
        if (types != null) {
            query.setLabelDefs(types);
        }
        query.setResults(null);
        query.setOffsetPage(Integer.valueOf(0));
        query.setStatus(status);
        return query;
    }

    private ReturnObject save(CPatientImage cimage) {
        ReturnObject answer = this.patientImageAccessor.save(cimage.x());
        XPatientImage savedXimage = (XPatientImage)answer.getObj();
        if (savedXimage != null) {
            CPatientImage savedCimage = new CPatientImage(savedXimage);
            savedCimage.type = cimage.type;
            savedCimage.viewerUrl = cimage.viewerUrl;
            savedCimage.printUrl = cimage.printUrl;
            savedCimage.pictureToPrint = null;
            savedCimage.picture = null;
            answer.setObj((Object)savedCimage);
        }
        return answer;
    }

    private ReturnObject saveQRCode(CPatientImage[] cPatientImage) {
        ArrayList<XPatientImage> xPatlist = new ArrayList<XPatientImage>();
        for (CPatientImage cpat : cPatientImage) {
            xPatlist.add(cpat.x());
        }
        XPatientImageContainer container = new XPatientImageContainer(xPatlist);
        ReturnObject answer = this.patientImageAccessor.save(container);
        if ((container = (XPatientImageContainer)answer.getObj()) != null) {
            ArrayList<CPatientImage> savedCimageList = new ArrayList<CPatientImage>();
            for (XPatientImage savedXimage : container.getImages()) {
                savedCimageList.add(new CPatientImage(savedXimage));
            }
            answer.setObj(savedCimageList);
        }
        return answer;
    }

    private List<CBasePatientImage> getDocs(XScanImageContainer docsList, String[] query, Boolean fromSearch) {
        ArrayList<CBasePatientImage> res = new ArrayList<CBasePatientImage>();
        if (docsList == null) {
            return res;
        }
        XBaseProfessionnal professionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
        Integer idProf = null;
        if (professionnal != null) {
            idProf = professionnal.id;
        }
        boolean search = query != null;
        for (XBasePatientImage doc : docsList.getBaseImages()) {
            boolean match = false;
            if (search) {
                for (int i = 0; !match && i < query.length; ++i) {
                    match = doc.getStr().toLowerCase().contains(query[i].toLowerCase());
                }
            } else {
                match = true;
            }
            if (!match) continue;
            CBasePatientImage cPatIma = new CBasePatientImage(doc, idProf, idProf);
            cPatIma.fromSearch = fromSearch;
            res.add(cPatIma);
        }
        return res;
    }

    private List<CBasePatientImage> getDocs(List<XBasePatientImage> lstIm, Integer selectedIdProf) {
        Integer idProf;
        ArrayList<CBasePatientImage> res = new ArrayList<CBasePatientImage>();
        if (lstIm == null) {
            return res;
        }
        XBaseProfessionnal sessionProfessionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
        Integer n = idProf = sessionProfessionnal == null ? null : sessionProfessionnal.getId();
        if (selectedIdProf == null) {
            selectedIdProf = idProf;
        }
        for (XBasePatientImage doc : lstIm) {
            res.add(new CBasePatientImage(doc, idProf, selectedIdProf));
        }
        return res;
    }

    private List<CBasePatientImage> getReview(XPatientImageProfessionnalStatus status) throws ParseException {
        XScanImageContainer query = this.documentStatusQuery(status);
        List<CBasePatientImage> res = this.getDocs(this.patientImageAccessor.docList(query), null, false);
        return res;
    }

    public XPatientImage getDocumentById(int documentId, boolean hasResourceLocally) {
        if (documentId < 1) {
            throw new IllegalArgumentException("Invalide document id ");
        }
        return (XPatientImage)this.patientImageAccessor.getPatientImageAndSetSeenStatus(documentId, !hasResourceLocally).getObj();
    }

    public ReturnObject growChart(IServerRequest req) {
        try {
            GrowChartData data = req.getPostBody(GrowChartData.class);
            Collections.sort(data.measurementsForGraph, new Comparator<CEncounter.Measurement>(){

                @Override
                public int compare(CEncounter.Measurement o1, CEncounter.Measurement o2) {
                    return o2.timeVitalSign.compareTo(o1.timeVitalSign);
                }
            });
            if (StringUtils.isNotBlank((String)data.pat.birthDate)) {
                LocalDate birthDay = Utils.dateToLocalDate(java.sql.Date.valueOf(data.pat.birthDate));
                if (data.measurementsForGraph.size() == 0) {
                    return ServerResponses.ErrorReturnObject(Messages.getString((String)"NO_DATA_FOR_GROWTHCURVE", (String[])new String[0]));
                }
                ArrayList<XMeasurement> lstMesures = new ArrayList<XMeasurement>(data.measurementsForGraph.size());
                for (CEncounter.Measurement m : data.measurementsForGraph) {
                    lstMesures.add(m.x());
                }
                LocalDate measureDate = LocalDate.fromTimeInMillisLOCAL((Long)((XMeasurement)lstMesures.get((int)0)).timeVitalSign);
                Age oAge = new Age(birthDay, measureDate);
                if (228 > oAge.totalMonths) {
                    byte[] pdf = null;
                    pdf = 24 > oAge.totalMonths ? MeasurementGraph.getChart024Pdf((XPerson.Gender)data.gender, (XPatient)data.pat.x(), lstMesures, (boolean)data.blackAndWhite) : MeasurementGraph.getGrowChart219_024Pdf((XPerson.Gender)data.gender, (XPatient)data.pat.x(), (int)oAge.totalMonths, lstMesures, (boolean)data.blackAndWhite);
                    boolean recentViewer = (Boolean)Application.get().getPreferencesPluginController().getUserProp("user_settings_UseNewPDFViewer");
                    IWebResource resp = WebApplication.get().getWebResourcesDelegate().newHtmlPdfViewerResource("growthChart" + data.pat.id, pdf, true, recentViewer);
                    return ServerResponses.OKReturnObject(resp.getUrl());
                }
                return ServerResponses.ErrorReturnObject(Messages.getString((String)"TOO_OLD_FOR_GROWTHCURVE", (String[])new String[0]));
            }
            return ServerResponses.ErrorReturnObject(Messages.getString((String)"MISSING_DOB_GROWTHCURVE", (String[])new String[0]));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Growth chart generation failed", e);
            return ServerResponses.ErrorReturnObject("Generation du courbe de croissance \u00e9chou\u00e9");
        }
    }

    private ActionResult assignOtherPatient(Integer docId, Integer patId) {
        XPatientImage doc = this.getDocumentById(docId, true);
        XPatient pt = new XPatient();
        pt.id = patId;
        pt.modificationStatus.plain_set((Object)ModificationStatus.STATUS_NEUTRAL);
        doc.setPatient((IPatient)pt);
        ReturnObject returnObject = this.patientImageAccessor.save(doc);
        if (returnObject != null) {
            if (returnObject.getStatus().isOK()) {
                if (returnObject.getObj() instanceof XPatientImage) {
                    return ServerResponses.SUCCESS();
                }
            } else {
                return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(returnObject.getStatus().getMessage()));
            }
        }
        return ServerResponses.ERROR("returnObject null");
    }

    private ActionResult assignOtherProf(Integer docId, List<CPatientImageProfessionnal> profs) {
        XPatientImage doc = this.getDocumentById(docId, true);
        List<XPatientImageProfessionnal> profsAsCollection = CPatientImageProfessionnal.CtoXList(profs);
        EditableDataObjectList xProfs = new EditableDataObjectList(profsAsCollection.size());
        xProfs.addAll(profsAsCollection);
        doc.setProfessionnals((IEditableDataObjectList)xProfs);
        ReturnObject returnObject = this.patientImageAccessor.save(doc);
        if (returnObject != null) {
            if (returnObject.getStatus().isOK()) {
                if (returnObject.getObj() instanceof XPatientImage) {
                    ArrayList<CPatientImageProfessionnal> lstC = new ArrayList<CPatientImageProfessionnal>(1);
                    XPatientImage x = (XPatientImage)returnObject.getObj();
                    for (XPatientImageProfessionnal xpip : x.getProfessionnals()) {
                        if (xpip.getTag() == null) continue;
                        for (XPatientImageProfessionnal xp : xProfs) {
                            if (!xpip.getTag().equals(xp.getTag())) continue;
                            lstC.add(CPatientImageProfessionnal.c(xpip));
                        }
                    }
                    return ServerResponses.toJsonActionResult(ServerResponses.OKReturnObject(lstC));
                }
            } else {
                return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(returnObject.getStatus().getMessage()));
            }
        }
        return ServerResponses.ERROR("returnObject null");
    }

    private IStatus saveEnumReset(CDocumentNote docNote) {
        MultiStatus status = new MultiStatus();
        if (docNote.docNotes != null && docNote.docNotes.length > 0) {
            int[] ids = new int[docNote.docNotes.length];
            for (int i = 0; i < docNote.docNotes.length; ++i) {
                CDocumentNote ln = docNote.docNotes[i];
                ids[i] = ln.id;
            }
            IStatus stat = this.patientImageAccessor.setPatientImageProfessionnalEnumSetStatus(ids, new Integer(1), docNote.idPatient);
            status.setMessage(stat.getMessage());
            status.setSeverity(stat.getSeverity());
            if (status.isOK()) {
                status.setData((Serializable)ids);
            }
        }
        return status;
    }

    private IStatus delAllAutoOpen(CDocumentNote labNote) {
        MultiStatus status = new MultiStatus();
        if (labNote.docNotes != null && labNote.docNotes.length > 0) {
            int[] ids = new int[labNote.docNotes.length];
            for (int i = 0; i < labNote.docNotes.length; ++i) {
                CDocumentNote ln = labNote.docNotes[i];
                ids[i] = ln.id;
            }
            IStatus stat = this.patientImageAccessor.delAllDocProfStatus(ids, new Integer(8), labNote.idPatient);
            status.setMessage(stat.getMessage());
            status.setSeverity(stat.getSeverity());
            if (status.isOK()) {
                status.setData((Serializable)ids);
            }
        }
        return status;
    }

    public CPatientImage getDocument(int docId, Integer idProf, Integer selectedProf) throws Exception {
        String resourceName;
        IWebResourcesDelegate resourcesDelegate = WebApplication.get().getWebResourcesDelegate();
        boolean hasResourceLocally = resourcesDelegate.hasHtmlPdfViewerResource(resourceName = this.getCPatientImageResourceName(String.valueOf(docId))) || resourcesDelegate.hasHtmlImageViewerResource(resourceName);
        XPatientImage doc = this.getDocumentById(docId, hasResourceLocally);
        if (doc != null) {
            CPatientImage res = new CPatientImage(doc, idProf, selectedProf);
            res = this.getCPatientImage(String.valueOf(docId), res);
            return res;
        }
        return null;
    }

    public CPatientImage getCPatientImage(String docId, CPatientImage cimage) throws Exception {
        if (docId == null) {
            throw new IllegalArgumentException("docId cant be null");
        }
        IWebResourcesDelegate webResourcesDelegate = WebApplication.get().getWebResourcesDelegate();
        String resourceName = this.getCPatientImageResourceName(docId);
        String resourceNamePrint = resourceName + "_print";
        if (cimage.picture != null && cimage.picture.length > 3) {
            boolean isPdf = this.isPdf(cimage.picture);
            if (isPdf) {
                cimage.type = "pdf";
                if (cimage.picture != null) {
                    String url;
                    boolean recentViewer = (Boolean)Application.get().getPreferencesPluginController().getUserProp("user_settings_UseNewPDFViewer");
                    IWebResource html = webResourcesDelegate.getOrCreateHtmlPdfViewerResource(resourceName, cimage.picture, false, recentViewer);
                    cimage.viewerUrl = url = html.getUrl();
                    cimage.picture = null;
                }
                if (cimage.pictureToPrint != null) {
                    String url;
                    IWebResource html = webResourcesDelegate.getOrCreateHtmlPdfResource(resourceNamePrint, cimage.pictureToPrint);
                    cimage.printUrl = url = html.getUrl();
                    cimage.pictureToPrint = null;
                }
            } else {
                String url;
                IWebResource html;
                cimage.type = "img";
                if (cimage.picture != null) {
                    html = webResourcesDelegate.getOrCreateImageViewerResource(resourceName, cimage.picture);
                    cimage.viewerUrl = url = html.getUrl();
                    cimage.picture = null;
                }
                if (cimage.pictureToPrint != null) {
                    html = webResourcesDelegate.getOrCreateImageViewerResource(resourceName, cimage.pictureToPrint);
                    cimage.printUrl = url = html.getUrl();
                    cimage.pictureToPrint = null;
                }
            }
        } else {
            IWebResource pdfViewerResource = webResourcesDelegate.getHtmlPdfViewerResource(resourceName);
            if (pdfViewerResource != null) {
                cimage.type = "pdf";
                cimage.viewerUrl = pdfViewerResource.getUrl();
                cimage.picture = null;
                IWebResource printResource = webResourcesDelegate.getHtmlPdfResource(resourceNamePrint);
                cimage.printUrl = printResource == null ? null : printResource.getUrl();
                cimage.pictureToPrint = null;
            } else {
                IWebResource imageViewerResource = webResourcesDelegate.getImageViewerResource(resourceName);
                if (imageViewerResource != null) {
                    cimage.type = "img";
                    cimage.viewerUrl = imageViewerResource.getUrl();
                    cimage.picture = null;
                    IWebResource printResource = webResourcesDelegate.getImageViewerResource(resourceNamePrint);
                    cimage.printUrl = printResource == null ? null : printResource.getUrl();
                    cimage.pictureToPrint = null;
                } else {
                    cimage.type = "nan";
                    cimage.viewerUrl = null;
                    cimage.picture = null;
                    cimage.pictureToPrint = null;
                }
            }
        }
        return cimage;
    }

    private String getCPatientImageResourceName(String docId) {
        return "CPatientImage_" + docId;
    }

    public void openEditor(int docId) {
        Application.get().getApplicationUiPlugin().openPatientImageEditor(this.getDocumentById(docId, false));
    }

    public Boolean isPdf(byte[] data) {
        if (data != null && data.length > 3) {
            byte[] p = new byte[4];
            for (int i = 0; i < 4; ++i) {
                p[i] = data[i];
            }
            String pdf = new String(p);
            if (pdf.startsWith("%PDF")) {
                String head = new String(data).substring(0, NumberUtils.min((int[])new int[]{66, data.length - 1}));
                int idx0 = head.indexOf("this.print");
                if (idx0 != -1) {
                    for (int i = idx0; i < idx0 + 14; ++i) {
                        data[i] = 59;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public byte[] addPrintByText(byte[] document, boolean isPdf) {
        try {
            String printedBy = "\"" + Messages.getString((String)"PRINTED_BY", (String[])new String[0]) + " " + Application.get().getGlobalInstances().getSession().getUser().getPersonNameOrTextOrEmpty() + " " + new SimpleDateFormat(FormatDateProvider.getFormatDate().toString() + " HH:mm").format(new Date()) + " - " + Messages.getString((String)"CONFIDENTIAL", (String[])new String[0]) + "\"";
            document = isPdf ? PdfUtil.addPrintedByToPdf((byte[])document, (String)printedBy) : this.addPrintByToImage(document, printedBy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public byte[] addPrintByToImage(byte[] image, String printedBy) {
        try {
            BufferedImage old;
            BufferedImage img = old = ImageIO.read(new ByteArrayInputStream(image));
            Graphics2D g2d = img.createGraphics();
            g2d.drawImage((Image)old, 0, 0, null);
            g2d.setFont(new Font("SansSerif", 0, 12));
            FontMetrics fm = g2d.getFontMetrics();
            int x = img.getWidth() / 2 - fm.stringWidth(printedBy) / 2;
            int y = img.getHeight() - fm.getHeight();
            this.drawBackGroundRect(fm, printedBy, g2d, x, y);
            this.drawString(fm, printedBy, g2d, x, y);
            g2d.dispose();
            return this.getImageBytes(img);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void drawBackGroundRect(FontMetrics fm, String printedBy, Graphics2D g2d, int x, int y) {
        Color bgColor = Color.WHITE;
        g2d.setPaint(bgColor);
        Rectangle2D rect = fm.getStringBounds(printedBy, g2d);
        g2d.fillRect(x, y - fm.getAscent(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    private void drawString(FontMetrics fm, String printedBy, Graphics2D g2d, int x, int y) {
        Color textColor = Color.BLACK;
        g2d.setPaint(textColor);
        g2d.drawString(printedBy, x, y);
    }

    public byte[] getImageBytes(BufferedImage img) {
        byte[] imageInByte = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", baos);
            baos.flush();
            imageInByte = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return imageInByte;
    }

    public XScanImageNumberContainer getReviewCount(Integer idProf) {
        XScanImageNumberContainer container = new XScanImageNumberContainer();
        container.doCountByStatus = true;
        container.idProfessionnal = idProf;
        container = this.patientImageAccessor.getCount(container);
        return container;
    }

    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard", RouterFunctions.routeReturnObject("/docs/growchart", this::growChart), RouterFunctions.routeAction("/docs/editor", req -> {
            Integer docId = req.getRequiredQueryParam("docId", Integer.class);
            this.openEditor(docId);
            return ServerResponses.SUCCESS();
        }), RouterFunctions.routes("/docs/ws", RouterFunctions.routeAction("/review", req -> {
            XPatientImageProfessionnalStatus status = req.getQueryParam("status", XPatientImageProfessionnalStatus.class);
            return ServerResponses.toJsonActionResult(this.getReview(status));
        }), RouterFunctions.routeAction("/labels", req -> ServerResponses.toJsonActionResult(CLabelDef.XLablelToCList(this.commonAccessor.findLabelDef(XLabelResType.PATIENT_IMAGE)))), RouterFunctions.routeAction("/alllabels", req -> {
            XLabelResType lblType = req.getQueryParam("type", XLabelResType.PATIENT_IMAGE, XLabelResType.class);
            return ServerResponses.toJsonActionResult(CLabelDef.XLablelToCList(this.commonAccessor.findLabelDef(lblType, false)));
        }), RouterFunctions.routeAction("/reviewCount", req -> {
            Integer prof = req.getQueryParam("idProf", Integer.class);
            return ServerResponses.toJsonActionResult(new CScanImageNumberContainer(this.getReviewCount(prof)));
        }), RouterFunctions.routeAction("/bypat", req -> {
            Integer id = req.getQueryParam("id", Integer.class);
            IWebSocketChannel wsChannel = null;
            try {
                wsChannel = WebApplication.get().getWebSocketDelegate().get(new WebSocketFilterByRequest(req));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get websocket channel documents by patient", e);
            }
            return this.getDocumentsByPatient(id, wsChannel);
        }), RouterFunctions.routeAction("/byIds", req -> {
            IdsProf data = req.getPostBody(IdsProf.class);
            List<Object> docs = data.ids != null && data.ids.length > 0 ? this.getDocs(this.patientImageAccessor.byIds(data.ids, Boolean.TRUE), data.idProf) : Collections.emptyList();
            return ServerResponses.toJsonActionResult(docs);
        }), RouterFunctions.routeAction("/search", req -> {
            if (req.hasQueryParam("q")) {
                String q = req.getQueryParam("q");
                return ServerResponses.toJsonActionResult(this.getDocs(this.patientImageAccessor.docList(this.documentSearchQuery(q)), q.split(" "), false));
            }
            if (req.hasPostBody()) {
                CQueryScanImage data = req.getPostBody(CQueryScanImage.class);
                return ServerResponses.toJsonActionResult(this.getDocs(this.patientImageAccessor.docList(this.documentSearchQuery(data)), null, false));
            }
            return null;
        }), RouterFunctions.routeReturnObject("/save", req -> {
            CPatientImage cimage = req.getPostBody(CPatientImage.class);
            return this.save(cimage);
        }), RouterFunctions.routeReturnObject("/saveQRCode", req -> {
            CPatientImage[] cimage = req.getPostBody(CPatientImage[].class);
            return this.saveQRCode(cimage);
        }), RouterFunctions.routeReturnObject("/print", req -> {
            CPatientImage cimage = req.getPostBody(CPatientImage.class);
            return this.print(cimage);
        }), RouterFunctions.routeAction("/fax", req -> {
            DocFaxPrint faxPrint = req.getPostBody(DocFaxPrint.class);
            return ServerResponses.toJsonActionResult(this.fax(faxPrint));
        }), RouterFunctions.routeAction("/assignOtherPatient", req -> {
            Integer docId = req.getQueryParam("id", Integer.class);
            Integer patId = req.getQueryParam("idPatient", Integer.class);
            if (docId != null && patId != null) {
                return this.assignOtherPatient(docId, patId);
            }
            return ServerResponses.ERROR("Invalid document id or patient id");
        }), RouterFunctions.routeAction("/assignOtherProf", req -> {
            Integer docId = req.getQueryParam("id", Integer.class);
            CPatientImageProfessionnal[] profs = req.getPostBody(CPatientImageProfessionnal[].class);
            if (docId != null && profs != null) {
                return this.assignOtherProf(docId, Arrays.asList(profs));
            }
            return ServerResponses.ERROR("Invalid document id or patient id");
        }), RouterFunctions.routeAction("/saveEnumSet", req -> {
            if (req.hasPostBody()) {
                CDocumentNote note = req.getPostBody(CDocumentNote.class);
                return ServerResponses.toJsonActionResult(this.saveEnumReset(note));
            }
            return ServerResponses.ERROR("\u00c9chec de sauvegarde");
        }), RouterFunctions.routeAction("/searchDoc", req -> {
            CQueryPatientImageSearch data = req.getPostBody(CQueryPatientImageSearch.class);
            try {
                XScanImageContainer documentSearchQuery = this.documentSearchQuery(data);
                return ServerResponses.toJsonActionResult(this.getDocs(this.patientImageAccessor.docList(documentSearchQuery), null, true));
            }
            catch (Exception e) {
                return ServerResponses.ERROR(e.getMessage());
            }
        }), RouterFunctions.routeAction("/delAllAutoOpen", req -> {
            if (req.hasPostBody()) {
                CDocumentNote note = req.getPostBody(CDocumentNote.class);
                return ServerResponses.toJsonActionResult(this.delAllAutoOpen(note));
            }
            return ServerResponses.ERROR("\u00c9chec de sauvegarde");
        }), RouterFunctions.routeAction("/docview", this::handleDocView)));
    }

    private ActionResult fax(DocFaxPrint faxPrint) {
        try {
            if (faxPrint.id != null) {
                XFinishedReport finishedReport = new XFinishedReport(null);
                finishedReport.setProperties(new ReportProperties());
                finishedReport.getProperties().put((IReportProperty)new OutputProperty("pdf"));
                XBasePatientImage img = new XBasePatientImage();
                img.id = faxPrint.id;
                img.idPatient = faxPrint.faxdata == null ? null : faxPrint.faxdata.idPatient;
                IPrintController printController = Application.get().getPrintControllerFactory().newPrintController((Serializable)img);
                LightweightReport report = new LightweightReport("scan", "Document num\u00e9ris\u00e9", PrintMode.ACTUAL_SIZE);
                report.setFinishedReport(finishedReport);
                report.setNumberOfDocuments(Integer.valueOf(1));
                printController.getSelection().add((IReport)report);
                FaxDataProperty faxProp = this.setFaxProp(faxPrint, finishedReport, report);
                if (faxProp != null) {
                    report.getProperties().put("faxData", (Serializable)faxProp);
                }
                try {
                    printController.printSync();
                }
                catch (Exception e1) {
                    return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(e1.getMessage()));
                }
                return ServerResponses.toJsonActionResult(ServerResponses.OKReturnObject());
            }
            return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(Messages.getString((String)"NOTHING_TO_PRINT", (String[])new String[0])));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error printing", e);
            return ServerResponses.toJsonActionResult(ServerResponses.ErrorReturnObject(MiscUtil.getStackTraceAsString((Throwable)e)));
        }
    }

    private ActionResult handleDocView(IServerRequest req) {
        Integer docId = req.getRequiredQueryParam("docId", Integer.class);
        Integer selectedIdProf = req.getQueryParam("idProf", Integer.class);
        if (docId != null) {
            XBaseProfessionnal professionnal = Application.get().getPersonPluginController().getSessionProfessionnal();
            Integer idProf = null;
            if (professionnal != null) {
                idProf = professionnal.id;
            }
            try {
                CPatientImage document = this.getDocument(docId, idProf, selectedIdProf);
                return ServerResponses.toJsonActionResult((Object)document);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting document " + docId, e);
                return ServerResponses.ERROR("Error getting document");
            }
        }
        return ServerResponses.ERROR("Invalid document id");
    }

    private ActionResult getDocumentsByPatient(Integer id, IWebSocketChannel wsChannel) {
        CDsqDmeObjectList ol;
        List<CDsqDmeObjectList> cdsqList = this.patientImageAccessor.docListByPatient(id);
        if (cdsqList != null && wsChannel != null) {
            CDsqDmeObjectList c;
            try {
                c = this.getCDsqDmeObjectList(cdsqList, CDsqDmeObjectList.METHODS.listImagingExam);
                if (c != null) {
                    this.dsqController.get().sendDsqListImagingExam(wsChannel, c);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to sendDsqListImagingExam for patient id " + id, e);
            }
            try {
                c = this.getCDsqDmeObjectList(cdsqList, CDsqDmeObjectList.METHODS.listPatientDischargeCareSummary);
                if (c != null) {
                    this.dsqController.get().sendDsqListDischargeCareSummary(wsChannel, c);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to sendDsqListDischargeCareSummary for patient id " + id, e);
            }
        }
        if ((ol = this.getCDsqDmeObjectList(cdsqList, CDsqDmeObjectList.METHODS.listPatientImage)) != null && ol.lstPatientImageBA != null && (ol.lstPatientImage == null || ol.lstPatientImage.isEmpty())) {
            ol.lstPatientImage = (ArrayList)LZMAClientSerialiser.deserialize((byte[])ol.lstPatientImageBA, (boolean)true);
        }
        List lstPatientImage = ol == null ? null : ol.lstPatientImage;
        return ServerResponses.toJsonActionResult(this.getDocs(lstPatientImage, null));
    }

    private CDsqDmeObjectList getCDsqDmeObjectList(List<CDsqDmeObjectList> list, CDsqDmeObjectList.METHODS method) {
        CDsqDmeObjectList r = null;
        for (CDsqDmeObjectList c : list) {
            if (c.method != method) continue;
            if (r == null) {
                r = c;
                continue;
            }
            logger.log(Level.SEVERE, "More than 1 CDsqDmeObjectList with method " + method + " found in list. first one is returned");
        }
        return r;
    }

    public ReturnObject print(CPatientImage image) {
        IPrintController ctrl = Application.get().getPrintControllerFactory().newPrintController((Serializable)image.x().toXBase(false));
        ctrl.getSelection().add((IReport)new LightweightReport("scan", "Document num\u00e9ris\u00e9", PrintMode.ACTUAL_SIZE));
        return ServerResponses.print(ctrl);
    }

    public String cleanString(String note) {
        if ((note = note.replaceAll("\"", "")) != null && note.trim().length() == 0) {
            note = "";
        }
        return note;
    }

    private FaxDataProperty setFaxProp(DocFaxPrint faxPrint, XFinishedReport finishedReport, LightweightReport report) {
        FaxDataProperty faxProp = null;
        if (faxPrint.faxdata != null) {
            faxPrint.faxdata.idSite = Application.get().getSitePluginController().getContextSite().getId();
            List documents = finishedReport.getDocuments();
            HashSet<String> set = new HashSet<String>(documents.size());
            for (XFinishedDocument x : documents) {
                set.add(x.name);
            }
            faxPrint.faxdata.docName = (StringUtils.isBlank((CharSequence)faxPrint.faxdata.docName) ? report.getName() : faxPrint.faxdata.docName) + (set.isEmpty() ? "" : ": " + new JoinList(", ", set).toString());
            faxProp = new FaxDataProperty("faxData", faxPrint.faxdata);
            finishedReport.getProperties().put("faxData", (Serializable)faxProp);
        }
        return faxProp;
    }

    public static class DocFaxPrint {
        public Integer id;
        public FaxData faxdata;
    }

    public static class GrowChartData {
        public CPatient pat;
        public XPerson.Gender gender;
        public List<CEncounter.Measurement> measurementsForGraph;
        public boolean blackAndWhite;
    }
}

