/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.uniqueValue;

import ca.infodata.ofys.client.uniqueValue.IAtomicUniqueValueGenerator;
import ca.infodata.util1.StringUtils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class LocalAtomicUniqueValueGenerator
implements IAtomicUniqueValueGenerator {
    private final ConcurrentHashMap<String, AtomicInteger> map;
    private final AtomicInteger nullContext = new AtomicInteger(0);
    private static final String websocket_context = "ws";
    private static final String cformdata_context = "cformdata";
    private static final String temp_context = "temp";

    public LocalAtomicUniqueValueGenerator() {
        this.map = new ConcurrentHashMap();
        this.registerContext(websocket_context);
        this.registerContext(cformdata_context);
        this.registerContext(temp_context);
    }

    @Override
    public void registerContext(String context) {
        if (StringUtils.isBlank((CharSequence)context)) {
            throw new IllegalArgumentException("context cant be null or blank");
        }
        if (this.map.contains(context)) {
            System.out.println(context + "already configured in LocalAtomicUniqueValueGenerator!");
            return;
        }
        this.map.put(context, new AtomicInteger(0));
    }

    @Override
    public String nextString(String context) {
        return String.valueOf(this.nextInt(context));
    }

    @Override
    public int nextInt(String context) {
        if (StringUtils.isBlank((CharSequence)context)) {
            return this.nullContext.incrementAndGet();
        }
        AtomicInteger a = this.map.get(context);
        if (a == null) {
            throw new IllegalStateException("context " + context + " was not registered with this generator");
        }
        return a.incrementAndGet();
    }

    @Override
    public String nextUUID(String context) {
        return UUID.randomUUID().toString();
    }
}

