/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.template;

import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.TypeDeDonnee;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DText
extends DField {
    public Integer maxLen;
    public Integer width;
    public Integer height;
    public TypeDeDonnee typeDeDonnee = TypeDeDonnee.S_O;
    public Boolean wrap;
    public static Pattern pattern = Pattern.compile("<text\\s*" + nameRegExp + "(maxlen=(\\d+))?\\s*(width=(\\d+))?\\s*(height=(\\d+))?\\s*(typeDeDonnee=(\\d+))?\\s*(wrap=(0|1))?\\s*(required)?\\s*/>");

    public DText() {
    }

    public DText(String name, Integer maxLen, boolean required, TypeDeDonnee typeDonnee, Boolean wrap) {
        this.name = name;
        this.maxLen = maxLen;
        this.required = required;
        this.wrap = wrap;
        this.typeDeDonnee = typeDonnee == null ? TypeDeDonnee.S_O : typeDonnee;
    }

    public static List<DField> parse(String text) {
        ArrayList<DField> list = new ArrayList<DField>();
        Matcher matcher = pattern.matcher(text);
        int start = 0;
        while (matcher.find(start)) {
            DText d = new DText();
            d.start = matcher.start();
            d.end = matcher.end();
            d.name = matcher.group(2);
            d.maxLen = matcher.group(4) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(4)));
            d.width = matcher.group(6) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(6)));
            d.height = matcher.group(8) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(8)));
            TypeDeDonnee typeDeDonnee = d.typeDeDonnee = matcher.group(10) == null ? null : TypeDeDonnee.from(Integer.parseInt(matcher.group(10)));
            d.wrap = matcher.group(12) == null ? null : new Boolean(Integer.parseInt(matcher.group(12)) == 1);
            d.required = StringUtils.isNotBlank((String)matcher.group(13));
            list.add(d);
            start = matcher.end();
        }
        return list;
    }

    @Override
    public String format() {
        String s = "<text name=\"" + this.name + "\" ";
        if (this.maxLen != null) {
            s = s + "maxlen=" + this.maxLen + " ";
        }
        if (this.width != null) {
            s = s + "width=" + this.width + " ";
        }
        if (this.height != null) {
            s = s + "height=" + this.height + " ";
        }
        if (this.typeDeDonnee != null) {
            s = s + "typeDeDonnee=" + this.typeDeDonnee.getValue() + " ";
        }
        if (this.wrap != null) {
            s = s + "wrap=" + (this.wrap != false ? 1 : 0) + " ";
        }
        if (this.required) {
            s = s + "required";
        }
        s = s + "/>";
        return s;
    }

    @Override
    public String formatMedo() {
        String s = "${" + this.name + ";";
        if (this.maxLen != null) {
            s = s + StringUtils.toLength((char)'!', (int)this.maxLen);
        }
        s = s + "}";
        return s;
    }
}

