/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.scan;

import boofcv.abst.fiducial.QrCodePreciseDetector;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.core.image.border.FactoryImageBorderAlgs;
import boofcv.factory.fiducial.ConfigQrCode;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.ByQuadrantReader;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZxingCodeReader {
    private static final Logger logger = Logger.getLogger(ZxingCodeReader.class.getName());
    private List<BarcodeFormat> formats = new ArrayList<BarcodeFormat>();
    private Map<DecodeHintType, Object> hints = new Hashtable<DecodeHintType, Object>();
    private MultiFormatReader reader = new MultiFormatReader();

    public ZxingCodeReader() {
        this.formats.add(BarcodeFormat.QR_CODE);
        this.formats.add(BarcodeFormat.CODE_128);
        this.setHints();
        this.reader.setHints(this.hints);
    }

    public static BufferedImage processBufferedImage(BufferedImage image) throws IOException {
        GrayU8 gray = ConvertBufferedImage.convertFrom((BufferedImage)image, (GrayU8)null);
        GrayU8 blurred = new GrayU8(gray.width, gray.height);
        GrayS16 derivX = new GrayS16(gray.width, gray.height);
        GrayS16 derivY = new GrayS16(gray.width, gray.height);
        BlurImageOps.gaussian((GrayU8)gray, (GrayU8)blurred, (double)-1.0, (int)4, null);
        GradientSobel.process((GrayU8)blurred, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)FactoryImageBorderAlgs.extend((GrayI)gray));
        BufferedImage processedImage = ConvertBufferedImage.convertTo((GrayU8)blurred, null);
        return processedImage;
    }

    public String decode(BufferedImage bufferedImage, String filePath) {
        try {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(bufferedImage);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            Result result = this.reader.decodeWithState(bitmap);
            String code = result.getText();
            return code;
        }
        catch (NotFoundException ignored) {
            return null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while trying to read Code from file " + filePath, e);
            return null;
        }
    }

    public String betterDecode(BufferedImage image) {
        GrayU8 gray = ConvertBufferedImage.convertFrom((BufferedImage)image, (GrayU8)null);
        ConfigQrCode config = new ConfigQrCode();
        config.threshold = ConfigThresholdBlockMinMax.local((ThresholdType)ThresholdType.BLOCK_MIN_MAX, (int)2);
        QrCodePreciseDetector detector = FactoryFiducial.qrcode((ConfigQrCode)config, GrayU8.class);
        detector.process((ImageGray)gray);
        List detections = detector.getDetections();
        String result = null;
        for (QrCode code : detections) {
            if (code.message == null && code.message == "") continue;
            result = code.message;
        }
        return result;
    }

    public List<String> multiDecode(BufferedImage bufferedImage, String filePath) {
        ArrayList<String> codeList = new ArrayList<String>();
        try {
            Result[] resultList;
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(bufferedImage);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            GenericMultipleBarcodeReader reader = new GenericMultipleBarcodeReader((Reader)new ByQuadrantReader((Reader)this.reader));
            for (Result result : resultList = reader.decodeMultiple(bitmap, this.hints)) {
                String code = result.getText();
                codeList.add(code);
            }
            return codeList;
        }
        catch (NotFoundException ignored) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while trying to read Code from file " + filePath, e);
            return Collections.emptyList();
        }
    }

    private void setHints() {
        Vector<BarcodeFormat> decodeFormats = new Vector<BarcodeFormat>();
        for (BarcodeFormat format : this.formats) {
            decodeFormats.addElement(format);
        }
        this.hints.put(DecodeHintType.POSSIBLE_FORMATS, decodeFormats);
        this.hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        this.hints = Collections.unmodifiableMap(this.hints);
    }
}

