/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.eform.autocomplete;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.eform.autocomplete.EFormAutoComplete;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterAllergyListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterBloodPressureListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterBodyTemperaturesListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterCustomMeasuresListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterDiagnosticListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterDocumentsListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterFrequencyListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterImmunizationsListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterInterventionsListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterLifeHabitsListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterMeasurementsListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterPhysicalExaminationsListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterPlansListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterPrescriptionListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterPreventListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.EncounterRappelsListAJsonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboCalciumIoniseListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboCalciumTotalListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboCholHdlListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboCholLdlListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboCholTotalListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboClairanceListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboCreatinineListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboFerritineListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboGlycemieListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboHbListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboKaliemieListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboMagnesiumListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboNatremieListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboRniListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboSedimentationListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.LaboUreeListAJSonAC;
import ca.infodata.ofys.client.modules.eform.autocomplete.input.PatientIdentifierListAJsonAC;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergy;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBloodPressure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBodyTemperature;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XCustomMeasure;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDiagnostic;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XDocuments;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XFrequency;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XImmunization;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XIntervention;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XLifeHabit;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XMeasurement;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPhysicalExamination;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPlan;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XPrevent;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XRappel;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XPatientIdentifier;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.PreviousLabResults;
import ca.infodata.ofys.data.middle.dataobjects.medication.MedCalc;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.site.SiteAddedAs;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.util.math.NumberUtils;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang3.time.DateUtils;

public abstract class EFormAutoCompleteJson
extends EFormAutoComplete {
    public EFormAutoCompleteJson(XPatient patient) {
        this.patient = patient;
        this.initAutoCompleteList();
        this.creatinine = new EFormAutoComplete.OnTheFly<HashMap<String, Integer>>(){

            @Override
            public HashMap<String, Integer> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().computePatientCreatinineClearance(EFormAutoCompleteJson.this.patient.getId());
                    if (o.getObj() instanceof HashMap) {
                        return (HashMap)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.creatinines = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZCREA");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.clearance = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                PreviousLabResults creat;
                PreviousLabResults labResult = null;
                List creats = (List)EFormAutoCompleteJson.this.creatinines.get();
                if (creats != null && !creats.isEmpty() && (creat = (PreviousLabResults)creats.get(0)) != null && NumberUtils.isNumber((String)creat.getVal())) {
                    int creatinineVal = new Double(Double.parseDouble(creat.getVal())).intValue();
                    Double clearance = null;
                    IPatient p = EFormAutoCompleteJson.this.getPatient();
                    if (p != null) {
                        LocalDate valDate = LocalDate.today();
                        if (creat.getDate() != null) {
                            try {
                                Date date = DateUtils.parseDate((String)creat.getDate(), (String[])new String[]{"yyyy-MM-dd", "yyyy/MM/dd"});
                                valDate = date == null ? null : LocalDate.fromTimeInMillisLOCAL((Long)date.getTime());
                            }
                            catch (Exception date) {
                                // empty catch block
                            }
                        }
                        Integer age = EFormAutoComplete.getAgeAtASpecificDate(p.getBirthDate(), valDate);
                        XPerson.Gender gender = XPerson.Gender.from((String)p.getGender());
                        Short race = p.getRace();
                        if (age != null && gender != null && gender != XPerson.Gender.INCONNU) {
                            int sex = gender == XPerson.Gender.FEMININ ? 1 : 0;
                            boolean isBlack = race != null && race.intValue() == 2;
                            clearance = MedCalc.MDRD((int)sex, (int)age, (boolean)isBlack, (int)creatinineVal);
                            labResult = new PreviousLabResults(creat.getDate(), EFormAutoComplete.valueOf(clearance == null ? null : String.format("%.2f", clearance).replace(',', '.')), "");
                        }
                    }
                }
                if (labResult != null) {
                    ArrayList<PreviousLabResults> prevLabResult = new ArrayList<PreviousLabResults>();
                    prevLabResult.add(labResult);
                    return prevLabResult;
                }
                return null;
            }
        };
        this.rnis = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~WINR");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.ca_ionises = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZCAI");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.ca_totals = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZCA");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.ferritines = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZFERR");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.glycemies = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZGLU");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.hbs = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZHB");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.kals = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZK");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.mags = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~MG");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.nats = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZNA");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.seds = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~YSEDI");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.urees = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZUREE");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the creatinine for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.cholt = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZCHOL");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the CHOL TOTAL for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.hdls = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZHDL");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the HDL CHOL for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.ldls = new EFormAutoComplete.OnTheFly<List<PreviousLabResults>>(){

            @Override
            public List<PreviousLabResults> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getLaboResultsAccessor().getPatientLastSpecificResults(EFormAutoCompleteJson.this.patient.getId(), "~~ZLDL");
                    if (o.getObj() != null && o.getObj() instanceof List) {
                        List prevLabResult = (List)o.getObj();
                        return prevLabResult;
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the LDL CHOL for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.patientIdentifiers = new EFormAutoComplete.OnTheFly<List<XPatientIdentifier>>(){

            @Override
            public List<XPatientIdentifier> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getPatientAccessor().findPatientIdentifiers(EFormAutoCompleteJson.this.patient.getId());
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the identifier for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.prescriptions = new EFormAutoComplete.OnTheFly<List<XPrescription>>(){

            @Override
            public List<XPrescription> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findPrescriptionsByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the identifier for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.encounter = new EFormAutoComplete.OnTheFly<XEncounter>(){

            @Override
            public XEncounter loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().getMostRecentEncounterByPatient(EFormAutoCompleteJson.this.patient.getId());
                    if (o.getObj() instanceof XEncounter) {
                        return (XEncounter)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the encounter for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.allergies = new EFormAutoComplete.OnTheFly<List<XAllergy>>(){

            @Override
            public List<XAllergy> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findAllergyAndIntoleranceByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.bodyTemperatures = new EFormAutoComplete.OnTheFly<List<XBodyTemperature>>(){

            @Override
            public List<XBodyTemperature> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findBodyTemperatureByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.diagnostics = new EFormAutoComplete.OnTheFly<List<XDiagnostic>>(){

            @Override
            public List<XDiagnostic> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findDiagnosticByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.prevents = new EFormAutoComplete.OnTheFly<List<XPrevent>>(){

            @Override
            public List<XPrevent> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findPreventByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.bloodPressures = new EFormAutoComplete.OnTheFly<List<XBloodPressure>>(){

            @Override
            public List<XBloodPressure> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findBloodPressureByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.frenquencies = new EFormAutoComplete.OnTheFly<List<XFrequency>>(){

            @Override
            public List<XFrequency> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findFrequencyByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.documents = new EFormAutoComplete.OnTheFly<List<XDocuments>>(){

            @Override
            public List<XDocuments> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findDocumentsByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.customMeasures = new EFormAutoComplete.OnTheFly<List<XCustomMeasure>>(){

            @Override
            public List<XCustomMeasure> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findCustomMeasureByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.immunizations = new EFormAutoComplete.OnTheFly<List<XImmunization>>(){

            @Override
            public List<XImmunization> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findImmunizationByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.interventions = new EFormAutoComplete.OnTheFly<List<XIntervention>>(){

            @Override
            public List<XIntervention> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findInterventionByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.lifeHabits = new EFormAutoComplete.OnTheFly<List<XLifeHabit>>(){

            @Override
            public List<XLifeHabit> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findLifeHabitByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.measurements = new EFormAutoComplete.OnTheFly<List<XMeasurement>>(){

            @Override
            public List<XMeasurement> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findMeasurementByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.plans = new EFormAutoComplete.OnTheFly<List<XPlan>>(){

            @Override
            public List<XPlan> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findPlanByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.rappels = new EFormAutoComplete.OnTheFly<List<XRappel>>(){

            @Override
            public List<XRappel> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findRappelByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.physicalExaminations = new EFormAutoComplete.OnTheFly<List<XPhysicalExamination>>(){

            @Override
            public List<XPhysicalExamination> loadObject() {
                try {
                    ReturnObject o = Application.get().getDataAccessors().getEncounterAccessor().findPhysicalExaminationByPatient(EFormAutoCompleteJson.this.patient.getId(), true);
                    if (o.getObj() instanceof List) {
                        return (List)o.getObj();
                    }
                }
                catch (Exception e) {
                    EFormAutoComplete.logger.log(Level.WARNING, "unable to get the allergies for autocompleteEform.", e);
                }
                return null;
            }
        };
        this.drugStores = new EFormAutoComplete.OnTheFly<List<XSite>>(){

            @Override
            public List<XSite> loadObject() {
                IEditableDataObjectList lstSites = EFormAutoCompleteJson.this.patient.getLstSites();
                if (lstSites != null) {
                    ArrayList<XSite> list = new ArrayList<XSite>(lstSites.size());
                    for (XPersonSite ps : lstSites) {
                        XSite site;
                        if (ps.addedAs != SiteAddedAs.DRUG_STORE || (site = Application.get().getSitePluginController().getSite(ps.idSite)) == null) continue;
                        list.add(site);
                    }
                    return list;
                }
                return null;
            }
        };
    }

    @Override
    protected void initAutoCompleteList() {
        super.initAutoCompleteList();
        this.autoCompletes.add(new PatientIdentifierListAJsonAC(this));
        this.autoCompletes.add(new EncounterAllergyListAJsonAC(this));
        this.autoCompletes.add(new EncounterBloodPressureListAJsonAC(this));
        this.autoCompletes.add(new EncounterBodyTemperaturesListAJsonAC(this));
        this.autoCompletes.add(new EncounterCustomMeasuresListAJsonAC(this));
        this.autoCompletes.add(new EncounterDiagnosticListAJsonAC(this));
        this.autoCompletes.add(new EncounterDocumentsListAJsonAC(this));
        this.autoCompletes.add(new EncounterFrequencyListAJsonAC(this));
        this.autoCompletes.add(new EncounterImmunizationsListAJsonAC(this));
        this.autoCompletes.add(new EncounterInterventionsListAJsonAC(this));
        this.autoCompletes.add(new EncounterLifeHabitsListAJsonAC(this));
        this.autoCompletes.add(new EncounterMeasurementsListAJsonAC(this));
        this.autoCompletes.add(new EncounterPhysicalExaminationsListAJsonAC(this));
        this.autoCompletes.add(new EncounterPlansListAJsonAC(this));
        this.autoCompletes.add(new EncounterPrescriptionListAJsonAC(this));
        this.autoCompletes.add(new EncounterPreventListAJsonAC(this));
        this.autoCompletes.add(new EncounterRappelsListAJsonAC(this));
        this.autoCompletes.add(new LaboCalciumIoniseListAJSonAC(this));
        this.autoCompletes.add(new LaboCalciumTotalListAJSonAC(this));
        this.autoCompletes.add(new LaboCreatinineListAJSonAC(this));
        this.autoCompletes.add(new LaboFerritineListAJSonAC(this));
        this.autoCompletes.add(new LaboGlycemieListAJSonAC(this));
        this.autoCompletes.add(new LaboHbListAJSonAC(this));
        this.autoCompletes.add(new LaboKaliemieListAJSonAC(this));
        this.autoCompletes.add(new LaboMagnesiumListAJSonAC(this));
        this.autoCompletes.add(new LaboNatremieListAJSonAC(this));
        this.autoCompletes.add(new LaboRniListAJSonAC(this));
        this.autoCompletes.add(new LaboSedimentationListAJSonAC(this));
        this.autoCompletes.add(new LaboUreeListAJSonAC(this));
        this.autoCompletes.add(new LaboCholTotalListAJSonAC(this));
        this.autoCompletes.add(new LaboCholHdlListAJSonAC(this));
        this.autoCompletes.add(new LaboCholLdlListAJSonAC(this));
        this.autoCompletes.add(new LaboClairanceListAJSonAC(this));
    }
}

