/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.ApprovedRequest;
import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION;
import ca.infodata.dsq.domain.PrescriptionDeviceSummary;
import ca.infodata.dsq.domain.PrescriptionDrugSummary;
import ca.infodata.dsq.domain.ToBeApprovedRequest;
import ca.infodata.dsq.service.oe.OEC1701Svc.RetractRequestCriteria;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.Job;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.ofys.client.job.NullProgressMonitor;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.modules.dsq.internal.OEPrescriptionController;
import ca.infodata.ofys.client.modules.dsq.internal.OERetractControllerCallback;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.util1.Pair;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OERetractController {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.encounter.dsq.controller.RetractOEController");
    private static final String RETRAIT_D_UNE_ORDONNANCE = "Retrait d'une ordonnance";
    private Integer idPatient;
    private OEPrescriptionController oePrescriptionController;
    private JobExtension job;
    private OERetractControllerCallback callback;
    private final IDSQPluginController dsq;
    private final IDSQAccessor dsqAccessor;

    public OERetractController(Integer idPatient, OERetractControllerCallback callback, OEPrescriptionController oePrescriptionController) {
        this.idPatient = idPatient;
        this.callback = callback;
        this.oePrescriptionController = oePrescriptionController;
        this.dsq = Application.get().getDsqPluginController();
        this.dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();
    }

    public void retract(NIU_PRESCRIPTION id) throws Exception {
        if (this.job == null) {
            this.job = new JobExtension(RETRAIT_D_UNE_ORDONNANCE);
        }
        if (this.job.getState() == JobStatus.RUNNING) {
            this.callback.retract(id, new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.job.setId(id);
            this.job.schedule();
        }
    }

    protected void retract2(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        this.callback.retract(id, this.retract3(id, monitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DsqCallback<Boolean> retract3(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        DsqCallback<Boolean> callback = new DsqCallback<Boolean>();
        try {
            IPrescriptionSummary prescription = this.oePrescriptionController.get(id);
            if (prescription != null) {
                RetractData data = this.retract4(prescription, monitor);
                callback.result = data.status1 != null && data.status1.isOK() && data.status2 != null && data.status2.isOK();
            } else {
                callback.message = "La prescription n'a pu \u00e8tre trouv\u00e9";
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]) : e.getMessage();
            callback.exception = e;
        }
        finally {
            monitor.done();
        }
        return callback;
    }

    private RetractData retract4(IPrescriptionSummary prescription, IProgressMonitor monitor) {
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        RetractData data = new RetractData();
        data.prescriptionFormat = this.format4(prescription);
        data.prescriptionId = prescription.getId();
        data.prescriptionVersion = prescription.getVersion();
        ArrayList<RetractData> datas = new ArrayList<RetractData>();
        datas.add(data);
        this.retract4(datas, monitor);
        return data;
    }

    private String format4(IPrescriptionSummary prescription) {
        String prescriptionText;
        if (prescription instanceof PrescriptionDrugSummary) {
            prescriptionText = ((PrescriptionDrugSummary)prescription).medication.name + ": " + ((PrescriptionDrugSummary)prescription).dosageText;
        } else if (prescription instanceof PrescriptionDeviceSummary) {
            prescriptionText = ((PrescriptionDeviceSummary)prescription).device.name + ": " + ((PrescriptionDeviceSummary)prescription).usageInstructions;
        } else {
            throw new IllegalArgumentException("unsupported prescription class type " + prescription.getClass().getSimpleName());
        }
        return prescriptionText;
    }

    public void retract4(List<RetractData> datas, IProgressMonitor monitor) {
        IProgressMonitor subMonitor = monitor == null ? NullProgressMonitor.INSTANCE : monitor.subMonitor(3);
        datas.forEach(data -> {
            data.status1 = Status.OK_STATUS;
        });
        XmlSignatureI signature = null;
        Alias alias = null;
        try {
            if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
            }
            alias = this.dsq.getAlias(monitor);
            if (!this.dsq.hasSignatures(this.idPatient)) {
                signature = this.dsq.getSignatureI(monitor, alias);
            }
            monitor.worked(1);
        }
        catch (AbortException | CancelException e) {
            datas.forEach(data -> {
                data.status1 = new Status(IStatus.Severity.ERROR, (Throwable)e);
            });
        }
        catch (Exception e) {
            datas.forEach(data -> {
                data.status1 = new Status(IStatus.Severity.BUG, (Throwable)e);
            });
        }
        IStatus status1 = Status.OK_STATUS;
        if (alias != null && signature != null) {
            block18: {
                try {
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    datas.forEach(data -> map.put(data.prescriptionId, data.prescriptionVersion));
                    ReturnObject response = this.dsqAccessor.retractPrescriptions1((Signature)signature, this.idPatient, map);
                    status1 = (Status)response.getObj();
                    for (RetractData retractData : datas) {
                        retractData.status1 = status1;
                    }
                    if (!status1.isOkToProceed()) break block18;
                    List p = (List)((Object)status1.getData());
                    for (Pair pp : p) {
                        datas.stream().filter(data -> data.prescriptionId.equals(pp.getFirst())).forEach(data -> {
                            data.toBeApprovedRequest = new ToBeApprovedRequest(null, (String)pp.getFirst(), 0L, (String)pp.getSecond(), null, null);
                        });
                    }
                    for (RetractData data2 : datas) {
                        if (data2.toBeApprovedRequest != null) {
                            Signature signatureS = this.dsq.getSignatureS(monitor, alias, data2.toBeApprovedRequest.hash);
                            data2.approvedRequest = data2.toBeApprovedRequest.toApprovedRequest(signatureS);
                            continue;
                        }
                        data2.status1 = data2.status1 = new Status(IStatus.Severity.BUG, "no toBeApprovedRequest present for data " + data2);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error on retract1 for datas " + datas, e);
                    status1 = new Status(IStatus.Severity.BUG, (Throwable)e);
                    for (RetractData data4 : datas) {
                        data4.status1 = status1;
                    }
                }
            }
            subMonitor.worked(1);
        }
        IStatus status2 = Status.OK_STATUS;
        if (status1.isOK()) {
            try {
                HashMap<String, ApprovedRequest<RetractRequestCriteria>> mapApprovedRequests = new HashMap<String, ApprovedRequest<RetractRequestCriteria>>();
                datas.forEach(data -> mapApprovedRequests.put(data.prescriptionId, data.approvedRequest));
                ReturnObject response = this.dsqAccessor.retractPrescriptions2((Signature)signature, this.idPatient, mapApprovedRequests);
                status2 = (Status)response.getObj();
                for (RetractData data3 : datas) {
                    data3.status2 = status2;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error on retract2 for datas " + datas, e);
                status2 = new Status(IStatus.Severity.BUG, (Throwable)e);
                for (RetractData retractData : datas) {
                    retractData.status2 = status2;
                }
            }
            subMonitor.worked(1);
        }
    }

    public OERetractControllerCallback getCallback() {
        return this.callback;
    }

    final class JobExtension
    extends Job {
        private NIU_PRESCRIPTION id;

        public void setId(NIU_PRESCRIPTION id) {
            this.id = id;
        }

        private JobExtension(String name) {
            super(name);
        }

        @Override
        protected void runWithException() throws Exception {
            OERetractController.this.retract2(this.id, this);
        }
    }

    static class RetractData {
        String prescriptionFormat;
        String prescriptionId;
        String prescriptionVersion;
        ToBeApprovedRequest toBeApprovedRequest;
        ApprovedRequest<RetractRequestCriteria> approvedRequest;
        IStatus status1;
        IStatus status2;

        RetractData() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.prescriptionId == null ? 0 : this.prescriptionId.hashCode());
            result = 31 * result + (this.prescriptionVersion == null ? 0 : this.prescriptionVersion.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RetractData other = (RetractData)obj;
            return this.hashCode() == other.hashCode();
        }
    }
}

