/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.Job;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.IDSQPluginController;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListImagingExamController {
    private static final String OBTENTION_DE_LA_LISTE = "Obtention de la liste des rapports d'examen d'imagerie m\u00e9dicale";
    private static final Logger logger = Logger.getLogger(ListImagingExamController.class.getName());
    private final Integer idPatient;
    private LocalDate start = null;
    private LocalDate end = null;
    private int limit = 250;
    private QueryContinuationResult result;
    private Job list;
    private final GetCandidateController findCandidateAction;
    private final IDSQPluginController dsq;
    private final IDSQAccessor dsqAccessor;

    public ListImagingExamController(Integer idPatient, GetCandidateController findCandidateAction) {
        if (findCandidateAction == null) {
            throw new NullPointerException("findCandidateAction");
        }
        this.dsq = Application.get().getDsqPluginController();
        this.dsqAccessor = Application.get().getDataAccessors().getDSQAccessor();
        this.findCandidateAction = findCandidateAction;
        this.idPatient = idPatient;
    }

    public void callback(DsqCallback<QueryContinuationResult> callback) {
    }

    public void list() throws Exception {
        if (this.list == null) {
            this.list = new Job(OBTENTION_DE_LA_LISTE, this::list2);
        }
        if (this.list.getState() == JobStatus.RUNNING) {
            this.callback(new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.list.schedule();
        }
    }

    public void list2(IProgressMonitor monitor) {
        if (this.result == null) {
            DsqCallback<QueryContinuationResult> r = this.list3(monitor);
            if (r.result != null) {
                this.result = (QueryContinuationResult)r.result;
            }
            this.callback(r);
        } else {
            this.callback(new DsqCallback<QueryContinuationResult>(this.result));
        }
    }

    public MultiStatus valid() {
        MultiStatus status = new MultiStatus();
        if (this.start != null && this.start.before((IPartialDate)LocalDate.from((int)1, (int)1, (int)2007))) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "La date de d\u00e9but ne doit pas \u00eatre avant le 1er janvier 2007"));
        }
        if (this.end != null && this.end.before((IPartialDate)LocalDate.from((int)1, (int)1, (int)2007))) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "La date de fin ne doit pas \u00eatre avant le 1er janvier 2007"));
        }
        if (this.start != null && this.start.after((IPartialDate)LocalDate.today())) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "La date de d\u00e9but ne doit pas \u00eatre dans le futur"));
        }
        if (this.end != null && this.end.after((IPartialDate)LocalDate.today())) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "La date de fin ne doit pas \u00eatre dans le futur"));
        }
        if (this.end != null && this.start != null && this.end.before((IPartialDate)this.start)) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "La date de d\u00e9but doit \u00eatre avant la date de fin"));
        }
        if (this.idPatient == null) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Veuillez sp\u00e9cifier un client"));
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DsqCallback<QueryContinuationResult> list3(IProgressMonitor monitor) {
        DsqCallback<QueryContinuationResult> callback = new DsqCallback<QueryContinuationResult>();
        try {
            if (this.end != null && this.start != null && this.end.before((IPartialDate)this.start)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.idPatient == null) {
                callback.message = "Veuillez sp\u00e9cifier un client";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (monitor != null) {
                monitor.beginTask(OBTENTION_DE_LA_LISTE, 2);
            }
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                this.dsq.checkIfActionWasCanceled(monitor);
                Alias alias = this.dsq.getAlias(monitor);
                this.dsq.checkIfActionWasCanceled(monitor);
                String niu = this.findCandidateAction.getNiu(monitor == null ? null : monitor.subMonitor(1));
                this.dsq.checkIfActionWasCanceled(monitor);
                signature = this.dsq.getSignatureI(monitor, alias);
                this.dsq.checkIfActionWasCanceled(monitor);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
                this.dsq.checkIfActionWasCanceled(monitor);
                if (monitor != null) {
                    monitor.worked(1);
                }
                this.dsq.checkIfActionWasCanceled(monitor);
            }
            if (monitor != null) {
                monitor.subTask("Recherche");
            }
            LocalDate start2 = this.start;
            LocalDate end2 = this.end;
            int limit2 = this.limit;
            ReturnObject r = this.dsqAccessor.listImagingExam((Signature)signature, (Signature)signatureNiu, this.idPatient, start2, end2, limit2, null, null);
            if (r == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DE_LA_LISTE.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (QueryContinuationResult)r.getObj();
            this.dsq.checkIfActionWasCanceled(monitor);
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.exception = e;
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = e.getMessage();
            logger.log(Level.SEVERE, String.format("Failed to list imaging %s, %s, %s, %s", this.idPatient, this.start, this.end, this.limit), e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void clear() {
        this.result = null;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.clear();
        this.start = start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.clear();
        this.end = end;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.clear();
        this.limit = limit;
    }
}

