/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.Job;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.internal.DMPrescriptionControllerCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.QueryContinuationController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMPrescriptionController
extends QueryContinuationController {
    private static final LocalDate MINIMALDATE = LocalDate.from((int)1, (int)1, (int)2007);
    private static final String OBTENTION_DE_L_ORDONNANCE_DETAILLEE = Messages.getString((String)"GetPrescriptionDispensedDetailsAction.OBTENTION_DE_L_ORDONNANCE_DETAILLEE", (String[])new String[0]);
    private static final String OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_RECU_PAR_UN_PHARMACIEN = Messages.getString((String)"ListPatientPrescriptionDispensedAction.OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_RECU_PAR_UN_PHARMACIEN", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(DMPrescriptionController.class.getName());
    private final DMPrescriptionControllerCallback callback;
    private final Integer idPatient;
    private LocalDate start = LocalDate.today().plusYear(-1);
    private LocalDate end = LocalDate.today();
    private boolean onlyThoseWithIssue;
    private boolean includeCompletlyDispensed = false;
    private boolean includePartiallyDispensed = true;
    private boolean includeNeverDispensed = true;
    private int limit = 50;
    private List<IPrescriptionSummary> list;
    private QueryContinuationResult lastQCR;
    private Job listSummaryJob;
    private JobExtension getDetailJob;
    private Map<NIU_PRESCRIPTION, PrescriptionDrugDetails> prescriptionMapDetail;
    private final GetCandidateController findCandidateAction;

    public DMPrescriptionController(Integer idPatient, DMPrescriptionControllerCallback callback, GetCandidateController findCandidateAction) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        this.idPatient = idPatient;
        this.callback = callback;
        this.findCandidateAction = findCandidateAction;
        this.prescriptionMapDetail = new ConcurrentHashMap<NIU_PRESCRIPTION, PrescriptionDrugDetails>();
    }

    public void listSummary() throws Exception {
        if (this.listSummaryJob == null) {
            this.listSummaryJob = new Job("Sommaire des ordonnances en attente", this::listSummary2);
        }
        if (this.listSummaryJob.getState() == JobStatus.RUNNING) {
            this.callback.listSummary(new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.listSummaryJob.schedule();
        }
    }

    public void listSummary2(IProgressMonitor monitor) {
        if (this.list == null) {
            DsqCallback<QueryContinuationResult> r = this.listSummary3(monitor);
            this.lastQCR = (QueryContinuationResult)r.result;
            if (r.result != null) {
                this.list = new ArrayList<IPrescriptionSummary>(((QueryContinuationResult)r.result).prescriptions);
            }
            this.callback.listSummary(r);
        } else if (this.lastQCR != null && this.lastQCR.originalTotalQuantity > this.list.size()) {
            DsqCallback<QueryContinuationResult> r = this.continueQuery(this.idPatient, this.lastQCR, this.limit, monitor);
            if (r.result != null) {
                this.lastQCR = (QueryContinuationResult)r.result;
                this.list.addAll(((QueryContinuationResult)r.result).prescriptions);
                QueryContinuationResult r2 = new QueryContinuationResult();
                r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
                r2.prescriptions = this.list;
                r2.queryId = ((QueryContinuationResult)r.result).queryId;
                r2.resultTotalQuantity = r2.originalTotalQuantity;
                r2.resultCurrentQuantity = r2.prescriptions.size();
                r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
                this.callback.listSummary(new DsqCallback<QueryContinuationResult>(r2));
            } else {
                this.callback.listSummary(r);
            }
        } else {
            QueryContinuationResult r2 = new QueryContinuationResult();
            r2.originalTotalQuantity = this.lastQCR.originalTotalQuantity;
            r2.prescriptions = this.list;
            r2.queryId = this.lastQCR.queryId;
            r2.resultTotalQuantity = r2.originalTotalQuantity;
            r2.resultCurrentQuantity = r2.prescriptions.size();
            r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
            this.callback.listSummary(new DsqCallback<QueryContinuationResult>(r2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DsqCallback<QueryContinuationResult> listSummary3(IProgressMonitor monitor) {
        DsqCallback<QueryContinuationResult> callback = new DsqCallback<QueryContinuationResult>();
        try {
            ReturnObject r;
            if (this.end == null || this.start == null) {
                callback.message = "Une date de d\u00e9but et une date de fin est requise";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.end.before((IPartialDate)this.start)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.start.before((IPartialDate)MINIMALDATE)) {
                callback.message = "La date de d\u00e9but ne peut \u00eatre avant " + MINIMALDATE.formatSlash();
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (monitor != null) {
                monitor.beginTask(OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_RECU_PAR_UN_PHARMACIEN, 2);
            }
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                this.dsq.checkIfActionWasCanceled(monitor);
                Alias alias = this.dsq.getAlias(monitor);
                this.dsq.checkIfActionWasCanceled(monitor);
                String niu = this.findCandidateAction.getNiu(monitor == null ? null : monitor.subMonitor(1));
                this.dsq.checkIfActionWasCanceled(monitor);
                signature = this.dsq.getSignatureI(monitor, alias);
                this.dsq.checkIfActionWasCanceled(monitor);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
                this.dsq.checkIfActionWasCanceled(monitor);
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            this.dsq.checkIfActionWasCanceled(monitor);
            if (monitor != null) {
                monitor.subTask("Recherche");
            }
            if ((r = this.dsqAccessor.getPrescriptionOrderSummaryServiceDM((Signature)signature, (Signature)signatureNiu, this.idPatient, this.start, this.end, this.onlyThoseWithIssue, this.includeCompletlyDispensed, this.includePartiallyDispensed, this.includeNeverDispensed, this.limit)) == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DE_LA_LISTE_DES_ORDONNANCES_RECU_PAR_UN_PHARMACIEN.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (QueryContinuationResult)r.getObj();
            this.dsq.checkIfActionWasCanceled(monitor);
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]) : e.getMessage();
            logger.log(Level.SEVERE, "Failed to list dm prescription. patient=" + this.idPatient, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void getDetail(NIU_PRESCRIPTION id, String context) throws Exception {
        if (this.getDetailJob == null) {
            this.getDetailJob = new JobExtension(OBTENTION_DE_L_ORDONNANCE_DETAILLEE);
        }
        if (this.getDetailJob.getState() == JobStatus.RUNNING) {
            this.callback.getDetail(id, context, new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDetailJob.setId(id);
            this.getDetailJob.setContext(context);
            this.getDetailJob.schedule();
        }
    }

    protected void getDetail2(NIU_PRESCRIPTION id, String context, IProgressMonitor monitor) {
        PrescriptionDrugDetails d = this.prescriptionMapDetail.get(id);
        if (d == null) {
            DsqCallback<PrescriptionDrugDetails> c = this.getDetail3(id, monitor);
            if (c.result != null) {
                this.prescriptionMapDetail.put(id, (PrescriptionDrugDetails)c.result);
            }
            this.callback.getDetail(id, context, c);
        } else {
            this.callback.getDetail(id, context, new DsqCallback<PrescriptionDrugDetails>(d));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DsqCallback<PrescriptionDrugDetails> getDetail3(NIU_PRESCRIPTION id, IProgressMonitor monitor) {
        DsqCallback<PrescriptionDrugDetails> callback = new DsqCallback<PrescriptionDrugDetails>();
        if (monitor != null) {
            monitor.beginTask(OBTENTION_DE_L_ORDONNANCE_DETAILLEE, 3);
        }
        try {
            ReturnObject r;
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.dsq.getAlias(monitor);
                String niu = this.findCandidateAction.getNiu(monitor == null ? null : monitor.subMonitor(1));
                signature = this.dsq.getSignatureI(monitor, alias);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
            }
            if ((r = this.dsqAccessor.getDrugPrescriptionDetailsDM((Signature)signature, (Signature)signatureNiu, this.idPatient, id.value(), id.version())) == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DE_L_ORDONNANCE_DETAILLEE.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (PrescriptionDrugDetails)r.getObj();
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]) : e.getMessage();
            logger.log(Level.SEVERE, "Failed to get prescription device details with niu=" + id + ", patient=" + this.idPatient, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public void setStart(LocalDate start) {
        this.start = start;
        this.list = null;
        this.lastQCR = null;
        this.prescriptionMapDetail.clear();
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public void setEnd(LocalDate end) {
        this.end = end;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isOnlyThoseWithIssue() {
        return this.onlyThoseWithIssue;
    }

    public void setOnlyThoseWithIssue(boolean onlyThoseWithIssue) {
        this.onlyThoseWithIssue = onlyThoseWithIssue;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isIncludeCompletlyDispensed() {
        return this.includeCompletlyDispensed;
    }

    public void setIncludeCompletlyDispensed(boolean includeCompletlyDispensed) {
        this.includeCompletlyDispensed = includeCompletlyDispensed;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isIncludePartiallyDispensed() {
        return this.includePartiallyDispensed;
    }

    public void setIncludePartiallyDispensed(boolean includePartiallyDispensed) {
        this.includePartiallyDispensed = includePartiallyDispensed;
        this.list = null;
        this.lastQCR = null;
    }

    public boolean isIncludeNeverDispensed() {
        return this.includeNeverDispensed;
    }

    public void setIncludeNeverDispensed(boolean includeNeverDispensed) {
        this.includeNeverDispensed = includeNeverDispensed;
        this.list = null;
        this.lastQCR = null;
    }

    public DMPrescriptionControllerCallback getCallback() {
        return this.callback;
    }

    final class JobExtension
    extends Job {
        private NIU_PRESCRIPTION id;
        private String context;

        public void setId(NIU_PRESCRIPTION id) {
            this.id = id;
        }

        private JobExtension(String name) {
            super(name);
        }

        @Override
        protected void runWithException() throws Exception {
            DMPrescriptionController.this.getDetail2(this.id, this.context, this);
        }

        public void setContext(String context) {
            this.context = context;
        }
    }
}

