/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.domain.NIU_OTHER_MEDICATION_DM;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION_DM;
import ca.infodata.dsq.domain.OtherMedicationDetail;
import ca.infodata.dsq.domain.OtherMedicationSummary;
import ca.infodata.dsq.domain.PrescriptionDrugDetails;
import ca.infodata.dsq.domain.PrescriptionDrugSummary;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.job.IProgressMonitor;
import ca.infodata.ofys.client.job.Job;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.internal.DMMedicationControllerCallback;
import ca.infodata.ofys.client.modules.dsq.internal.DMPrescriptionController;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.QueryContinuationController;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMMedicationController
extends QueryContinuationController {
    private static final LocalDate MINIMALDATE = LocalDate.from((int)1, (int)1, (int)2007);
    private static final String OBTENTION_DU_SOMMAIRE_DE_LA_MEDICATION = Messages.getString((String)"DMPrescriptionController.OBTENTION_DU_SOMMAIRE_DE_LA_MEDICATION", (String[])new String[0]);
    private static final String OBTENTION_DU_DETAIL_DUN_MEDICAMENT_SANS_ORDONNANCE = Messages.getString((String)"DMPrescriptionController.OBTENTION_DU_DETAIL_DUN_MEDICAMENT_SANS_ORDONNANCE", (String[])new String[0]);
    private static final String OBTENTION_DU_DETAIL_DUNE_ORDONNANCE = Messages.getString((String)"DMPrescriptionController.OBTENTION_DU_DETAIL_DUNE_ORDONNANCE", (String[])new String[0]);
    private static final Logger logger = Logger.getLogger(DMPrescriptionController.class.getName());
    private final DMMedicationControllerCallback callback;
    private final Integer idPatient;
    private LocalDate administrationEffectiveStart = LocalDate.today().plusYear(-1);
    private LocalDate administrationEffectiveEnd = LocalDate.today();
    private LocalDate amendedInTimeStart;
    private LocalDate amendedInTimeEnd;
    private boolean onlyThoseWithIssue;
    private int limit = 50;
    private List<PrescriptionDrugSummary> prescriptions;
    private List<OtherMedicationSummary> medications;
    private QueryContinuationResult summaryQCR;
    private Job listSummaryJob;
    private Map<NIU_PRESCRIPTION_DM, PrescriptionDrugDetails> prescriptionMapDetail;
    private Map<NIU_OTHER_MEDICATION_DM, OtherMedicationDetail> medicationMapDetail;
    private JobExtension getDetailJob;
    private final GetCandidateController findCandidateController;

    public DMMedicationController(Integer idPatient, DMMedicationControllerCallback callback, GetCandidateController findCandidateController) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
        this.callback = callback;
        if (findCandidateController == null) {
            throw new NullPointerException("findCandidateController");
        }
        this.idPatient = idPatient;
        this.findCandidateController = findCandidateController;
        this.prescriptionMapDetail = new ConcurrentHashMap<NIU_PRESCRIPTION_DM, PrescriptionDrugDetails>();
        this.medicationMapDetail = new ConcurrentHashMap<NIU_OTHER_MEDICATION_DM, OtherMedicationDetail>();
    }

    public void listSummary() throws Exception {
        if (this.listSummaryJob == null) {
            this.listSummaryJob = new Job("Sommaire de la m\u00e9dication active", this::listSummary2);
        }
        if (this.listSummaryJob.getState() == JobStatus.RUNNING) {
            this.callback.listSummary(new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.listSummaryJob.schedule();
        }
    }

    public void listSummary2(IProgressMonitor monitor) {
        if (this.summaryQCR == null) {
            DsqCallback<QueryContinuationResult> r = this.listSummary3(monitor);
            this.summaryQCR = (QueryContinuationResult)r.result;
            if (r.result != null) {
                this.prescriptions = new ArrayList<PrescriptionDrugSummary>(((QueryContinuationResult)r.result).drugs);
                this.medications = new ArrayList<OtherMedicationSummary>(((QueryContinuationResult)r.result).otherMedications);
            }
            this.callback.listSummary(r);
        } else if (this.summaryQCR != null && this.summaryQCR.originalTotalQuantity > this.prescriptions.size() + this.medications.size()) {
            DsqCallback<QueryContinuationResult> r = this.continueQuery(this.idPatient, this.summaryQCR, this.limit, monitor);
            if (r.result != null) {
                this.summaryQCR = (QueryContinuationResult)r.result;
                int maxSequenceValue = this.computeMaxSequenceValue();
                for (PrescriptionDrugSummary e : ((QueryContinuationResult)r.result).drugs) {
                    e.sequence += maxSequenceValue;
                }
                for (PrescriptionDrugSummary e : ((QueryContinuationResult)r.result).otherMedications) {
                    e.sequence += maxSequenceValue;
                }
                this.prescriptions.addAll(((QueryContinuationResult)r.result).drugs);
                this.medications.addAll(((QueryContinuationResult)r.result).otherMedications);
                QueryContinuationResult r2 = new QueryContinuationResult();
                r2.originalTotalQuantity = this.summaryQCR.originalTotalQuantity;
                r2.drugs = this.prescriptions;
                r2.otherMedications = this.medications;
                r2.queryId = ((QueryContinuationResult)r.result).queryId;
                r2.resultTotalQuantity = r2.originalTotalQuantity;
                r2.resultCurrentQuantity = r2.drugs.size() + r2.otherMedications.size();
                r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
                this.callback.listSummary(new DsqCallback<QueryContinuationResult>(r2));
            } else {
                this.callback.listSummary(r);
            }
        } else {
            QueryContinuationResult r2 = new QueryContinuationResult();
            r2.originalTotalQuantity = this.summaryQCR.originalTotalQuantity;
            r2.drugs = this.prescriptions;
            r2.otherMedications = this.medications;
            r2.queryId = this.summaryQCR.queryId;
            r2.resultTotalQuantity = r2.originalTotalQuantity;
            r2.resultCurrentQuantity = r2.drugs.size() + r2.otherMedications.size();
            r2.resultRemainingQuantity = r2.resultTotalQuantity - r2.resultCurrentQuantity;
            this.callback.listSummary(new DsqCallback<QueryContinuationResult>(r2));
        }
    }

    private int computeMaxSequenceValue() {
        int v = 0;
        if (this.prescriptions != null) {
            for (PrescriptionDrugSummary prescriptionDrugSummary : this.prescriptions) {
                v = Math.max(v, prescriptionDrugSummary.sequence);
            }
        }
        if (this.medications != null) {
            for (OtherMedicationSummary otherMedicationSummary : this.medications) {
                v = Math.max(v, otherMedicationSummary.sequence);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DsqCallback<QueryContinuationResult> listSummary3(IProgressMonitor monitor) {
        DsqCallback<QueryContinuationResult> callback = new DsqCallback<QueryContinuationResult>();
        try {
            ReturnObject r;
            if (this.administrationEffectiveStart == null && this.administrationEffectiveEnd != null || this.administrationEffectiveStart != null && this.administrationEffectiveEnd == null) {
                callback.message = "Les deux dates de p\u00e9riode doivent \u00eatre pr\u00e9sente pour \u00eatre prisent en compte";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.amendedInTimeStart == null && this.amendedInTimeEnd != null || this.amendedInTimeStart != null && this.amendedInTimeEnd == null) {
                callback.message = "Les deux dates de Modif\u00e9 doivent \u00eatre pr\u00e9sente pour \u00eatre prisent en compte";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.administrationEffectiveStart != null && this.administrationEffectiveEnd != null && this.administrationEffectiveEnd.before((IPartialDate)this.administrationEffectiveStart)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.amendedInTimeStart != null && this.amendedInTimeEnd != null && this.amendedInTimeEnd.before((IPartialDate)this.amendedInTimeStart)) {
                callback.message = "La date de d\u00e9but doit \u00eatre avant la date de fin";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.administrationEffectiveStart != null && LocalDate.today().before((IPartialDate)this.administrationEffectiveStart) || this.amendedInTimeStart != null && LocalDate.today().before((IPartialDate)this.amendedInTimeStart)) {
                callback.message = "Une date de d\u00e9but est dans le futur";
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (this.administrationEffectiveStart != null && this.administrationEffectiveStart.before((IPartialDate)MINIMALDATE) || this.amendedInTimeStart != null && this.amendedInTimeStart.before((IPartialDate)MINIMALDATE)) {
                callback.message = "La date de d\u00e9but ne peut \u00eatre avant " + MINIMALDATE.formatSlash();
                if (monitor != null) {
                    monitor.done();
                }
                DsqCallback<QueryContinuationResult> dsqCallback = callback;
                return dsqCallback;
            }
            if (monitor != null) {
                monitor.beginTask(OBTENTION_DU_SOMMAIRE_DE_LA_MEDICATION, 2);
            }
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                this.dsq.checkIfActionWasCanceled(monitor);
                Alias alias = this.dsq.getAlias(monitor);
                this.dsq.checkIfActionWasCanceled(monitor);
                String niu = this.findCandidateController.getNiu(monitor == null ? null : monitor.subMonitor(1));
                this.dsq.checkIfActionWasCanceled(monitor);
                signature = this.dsq.getSignatureI(monitor, alias);
                this.dsq.checkIfActionWasCanceled(monitor);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
                this.dsq.checkIfActionWasCanceled(monitor);
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            this.dsq.checkIfActionWasCanceled(monitor);
            if (monitor != null) {
                monitor.subTask("Recherche");
            }
            if ((r = this.dsqAccessor.getMedicationSummaryServiceDM((Signature)signature, (Signature)signatureNiu, this.administrationEffectiveStart, this.administrationEffectiveEnd, this.amendedInTimeStart, this.amendedInTimeEnd, this.onlyThoseWithIssue, this.idPatient, this.limit)) == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DU_SOMMAIRE_DE_LA_MEDICATION.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (QueryContinuationResult)r.getObj();
            this.dsq.checkIfActionWasCanceled(monitor);
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]) : e.getMessage();
            logger.log(Level.SEVERE, "Failed to get dm summary list. patient=" + this.idPatient, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public void getPrescriptionDetail(NIU_PRESCRIPTION_DM id, String context) throws Exception {
        if (this.getDetailJob == null) {
            this.getDetailJob = new JobExtension(OBTENTION_DU_DETAIL_DUNE_ORDONNANCE);
        }
        if (this.getDetailJob.getState() == JobStatus.RUNNING) {
            this.callback.getPrescriptionDetail(id, context, new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDetailJob.setIdPrescription(id, context);
            this.getDetailJob.schedule();
        }
    }

    protected void getPrescriptionDetail2(NIU_PRESCRIPTION_DM id, String context, IProgressMonitor monitor) {
        PrescriptionDrugDetails d = this.prescriptionMapDetail.get(id);
        if (d == null) {
            DsqCallback<PrescriptionDrugDetails> c = this.getPrescriptionDetail3(id, monitor);
            if (c.result != null) {
                this.prescriptionMapDetail.put(id, (PrescriptionDrugDetails)c.result);
            }
            this.callback.getPrescriptionDetail(id, context, c);
        } else {
            this.callback.getPrescriptionDetail(id, context, new DsqCallback<PrescriptionDrugDetails>(d));
        }
    }

    public void getMedicationDetail(NIU_OTHER_MEDICATION_DM id) throws Exception {
        if (this.getDetailJob == null) {
            this.getDetailJob = new JobExtension(OBTENTION_DU_DETAIL_DUN_MEDICAMENT_SANS_ORDONNANCE);
        }
        if (this.getDetailJob.getState() == JobStatus.RUNNING) {
            this.callback.getMedicationDetail(id, new DsqCallback<Object>(null, "Op\u00e9ration en cours...", null));
        } else {
            this.getDetailJob.setIdMedication(id);
            this.getDetailJob.schedule();
        }
    }

    protected void getMedicationDetail2(NIU_OTHER_MEDICATION_DM id, IProgressMonitor monitor) {
        OtherMedicationDetail d = this.medicationMapDetail.get(id);
        if (d == null) {
            DsqCallback<OtherMedicationDetail> c = this.getMedicationDetail3(id, monitor);
            if (c.result != null) {
                this.medicationMapDetail.put(id, (OtherMedicationDetail)c.result);
            }
            this.callback.getMedicationDetail(id, c);
        } else {
            this.callback.getMedicationDetail(id, new DsqCallback<OtherMedicationDetail>(d));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DsqCallback<PrescriptionDrugDetails> getPrescriptionDetail3(NIU_PRESCRIPTION_DM id, IProgressMonitor monitor) {
        DsqCallback<PrescriptionDrugDetails> callback = new DsqCallback<PrescriptionDrugDetails>();
        if (monitor != null) {
            monitor.beginTask(OBTENTION_DU_DETAIL_DUNE_ORDONNANCE, 3);
        }
        try {
            ReturnObject r;
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.dsq.getAlias(monitor);
                String niu = this.findCandidateController.getNiu(monitor == null ? null : monitor.subMonitor(1));
                signature = this.dsq.getSignatureI(monitor, alias);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
            }
            if ((r = this.dsqAccessor.getDrugPrescriptionDetailsDM((Signature)signature, (Signature)signatureNiu, this.idPatient, id.value(), id.version())) == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DU_DETAIL_DUNE_ORDONNANCE.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            callback.result = (PrescriptionDrugDetails)r.getObj();
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]) : e.getMessage();
            logger.log(Level.SEVERE, "Failed to get prescription drug details with niu=" + id + ", patient=" + this.idPatient, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DsqCallback<OtherMedicationDetail> getMedicationDetail3(NIU_OTHER_MEDICATION_DM id, IProgressMonitor monitor) {
        DsqCallback<OtherMedicationDetail> callback = new DsqCallback<OtherMedicationDetail>();
        if (monitor != null) {
            monitor.beginTask(OBTENTION_DU_DETAIL_DUN_MEDICAMENT_SANS_ORDONNANCE, 3);
        }
        try {
            ReturnObject r;
            XmlSignatureI signature = null;
            XmlSignatureI signatureNiu = null;
            if (!this.dsq.hasSignatures(this.idPatient)) {
                if (!Application.get().getApplicationUiPlugin().isWindowsDesktop()) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.dsq.getAlias(monitor);
                String niu = this.findCandidateController.getNiu(monitor == null ? null : monitor.subMonitor(1));
                signature = this.dsq.getSignatureI(monitor, alias);
                signatureNiu = this.dsq.getXmlSignatureI(monitor, alias, niu);
            }
            if ((r = this.dsqAccessor.getMedicationDetailServiceDM((Signature)signature, (Signature)signatureNiu, null, null, null, null, false, id, this.idPatient, null)) == null) {
                throw new AbortException("Erreur lors de l'" + OBTENTION_DU_DETAIL_DUN_MEDICAMENT_SANS_ORDONNANCE.toLowerCase());
            }
            this.dsq.manageDsqStatus(r.getStatus());
            QueryContinuationResult qcr = (QueryContinuationResult)r.getObj();
            callback.result = qcr.otherMedicationsDetails.get(0);
        }
        catch (AbortException | CancelException | CannotConnectToServerException | StatusException e) {
            callback.message = e.getMessage();
        }
        catch (Exception e) {
            callback.exception = e;
            callback.message = StringUtils.isBlank((CharSequence)e.getMessage()) ? Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]) : e.getMessage();
            logger.log(Level.SEVERE, "Failed to get prescription drug details with niu=" + id + ", patient=" + this.idPatient, e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return callback;
    }

    public boolean isOnlyThoseWithIssue() {
        return this.onlyThoseWithIssue;
    }

    public void setOnlyThoseWithIssue(boolean onlyThoseWithIssue) {
        this.onlyThoseWithIssue = onlyThoseWithIssue;
        this.clearLists();
    }

    public LocalDate getAdministrationEffectiveStart() {
        return this.administrationEffectiveStart;
    }

    public void setAdministrationEffectiveStart(LocalDate administrationEffectiveStart) {
        this.administrationEffectiveStart = administrationEffectiveStart;
        this.clearLists();
    }

    private void clearLists() {
        this.prescriptions = null;
        this.medications = null;
        this.summaryQCR = null;
    }

    public LocalDate getAdministrationEffectiveEnd() {
        return this.administrationEffectiveEnd;
    }

    public void setAdministrationEffectiveEnd(LocalDate administrationEffectiveEnd) {
        this.administrationEffectiveEnd = administrationEffectiveEnd;
        this.clearLists();
    }

    public LocalDate getAmendedInTimeStart() {
        return this.amendedInTimeStart;
    }

    public void setAmendedInTimeStart(LocalDate amendedInTimeStart) {
        this.amendedInTimeStart = amendedInTimeStart;
        this.clearLists();
    }

    public LocalDate getAmendedInTimeEnd() {
        return this.amendedInTimeEnd;
    }

    public void setAmendedInTimeEnd(LocalDate amendedInTimeEnd) {
        this.amendedInTimeEnd = amendedInTimeEnd;
        this.clearLists();
    }

    public DMMedicationControllerCallback getCallback() {
        return this.callback;
    }

    final class JobExtension
    extends Job {
        private NIU_OTHER_MEDICATION_DM idMedication;
        private NIU_PRESCRIPTION_DM idPrescription;
        private String context;

        private JobExtension(String name) {
            super(name);
        }

        @Override
        protected void runWithException() {
            if (this.idMedication != null) {
                DMMedicationController.this.getMedicationDetail2(this.idMedication, this);
            } else if (this.idPrescription != null) {
                DMMedicationController.this.getPrescriptionDetail2(this.idPrescription, this.context, this);
            }
        }

        public void setIdMedication(NIU_OTHER_MEDICATION_DM idMedication) {
            this.idMedication = idMedication;
            this.idPrescription = null;
            this.context = null;
        }

        public void setIdPrescription(NIU_PRESCRIPTION_DM idPrescription, String context) {
            this.idMedication = null;
            this.idPrescription = idPrescription;
            this.context = context;
        }
    }
}

