/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.gson.impl;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.Arrays;

public class IntListTypeAdapter
extends TypeAdapter<IntList> {
    public void write(JsonWriter jsonWriter, IntList src) throws IOException {
        if (src == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.value(Arrays.toString(src.toIntArray()));
    }

    public IntList read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        try {
            IntArrayList intLst = new IntArrayList();
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                intLst.add(jsonReader.nextInt());
            }
            jsonReader.endArray();
            return intLst;
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }
}

