/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.netty;

import com.hivemq.client.internal.annotations.ThreadSafe;
import com.hivemq.client.internal.logging.InternalLogger;
import com.hivemq.client.internal.logging.InternalLoggerFactory;
import com.hivemq.client.internal.shaded.io.netty.channel.ChannelFactory;
import com.hivemq.client.internal.shaded.io.netty.channel.EventLoop;
import com.hivemq.client.internal.shaded.io.netty.channel.MultithreadEventLoopGroup;
import com.hivemq.client.internal.shaded.io.netty.channel.epoll.Epoll;
import com.hivemq.client.internal.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import com.hivemq.client.internal.shaded.io.netty.channel.epoll.EpollSocketChannel;
import com.hivemq.client.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import com.hivemq.client.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import com.hivemq.client.internal.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import com.hivemq.client.internal.shaded.io.netty.util.concurrent.ThreadPerTaskExecutor;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.ClassUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

@ThreadSafe
public class NettyEventLoopProvider {
    @NotNull
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(NettyEventLoopProvider.class);
    @NotNull
    public static final NettyEventLoopProvider INSTANCE = ClassUtil.isAvailable("com.hivemq.client.internal.shaded.io.netty.channel.epoll.Epoll") ? EpollHolder.access$000() : NettyEventLoopProvider.nioEventLoopProvider();
    @NotNull
    private final @NotNull Map<@Nullable Executor, @NotNull Entry> entries = new HashMap<Executor, Entry>();
    @NotNull
    private final BiFunction<Integer, Executor, MultithreadEventLoopGroup> eventLoopGroupFactory;
    @NotNull
    private final ChannelFactory<?> channelFactory;

    private static NettyEventLoopProvider nioEventLoopProvider() {
        return new NettyEventLoopProvider(NioEventLoopGroup::new, NioSocketChannel::new);
    }

    private NettyEventLoopProvider(@NotNull BiFunction<Integer, Executor, MultithreadEventLoopGroup> eventLoopGroupFactory, @NotNull ChannelFactory<?> channelFactory) {
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.channelFactory = channelFactory;
    }

    @NotNull
    public synchronized EventLoop acquireEventLoop(@Nullable Executor executor, int threadCount) {
        Entry entry = this.entries.get(executor);
        if (entry == null) {
            MultithreadEventLoopGroup eventLoopGroup;
            if (executor == null) {
                eventLoopGroup = this.eventLoopGroupFactory.apply(threadCount, new ThreadPerTaskExecutor(new DefaultThreadFactory("com.hivemq.client.mqtt", 10)));
            } else if (executor instanceof MultithreadEventLoopGroup) {
                eventLoopGroup = (MultithreadEventLoopGroup)executor;
                if (threadCount != 0 && eventLoopGroup.executorCount() != threadCount) {
                    LOGGER.warn("Tried to use a different amount of Netty threads for the provided event loop. Using {} threads instead of {}", eventLoopGroup.executorCount(), threadCount);
                }
            } else {
                eventLoopGroup = this.eventLoopGroupFactory.apply(threadCount, executor);
            }
            entry = new Entry(eventLoopGroup);
            this.entries.put(executor, entry);
        } else {
            if (threadCount != 0 && entry.eventLoopGroup.executorCount() != threadCount) {
                LOGGER.warn("Tried to use a different amount of Netty threads for the same executor. Using {} threads instead of {}", entry.eventLoopGroup.executorCount(), threadCount);
            }
            ++entry.referenceCount;
        }
        return entry.eventLoopGroup.next();
    }

    public synchronized void releaseEventLoop(@Nullable Executor executor) {
        Entry entry = this.entries.get(executor);
        if (--entry.referenceCount == 0) {
            this.entries.remove(executor);
            if (!(executor instanceof MultithreadEventLoopGroup)) {
                entry.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @NotNull
    public ChannelFactory<?> getChannelFactory() {
        return this.channelFactory;
    }

    private static class Entry {
        @NotNull
        final MultithreadEventLoopGroup eventLoopGroup;
        int referenceCount = 1;

        private Entry(@NotNull MultithreadEventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
        }
    }

    private static class EpollHolder {
        private EpollHolder() {
        }

        private static NettyEventLoopProvider eventLoopProvider() {
            if (Epoll.isAvailable()) {
                return new NettyEventLoopProvider(EpollEventLoopGroup::new, EpollSocketChannel::new);
            }
            return NettyEventLoopProvider.nioEventLoopProvider();
        }

        static /* synthetic */ NettyEventLoopProvider access$000() {
            return EpollHolder.eventLoopProvider();
        }
    }
}

