/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.http;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpUtils {
    private static final Logger logger = Logger.getLogger(HttpUtils.class.getName());
    private static SSLSocketFactory initialDefaultSSLSocketFactory;
    private static HostnameVerifier initialDefaultHostnameVerifier;

    public static void untrustAllHttpsServerCertificate() {
        if (initialDefaultSSLSocketFactory != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(initialDefaultSSLSocketFactory);
        }
        if (initialDefaultHostnameVerifier != null) {
            HttpsURLConnection.setDefaultHostnameVerifier(initialDefaultHostnameVerifier);
        }
    }

    public static void trustAllHttpsServerCertificate() {
        try {
            if (initialDefaultSSLSocketFactory == null) {
                initialDefaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            }
            if (initialDefaultHostnameVerifier == null) {
                initialDefaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            }
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new AllowAllTrustManager()}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(factory);
            HttpsURLConnection.setDefaultHostnameVerifier(new IgnoreHostNameVerifier());
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to trustAllHttpsServerCertificate", ex);
        }
    }

    private static class AllowAllTrustManager
    implements X509TrustManager,
    TrustManager {
        private AllowAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static class IgnoreHostNameVerifier
    implements HostnameVerifier {
        private IgnoreHostNameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

