/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1.config;

import ca.infodata.util1.config.ConfigurationException;
import ca.infodata.util1.config.IConfigService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class ConfigKey<T> {
    private static final Logger logger = Logger.getLogger(ConfigKey.class.getName());
    private String key;
    private List<String> deprecatedKeys;
    private T defaultValue;
    private final ThreadLocal<Map<Object, Object>> properties;

    public ConfigKey(String ... keys) {
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException("keys is null or empty");
        }
        this.key = keys[0];
        this.deprecatedKeys = new ArrayList<String>();
        for (int i = 1; i < keys.length; ++i) {
            this.deprecatedKeys.add(keys[i]);
        }
        this.properties = new ThreadLocal();
    }

    public ConfigKey<T> setDefaultValue(T value) {
        this.defaultValue = value;
        return this;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    T getProperty(T defaultValue) {
        T value = this.getProperty();
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    T getCheckedProperty() throws ConfigurationException {
        T t = this.getProperty();
        if (t == null) {
            throw new ConfigurationException(this.getKey() + " config key cannot be null");
        }
        return t;
    }

    public T getCheckedProperty(IConfigService configService) throws ConfigurationException {
        return configService.getCheckedProperty(this);
    }

    public T getProperty(IConfigService configService) {
        return configService.getProperty(this);
    }

    void setProperties(Map<Object, Object> properties) {
        this.properties.set(properties);
    }

    Map<Object, Object> getProperties() {
        Map<Object, Object> map = this.properties.get();
        return map == null ? Collections.emptyMap() : map;
    }

    T getProperty() {
        Map<Object, Object> map = this.getProperties();
        if (map == null) {
            throw new IllegalStateException("properties is not set. properties should be set before using a get*Property method. ");
        }
        String foundKey = null;
        Object foundValue = null;
        if (map.containsKey(this.key)) {
            foundKey = this.key;
            foundValue = map.get(this.key);
        } else {
            for (String dkey : this.deprecatedKeys) {
                if (!map.containsKey(dkey)) continue;
                foundKey = dkey;
                foundValue = map.get(dkey);
                break;
            }
        }
        if (foundKey == null) {
            logger.severe("property with key " + this.key + " not found in config.");
        } else if (!this.key.equals(foundKey)) {
            logger.warning("property with key " + foundKey + " is deprecated. use key " + this.key + " instead.");
        }
        if (foundValue == null) {
            return this.defaultValue;
        }
        return this.convertFoundValueToT(foundValue);
    }

    protected abstract T convertFoundValueToT(Object var1);

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigKey other = (ConfigKey)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return "ConfigKey [key=" + this.key + ", deprecatedKeys=" + this.deprecatedKeys + ", defaultValue=" + this.defaultValue + "]";
    }
}

