/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CQ;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.NULLDT;
import ca.uhn.hl7v2.model.v281.datatype.ST;
import ca.uhn.hl7v2.model.v281.datatype.XAD;
import ca.uhn.hl7v2.model.v281.datatype.XCN;
import ca.uhn.hl7v2.model.v281.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXD
extends AbstractSegment {
    public RXD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Dispense Sub-ID Counter");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Dispense/Give Code");
            this.add(DTM.class, true, 1, 0, new Object[]{this.getMessage()}, "Date/Time Dispensed");
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Actual Dispense Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Actual Dispense Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Actual Dosage Form");
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "Prescription Number");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Refills Remaining");
            this.add(ST.class, false, 0, 0, new Object[]{this.getMessage()}, "Dispense Notes");
            this.add(XCN.class, false, 0, 0, new Object[]{this.getMessage()}, "Dispensing Provider");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(167)}, "Substitution Status");
            this.add(CQ.class, false, 1, 0, new Object[]{this.getMessage()}, "Total Daily Dose");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense-to Location");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(136)}, "Needs Human Review");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Special Dispensing Instructions");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Actual Strength");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Actual Strength Unit");
            this.add(ST.class, false, 0, 0, new Object[]{this.getMessage()}, "Substance Lot Number");
            this.add(DTM.class, false, 0, 0, new Object[]{this.getMessage()}, "Substance Expiration Date");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Substance Manufacturer Name");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Indication");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Package Size");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Package Size Unit");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(321)}, "Dispense Package Method");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Supplementary Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Initiating Location");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Packaging/Assembly Location");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Actual Drug Strength Volume");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Actual Drug Strength Volume Units");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense to Pharmacy");
            this.add(XAD.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense to Pharmacy Address");
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(480)}, "Pharmacy Order Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Type");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Pharmacy Phone Number");
            this.add(EI.class, false, 0, 0, new Object[]{this.getMessage()}, "Dispense Tag Identifier");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXD - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getDispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRxd1_DispenseSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getDispenseGiveCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getRxd2_DispenseGiveCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getDateTimeDispensed() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getRxd3_DateTimeDispensed() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getActualDispenseAmount() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getRxd4_ActualDispenseAmount() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getActualDispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getRxd5_ActualDispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getActualDosageForm() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getRxd6_ActualDosageForm() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getPrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getRxd7_PrescriptionNumber() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getNumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getRxd8_NumberOfRefillsRemaining() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public ST[] getDispenseNotes() {
        ST[] retVal = (ST[])this.getTypedField(9, new ST[0]);
        return retVal;
    }

    public ST[] getRxd9_DispenseNotes() {
        ST[] retVal = (ST[])this.getTypedField(9, new ST[0]);
        return retVal;
    }

    public int getDispenseNotesReps() {
        return this.getReps(9);
    }

    public ST getDispenseNotes(int rep) {
        ST retVal = (ST)this.getTypedField(9, rep);
        return retVal;
    }

    public ST getRxd9_DispenseNotes(int rep) {
        ST retVal = (ST)this.getTypedField(9, rep);
        return retVal;
    }

    public int getRxd9_DispenseNotesReps() {
        return this.getReps(9);
    }

    public ST insertDispenseNotes(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST insertRxd9_DispenseNotes(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST removeDispenseNotes(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public ST removeRxd9_DispenseNotes(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public XCN[] getDispensingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public XCN[] getRxd10_DispensingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(10, new XCN[0]);
        return retVal;
    }

    public int getDispensingProviderReps() {
        return this.getReps(10);
    }

    public XCN getDispensingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public XCN getRxd10_DispensingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(10, rep);
        return retVal;
    }

    public int getRxd10_DispensingProviderReps() {
        return this.getReps(10);
    }

    public XCN insertDispensingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN insertRxd10_DispensingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(10, rep);
    }

    public XCN removeDispensingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public XCN removeRxd10_DispensingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(10, rep);
    }

    public ID getSubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getRxd11_SubstitutionStatus() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ getTotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getRxd12_TotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public NULLDT getDispenseToLocation() {
        NULLDT retVal = (NULLDT)this.getTypedField(13, 0);
        return retVal;
    }

    public NULLDT getRxd13_DispenseToLocation() {
        NULLDT retVal = (NULLDT)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getRxd14_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE[] getSpecialDispensingInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(15, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxd15_SpecialDispensingInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(15, new CWE[0]);
        return retVal;
    }

    public int getSpecialDispensingInstructionsReps() {
        return this.getReps(15);
    }

    public CWE getSpecialDispensingInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public CWE getRxd15_SpecialDispensingInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getRxd15_SpecialDispensingInstructionsReps() {
        return this.getReps(15);
    }

    public CWE insertSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE insertRxd15_SpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE removeSpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE removeRxd15_SpecialDispensingInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public NM getActualStrength() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getRxd16_ActualStrength() {
        NM retVal = (NM)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getActualStrengthUnit() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getRxd17_ActualStrengthUnit() {
        CWE retVal = (CWE)this.getTypedField(17, 0);
        return retVal;
    }

    public ST[] getSubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(18, new ST[0]);
        return retVal;
    }

    public ST[] getRxd18_SubstanceLotNumber() {
        ST[] retVal = (ST[])this.getTypedField(18, new ST[0]);
        return retVal;
    }

    public int getSubstanceLotNumberReps() {
        return this.getReps(18);
    }

    public ST getSubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(18, rep);
        return retVal;
    }

    public ST getRxd18_SubstanceLotNumber(int rep) {
        ST retVal = (ST)this.getTypedField(18, rep);
        return retVal;
    }

    public int getRxd18_SubstanceLotNumberReps() {
        return this.getReps(18);
    }

    public ST insertSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(18, rep);
    }

    public ST insertRxd18_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(18, rep);
    }

    public ST removeSubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(18, rep);
    }

    public ST removeRxd18_SubstanceLotNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(18, rep);
    }

    public DTM[] getSubstanceExpirationDate() {
        DTM[] retVal = (DTM[])this.getTypedField(19, new DTM[0]);
        return retVal;
    }

    public DTM[] getRxd19_SubstanceExpirationDate() {
        DTM[] retVal = (DTM[])this.getTypedField(19, new DTM[0]);
        return retVal;
    }

    public int getSubstanceExpirationDateReps() {
        return this.getReps(19);
    }

    public DTM getSubstanceExpirationDate(int rep) {
        DTM retVal = (DTM)this.getTypedField(19, rep);
        return retVal;
    }

    public DTM getRxd19_SubstanceExpirationDate(int rep) {
        DTM retVal = (DTM)this.getTypedField(19, rep);
        return retVal;
    }

    public int getRxd19_SubstanceExpirationDateReps() {
        return this.getReps(19);
    }

    public DTM insertSubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(19, rep);
    }

    public DTM insertRxd19_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(19, rep);
    }

    public DTM removeSubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(19, rep);
    }

    public DTM removeRxd19_SubstanceExpirationDate(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(19, rep);
    }

    public CWE[] getSubstanceManufacturerName() {
        CWE[] retVal = (CWE[])this.getTypedField(20, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxd20_SubstanceManufacturerName() {
        CWE[] retVal = (CWE[])this.getTypedField(20, new CWE[0]);
        return retVal;
    }

    public int getSubstanceManufacturerNameReps() {
        return this.getReps(20);
    }

    public CWE getSubstanceManufacturerName(int rep) {
        CWE retVal = (CWE)this.getTypedField(20, rep);
        return retVal;
    }

    public CWE getRxd20_SubstanceManufacturerName(int rep) {
        CWE retVal = (CWE)this.getTypedField(20, rep);
        return retVal;
    }

    public int getRxd20_SubstanceManufacturerNameReps() {
        return this.getReps(20);
    }

    public CWE insertSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(20, rep);
    }

    public CWE insertRxd20_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(20, rep);
    }

    public CWE removeSubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(20, rep);
    }

    public CWE removeRxd20_SubstanceManufacturerName(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(20, rep);
    }

    public CWE[] getIndication() {
        CWE[] retVal = (CWE[])this.getTypedField(21, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxd21_Indication() {
        CWE[] retVal = (CWE[])this.getTypedField(21, new CWE[0]);
        return retVal;
    }

    public int getIndicationReps() {
        return this.getReps(21);
    }

    public CWE getIndication(int rep) {
        CWE retVal = (CWE)this.getTypedField(21, rep);
        return retVal;
    }

    public CWE getRxd21_Indication(int rep) {
        CWE retVal = (CWE)this.getTypedField(21, rep);
        return retVal;
    }

    public int getRxd21_IndicationReps() {
        return this.getReps(21);
    }

    public CWE insertIndication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(21, rep);
    }

    public CWE insertRxd21_Indication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(21, rep);
    }

    public CWE removeIndication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(21, rep);
    }

    public CWE removeRxd21_Indication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(21, rep);
    }

    public NM getDispensePackageSize() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getRxd22_DispensePackageSize() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getDispensePackageSizeUnit() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE getRxd23_DispensePackageSizeUnit() {
        CWE retVal = (CWE)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getDispensePackageMethod() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getRxd24_DispensePackageMethod() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public CWE[] getSupplementaryCode() {
        CWE[] retVal = (CWE[])this.getTypedField(25, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxd25_SupplementaryCode() {
        CWE[] retVal = (CWE[])this.getTypedField(25, new CWE[0]);
        return retVal;
    }

    public int getSupplementaryCodeReps() {
        return this.getReps(25);
    }

    public CWE getSupplementaryCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(25, rep);
        return retVal;
    }

    public CWE getRxd25_SupplementaryCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(25, rep);
        return retVal;
    }

    public int getRxd25_SupplementaryCodeReps() {
        return this.getReps(25);
    }

    public CWE insertSupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(25, rep);
    }

    public CWE insertRxd25_SupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(25, rep);
    }

    public CWE removeSupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(25, rep);
    }

    public CWE removeRxd25_SupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(25, rep);
    }

    public CWE getInitiatingLocation() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getRxd26_InitiatingLocation() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getPackagingAssemblyLocation() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public CWE getRxd27_PackagingAssemblyLocation() {
        CWE retVal = (CWE)this.getTypedField(27, 0);
        return retVal;
    }

    public NM getActualDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public NM getRxd28_ActualDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public CWE getActualDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getRxd29_ActualDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getDispenseToPharmacy() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public CWE getRxd30_DispenseToPharmacy() {
        CWE retVal = (CWE)this.getTypedField(30, 0);
        return retVal;
    }

    public XAD getDispenseToPharmacyAddress() {
        XAD retVal = (XAD)this.getTypedField(31, 0);
        return retVal;
    }

    public XAD getRxd31_DispenseToPharmacyAddress() {
        XAD retVal = (XAD)this.getTypedField(31, 0);
        return retVal;
    }

    public ID getPharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(32, 0);
        return retVal;
    }

    public ID getRxd32_PharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(32, 0);
        return retVal;
    }

    public CWE getDispenseType() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    public CWE getRxd33_DispenseType() {
        CWE retVal = (CWE)this.getTypedField(33, 0);
        return retVal;
    }

    public XTN[] getPharmacyPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(34, new XTN[0]);
        return retVal;
    }

    public XTN[] getRxd34_PharmacyPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(34, new XTN[0]);
        return retVal;
    }

    public int getPharmacyPhoneNumberReps() {
        return this.getReps(34);
    }

    public XTN getPharmacyPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(34, rep);
        return retVal;
    }

    public XTN getRxd34_PharmacyPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(34, rep);
        return retVal;
    }

    public int getRxd34_PharmacyPhoneNumberReps() {
        return this.getReps(34);
    }

    public XTN insertPharmacyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(34, rep);
    }

    public XTN insertRxd34_PharmacyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(34, rep);
    }

    public XTN removePharmacyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(34, rep);
    }

    public XTN removeRxd34_PharmacyPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(34, rep);
    }

    public EI[] getDispenseTagIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(35, new EI[0]);
        return retVal;
    }

    public EI[] getRxd35_DispenseTagIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(35, new EI[0]);
        return retVal;
    }

    public int getDispenseTagIdentifierReps() {
        return this.getReps(35);
    }

    public EI getDispenseTagIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(35, rep);
        return retVal;
    }

    public EI getRxd35_DispenseTagIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(35, rep);
        return retVal;
    }

    public int getRxd35_DispenseTagIdentifierReps() {
        return this.getReps(35);
    }

    public EI insertDispenseTagIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(35, rep);
    }

    public EI insertRxd35_DispenseTagIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(35, rep);
    }

    public EI removeDispenseTagIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(35, rep);
    }

    public EI removeRxd35_DispenseTagIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(35, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new XCN(this.getMessage());
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(167));
            }
            case 11: {
                return new CQ(this.getMessage());
            }
            case 12: {
                return new NULLDT(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new NM(this.getMessage());
            }
            case 16: {
                return new CWE(this.getMessage());
            }
            case 17: {
                return new ST(this.getMessage());
            }
            case 18: {
                return new DTM(this.getMessage());
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new NM(this.getMessage());
            }
            case 22: {
                return new CWE(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(321));
            }
            case 24: {
                return new CWE(this.getMessage());
            }
            case 25: {
                return new CWE(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new NM(this.getMessage());
            }
            case 28: {
                return new CWE(this.getMessage());
            }
            case 29: {
                return new CWE(this.getMessage());
            }
            case 30: {
                return new XAD(this.getMessage());
            }
            case 31: {
                return new ID(this.getMessage(), new Integer(480));
            }
            case 32: {
                return new CWE(this.getMessage());
            }
            case 33: {
                return new XTN(this.getMessage());
            }
            case 34: {
                return new EI(this.getMessage());
            }
        }
        return null;
    }
}

