/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXC
extends AbstractSegment {
    public RXC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 0, new Object[]{this.getMessage(), new Integer(166)}, "RX Component Type");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Component Code");
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Component Amount");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Component Units");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Component Strength");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Component Strength Units");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Supplementary Code");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Component Drug Strength Volume");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Component Drug Strength Volume Units");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Dispense Units");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXC - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getRXComponentType() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getRxc1_RXComponentType() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getComponentCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getRxc2_ComponentCode() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getComponentAmount() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getRxc3_ComponentAmount() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getComponentUnits() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getRxc4_ComponentUnits() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getComponentStrength() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getRxc5_ComponentStrength() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getComponentStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getRxc6_ComponentStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE[] getSupplementaryCode() {
        CWE[] retVal = (CWE[])this.getTypedField(7, new CWE[0]);
        return retVal;
    }

    public CWE[] getRxc7_SupplementaryCode() {
        CWE[] retVal = (CWE[])this.getTypedField(7, new CWE[0]);
        return retVal;
    }

    public int getSupplementaryCodeReps() {
        return this.getReps(7);
    }

    public CWE getSupplementaryCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public CWE getRxc7_SupplementaryCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getRxc7_SupplementaryCodeReps() {
        return this.getReps(7);
    }

    public CWE insertSupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE insertRxc7_SupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE removeSupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public CWE removeRxc7_SupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public NM getComponentDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getRxc8_ComponentDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getComponentDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getRxc9_ComponentDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getDispenseAmount() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getRxc10_DispenseAmount() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getDispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getRxc11_DispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(166));
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

