/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v281.group.RRD_O14_DISPENSE;
import ca.uhn.hl7v2.model.v281.group.RRD_O14_TIMING;
import ca.uhn.hl7v2.model.v281.segment.ORC;
import ca.uhn.hl7v2.model.v281.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RRD_O14_ORDER
extends AbstractGroup {
    public RRD_O14_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(RRD_O14_TIMING.class, false, true, false);
            this.add(RRD_O14_DISPENSE.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RRD_O14_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public RRD_O14_TIMING getTIMING() {
        RRD_O14_TIMING retVal = this.getTyped("TIMING", RRD_O14_TIMING.class);
        return retVal;
    }

    public RRD_O14_TIMING getTIMING(int rep) {
        RRD_O14_TIMING retVal = this.getTyped("TIMING", rep, RRD_O14_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RRD_O14_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RRD_O14_TIMING.class);
    }

    public void insertTIMING(RRD_O14_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public RRD_O14_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RRD_O14_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RRD_O14_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RRD_O14_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RRD_O14_DISPENSE getDISPENSE() {
        RRD_O14_DISPENSE retVal = this.getTyped("DISPENSE", RRD_O14_DISPENSE.class);
        return retVal;
    }
}

